/*
 * Decompiled with CFR 0.152.
 */
package org.cts.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Complex
extends Number {
    private static final Logger LOGGER = LoggerFactory.getLogger(Complex.class);
    public static final Complex i = Complex.cartesian(0.0, 1.0);
    public static final Complex ONE = Complex.cartesian(1.0, 0.0);
    private double re;
    private double im;

    public static Complex cartesian(double re, double im) {
        return new Complex(re, im);
    }

    public static Complex cartesian(double re) {
        return new Complex(re, 0.0);
    }

    public static Complex polar(double radius, double phi) {
        return new Complex(radius * Math.cos(phi), radius * Math.sin(phi));
    }

    public static Complex polar(double phi) {
        return new Complex(Math.cos(phi), Math.sin(phi));
    }

    @Deprecated
    public Complex(double re, double im) {
        this.re = re;
        this.im = im;
    }

    public Complex() {
        this(0.0, 0.0);
    }

    @Deprecated
    public Complex(double re) {
        this(re, 0.0);
    }

    public Complex(Complex z) {
        this(z.re(), z.im());
    }

    @Deprecated
    public static Complex createComplexFromA(double phi) {
        return Complex.cartesian(Math.cos(phi), Math.sin(phi));
    }

    @Deprecated
    public static Complex createComplexFromRA(double radius, double phi) {
        return Complex.cartesian(radius * Math.cos(phi), radius * Math.sin(phi));
    }

    public boolean equals(Object obj) {
        if (obj instanceof Complex) {
            return this.re == ((Complex)obj).re() && this.im == ((Complex)obj).im();
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + Double.valueOf(this.re).hashCode();
        hash = 83 * hash + Double.valueOf(this.im).hashCode();
        return hash;
    }

    public double re() {
        return this.re;
    }

    public double im() {
        return this.im;
    }

    public Complex conj() {
        return Complex.cartesian(this.re(), -this.im());
    }

    public boolean isReal() {
        return 1.0E-12 > Math.abs(this.im);
    }

    public double mag() {
        return Math.hypot(this.re, this.im);
    }

    @Override
    public double doubleValue() {
        if (!this.isReal()) {
            LOGGER.warn("The complex number is not a pure real.");
            return 0.0;
        }
        return this.re;
    }

    @Override
    public float floatValue() {
        if (!this.isReal()) {
            LOGGER.warn("The complex number is not a pure real.");
            return 0.0f;
        }
        return (float)this.re;
    }

    @Override
    public long longValue() {
        if (!this.isReal()) {
            LOGGER.warn("The complex number is not a pure real.");
            return 0L;
        }
        return (long)this.re;
    }

    @Override
    public int intValue() {
        if (!this.isReal()) {
            LOGGER.warn("The complex number is not a pure real.");
            return 0;
        }
        return (int)this.re;
    }

    public double arg() {
        return Math.atan2(this.im, this.re);
    }

    public Complex plus(Complex z) {
        return Complex.cartesian(this.re + z.re(), this.im + z.im());
    }

    public Complex plus(double x) {
        return Complex.cartesian(this.re() + x, this.im());
    }

    public Complex minus(Complex z) {
        return Complex.cartesian(this.re - z.re(), this.im - z.im());
    }

    public Complex minus(double x) {
        return Complex.cartesian(this.re() - x, this.im());
    }

    @Deprecated
    public Complex times(Complex z) {
        return Complex.cartesian(this.re * z.re() - this.im * z.im(), this.re * z.im() + this.im * z.re());
    }

    public Complex multiplyBy(Complex z) {
        return Complex.cartesian(this.re * z.re() - this.im * z.im(), this.re * z.im() + this.im * z.re());
    }

    @Deprecated
    public Complex times(double x) {
        return Complex.cartesian(x * this.re, x * this.im);
    }

    public Complex multiplyBy(double x) {
        return Complex.cartesian(x * this.re, x * this.im);
    }

    public Complex divideBy(Complex z) throws ArithmeticException {
        double rz = z.mag();
        if (Math.abs(rz) < 1.0E-12) {
            throw new ArithmeticException("Complex.divideBy cannot divide by a Complex with magnitude zero");
        }
        return Complex.cartesian((this.re * z.re() + this.im * z.im()) / (rz * rz), (this.im * z.re() - this.re * z.im()) / (rz * rz));
    }

    public Complex divideBy(double x) {
        return Complex.cartesian(this.re / x, this.im / x);
    }

    public Complex axpb(double a, double b) {
        return new Complex(this.multiplyBy(a).plus(b));
    }

    public Complex axpb(Complex a, Complex b) {
        return new Complex(this.multiplyBy(a).plus(b));
    }

    public static Complex sin(Complex z) {
        double _re = Math.sin(z.re()) * Math.cosh(z.im());
        double _im = Math.cos(z.re()) * Math.sinh(z.im());
        return Complex.cartesian(_re, _im);
    }

    public static Complex cos(Complex z) {
        double _re = Math.cos(z.re()) * Math.cosh(z.im());
        double _im = -Math.sin(z.re()) * Math.sinh(z.im());
        return Complex.cartesian(_re, _im);
    }

    public static Complex tan(Complex z) {
        double nenner = Math.cos(2.0 * z.re()) + Math.cosh(2.0 * z.im());
        double _re = Math.sin(2.0 * z.re()) / nenner;
        double _im = Math.sinh(2.0 * z.im()) / nenner;
        return Complex.cartesian(_re, _im);
    }

    public static Complex pow(Complex z) {
        double ex = Math.pow(Math.E, z.re());
        return Complex.cartesian(ex * Math.cos(z.im()), ex * Math.sin(z.im()));
    }

    public static Complex sinh(Complex z) {
        return new Complex(Complex.pow(z).minus(Complex.pow(z.multiplyBy(-1.0))).multiplyBy(0.5));
    }

    public static Complex cosh(Complex z) {
        double _re = Math.cosh(z.re()) * Math.cos(z.im());
        double _im = Math.sinh(z.re()) * Math.sin(z.im());
        return Complex.cartesian(_re, _im);
    }

    public static Complex tanh(Complex z) throws ArithmeticException {
        return new Complex(Complex.sinh(z).divideBy(Complex.cosh(z)));
    }

    public static double tanh(double x) throws ArithmeticException {
        return Complex.cartesian(x, 0.0).re();
    }

    public static Complex atan(Complex z) throws ArithmeticException {
        Complex frac = z.multiplyBy(i).plus(1.0).divideBy(z.multiplyBy(i).multiplyBy(-1.0).plus(1.0));
        return new Complex(i.multiplyBy(-0.5).multiplyBy(Complex.ln(frac)));
    }

    public static Complex exp(Complex z) {
        double _re = Math.exp(z.re()) * Math.cos(z.im());
        double _im = Math.exp(z.re()) * Math.sin(z.im());
        return Complex.cartesian(_re, _im);
    }

    public static Complex ln(Complex z) {
        double _re = Math.log(z.mag());
        double _im = z.arg();
        return Complex.cartesian(_re, _im);
    }

    public static Complex sqrt(Complex z) {
        double r = Math.sqrt(z.mag());
        double phi = z.arg() / 2.0;
        return Complex.cartesian(r * Math.cos(phi), r * Math.sin(phi));
    }

    public static Complex asin(Complex z) {
        Complex zz = ONE.minus(z.multiplyBy(z));
        zz = Complex.sqrt(zz);
        zz = zz.plus(i.multiplyBy(z));
        zz = i.multiplyBy(Complex.ln(zz)).multiplyBy(-1.0);
        return zz;
    }

    public static Complex atanh(Complex z) throws ArithmeticException {
        Complex zz = z;
        zz = zz.plus(1.0).divideBy(zz.minus(1.0)).multiplyBy(-1.0);
        zz = Complex.ln(zz).multiplyBy(0.5);
        return zz;
    }

    public static double atanh(double x) throws ArithmeticException {
        return Complex.atanh(Complex.cartesian(x, 0.0)).re();
    }

    public String toString() {
        return "[" + this.re() + (this.im() < 0.0 ? " - " : " + ") + Math.abs(this.im()) + "i]";
    }
}

