/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.properties;

import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;

public class ST_Length
extends DeterministicScalarFunction {
    public ST_Length() {
        this.addProperty("remarks", "Returns the 2D length of the geometry if it is a LineString or MultiLineString.\n 0 is returned for other geometries");
    }

    public String getJavaStaticMethod() {
        return "getLength";
    }

    public static Double getLength(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        if (geometry instanceof LineString || geometry instanceof MultiLineString) {
            return geometry.getLength();
        }
        return 0.0;
    }
}

