/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.edit;

import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Geometry;

public class ST_UpdateZ
extends DeterministicScalarFunction {
    public ST_UpdateZ() {
        this.addProperty("remarks", "This function replace the z value of (each vertex of) the\n geometric parameter to the corresponding value given by a field.");
    }

    public String getJavaStaticMethod() {
        return "updateZ";
    }

    public static Geometry updateZ(Geometry geometry, double z) {
        if (geometry == null) {
            return null;
        }
        geometry.apply((CoordinateSequenceFilter)new UpdateZCoordinateSequenceFilter(z));
        return geometry;
    }

    public static class UpdateZCoordinateSequenceFilter
    implements CoordinateSequenceFilter {
        private boolean done = false;
        private final double z;

        public UpdateZCoordinateSequenceFilter(double z) {
            this.z = z;
        }

        public boolean isGeometryChanged() {
            return true;
        }

        public boolean isDone() {
            return this.done;
        }

        public void filter(CoordinateSequence seq, int i) {
            seq.setOrdinate(i, 2, this.z);
            if (i == seq.size()) {
                this.done = true;
            }
        }
    }
}

