/*
 * Decompiled with CFR 0.152.
 */
package org.javanetworkanalyzer.alg;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.javanetworkanalyzer.alg.GraphSearchAlgorithm;
import org.javanetworkanalyzer.data.VDijkstra;
import org.javanetworkanalyzer.data.VPredImpl;
import org.javanetworkanalyzer.model.EdgeSPT;
import org.javanetworkanalyzer.model.TraversalGraph;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.graph.EdgeReversedGraph;

public class Dijkstra<V extends VDijkstra, E extends EdgeSPT>
extends GraphSearchAlgorithm<V, E> {
    private final PriorityQueue<V> queue = this.createPriorityQueue();
    protected static final double TOLERANCE = 1.0E-9;
    private double largestDistanceSoFar = 0.0;

    public Dijkstra(Graph<V, E> graph) {
        super(graph);
    }

    @Override
    public void calculate(V startNode) {
        this.calculate(startNode, Double.POSITIVE_INFINITY);
    }

    public void calculate(V startNode, double radius) {
        VDijkstra u;
        this.init(startNode);
        while (!this.queue.isEmpty() && this.largestDistanceSoFar < radius && !this.preRelaxStep(startNode, u = (VDijkstra)this.queue.poll())) {
            Set outgoing = this.outgoingEdgesOf(u);
            for (EdgeSPT e : outgoing) {
                this.relax(startNode, u, e, this.queue);
            }
        }
    }

    @Override
    protected void init(V startNode) {
        super.init(startNode);
        for (VDijkstra node : this.graph.vertexSet()) {
            node.reset();
        }
        ((VDijkstra)startNode).setSource();
        this.queue.clear();
        this.queue.add(startNode);
    }

    protected boolean preRelaxStep(V startNode, V u) {
        return false;
    }

    protected void relax(V startNode, V u, E e, PriorityQueue<V> queue) {
        VDijkstra v = (VDijkstra)Graphs.getOppositeVertex((Graph)this.graph, e, u);
        double uvWeight = this.graph.getEdgeWeight(e);
        if (v.getDistance() > ((VDijkstra)u).getDistance() + uvWeight) {
            this.shortestPathSoFarUpdate(startNode, u, v, uvWeight, e, queue);
        } else if (Math.abs(v.getDistance() - (((VDijkstra)u).getDistance() + uvWeight)) < 1.0E-9) {
            this.multipleShortestPathUpdate(u, v, e);
        }
    }

    protected void shortestPathSoFarUpdate(V startNode, V u, V v, Double uvWeight, E e, PriorityQueue<V> queue) {
        ((VPredImpl)v).clear();
        ((VPredImpl)v).addPredecessor(u);
        ((VPredImpl)v).addPredecessorEdge(e);
        ((VDijkstra)v).setDistance(((VDijkstra)u).getDistance() + uvWeight);
        this.largestDistanceSoFar = ((VDijkstra)v).getDistance();
        queue.remove(v);
        queue.add(v);
    }

    protected void multipleShortestPathUpdate(V u, V v, E e) {
        ((VPredImpl)v).addPredecessor(u);
        ((VPredImpl)v).addPredecessorEdge(e);
    }

    private PriorityQueue<V> createPriorityQueue() {
        return new PriorityQueue(this.graph.vertexSet().size(), new Comparator<V>(){

            @Override
            public int compare(V v1, V v2) {
                return Double.compare(((VDijkstra)v1).getDistance(), ((VDijkstra)v2).getDistance());
            }
        });
    }

    public TraversalGraph<V, E> reconstructTraversalGraph(double radius) {
        if (this.currentStartNode == null) {
            throw new IllegalStateException("You must call #calculate before reconstructing the traversal graph.");
        }
        TraversalGraph traversalGraph = new TraversalGraph(this.graph.getEdgeFactory(), this.currentStartNode);
        for (VDijkstra v : this.graph.vertexSet()) {
            Set predEdges = v.getPredecessorEdges();
            for (EdgeSPT e : predEdges) {
                VDijkstra source = (VDijkstra)this.graph.getEdgeSource((Object)e);
                VDijkstra target = (VDijkstra)this.graph.getEdgeTarget((Object)e);
                if (!(source.getDistance() < radius) || !(target.getDistance() < radius)) continue;
                traversalGraph.addVertex(source);
                traversalGraph.addVertex(target);
                if (v.equals(source)) {
                    ((EdgeSPT)traversalGraph.addEdge(target, source)).setBaseGraphEdge(e);
                    continue;
                }
                if (v.equals(target)) {
                    ((EdgeSPT)traversalGraph.addEdge(source, target)).setBaseGraphEdge(e);
                    continue;
                }
                throw new IllegalStateException("A vertex has a predecessor edge not ending on itself.");
            }
        }
        return traversalGraph;
    }

    public double oneToOne(V source, V target) {
        if (source == null || !this.graph.containsVertex(source)) {
            throw new IllegalArgumentException("Source vertex not found.");
        }
        if (target == null || !this.graph.containsVertex(target)) {
            throw new IllegalArgumentException("Target vertex not found.");
        }
        if (source.equals(target)) {
            ((VDijkstra)source).setSource();
            return ((VDijkstra)source).getDistance();
        }
        new Dijkstra<V, E>(this.graph, (VDijkstra)target){
            final /* synthetic */ VDijkstra val$target;
            {
                this.val$target = vDijkstra;
                super(graph);
            }

            @Override
            protected boolean preRelaxStep(V startNode, V u) {
                return u.equals(this.val$target);
            }
        }.calculate(source);
        return ((VDijkstra)target).getDistance();
    }

    public Map<V, Double> oneToMany(V source, Set<V> targets) {
        if (targets.isEmpty()) {
            throw new IllegalArgumentException("Please specify at least one target.");
        }
        final HashMap<VDijkstra, Double> distances = new HashMap<VDijkstra, Double>();
        if (targets.size() == 1) {
            VDijkstra target = (VDijkstra)targets.iterator().next();
            double distance = this.oneToOne(source, target);
            distances.put(target, distance);
        } else {
            final HashSet<V> remainingTargets = new HashSet<V>(targets);
            new Dijkstra<V, E>(this.graph){

                @Override
                protected boolean preRelaxStep(V startNode, V u) {
                    if (remainingTargets.isEmpty()) {
                        return true;
                    }
                    if (remainingTargets.remove(u)) {
                        distances.put(u, ((VDijkstra)u).getDistance());
                    }
                    return remainingTargets.isEmpty();
                }
            }.calculate(source);
        }
        return distances;
    }

    public Map<V, Double> manyToOne(Set<V> sources, V target) {
        if (sources.isEmpty()) {
            throw new IllegalArgumentException("Please specify at least one source.");
        }
        if (this.graph instanceof DirectedGraph) {
            EdgeReversedGraph reversedGraph = new EdgeReversedGraph((DirectedGraph)this.graph);
            return new Dijkstra<V, E>(reversedGraph).oneToMany(target, sources);
        }
        return this.oneToMany(target, sources);
    }

    public Map<V, Map<V, Double>> manyToMany(Set<V> sources, Set<V> targets) {
        if (sources.isEmpty()) {
            throw new IllegalArgumentException("Please specify at least one source.");
        }
        HashMap<VDijkstra, Map<VDijkstra, Double>> distances = new HashMap<VDijkstra, Map<VDijkstra, Double>>();
        for (VDijkstra source : sources) {
            Map<VDijkstra, Double> oneToMany = this.oneToMany(source, targets);
            distances.put(source, oneToMany);
        }
        return distances;
    }
}

