/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.postgis_jts;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import org.h2gis.postgis_jts.ConnectionWrapper;
import org.h2gis.postgis_jts.JtsWrapper;

public class Driver
extends JtsWrapper {
    private static final String POSTGIS_PROTOCOL = "jdbc:postgres_jts:";
    private static final String POSTGIS_H2PROTOCOL = "jdbc:postgresql_h2:";

    public static String mangleURL(String url) throws SQLException {
        if (url.startsWith(POSTGIS_H2PROTOCOL)) {
            return POSTGIS_PROTOCOL + url.substring(POSTGIS_H2PROTOCOL.length());
        }
        throw new SQLException("Unknown protocol or subprotocol in url " + url);
    }

    @Override
    public boolean acceptsURL(String url) {
        try {
            url = Driver.mangleURL(url);
        }
        catch (SQLException e) {
            return false;
        }
        return super.acceptsURL(url);
    }

    public static String getVersion() {
        return "H2 compatible driver, wrapping pg " + org.postgresql.Driver.getVersion();
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        return new ConnectionWrapper(super.connect(POSTGIS_PROTOCOL + url.substring(POSTGIS_H2PROTOCOL.length()), info));
    }

    static {
        try {
            DriverManager.registerDriver((java.sql.Driver)((Object)new Driver()));
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, "PostGIS H2 compatible Driver", e);
        }
    }
}

