/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.predicates;

import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;

public class ST_Disjoint
extends DeterministicScalarFunction {
    public ST_Disjoint() {
        this.addProperty("remarks", "Return true if the two Geometries are disjoint");
    }

    public String getJavaStaticMethod() {
        return "geomDisjoint";
    }

    public static Boolean geomDisjoint(Geometry a, Geometry b) throws SQLException {
        if (a == null || b == null) {
            return null;
        }
        if (a.getSRID() != b.getSRID()) {
            throw new SQLException("Operation on mixed SRID geometries not supported");
        }
        return a.disjoint(b);
    }
}

