/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.tsv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.zip.GZIPInputStream;
import org.h2.tools.Csv;
import org.h2gis.api.DriverFunction;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.functions.io.DriverManager;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.dbtypes.DBTypes;
import org.h2gis.utilities.dbtypes.DBUtils;

public class TSVDriverFunction
implements DriverFunction {
    public static String DESCRIPTION = "TSV file (Tab Separated Values)";
    private static final int BATCH_MAX_SIZE = 200;

    public DriverFunction.IMPORT_DRIVER_TYPE getImportDriverType() {
        return DriverFunction.IMPORT_DRIVER_TYPE.COPY;
    }

    public String[] getImportFormats() {
        return new String[]{"tsv", "tsv.gz"};
    }

    public String[] getExportFormats() {
        return new String[]{"tsv", "tsv.gz"};
    }

    public String getFormatDescription(String format) {
        if (format.equalsIgnoreCase("tsv")) {
            return DESCRIPTION;
        }
        return "";
    }

    public boolean isSpatialFormat(String extension) {
        return false;
    }

    public String[] exportTable(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        return this.exportTable(connection, tableReference, fileName, null, false, progress);
    }

    public String[] exportTable(Connection connection, String tableReference, File fileName, boolean deleteFiles, ProgressVisitor progress) throws SQLException, IOException {
        return this.exportTable(connection, tableReference, fileName, null, deleteFiles, progress);
    }

    /*
     * Exception decompiling
     */
    public String[] exportTable(Connection connection, String tableReference, File fileName, String encoding, boolean deleteFiles, ProgressVisitor progress) throws SQLException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String[] exportTable(Connection connection, String tableReference, File fileName, String encoding, ProgressVisitor progress) throws SQLException, IOException {
        return this.exportTable(connection, tableReference, fileName, encoding, false, progress);
    }

    public void exportFromResultSet(Connection connection, ResultSet res, Writer writer, String encoding, ProgressVisitor progress) throws SQLException {
        Csv csv = new Csv();
        String csvOptions = "charset=UTF-8 fieldSeparator=\t fieldDelimiter=\t";
        if (encoding != null) {
            csvOptions = String.format("charset=%s fieldSeparator=\t fieldDelimiter=\t", encoding);
        }
        csv.setOptions(csvOptions);
        csv.write(writer, res);
    }

    public String[] importFile(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        return this.importFile(connection, tableReference, fileName, null, false, progress);
    }

    public String[] importFile(Connection connection, String tableReference, File fileName, String options, ProgressVisitor progress) throws SQLException, IOException {
        return this.importFile(connection, tableReference, fileName, options, false, progress);
    }

    public String[] importFile(Connection connection, String tableReference, File fileName, boolean deleteTables, ProgressVisitor progress) throws SQLException, IOException {
        return this.importFile(connection, tableReference, fileName, null, deleteTables, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] importFile(Connection connection, String tableReference, File fileName, String options, boolean deleteTables, ProgressVisitor progress) throws SQLException, IOException {
        progress = DriverManager.check(connection, tableReference, fileName, progress);
        DBTypes dbType = DBUtils.getDBType((Connection)connection);
        TableLocation requestedTable = TableLocation.parse((String)tableReference, (DBTypes)dbType);
        if (fileName != null && fileName.getName().toLowerCase().endsWith(".tsv")) {
            if (!fileName.exists()) {
                throw new SQLException("The file " + requestedTable + " doesn't exist ");
            }
            if (deleteTables) {
                Statement stmt = connection.createStatement();
                stmt.execute("DROP TABLE IF EXISTS " + requestedTable);
                stmt.close();
            }
            String table = requestedTable.toString();
            int AVERAGE_NODE_SIZE = 500;
            FileInputStream fis = new FileInputStream(fileName);
            FileChannel fc = fis.getChannel();
            long fileSize = fc.size();
            long readFileSizeEachNode = Math.max(1L, fileSize / (long)AVERAGE_NODE_SIZE / 100L);
            int average_row_size = 0;
            Csv csv = new Csv();
            csv.setFieldDelimiter('\t');
            csv.setFieldSeparatorRead('\t');
            ResultSet reader = csv.read((Reader)new BufferedReader(new InputStreamReader(fis)), null);
            ResultSetMetaData metadata = reader.getMetaData();
            int columnCount = metadata.getColumnCount();
            StringBuilder createTable = new StringBuilder("CREATE TABLE ");
            createTable.append(table).append("(");
            StringBuilder insertTable = new StringBuilder("INSERT INTO ");
            insertTable.append(table).append(" VALUES(");
            for (int i = 0; i < columnCount; ++i) {
                if (i > 0) {
                    createTable.append(",");
                    insertTable.append(",");
                }
                createTable.append(metadata.getColumnName(i + 1)).append(" VARCHAR");
                insertTable.append("?");
            }
            createTable.append(")");
            insertTable.append(")");
            try (Statement stmt = connection.createStatement();){
                stmt.execute(createTable.toString());
            }
            long batchSize = 0L;
            try (PreparedStatement pst = connection.prepareStatement(insertTable.toString());){
                while (reader.next()) {
                    if (progress.isCanceled()) {
                        throw new SQLException("Canceled by user");
                    }
                    for (int i = 0; i < columnCount; ++i) {
                        pst.setString(i + 1, reader.getString(i + 1));
                    }
                    pst.addBatch();
                    if (++batchSize >= 200L) {
                        pst.executeBatch();
                        pst.clearBatch();
                        batchSize = 0L;
                    }
                    if ((long)average_row_size++ % readFileSizeEachNode != 0L) continue;
                    try {
                        progress.setStep((int)((double)fc.position() / (double)fileSize * 100.0));
                    }
                    catch (IOException iOException) {}
                }
                if (batchSize > 0L) {
                    pst.executeBatch();
                }
                String[] stringArray = new String[]{table};
                return stringArray;
            }
        }
        if (fileName != null && fileName.getName().toLowerCase().endsWith(".gz")) {
            if (!fileName.exists()) {
                throw new SQLException("The file " + requestedTable + " doesn't exist ");
            }
            if (deleteTables) {
                Statement stmt = connection.createStatement();
                stmt.execute("DROP TABLE IF EXISTS " + requestedTable);
                stmt.close();
            }
            Throwable throwable = null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(fileName))));){
                String[] stringArray;
                String table = requestedTable.toString();
                Csv csv = new Csv();
                csv.setFieldDelimiter('\t');
                csv.setFieldSeparatorRead('\t');
                ResultSet reader = csv.read((Reader)br, null);
                ResultSetMetaData metadata = reader.getMetaData();
                int columnCount = metadata.getColumnCount();
                StringBuilder createTable = new StringBuilder("CREATE TABLE ");
                createTable.append(table).append("(");
                StringBuilder insertTable = new StringBuilder("INSERT INTO ");
                insertTable.append(table).append(" VALUES(");
                for (int i = 0; i < columnCount; ++i) {
                    if (i > 0) {
                        createTable.append(",");
                        insertTable.append(",");
                    }
                    createTable.append(metadata.getColumnName(i + 1)).append(" VARCHAR");
                    insertTable.append("?");
                }
                createTable.append(")");
                insertTable.append(")");
                try (Statement stmt = connection.createStatement();){
                    stmt.execute(createTable.toString());
                }
                PreparedStatement pst = connection.prepareStatement(insertTable.toString());
                long batchSize = 0L;
                try {
                    while (reader.next()) {
                        if (progress.isCanceled()) {
                            throw new SQLException("Canceled by user");
                        }
                        for (int i = 0; i < columnCount; ++i) {
                            pst.setString(i + 1, reader.getString(i + 1));
                        }
                        pst.addBatch();
                        if (++batchSize < 200L) continue;
                        pst.executeBatch();
                        pst.clearBatch();
                        batchSize = 0L;
                    }
                    if (batchSize > 0L) {
                        pst.executeBatch();
                    }
                    stringArray = new String[]{table};
                }
                catch (Throwable throwable2) {
                    try {
                        pst.close();
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                pst.close();
                return stringArray;
            }
        }
        throw new SQLException("The TSV read driver supports only tsv or gz extensions");
    }
}

