/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.shp.internal;

import java.io.IOException;
import org.h2gis.functions.io.shp.internal.ShapeHandler;
import org.h2gis.functions.io.shp.internal.ShapeType;
import org.h2gis.functions.io.shp.internal.ShapefileException;
import org.h2gis.functions.io.utility.ReadBufferManager;
import org.h2gis.functions.io.utility.WriteBufferManager;
import org.h2gis.utilities.jts_utils.CoordinateUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.impl.PackedCoordinateSequence;

public class MultiLineHandler
implements ShapeHandler {
    final ShapeType shapeType;
    GeometryFactory geometryFactory = new GeometryFactory();

    public MultiLineHandler() {
        this.shapeType = ShapeType.ARC;
    }

    public MultiLineHandler(ShapeType type) throws ShapefileException {
        if (type != ShapeType.ARC && type != ShapeType.ARCM && type != ShapeType.ARCZ) {
            throw new ShapefileException("MultiLineHandler constructor - expected type to be 3,13 or 23");
        }
        this.shapeType = type;
    }

    @Override
    public ShapeType getShapeType() {
        return this.shapeType;
    }

    private MultiLineString castToMultiLineString(Object geometry) {
        if (geometry instanceof MultiLineString) {
            return (MultiLineString)geometry;
        }
        if (geometry instanceof LineString) {
            return this.geometryFactory.createMultiLineString(new LineString[]{(LineString)geometry});
        }
        throw new IllegalArgumentException("Only LineString and MultiLineString are managed by MultiLineHandler");
    }

    @Override
    public int getLength(Object geometry) {
        int length;
        Geometry geom = (Geometry)geometry;
        int numLines = geom.getNumGeometries();
        int numPoints = geom.getNumPoints();
        if (this.shapeType == ShapeType.ARC) {
            length = 44 + 4 * numLines + numPoints * 16;
        } else if (this.shapeType == ShapeType.ARCM) {
            length = 44 + 4 * numLines + numPoints * 16 + 8 + 8 + 8 * numPoints;
        } else if (this.shapeType == ShapeType.ARCZ) {
            length = 44 + 4 * numLines + numPoints * 16 + 8 + 8 + 8 * numPoints + 8 + 8 + 8 * numPoints;
        } else {
            throw new IllegalStateException("Expected ShapeType of Arc, got " + this.shapeType);
        }
        return length;
    }

    @Override
    public Geometry read(ReadBufferManager buffer, ShapeType type) throws IOException {
        int finish;
        int part;
        if (type == ShapeType.NULL) {
            return null;
        }
        int dimensions = this.shapeType == ShapeType.ARCZ ? 3 : 2;
        buffer.skip(32);
        int numParts = buffer.getInt();
        int numPoints = buffer.getInt();
        int[] partOffsets = new int[numParts];
        for (int i = 0; i < numParts; ++i) {
            partOffsets[i] = buffer.getInt();
        }
        PackedCoordinateSequence[] lines = new PackedCoordinateSequence[numParts];
        int start = 0;
        int length = 0;
        boolean clonePoint = false;
        for (part = 0; part < numParts; ++part) {
            finish = part == numParts - 1 ? numPoints : partOffsets[part + 1];
            length = finish - (start = partOffsets[part]);
            if (length == 1) {
                length = 2;
                clonePoint = true;
            } else {
                clonePoint = false;
            }
            PackedCoordinateSequence.Double builder = new PackedCoordinateSequence.Double(length, 3, 0);
            for (int i = 0; i < length; ++i) {
                builder.setOrdinate(i, 0, buffer.getDouble());
                builder.setOrdinate(i, 1, buffer.getDouble());
                builder.setOrdinate(i, 2, Double.NaN);
            }
            if (clonePoint) {
                builder.setOrdinate(1, 0, builder.getOrdinate(0, 0));
                builder.setOrdinate(1, 1, builder.getOrdinate(1, 0));
                builder.setOrdinate(1, 2, Double.NaN);
            }
            lines[part] = builder;
        }
        if (dimensions == 3) {
            buffer.skip(16);
            for (part = 0; part < numParts; ++part) {
                finish = part == numParts - 1 ? numPoints : partOffsets[part + 1];
                length = finish - (start = partOffsets[part]);
                if (length == 1) {
                    length = 2;
                    clonePoint = true;
                } else {
                    clonePoint = false;
                }
                for (int i = 0; i < length; ++i) {
                    lines[part].setOrdinate(i, 2, buffer.getDouble());
                }
            }
        }
        LineString[] lineStrings = new LineString[numParts];
        for (int part2 = 0; part2 < numParts; ++part2) {
            lineStrings[part2] = this.geometryFactory.createLineString((CoordinateSequence)lines[part2]);
        }
        return this.geometryFactory.createMultiLineString(lineStrings);
    }

    @Override
    public void write(WriteBufferManager buffer, Object geometry) throws IOException {
        int t;
        MultiLineString multi = this.castToMultiLineString(geometry);
        Envelope box = multi.getEnvelopeInternal();
        buffer.putDouble(box.getMinX());
        buffer.putDouble(box.getMinY());
        buffer.putDouble(box.getMaxX());
        buffer.putDouble(box.getMaxY());
        int numParts = multi.getNumGeometries();
        buffer.putInt(numParts);
        int npoints = multi.getNumPoints();
        buffer.putInt(npoints);
        LineString[] lines = new LineString[numParts];
        int idx = 0;
        for (int i = 0; i < numParts; ++i) {
            lines[i] = (LineString)multi.getGeometryN(i);
            buffer.putInt(idx);
            idx += lines[i].getNumPoints();
        }
        Coordinate[] coords = multi.getCoordinates();
        for (t = 0; t < npoints; ++t) {
            buffer.putDouble(coords[t].x);
            buffer.putDouble(coords[t].y);
        }
        if (this.shapeType == ShapeType.ARCZ) {
            double[] zExtreame = CoordinateUtils.zMinMax((Coordinate[])coords);
            if (Double.isNaN(zExtreame[0])) {
                buffer.putDouble(0.0);
                buffer.putDouble(0.0);
            } else {
                buffer.putDouble(zExtreame[0]);
                buffer.putDouble(zExtreame[1]);
            }
            for (int t2 = 0; t2 < npoints; ++t2) {
                double z = coords[t2].z;
                if (Double.isNaN(z)) {
                    buffer.putDouble(0.0);
                    continue;
                }
                buffer.putDouble(z);
            }
        }
        if (this.shapeType == ShapeType.ARCZ) {
            buffer.putDouble(-1.0E41);
            buffer.putDouble(-1.0E41);
            for (t = 0; t < npoints; ++t) {
                buffer.putDouble(-1.0E41);
            }
        }
    }
}

