/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.dbf.internal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Calendar;
import org.h2.value.Value;
import org.h2.value.ValueBigint;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueDouble;
import org.h2.value.ValueInteger;
import org.h2.value.ValueNull;
import org.h2.value.ValueVarchar;
import org.h2gis.functions.io.dbf.internal.DbaseFileHeader;
import org.h2gis.functions.io.utility.ReadBufferManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbaseFileReader {
    private DbaseFileHeader header;
    private ReadBufferManager buffer;
    private FileChannel channel;
    private CharBuffer charBuffer;
    private CharsetDecoder decoder;
    private char[] fieldTypes;
    private int[] fieldLengths;
    private static final Logger LOG = LoggerFactory.getLogger(DbaseFileReader.class);

    public DbaseFileReader(FileChannel channel, String forceEncoding) throws IOException {
        this.channel = channel;
        this.header = new DbaseFileHeader();
        this.header.readHeader(channel, forceEncoding);
        this.init();
    }

    private void init() throws IOException {
        this.buffer = new ReadBufferManager(this.channel);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.fieldTypes = new char[this.header.getNumFields()];
        this.fieldLengths = new int[this.header.getNumFields()];
        int ii = this.header.getNumFields();
        for (int i = 0; i < ii; ++i) {
            this.fieldTypes[i] = this.header.getFieldType(i);
            this.fieldLengths[i] = this.header.getFieldLength(i);
        }
        this.charBuffer = CharBuffer.allocate(this.header.getRecordLength() - 1);
        Charset chars = Charset.forName(this.header.getFileEncoding());
        this.decoder = chars.newDecoder();
    }

    public DbaseFileHeader getHeader() {
        return this.header;
    }

    public void close() throws IOException {
        if (this.channel != null && this.channel.isOpen()) {
            this.channel.close();
        }
        this.buffer = null;
        this.channel = null;
        this.charBuffer = null;
        this.decoder = null;
        this.header = null;
    }

    private byte[] getBytes(long pos, int length) throws IOException {
        byte[] bytes = new byte[length];
        this.buffer.get(pos, bytes);
        return bytes;
    }

    public Value getFieldValue(int row, int column) throws IOException {
        long fieldPosition = this.getPositionFor(row, column);
        int fieldLength = this.getLengthFor(column);
        byte[] fieldBytes = this.getBytes(fieldPosition, fieldLength);
        ByteBuffer field = ByteBuffer.wrap(fieldBytes);
        this.charBuffer.clear();
        this.decoder.decode(field, this.charBuffer, true);
        this.charBuffer.flip();
        return this.readObject(0, column);
    }

    public int getLengthFor(int column) {
        return this.header.getFieldLength(column);
    }

    protected long getPositionFor(int row, int column) {
        long recordOffset = (long)this.header.getHeaderLength() + (long)row * (long)this.header.getRecordLength() + 1L;
        long fieldOffset = 0L;
        for (int i = 0; i < column; ++i) {
            fieldOffset += (long)this.header.getFieldLength(i);
        }
        return fieldOffset + recordOffset;
    }

    private Value readObject(int fieldOffset, int fieldNum) throws IOException {
        char type = this.fieldTypes[fieldNum];
        int fieldLen = this.fieldLengths[fieldNum];
        ValueNull object = null;
        if (fieldLen > 0) {
            block5 : switch (type) {
                case 'L': 
                case 'l': {
                    char cBool = this.charBuffer.charAt(fieldOffset);
                    switch (cBool) {
                        case 'T': 
                        case 'Y': 
                        case 't': 
                        case 'y': {
                            object = ValueBoolean.TRUE;
                            break block5;
                        }
                        case 'F': 
                        case 'N': 
                        case 'f': 
                        case 'n': {
                            object = ValueBoolean.FALSE;
                            break block5;
                        }
                    }
                    object = ValueNull.INSTANCE;
                    break;
                }
                case 'C': 
                case 'c': {
                    if (this.charBuffer.charAt(fieldOffset) != '\u0000') {
                        char c;
                        int start;
                        int end = Math.min(fieldOffset + fieldLen - 1, this.charBuffer.length() - 1);
                        for (start = fieldOffset; start < end && ((c = this.charBuffer.get(start)) == '\u0000' || Character.isWhitespace(c)); ++start) {
                        }
                        while (end > start) {
                            try {
                                c = this.charBuffer.get(end);
                                if (c != '\u0000' && !Character.isWhitespace(c)) break;
                                --end;
                            }
                            catch (IndexOutOfBoundsException ex) {
                                throw new IndexOutOfBoundsException();
                            }
                        }
                        object = ValueVarchar.get((String)new String(this.charBuffer.array(), start, end + 1 - start));
                        break;
                    }
                    object = ValueNull.INSTANCE;
                    break;
                }
                case 'D': 
                case 'd': {
                    if (this.charBuffer.toString().equals("00000000")) {
                        object = ValueNull.INSTANCE;
                        break;
                    }
                    try {
                        String tempString = this.charBuffer.subSequence(fieldOffset, fieldOffset + 4).toString();
                        if (!tempString.trim().isEmpty()) {
                            int tempYear = Integer.parseInt(tempString);
                            tempString = this.charBuffer.subSequence(fieldOffset + 4, fieldOffset + 6).toString();
                            int tempMonth = Integer.parseInt(tempString) - 1;
                            tempString = this.charBuffer.subSequence(fieldOffset + 6, fieldOffset + 8).toString();
                            int tempDay = Integer.parseInt(tempString);
                            Calendar cal = Calendar.getInstance();
                            cal.clear();
                            cal.set(1, tempYear);
                            cal.set(2, tempMonth);
                            cal.set(5, tempDay);
                            object = ValueNull.INSTANCE;
                            break;
                        }
                        object = ValueNull.INSTANCE;
                    }
                    catch (NumberFormatException nfe) {
                        LOG.warn("There was an error parsing a date. Ignoring it.", (Throwable)nfe);
                    }
                    break;
                }
                case 'N': 
                case 'n': {
                    if (this.charBuffer.charAt(fieldOffset) == '*') {
                        object = ValueNull.INSTANCE;
                        break;
                    }
                    try {
                        if (this.header.getFieldDecimalCount(fieldNum) == 0) {
                            String numberString = this.extractNumberString(this.charBuffer, fieldOffset, fieldLen);
                            object = ValueInteger.get((int)Integer.parseInt(numberString));
                            break;
                        }
                    }
                    catch (NumberFormatException e) {
                        try {
                            String numberString = this.extractNumberString(this.charBuffer, fieldOffset, fieldLen);
                            object = ValueBigint.get((long)Long.parseLong(numberString));
                            break;
                        }
                        catch (NumberFormatException numberString) {
                            // empty catch block
                        }
                    }
                }
                case 'F': 
                case 'f': {
                    if (this.charBuffer.charAt(fieldOffset) == '*') {
                        object = ValueNull.INSTANCE;
                        break;
                    }
                    String numberString = this.extractNumberString(this.charBuffer, fieldOffset, fieldLen);
                    try {
                        object = ValueDouble.get((double)Double.parseDouble(numberString));
                    }
                    catch (NumberFormatException e) {
                        if (numberString.contains(",")) {
                            object = ValueDouble.get((double)Double.parseDouble(numberString.replace(",", ".")));
                            break;
                        }
                        object = ValueNull.INSTANCE;
                    }
                    break;
                }
                default: {
                    throw new IOException("Invalid field type : " + type);
                }
            }
        }
        return object;
    }

    private String extractNumberString(CharBuffer charBuffer2, int fieldOffset, int fieldLen) {
        return charBuffer2.subSequence(fieldOffset, fieldOffset + fieldLen).toString().trim();
    }

    public int getRecordCount() {
        return this.header.getNumRecords();
    }

    public int getFieldCount() {
        return this.header.getNumFields();
    }
}

