/*
 * Decompiled with CFR 0.152.
 */
package org.javanetworkanalyzer.analyzers;

import java.lang.reflect.InvocationTargetException;
import org.javanetworkanalyzer.alg.BFSForCentrality;
import org.javanetworkanalyzer.analyzers.GraphAnalyzer;
import org.javanetworkanalyzer.data.UnweightedPathLengthData;
import org.javanetworkanalyzer.data.VUCent;
import org.javanetworkanalyzer.model.EdgeCent;
import org.javanetworkanalyzer.progress.NullProgressMonitor;
import org.javanetworkanalyzer.progress.ProgressMonitor;
import org.jgrapht.Graph;

public class UnweightedGraphAnalyzer<E extends EdgeCent>
extends GraphAnalyzer<VUCent, E, UnweightedPathLengthData> {
    private final BFSForCentrality<E> bfs;

    public UnweightedGraphAnalyzer(Graph<VUCent, E> graph, ProgressMonitor pm) throws NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        super(graph, pm);
        this.bfs = new BFSForCentrality<E>(graph, this.stack);
    }

    public UnweightedGraphAnalyzer(Graph<VUCent, E> graph) throws NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this(graph, (ProgressMonitor)new NullProgressMonitor());
    }

    protected BFSForCentrality<E> calculateShortestPathsFromNode(VUCent startNode) {
        this.bfs.calculate(startNode);
        return this.bfs;
    }

    @Override
    public void computeAll() throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.pm.startTask("Unweighted graph analysis", this.nodeCount);
        super.computeAll();
        this.pm.endTask();
    }
}

