/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.osgi;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.h2gis.functions.osgi.FunctionTracker;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.dbtypes.DBTypes;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class DataSourceTracker
implements ServiceTrackerCustomizer<DataSource, FunctionTracker> {
    private BundleContext bundleContext;

    public DataSourceTracker(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FunctionTracker addingService(ServiceReference<DataSource> dataSourceServiceReference) {
        DataSource dataSource = (DataSource)this.bundleContext.getService(dataSourceServiceReference);
        try (Connection connection = dataSource.getConnection();){
            DatabaseMetaData meta = connection.getMetaData();
            if (!"H2 JDBC Driver".equals(meta.getDriverName()) || meta.getURL() != null && meta.getURL().toLowerCase().startsWith("jdbc:h2:tcp://")) {
                FunctionTracker functionTracker = null;
                return functionTracker;
            }
            if (!JDBCUtilities.tableExists((Connection)connection, (TableLocation)TableLocation.parse((String)"PUBLIC.GEOMETRY_COLUMNS", (DBTypes)DBTypes.H2))) {
                FunctionTracker functionTracker = null;
                return functionTracker;
            }
        }
        catch (SQLException ex) {
            System.err.print(ex.toString());
        }
        FunctionTracker functionTracker = new FunctionTracker(dataSource, this.bundleContext);
        functionTracker.open();
        return functionTracker;
    }

    public void modifiedService(ServiceReference<DataSource> dataSourceServiceReference, FunctionTracker functionTracker) {
    }

    public void removedService(ServiceReference<DataSource> dataSourceServiceReference, FunctionTracker functionTracker) {
        if (functionTracker != null) {
            functionTracker.close();
        }
    }
}

