/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.commons.printer;

import org.orbisgis.commons.annotations.NotNull;
import org.orbisgis.commons.printer.ICustomPrinter;
import org.orbisgis.commons.utilities.CheckUtils;

public abstract class CustomPrinter
implements ICustomPrinter {
    @NotNull
    protected StringBuilder builder;
    protected int columnWidth;
    protected int columnCount;
    protected boolean isDrawingTable;
    protected int columnIndex;

    protected CustomPrinter(@NotNull StringBuilder builder) {
        CheckUtils.checkNotNull(builder, "The builder should not be null.");
        this.builder = builder;
    }

    @Override
    @NotNull
    public String toString() {
        return this.builder.toString();
    }

    @Override
    public void startTable(int columnWidth, int columnCount) {
        this.columnCount = columnCount;
        this.columnWidth = columnWidth;
        this.columnIndex = 0;
        this.isDrawingTable = true;
    }

    @Override
    public void endTable() {
        this.columnCount = -1;
        this.columnWidth = -1;
        this.columnIndex = -1;
        this.isDrawingTable = false;
    }

    @Override
    public void appendTableValue(@NotNull Object value) {
        CheckUtils.checkNotNull(value, "The value to append should not be null.");
        this.appendTableValue(value, ICustomPrinter.CellPosition.LEFT);
    }
}

