/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.properties;

import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;

public class ST_PointN
extends DeterministicScalarFunction {
    private static final String OUT_OF_BOUNDS_ERR_MESSAGE = "Point index out of range. Must be between 1 and ST_NumPoints.";

    public ST_PointN() {
        this.addProperty("remarks", "Returns the <i>n</i>th point of a LINESTRING or a MULTILINESTRING containing exactly one LINESTRING; NULL otherwise. As the OGC specifies, ST_PointN is 1-N based.");
    }

    public String getJavaStaticMethod() {
        return "getPointN";
    }

    public static Geometry getPointN(Geometry geometry, int pointIndex) throws SQLException {
        if (geometry == null) {
            return null;
        }
        if (geometry instanceof MultiLineString) {
            if (geometry.getNumGeometries() == 1) {
                return ST_PointN.getPointNFromLine((LineString)geometry.getGeometryN(0), pointIndex);
            }
        } else if (geometry instanceof LineString) {
            return ST_PointN.getPointNFromLine((LineString)geometry, pointIndex);
        }
        return null;
    }

    private static Geometry getPointNFromLine(LineString line, int pointIndex) throws SQLException {
        if (pointIndex <= 0 || pointIndex <= line.getNumPoints()) {
            return line.getPointN(pointIndex - 1);
        }
        throw new SQLException(OUT_OF_BOUNDS_ERR_MESSAGE);
    }
}

