/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.properties;

import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;

public class ST_CompactnessRatio
extends DeterministicScalarFunction {
    public ST_CompactnessRatio() {
        this.addProperty("remarks", "Returns the compactness ratio of the given polygon, defined to be the the perimeter of a circle whose area is equal to the given geometry's area divided by the given polygon's perimeter.");
    }

    public String getJavaStaticMethod() {
        return "computeCompacity";
    }

    public static Double computeCompacity(Geometry geom) {
        if (geom == null) {
            return null;
        }
        if (geom instanceof Polygon) {
            double circleRadius = Math.sqrt(geom.getArea() / Math.PI);
            double circleCurcumference = Math.PI * 2 * circleRadius;
            return circleCurcumference / geom.getLength();
        }
        return null;
    }
}

