/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.earth;

import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.utilities.jts_utils.VisibilityAlgorithm;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.GeometricShapeFactory;

public class ST_Isovist
extends DeterministicScalarFunction {
    public ST_Isovist() {
        this.addProperty("remarks", "ST_Isovist takes LINESTRING(S) or POLYGON(S) as input\n and a maximum distance (spatial ref units). This function compute the visibility polygon obstructed by provided \"walls\". Provided segments will be enclosed by a circle defined by maximum distance parameter.");
    }

    public String getJavaStaticMethod() {
        return "isovist";
    }

    public static Geometry isovist(Geometry viewPoint, Geometry lineSegments, double maxDistance) throws SQLException {
        if (!(viewPoint instanceof Point) || viewPoint.isEmpty()) {
            throw new SQLException("First parameter of ST_Isovist must be a Point");
        }
        if (viewPoint.getSRID() != lineSegments.getSRID()) {
            throw new SQLException("Operation on mixed SRID geometries not supported");
        }
        if (maxDistance <= 0.0) {
            throw new SQLException("Third parameter of ST_Isovist must be a valid distance superior than 0");
        }
        VisibilityAlgorithm visibilityAlgorithm = new VisibilityAlgorithm(maxDistance);
        visibilityAlgorithm.addGeometry(lineSegments);
        Polygon geomIsovist = visibilityAlgorithm.getIsoVist(viewPoint.getCoordinate(), true);
        geomIsovist.setSRID(viewPoint.getSRID());
        return geomIsovist;
    }

    public static Geometry isovist(Geometry viewPoint, Geometry lineSegments, double maxDistance, double radBegin, double radSize) throws SQLException {
        if (radSize <= 0.0) {
            throw new SQLException("Angle size must be superior than 0 rad");
        }
        Geometry isopoly = ST_Isovist.isovist(viewPoint, lineSegments, maxDistance);
        GeometricShapeFactory geometricShapeFactory = new GeometricShapeFactory();
        geometricShapeFactory.setCentre(viewPoint.getCoordinate());
        geometricShapeFactory.setWidth(maxDistance * 2.0);
        geometricShapeFactory.setHeight(maxDistance * 2.0);
        return geometricShapeFactory.createArcPolygon(radBegin, radSize).intersection(isopoly);
    }
}

