/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.distance;

import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.functions.spatial.distance.MaxDistanceOp;
import org.locationtech.jts.geom.Geometry;

public class ST_MaxDistance
extends DeterministicScalarFunction {
    public ST_MaxDistance() {
        this.addProperty("remarks", "Returns the 2-dimensional largest distance between two geometries in projected units.\nIf the geometry 1 and geometry 2 is the same geometry the function will \n return the distance between the two vertices most far from each other in that geometry.");
    }

    public String getJavaStaticMethod() {
        return "maxDistance";
    }

    public static Double maxDistance(Geometry geomA, Geometry geomB) throws SQLException {
        if (geomA == null || geomB == null) {
            return null;
        }
        if (geomA.getSRID() != geomB.getSRID()) {
            throw new SQLException("Operation on mixed SRID geometries not supported");
        }
        return new MaxDistanceOp(geomA, geomB).getDistance();
    }
}

