/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.distance;

import java.util.HashSet;
import java.util.Set;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Polygon;

public class ST_LocateAlong
extends DeterministicScalarFunction {
    public ST_LocateAlong() {
        this.addProperty("remarks", "Returns a MULTIPOINT containing points along the line segments of the given geometry matching the specified segment length fraction and offset distance. A positive offset places the point to the left of the segment (with the ordering given by Coordinate traversal); a negative offset to the right. For areal elements, only exterior rings are supported.");
    }

    public String getJavaStaticMethod() {
        return "locateAlong";
    }

    public static MultiPoint locateAlong(Geometry geom, double segmentLengthFraction, double offsetDistance) {
        if (geom == null) {
            return null;
        }
        if (geom.getDimension() == 0) {
            return null;
        }
        HashSet<Coordinate> result = new HashSet<Coordinate>();
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Geometry subGeom = geom.getGeometryN(i);
            if (subGeom instanceof Polygon) {
                result.addAll(ST_LocateAlong.computePoints(((Polygon)subGeom).getExteriorRing().getCoordinates(), segmentLengthFraction, offsetDistance));
                continue;
            }
            if (!(subGeom instanceof LineString)) continue;
            result.addAll(ST_LocateAlong.computePoints(subGeom.getCoordinates(), segmentLengthFraction, offsetDistance));
        }
        return geom.getFactory().createMultiPoint(result.toArray(new Coordinate[0]));
    }

    private static Set<Coordinate> computePoints(Coordinate[] coords, double segmentLengthFraction, double offsetDistance) {
        HashSet<Coordinate> pointsToAdd = new HashSet<Coordinate>();
        for (int j = 0; j < coords.length - 1; ++j) {
            LineSegment segment = new LineSegment(coords[j], coords[j + 1]);
            pointsToAdd.add(segment.pointAlongOffset(segmentLengthFraction, offsetDistance));
        }
        return pointsToAdd;
    }
}

