/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.tsv;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;
import org.h2.value.ValueVarchar;
import org.h2gis.api.AbstractFunction;
import org.h2gis.api.EmptyProgressVisitor;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.api.ScalarFunction;
import org.h2gis.functions.io.tsv.TSVDriverFunction;
import org.h2gis.utilities.URIUtilities;

public class TSVRead
extends AbstractFunction
implements ScalarFunction {
    public TSVRead() {
        this.addProperty("remarks", "Read a Tab-separated values file.\n TSVRead(...\n Supported arguments :\n path of the file\n path of the file, table name\n path of the file, table name, true to delete the table name\n path of the file, table name, encoding chartset\n path of the file, table name, encoding chartset, true to delete the table name");
    }

    public String getJavaStaticMethod() {
        return "importTable";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void importTable(Connection connection, String fileName, Value option) throws SQLException, FileNotFoundException, IOException {
        String tableReference = null;
        boolean deleteTable = false;
        if (option instanceof ValueBoolean) {
            deleteTable = option.getBoolean();
            String name = URIUtilities.fileFromString((String)fileName).getName();
            String tableName = name.substring(0, name.lastIndexOf(".")).replace(".", "_").toUpperCase();
            if (!tableName.matches("^[a-zA-Z][a-zA-Z0-9_]*$")) throw new SQLException("The file name contains unsupported characters");
            TSVRead.importTable(connection, fileName, tableName, null, deleteTable);
            return;
        } else if (option instanceof ValueVarchar) {
            tableReference = option.getString();
            TSVRead.importTable(connection, fileName, tableReference, null, deleteTable);
            return;
        } else {
            if (option instanceof ValueNull) return;
            throw new SQLException("Supported optional parameter is boolean or varchar");
        }
    }

    public static void importTable(Connection connection, String fileName, String tableReference, Value option) throws SQLException, IOException {
        String encoding = null;
        boolean deleteTable = false;
        if (option instanceof ValueBoolean) {
            deleteTable = option.getBoolean();
        } else if (option instanceof ValueVarchar) {
            encoding = option.getString();
        } else if (!(option instanceof ValueNull)) {
            throw new SQLException("Supported optional parameter is boolean or varchar");
        }
        TSVRead.importTable(connection, fileName, tableReference, encoding, deleteTable);
    }

    public static void importTable(Connection connection, String fileName, String tableReference, String encoding, boolean deleteTable) throws SQLException, FileNotFoundException, IOException {
        TSVDriverFunction tsvDriver = new TSVDriverFunction();
        tsvDriver.importFile(connection, tableReference, URIUtilities.fileFromString((String)fileName), encoding, deleteTable, (ProgressVisitor)new EmptyProgressVisitor());
    }

    public static void importTable(Connection connection, String fileName) throws IOException, SQLException {
        String name = URIUtilities.fileFromString((String)fileName).getName();
        String tableName = name.substring(0, name.lastIndexOf(".")).toUpperCase().replace(".", "_");
        if (!tableName.matches("^[a-zA-Z][a-zA-Z0-9_]*$")) {
            throw new SQLException("The file name contains unsupported characters");
        }
        TSVRead.importTable(connection, fileName, tableName, null, false);
    }
}

