/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.osm;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;
import org.h2.value.ValueVarchar;
import org.h2gis.api.AbstractFunction;
import org.h2gis.api.EmptyProgressVisitor;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.api.ScalarFunction;
import org.h2gis.functions.io.osm.OSMDriverFunction;
import org.h2gis.utilities.URIUtilities;

public class OSMRead
extends AbstractFunction
implements ScalarFunction {
    public OSMRead() {
        this.addProperty("remarks", "Read a OSM file and copy the content in the specified tables.\nThe user can set a prefix name for all OSM tables and specify if the existing OSM\n tables must be dropped.\n OSMRead(...\n Supported arguments :\n path of the file\n path of the file, table name\n path of the file, true for delete the table with the same file name\n path of the file, table name, encoding chartset\n path of the file, table name, encoding chartset, true to delete the table name");
    }

    public String getJavaStaticMethod() {
        return "importTable";
    }

    public static void importTable(Connection connection, String fileName, String tableReference, Value option) throws SQLException, IOException {
        String encoding = null;
        boolean deleteTable = false;
        if (option instanceof ValueBoolean) {
            deleteTable = option.getBoolean();
        } else if (option instanceof ValueVarchar) {
            encoding = option.getString();
        } else if (!(option instanceof ValueNull)) {
            throw new SQLException("Supported optional parameter is boolean or varchar");
        }
        OSMRead.importTable(connection, fileName, tableReference, encoding, deleteTable);
    }

    public static void importTable(Connection connection, String fileName, Value option) throws SQLException, IOException {
        String tableReference = null;
        boolean deleteTable = false;
        if (option instanceof ValueBoolean) {
            deleteTable = option.getBoolean();
            String name = URIUtilities.fileFromString((String)fileName).getName();
            tableReference = name.substring(0, name.lastIndexOf(".")).replace(".", "_").toUpperCase();
            if (!tableReference.matches("^[a-zA-Z][a-zA-Z0-9_]*$")) {
                throw new SQLException("The file name contains unsupported characters");
            }
        } else if (option instanceof ValueVarchar) {
            tableReference = option.getString();
        } else if (!(option instanceof ValueNull)) {
            throw new SQLException("Supported optional parameter is boolean or varchar");
        }
        OSMRead.importTable(connection, fileName, tableReference, null, deleteTable);
    }

    public static void importTable(Connection connection, String fileName, String tableReference, String encoding, boolean deleteTables) throws FileNotFoundException, SQLException, IOException {
        OSMDriverFunction osmdf = new OSMDriverFunction();
        osmdf.importFile(connection, tableReference, URIUtilities.fileFromString((String)fileName), encoding, deleteTables, (ProgressVisitor)new EmptyProgressVisitor());
    }

    public static void importTable(Connection connection, String fileName) throws SQLException, IOException {
        String name = URIUtilities.fileFromString((String)fileName).getName();
        String tableName = name.substring(0, name.lastIndexOf(".")).toUpperCase().replace(".", "_");
        if (!tableName.matches("^[a-zA-Z][a-zA-Z0-9_]*$")) {
            throw new SQLException("The file name contains unsupported characters");
        }
        OSMRead.importTable(connection, fileName, tableName, null, false);
    }
}

