/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.osm;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.h2gis.api.EmptyProgressVisitor;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.functions.io.osm.NodeOSMElement;
import org.h2gis.functions.io.osm.OSMElement;
import org.h2gis.functions.io.osm.OSMTablesFactory;
import org.h2gis.functions.io.osm.TAG_LOCATION;
import org.h2gis.functions.io.osm.WayOSMElement;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.TableUtilities;
import org.h2gis.utilities.dbtypes.DBTypes;
import org.h2gis.utilities.dbtypes.DBUtils;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class OSMParser
extends DefaultHandler {
    private final File fileName;
    private final String encoding;
    private final boolean deleteTable;
    private static final int BATCH_SIZE = 8000;
    private PreparedStatement nodePreparedStmt;
    private PreparedStatement nodeTagPreparedStmt;
    private PreparedStatement wayPreparedStmt;
    private PreparedStatement wayTagPreparedStmt;
    private PreparedStatement relationPreparedStmt;
    private PreparedStatement relationTagPreparedStmt;
    private PreparedStatement nodeMemberPreparedStmt;
    private PreparedStatement wayMemberPreparedStmt;
    private PreparedStatement relationMemberPreparedStmt;
    private PreparedStatement wayNodePreparedStmt;
    private int nodePreparedStmtBatchSize = 0;
    private int nodeTagPreparedStmtBatchSize = 0;
    private int wayPreparedStmtBatchSize = 0;
    private int wayTagPreparedStmtBatchSize = 0;
    private int relationPreparedStmtBatchSize = 0;
    private int relationTagPreparedStmtBatchSize = 0;
    private int nodeMemberPreparedStmtBatchSize = 0;
    private int wayMemberPreparedStmtBatchSize = 0;
    private int relationMemberPreparedStmtBatchSize = 0;
    private int wayNodePreparedStmtBatchSize = 0;
    private Set<String> insertedTagsKeys = new HashSet<String>();
    private int idMemberOrder = 1;
    private TAG_LOCATION tagLocation;
    private final GeometryFactory gf = new GeometryFactory(new PrecisionModel(), 4326);
    private NodeOSMElement nodeOSMElement;
    private WayOSMElement wayOSMElement;
    private OSMElement relationOSMElement;
    private ProgressVisitor progress = new EmptyProgressVisitor();
    private FileChannel fc;
    private long fileSize = 0L;
    private long readFileSizeEachNode = 1L;
    private long nodeCountProgress = 0L;
    private static final int AVERAGE_NODE_SIZE = 500;
    private static String TAG_DUPLICATE_EXCEPTION = String.valueOf(23505);
    private Connection connection;

    public OSMParser(Connection connection, File fileName, String encoding, boolean deleteTable) {
        this.connection = connection;
        this.fileName = fileName;
        this.encoding = encoding;
        this.deleteTable = deleteTable;
    }

    public String[] read(String tableName, ProgressVisitor progress) throws SQLException {
        if (this.fileName == null || !this.fileName.getName().endsWith(".osm") && !this.fileName.getName().endsWith("osm.gz") && !this.fileName.getName().endsWith("osm.bz2")) {
            throw new SQLException(new IllegalArgumentException("This driver handle only .osm, .osm.gz and .osm.bz2 files"));
        }
        this.progress = progress.subProcess(100);
        DBTypes dbType = DBUtils.getDBType((Connection)this.connection);
        this.connection.setAutoCommit(false);
        TableLocation requestedTable = TableLocation.parse((String)tableName, (DBTypes)dbType);
        String osmTableName = requestedTable.toString();
        if (this.deleteTable) {
            OSMTablesFactory.dropOSMTables(this.connection, requestedTable.toString());
        }
        this.checkOSMTables(this.connection, dbType, requestedTable, osmTableName);
        String[] outputOSMTableNames = this.createOSMDatabaseModel(this.connection, dbType, requestedTable, osmTableName);
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(this.fileName);
            this.fc = fs.getChannel();
            this.fileSize = this.fc.size();
            if (this.fileSize > 0L) {
                this.readFileSizeEachNode = Math.max(1L, this.fileSize / 500L / 100L);
                this.nodeCountProgress = 0L;
                XMLReader parser = XMLReaderFactory.createXMLReader();
                parser.setErrorHandler(this);
                parser.setContentHandler(this);
                if (this.fileName.getName().endsWith(".osm")) {
                    InputSource is = new InputSource(fs);
                    if (this.encoding != null && !this.encoding.isEmpty()) {
                        is.setEncoding(this.encoding);
                    }
                    parser.parse(is);
                    String[] stringArray = outputOSMTableNames;
                    return stringArray;
                }
                if (this.fileName.getName().endsWith(".osm.gz")) {
                    InputSource is = new InputSource(new GZIPInputStream(fs));
                    if (this.encoding != null && !this.encoding.isEmpty()) {
                        is.setEncoding(this.encoding);
                    }
                    parser.parse(is);
                    String[] stringArray = outputOSMTableNames;
                    return stringArray;
                }
                if (this.fileName.getName().endsWith(".osm.bz2")) {
                    InputSource is = new InputSource((InputStream)new BZip2CompressorInputStream((InputStream)fs));
                    if (this.encoding != null && !this.encoding.isEmpty()) {
                        is.setEncoding(this.encoding);
                    }
                    parser.parse(is);
                    String[] stringArray = outputOSMTableNames;
                    return stringArray;
                }
                throw new SQLException("Supported formats are .osm, .osm.gz, .osm.bz2");
            }
        }
        catch (SAXException ex) {
            throw new SQLException(ex);
        }
        catch (IOException ex) {
            throw new SQLException("Cannot parse the file " + this.fileName.getAbsolutePath(), ex);
        }
        finally {
            try {
                if (fs != null) {
                    fs.close();
                }
            }
            catch (IOException ex) {
                throw new SQLException("Cannot close the file " + this.fileName.getAbsolutePath(), ex);
            }
            if (this.nodePreparedStmt != null) {
                this.nodePreparedStmt.close();
            }
            if (this.nodeTagPreparedStmt != null) {
                this.nodeTagPreparedStmt.close();
            }
            if (this.wayPreparedStmt != null) {
                this.wayPreparedStmt.close();
            }
            if (this.wayTagPreparedStmt != null) {
                this.wayTagPreparedStmt.close();
            }
            if (this.wayNodePreparedStmt != null) {
                this.wayNodePreparedStmt.close();
            }
            if (this.relationPreparedStmt != null) {
                this.relationPreparedStmt.close();
            }
            if (this.relationTagPreparedStmt != null) {
                this.relationTagPreparedStmt.close();
            }
            if (this.nodeMemberPreparedStmt != null) {
                this.nodeMemberPreparedStmt.close();
            }
            if (this.wayMemberPreparedStmt != null) {
                this.wayMemberPreparedStmt.close();
            }
            if (this.relationMemberPreparedStmt != null) {
                this.relationMemberPreparedStmt.close();
            }
            this.connection.setAutoCommit(true);
        }
        return null;
    }

    private void checkOSMTables(Connection connection, DBTypes dbType, TableLocation requestedTable, String osmTableName) throws SQLException {
        String[] omsTables;
        for (String omsTableSuffix : omsTables = new String[]{"_node", "_node_tag", "_way", "_way_node", "_way_tag", "_relation", "_relation_tag", "_node_member", "_way_member", "_relation_member"}) {
            String osmTable = TableUtilities.caseIdentifier((TableLocation)requestedTable, (String)(osmTableName + omsTableSuffix), (DBTypes)dbType);
            if (!JDBCUtilities.tableExists((Connection)connection, (TableLocation)TableLocation.parse((String)osmTable, (DBTypes)dbType))) continue;
            throw new SQLException("The table " + osmTable + " already exists.");
        }
    }

    private String[] createOSMDatabaseModel(Connection connection, DBTypes dbType, TableLocation requestedTable, String osmTableName) throws SQLException {
        String nodeTableName = TableUtilities.caseIdentifier((TableLocation)requestedTable, (String)(osmTableName + "_node"), (DBTypes)dbType);
        this.nodePreparedStmt = OSMTablesFactory.createNodeTable(connection, nodeTableName);
        String nodeTagTableName = TableUtilities.caseIdentifier((TableLocation)requestedTable, (String)(osmTableName + "_node_tag"), (DBTypes)dbType);
        this.nodeTagPreparedStmt = OSMTablesFactory.createNodeTagTable(connection, nodeTagTableName);
        String wayTableName = TableUtilities.caseIdentifier((TableLocation)requestedTable, (String)(osmTableName + "_way"), (DBTypes)dbType);
        this.wayPreparedStmt = OSMTablesFactory.createWayTable(connection, wayTableName);
        String wayTagTableName = TableUtilities.caseIdentifier((TableLocation)requestedTable, (String)(osmTableName + "_way_tag"), (DBTypes)dbType);
        this.wayTagPreparedStmt = OSMTablesFactory.createWayTagTable(connection, wayTagTableName);
        String wayNodeTableName = TableUtilities.caseIdentifier((TableLocation)requestedTable, (String)(osmTableName + "_way_node"), (DBTypes)dbType);
        this.wayNodePreparedStmt = OSMTablesFactory.createWayNodeTable(connection, wayNodeTableName);
        String relationTableName = TableUtilities.caseIdentifier((TableLocation)requestedTable, (String)(osmTableName + "_relation"), (DBTypes)dbType);
        this.relationPreparedStmt = OSMTablesFactory.createRelationTable(connection, relationTableName);
        String relationTagTableName = TableUtilities.caseIdentifier((TableLocation)requestedTable, (String)(osmTableName + "_relation_tag"), (DBTypes)dbType);
        this.relationTagPreparedStmt = OSMTablesFactory.createRelationTagTable(connection, relationTagTableName);
        String nodeMemberTableName = TableUtilities.caseIdentifier((TableLocation)requestedTable, (String)(osmTableName + "_node_member"), (DBTypes)dbType);
        this.nodeMemberPreparedStmt = OSMTablesFactory.createNodeMemberTable(connection, nodeMemberTableName);
        String wayMemberTableName = TableUtilities.caseIdentifier((TableLocation)requestedTable, (String)(osmTableName + "_way_member"), (DBTypes)dbType);
        this.wayMemberPreparedStmt = OSMTablesFactory.createWayMemberTable(connection, wayMemberTableName);
        String relationMemberTableName = TableUtilities.caseIdentifier((TableLocation)requestedTable, (String)(osmTableName + "_relation_member"), (DBTypes)dbType);
        this.relationMemberPreparedStmt = OSMTablesFactory.createRelationMemberTable(connection, relationMemberTableName);
        return new String[]{nodeTableName, nodeTagTableName, wayTableName, wayTagTableName, wayNodeTableName, relationTableName, relationTagTableName, nodeMemberTableName, wayMemberTableName, relationMemberTableName};
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String type = attributes.getValue("type");
        if (this.progress.isCanceled()) {
            throw new SAXException("Canceled by user");
        }
        if (localName.compareToIgnoreCase("node") == 0) {
            this.nodeOSMElement = new NodeOSMElement(Double.valueOf(attributes.getValue("lat")), Double.valueOf(attributes.getValue("lon")));
            this.setCommonsAttributes(this.nodeOSMElement, attributes);
            this.tagLocation = TAG_LOCATION.NODE;
        } else if (localName.compareToIgnoreCase("way") == 0) {
            this.wayOSMElement = new WayOSMElement();
            this.setCommonsAttributes(this.wayOSMElement, attributes);
            this.tagLocation = TAG_LOCATION.WAY;
        } else if (localName.compareToIgnoreCase("tag") == 0) {
            String key = attributes.getValue("k");
            String value = attributes.getValue("v");
            boolean insertTag = true;
            switch (this.tagLocation) {
                case NODE: {
                    insertTag = this.nodeOSMElement.addTag(key, value);
                    break;
                }
                case WAY: {
                    insertTag = this.wayOSMElement.addTag(key, value);
                    break;
                }
                case RELATION: {
                    insertTag = this.relationOSMElement.addTag(key, value);
                }
            }
        } else if (localName.compareToIgnoreCase("nd") == 0) {
            this.wayOSMElement.addRef(attributes.getValue("ref"));
        } else if (localName.compareToIgnoreCase("relation") == 0) {
            this.relationOSMElement = new OSMElement();
            this.setCommonsAttributes(this.relationOSMElement, attributes);
            this.tagLocation = TAG_LOCATION.RELATION;
        } else if (localName.compareToIgnoreCase("member") == 0) {
            if (type.equalsIgnoreCase("node")) {
                try {
                    this.nodeMemberPreparedStmt.setObject(1, this.relationOSMElement.getID());
                    this.nodeMemberPreparedStmt.setObject(2, Long.valueOf(attributes.getValue("ref")));
                    this.nodeMemberPreparedStmt.setObject(3, attributes.getValue("role"));
                    this.nodeMemberPreparedStmt.setObject(4, this.idMemberOrder);
                    this.nodeMemberPreparedStmt.addBatch();
                    ++this.nodeMemberPreparedStmtBatchSize;
                }
                catch (SQLException ex) {
                    throw new SAXException("Cannot insert the node member for the relation :  " + this.relationOSMElement.getID(), ex);
                }
            }
            if (type.equalsIgnoreCase("way")) {
                try {
                    this.wayMemberPreparedStmt.setObject(1, this.relationOSMElement.getID());
                    this.wayMemberPreparedStmt.setObject(2, Long.valueOf(attributes.getValue("ref")));
                    this.wayMemberPreparedStmt.setObject(3, attributes.getValue("role"));
                    this.wayMemberPreparedStmt.setObject(4, this.idMemberOrder);
                    this.wayMemberPreparedStmt.addBatch();
                    ++this.wayMemberPreparedStmtBatchSize;
                }
                catch (SQLException ex) {
                    throw new SAXException("Cannot insert the way member for the relation :  " + this.relationOSMElement.getID(), ex);
                }
            }
            if (type.equalsIgnoreCase("relation")) {
                try {
                    this.relationMemberPreparedStmt.setObject(1, this.relationOSMElement.getID());
                    this.relationMemberPreparedStmt.setObject(2, Long.valueOf(attributes.getValue("ref")));
                    this.relationMemberPreparedStmt.setObject(3, attributes.getValue("role"));
                    this.relationMemberPreparedStmt.setObject(4, this.idMemberOrder);
                    this.relationMemberPreparedStmt.addBatch();
                    ++this.relationMemberPreparedStmtBatchSize;
                }
                catch (SQLException ex) {
                    throw new SAXException("Cannot insert the relation member for the relation :  " + this.relationOSMElement.getID(), ex);
                }
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.nodePreparedStmtBatchSize = this.insertBatch(this.nodePreparedStmt, this.nodePreparedStmtBatchSize, 1);
            this.nodeTagPreparedStmtBatchSize = this.insertBatch(this.nodeTagPreparedStmt, this.nodeTagPreparedStmtBatchSize, 1);
            this.wayPreparedStmtBatchSize = this.insertBatch(this.wayPreparedStmt, this.wayPreparedStmtBatchSize, 1);
            this.wayTagPreparedStmtBatchSize = this.insertBatch(this.wayTagPreparedStmt, this.wayTagPreparedStmtBatchSize, 1);
            this.relationPreparedStmtBatchSize = this.insertBatch(this.relationPreparedStmt, this.relationPreparedStmtBatchSize, 1);
            this.relationTagPreparedStmtBatchSize = this.insertBatch(this.relationTagPreparedStmt, this.relationTagPreparedStmtBatchSize, 1);
            this.nodeMemberPreparedStmtBatchSize = this.insertBatch(this.nodeMemberPreparedStmt, this.nodeMemberPreparedStmtBatchSize, 1);
            this.wayMemberPreparedStmtBatchSize = this.insertBatch(this.wayMemberPreparedStmt, this.wayMemberPreparedStmtBatchSize, 1);
            this.relationMemberPreparedStmtBatchSize = this.insertBatch(this.relationMemberPreparedStmt, this.relationMemberPreparedStmtBatchSize, 1);
            this.wayNodePreparedStmtBatchSize = this.insertBatch(this.wayNodePreparedStmt, this.wayNodePreparedStmtBatchSize, 1);
        }
        catch (SQLException ex) {
            throw new SAXException("Could not insert sql batch", ex);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        HashMap<String, String> tags;
        if (localName.compareToIgnoreCase("node") == 0) {
            this.tagLocation = TAG_LOCATION.OTHER;
            try {
                this.nodePreparedStmt.setObject(1, this.nodeOSMElement.getID());
                this.nodePreparedStmt.setObject(2, this.nodeOSMElement.getPoint(this.gf));
                this.nodePreparedStmt.setObject(3, this.nodeOSMElement.getElevation());
                this.nodePreparedStmt.setObject(4, this.nodeOSMElement.getUser());
                this.nodePreparedStmt.setObject(5, this.nodeOSMElement.getUID());
                this.nodePreparedStmt.setObject(6, this.nodeOSMElement.getVisible());
                this.nodePreparedStmt.setObject(7, this.nodeOSMElement.getVersion());
                this.nodePreparedStmt.setObject(8, this.nodeOSMElement.getChangeSet());
                this.nodePreparedStmt.setObject(9, (Object)this.nodeOSMElement.getTimeStamp(), 91);
                this.nodePreparedStmt.setString(10, this.nodeOSMElement.getName());
                this.nodePreparedStmt.addBatch();
                ++this.nodePreparedStmtBatchSize;
                tags = this.nodeOSMElement.getTags();
                for (Map.Entry<String, String> entry : tags.entrySet()) {
                    this.nodeTagPreparedStmt.setObject(1, this.nodeOSMElement.getID());
                    this.nodeTagPreparedStmt.setObject(2, entry.getKey());
                    this.nodeTagPreparedStmt.setObject(3, entry.getValue());
                    this.nodeTagPreparedStmt.addBatch();
                    ++this.nodeTagPreparedStmtBatchSize;
                }
            }
            catch (SQLException ex) {
                throw new SAXException("Cannot insert the node  :  " + this.nodeOSMElement.getID(), ex);
            }
        } else if (localName.compareToIgnoreCase("way") == 0) {
            this.tagLocation = TAG_LOCATION.OTHER;
            try {
                this.wayPreparedStmt.setObject(1, this.wayOSMElement.getID());
                this.wayPreparedStmt.setObject(2, this.wayOSMElement.getUser());
                this.wayPreparedStmt.setObject(3, this.wayOSMElement.getUID());
                this.wayPreparedStmt.setObject(4, this.wayOSMElement.getVisible());
                this.wayPreparedStmt.setObject(5, this.wayOSMElement.getVersion());
                this.wayPreparedStmt.setObject(6, this.wayOSMElement.getChangeSet());
                this.wayPreparedStmt.setTimestamp(7, this.wayOSMElement.getTimeStamp());
                this.wayPreparedStmt.setString(8, this.wayOSMElement.getName());
                this.wayPreparedStmt.addBatch();
                ++this.wayPreparedStmtBatchSize;
                tags = this.wayOSMElement.getTags();
                for (Map.Entry<String, String> entry : tags.entrySet()) {
                    this.wayTagPreparedStmt.setObject(1, this.wayOSMElement.getID());
                    this.wayTagPreparedStmt.setObject(2, entry.getKey());
                    this.wayTagPreparedStmt.setObject(3, entry.getValue());
                    this.wayTagPreparedStmt.addBatch();
                    ++this.wayTagPreparedStmtBatchSize;
                }
                int order = 1;
                for (long ref : this.wayOSMElement.getNodesRef()) {
                    this.wayNodePreparedStmt.setObject(1, this.wayOSMElement.getID());
                    this.wayNodePreparedStmt.setObject(2, ref);
                    this.wayNodePreparedStmt.setObject(3, order++);
                    this.wayNodePreparedStmt.addBatch();
                    ++this.wayNodePreparedStmtBatchSize;
                }
            }
            catch (SQLException ex) {
                throw new SAXException("Cannot insert the way  :  " + this.wayOSMElement.getID(), ex);
            }
        } else if (localName.compareToIgnoreCase("relation") == 0) {
            this.tagLocation = TAG_LOCATION.OTHER;
            try {
                this.relationPreparedStmt.setObject(1, this.relationOSMElement.getID());
                this.relationPreparedStmt.setObject(2, this.relationOSMElement.getUser());
                this.relationPreparedStmt.setObject(3, this.relationOSMElement.getUID());
                this.relationPreparedStmt.setObject(4, this.relationOSMElement.getVisible());
                this.relationPreparedStmt.setObject(5, this.relationOSMElement.getVersion());
                this.relationPreparedStmt.setObject(6, this.relationOSMElement.getChangeSet());
                this.relationPreparedStmt.setTimestamp(7, this.relationOSMElement.getTimeStamp());
                this.relationPreparedStmt.addBatch();
                ++this.relationPreparedStmtBatchSize;
                tags = this.relationOSMElement.getTags();
                for (Map.Entry<String, String> entry : tags.entrySet()) {
                    this.relationTagPreparedStmt.setObject(1, this.relationOSMElement.getID());
                    this.relationTagPreparedStmt.setObject(2, entry.getKey());
                    this.relationTagPreparedStmt.setObject(3, entry.getValue());
                    this.relationTagPreparedStmt.addBatch();
                    ++this.relationTagPreparedStmtBatchSize;
                }
                this.idMemberOrder = 0;
            }
            catch (SQLException ex) {
                throw new SAXException("Cannot insert the relation  :  " + this.relationOSMElement.getID(), ex);
            }
        } else if (localName.compareToIgnoreCase("member") == 0) {
            ++this.idMemberOrder;
        }
        try {
            this.insertBatch();
        }
        catch (SQLException ex) {
            throw new SAXException("Could not insert sql batch", ex);
        }
        if (this.nodeCountProgress++ % this.readFileSizeEachNode == 0L) {
            try {
                this.progress.setStep((int)((double)this.fc.position() / (double)this.fileSize * 100.0));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void insertBatch() throws SQLException {
        this.nodePreparedStmtBatchSize = this.insertBatch(this.nodePreparedStmt, this.nodePreparedStmtBatchSize);
        this.nodeTagPreparedStmtBatchSize = this.insertBatch(this.nodeTagPreparedStmt, this.nodeTagPreparedStmtBatchSize);
        this.wayPreparedStmtBatchSize = this.insertBatch(this.wayPreparedStmt, this.wayPreparedStmtBatchSize);
        this.wayTagPreparedStmtBatchSize = this.insertBatch(this.wayTagPreparedStmt, this.wayTagPreparedStmtBatchSize);
        this.relationPreparedStmtBatchSize = this.insertBatch(this.relationPreparedStmt, this.relationPreparedStmtBatchSize);
        this.relationTagPreparedStmtBatchSize = this.insertBatch(this.relationTagPreparedStmt, this.relationTagPreparedStmtBatchSize);
        this.nodeMemberPreparedStmtBatchSize = this.insertBatch(this.nodeMemberPreparedStmt, this.nodeMemberPreparedStmtBatchSize);
        this.wayMemberPreparedStmtBatchSize = this.insertBatch(this.wayMemberPreparedStmt, this.wayMemberPreparedStmtBatchSize);
        this.relationMemberPreparedStmtBatchSize = this.insertBatch(this.relationMemberPreparedStmt, this.relationMemberPreparedStmtBatchSize);
        this.wayNodePreparedStmtBatchSize = this.insertBatch(this.wayNodePreparedStmt, this.wayNodePreparedStmtBatchSize);
    }

    private int insertBatch(PreparedStatement st, int batchSize, int maxBatchSize) throws SQLException {
        if (batchSize >= maxBatchSize) {
            st.executeBatch();
            this.connection.commit();
            st.clearBatch();
            return 0;
        }
        return batchSize;
    }

    private int insertBatch(PreparedStatement st, int batchSize) throws SQLException {
        return this.insertBatch(st, batchSize, 8000);
    }

    private void setCommonsAttributes(OSMElement osmElement, Attributes attributes) throws SAXException {
        osmElement.setId(attributes.getValue("id"));
        osmElement.setUser(attributes.getValue("user"));
        osmElement.setUid(attributes.getValue("uid"));
        osmElement.setVisible(attributes.getValue("visible"));
        osmElement.setVersion(attributes.getValue("version"));
        osmElement.setChangeset(attributes.getValue("changeset"));
        osmElement.setTimestamp(attributes.getValue("timestamp"));
    }
}

