/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.osm;

import org.h2gis.functions.io.osm.OSMElement;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

public class NodeOSMElement
extends OSMElement {
    private double latitude;
    private double longitude;
    private Double elevation = null;

    public NodeOSMElement(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public void setElevation(double elevation) {
        this.elevation = elevation;
    }

    public Point getPoint(GeometryFactory gf) {
        return gf.createPoint(new Coordinate(this.longitude, this.latitude));
    }

    public Double getElevation() {
        return this.elevation;
    }

    @Override
    public boolean addTag(String key, String value) {
        if (key.equalsIgnoreCase("ele")) {
            try {
                this.setElevation(Double.valueOf(value));
                return false;
            }
            catch (NumberFormatException ex) {
                return super.addTag(key, value);
            }
        }
        return super.addTag(key, value);
    }
}

