/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.file_table;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.h2.api.TableEngine;
import org.h2.command.ddl.CreateTableData;
import org.h2.message.DbException;
import org.h2.table.Column;
import org.h2.table.TableBase;
import org.h2.util.StringUtils;
import org.h2.value.TypeInfo;
import org.h2gis.api.FileDriver;
import org.h2gis.functions.io.file_table.DummyMVTable;
import org.h2gis.functions.io.file_table.H2MVTable;
import org.h2gis.utilities.URIUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileEngine<Driver extends FileDriver>
implements TableEngine {
    private Logger LOGGER = LoggerFactory.getLogger(FileEngine.class);

    public TableBase createTable(CreateTableData data) {
        if (data.tableEngineParams.isEmpty()) {
            throw DbException.get((int)90124);
        }
        File filePath = URIUtilities.fileFromString((String)StringUtils.javaDecode((String)((String)data.tableEngineParams.get(0))));
        if (!filePath.exists()) {
            this.LOGGER.error("File not found:\n" + filePath.getAbsolutePath() + "\nThe table " + data.tableName + " will be empty.");
            return new DummyMVTable(data);
        }
        try {
            Driver driver = this.createDriver(filePath, data.tableEngineParams);
            if (data.columns.isEmpty()) {
                this.feedCreateTableData(driver, data);
                String pkColumnName = FileEngine.getUniqueColumnName("PK", data.columns);
                Column pk = new Column(pkColumnName, TypeInfo.TYPE_BIGINT);
                pk.setPrimaryKey(true);
                pk.setNullable(false);
                data.columns.add(0, pk);
            }
            H2MVTable table = new H2MVTable((FileDriver)driver, data);
            table.init(data.session);
            return table;
        }
        catch (IOException ex) {
            throw DbException.get((int)90028, (Throwable)ex, (String[])new String[0]);
        }
    }

    public static String getUniqueColumnName(String base, List<Column> columns) {
        String cursor = base;
        int cpt = 2;
        boolean findDuplicate = true;
        while (findDuplicate) {
            findDuplicate = false;
            for (Column column : columns) {
                if (!column.getName().equalsIgnoreCase(cursor)) continue;
                findDuplicate = true;
                break;
            }
            if (!findDuplicate) continue;
            cursor = base + cpt;
            ++cpt;
        }
        return cursor;
    }

    protected abstract Driver createDriver(File var1, List<String> var2) throws IOException;

    protected abstract void feedCreateTableData(Driver var1, CreateTableData var2) throws IOException;
}

