/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.utilities.dbtypes;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.h2gis.utilities.dbtypes.DBTypes;

public abstract class Constants {
    public static final String H2_JDBC_PROTOCOL = "h2";
    public static final String POSTGRESQL_JDBC_PROTOCOL = "postgresql";
    public static final String POSTGRESQL_H2_JDBC_PROTOCOL = "postgresql_h2";
    public static final String POSTGIS_JDBC_PROTOCOL = "postgresql_postGIS";
    public static final String H2_JDBC_NAME = "H2 JDBC Driver";
    public static final String POSTGRESQL_JDBC_NAME = "PostgreSQL JDBC Driver";
    public static final Map<String, DBTypes> SCHEME_DBTYPE_MAP = new HashMap<String, DBTypes>();
    public static final Map<String, DBTypes> DB_NAME_TYPE_MAP;
    public static final Map<String, DBTypes> driverDBTypeMap;
    public static final Pattern H2_SPECIAL_NAME_PATTERN;
    public static final Pattern POSTGRESQL_SPECIAL_NAME_PATTERN;
    public static final Set<String> H2_RESERVED_WORDS;
    public static final Set<String> POSTGRESQL_RESERVED_WORDS;

    static {
        SCHEME_DBTYPE_MAP.put(H2_JDBC_PROTOCOL, DBTypes.H2);
        SCHEME_DBTYPE_MAP.put(POSTGRESQL_H2_JDBC_PROTOCOL, DBTypes.H2);
        SCHEME_DBTYPE_MAP.put(POSTGRESQL_JDBC_PROTOCOL, DBTypes.POSTGRESQL);
        SCHEME_DBTYPE_MAP.put(POSTGIS_JDBC_PROTOCOL, DBTypes.POSTGIS);
        DB_NAME_TYPE_MAP = new HashMap<String, DBTypes>();
        DB_NAME_TYPE_MAP.put(H2_JDBC_NAME, DBTypes.H2);
        DB_NAME_TYPE_MAP.put(POSTGRESQL_JDBC_NAME, DBTypes.POSTGRESQL);
        driverDBTypeMap = new HashMap<String, DBTypes>();
        driverDBTypeMap.put("org.h2.jdbc.JdbcConnection", DBTypes.H2);
        driverDBTypeMap.put("org.h2gis.utilities.wrapper.ConnectionWrapper", DBTypes.H2GIS);
        driverDBTypeMap.put("org.h2gis.postgis_jts.ConnectionWrapper", DBTypes.POSTGIS);
        driverDBTypeMap.put("org.postgresql.PGConnection", DBTypes.POSTGRESQL);
        H2_SPECIAL_NAME_PATTERN = Pattern.compile("^[A-Z]{1,1}[A-Z0-9_]*$");
        POSTGRESQL_SPECIAL_NAME_PATTERN = Pattern.compile("^[a-z]{1,1}[a-z0-9_]*$");
        H2_RESERVED_WORDS = new HashSet<String>(Arrays.asList("ALL", "AND", "ARRAY", "AS", "BETWEEN", "BOTH", "CASE", "CHECK", "CONSTRAINT", "CROSS", "CURRENT_CATALOG", "CURRENT_DATE", "CURRENT_SCHEMA", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "DISTINCT", "EXCEPT", "EXISTS", "FALSE", "FETCH", "FILTER", "FOR", "FOREIGN", "FROM", "FULL", "GROUP", "GROUPS", "HAVING", "IF", "ILIKE", "IN", "INNER", "INTERSECT", "INTERSECTS", "INTERVAL", "IS", "JOIN", "LEADING", "LEFT", "LIKE", "LIMIT", "LOCALTIME", "LOCALTIMESTAMP", "MINUS", "NATURAL", "NOT", "NULL", "OFFSET", "ON", "OR", "ORDER", "OVER", "PARTITION", "PRIMARY", "QUALIFY", "RANGE", "REGEXP", "RIGHT", "ROW", "_ROWID_", "ROWNUM", "ROWS", "SELECT", "SYSDATE", "SYSTIME", "SYSTIMESTAMP", "TABLE", "TODAY", "TOP", "TRAILING", "TRUE", "UNION", "UNIQUE", "UNKNOWN", "USING", "VALUES", "WHERE", "WINDOW", "WITH"));
        POSTGRESQL_RESERVED_WORDS = new HashSet<String>(Arrays.asList("ALL", "ANALYSE", "ANALYZE", "AND", "ANY", "AS", "ASC", "AUTHORIZATION", "BETWEEN", "BINARY", "BOTH", "CASE", "CAST", "CHECK", "COLLATE", "COLUMN", "CONSTRAINT", "CREATE", "CROSS", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "DEFAULT", "DEFERRABLE", "DESC", "DISTINCT", "DO", "ELSE", "END", "EXCEPT", "FALSE", "FOR", "FOREIGN", "FREEZE", "FROM", "FULL", "GRANT", "GROUP", "HAVING", "ILIKE", "IN", "INITIALLY", "INNER", "INTERSECT", "INTO", "IS", "ISNULL", "JOIN", "LEADING", "LEFT", "LIKE", "LIMIT", "LOCALTIME", "LOCALTIMESTAMP", "NATURAL", "NEW", "NOT", "NOTNULL", "NULL", "OFF", "OFFSET", "OLD", "ON", "ONLY", "OR", "ORDER", "OUTER", "OVERLAPS", "PLACING", "PRIMARY", "REFERENCES", "RIGHT", "SELECT", "SESSION_USER", "SIMILAR", "SOME", "TABLE", "THEN", "TO", "TRAILING", "TRUE", "UNION", "UNIQUE", "USER", "USING", "VERBOSE", "WHEN", "WHERE"));
    }
}

