/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.utilities;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.tools.SimpleResultSet;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.dbtypes.DBTypes;
import org.h2gis.utilities.dbtypes.DBUtils;

public class TableUtilities {
    private TableUtilities() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFields(Connection connection, SimpleResultSet rs, TableLocation tableLocation) throws SQLException {
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT * FROM " + tableLocation + " LIMIT 0;");){
            ResultSetMetaData metadata = resultSet.getMetaData();
            for (int columnId = 1; columnId <= metadata.getColumnCount(); ++columnId) {
                rs.addColumn(metadata.getColumnName(columnId), metadata.getColumnType(columnId), metadata.getColumnTypeName(columnId), metadata.getPrecision(columnId), metadata.getScale(columnId));
            }
        }
    }

    public static boolean isColumnListConnection(Connection connection) throws SQLException {
        return connection.getMetaData().getURL().equals("jdbc:columnlist:connection");
    }

    public static TableLocation parseInputTable(Connection connection, String inputTable) throws SQLException {
        return TableLocation.parse(inputTable, DBUtils.getDBType(connection));
    }

    public static TableLocation suffixTableLocation(TableLocation inputTable, String suffix) {
        return new TableLocation(inputTable.getCatalog(), inputTable.getSchema(), inputTable.getTable() + suffix);
    }

    public static String caseIdentifier(TableLocation requestedTable, String tableName, DBTypes dbType) {
        return new TableLocation(requestedTable.getCatalog(), requestedTable.getSchema(), TableLocation.parse(tableName, dbType).getTable()).toString();
    }
}

