/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.h2.engine.CastDataProvider;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.store.FileStoreInputStream;
import org.h2.store.FileStoreOutputStream;
import org.h2.store.LobStorageInterface;
import org.h2.store.RangeInputStream;
import org.h2.store.RangeReader;
import org.h2.store.fs.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

public final class ValueLob
extends Value {
    private static final int BLOCK_COMPARISON_SIZE = 512;
    private final int valueType;
    private TypeInfo type;
    private final int tableId;
    private final long lobId;
    private final byte[] hmac;
    private final byte[] small;
    private DataHandler handler;
    private final long precision;
    private final String fileName;
    private final FileStore tempFile;
    private int hash;
    private boolean isRecoveryReference;

    private static void rangeCheckUnknown(long l, long l2) {
        if (l < 0L) {
            throw DbException.getInvalidValueException("offset", l + 1L);
        }
        if (l2 < 0L) {
            throw DbException.getInvalidValueException("length", l2);
        }
    }

    private static InputStream rangeInputStream(InputStream inputStream, long l, long l2, long l3) {
        if (l3 > 0L) {
            ValueLob.rangeCheck(l - 1L, l2, l3);
        } else {
            ValueLob.rangeCheckUnknown(l - 1L, l2);
        }
        try {
            return new RangeInputStream(inputStream, l - 1L, l2);
        }
        catch (IOException iOException) {
            throw DbException.getInvalidValueException("offset", l);
        }
    }

    private static Reader rangeReader(Reader reader, long l, long l2, long l3) {
        if (l3 > 0L) {
            ValueLob.rangeCheck(l - 1L, l2, l3);
        } else {
            ValueLob.rangeCheckUnknown(l - 1L, l2);
        }
        try {
            return new RangeReader(reader, l - 1L, l2);
        }
        catch (IOException iOException) {
            throw DbException.getInvalidValueException("offset", l);
        }
    }

    /*
     * Exception decompiling
     */
    private static int compare(ValueLob var0, ValueLob var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 84[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ValueLob(int n, DataHandler dataHandler, int n2, long l, byte[] byArray, long l2) {
        this.valueType = n;
        this.handler = dataHandler;
        this.tableId = n2;
        this.lobId = l;
        this.hmac = byArray;
        this.precision = l2;
        this.small = null;
        this.fileName = null;
        this.tempFile = null;
    }

    private ValueLob(int n, byte[] byArray, long l) {
        this.valueType = n;
        this.small = byArray;
        this.precision = l;
        this.lobId = 0L;
        this.hmac = null;
        this.handler = null;
        this.fileName = null;
        this.tempFile = null;
        this.tableId = 0;
    }

    private ValueLob(DataHandler dataHandler, Reader reader, long l) throws IOException {
        this.valueType = 16;
        this.handler = dataHandler;
        this.small = null;
        this.lobId = 0L;
        this.hmac = null;
        this.fileName = ValueLob.createTempLobFileName(dataHandler);
        this.tempFile = dataHandler.openFile(this.fileName, "rw", false);
        this.tempFile.autoDelete();
        long l2 = 0L;
        try (FileStoreOutputStream fileStoreOutputStream = new FileStoreOutputStream(this.tempFile, null, null);){
            char[] cArray = new char[4096];
            while (true) {
                int n = ValueLob.getBufferSize(dataHandler, false, l);
                if ((n = IOUtils.readFully(reader, cArray, n)) == 0) {
                    break;
                }
                byte[] byArray = new String(cArray, 0, n).getBytes(StandardCharsets.UTF_8);
                fileStoreOutputStream.write(byArray);
                l2 += (long)n;
            }
        }
        this.precision = l2;
        this.tableId = 0;
    }

    private ValueLob(DataHandler dataHandler, byte[] byArray, int n, InputStream inputStream, long l) throws IOException {
        this.valueType = 15;
        this.handler = dataHandler;
        this.small = null;
        this.lobId = 0L;
        this.hmac = null;
        this.fileName = ValueLob.createTempLobFileName(dataHandler);
        this.tempFile = dataHandler.openFile(this.fileName, "rw", false);
        this.tempFile.autoDelete();
        long l2 = 0L;
        boolean bl = dataHandler.getLobCompressionAlgorithm(15) != null;
        try (FileStoreOutputStream fileStoreOutputStream = new FileStoreOutputStream(this.tempFile, null, null);){
            do {
                l2 += (long)n;
                fileStoreOutputStream.write(byArray, 0, n);
                if ((l -= (long)n) <= 0L) {
                    break;
                }
                n = ValueLob.getBufferSize(dataHandler, bl, l);
            } while ((n = IOUtils.readFully(inputStream, byArray, n)) > 0);
        }
        this.precision = l2;
        this.tableId = 0;
    }

    private static String createTempLobFileName(DataHandler dataHandler) throws IOException {
        String string = dataHandler.getDatabasePath();
        if (string.isEmpty()) {
            string = SysProperties.PREFIX_TEMP_FILE;
        }
        return FileUtils.createTempFile(string, ".temp.db", true);
    }

    public static ValueLob create(int n, DataHandler dataHandler, int n2, long l, byte[] byArray, long l2) {
        return new ValueLob(n, dataHandler, n2, l, byArray, l2);
    }

    public boolean isLinkedToTable() {
        return this.small == null && this.tableId >= 0;
    }

    public boolean isStored() {
        return this.small == null && this.fileName == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        if (this.fileName != null) {
            if (this.tempFile != null) {
                this.tempFile.stopAutoDelete();
            }
            Object object = this.handler.getLobSyncObject();
            synchronized (object) {
                FileUtils.delete(this.fileName);
            }
        }
        if (this.handler != null) {
            this.handler.getLobStorage().removeLob(this);
        }
    }

    public ValueLob copy(DataHandler dataHandler, int n) {
        if (this.small == null) {
            return this.handler.getLobStorage().copyLob(this, n, this.precision);
        }
        if (this.small.length > dataHandler.getMaxLengthInplaceLob()) {
            LobStorageInterface lobStorageInterface = dataHandler.getLobStorage();
            ValueLob valueLob = this.valueType == 15 ? lobStorageInterface.createBlob(this.getInputStream(), this.precision) : lobStorageInterface.createClob(this.getReader(), this.precision);
            ValueLob valueLob2 = valueLob.copy(dataHandler, n);
            valueLob.remove();
            return valueLob2;
        }
        return this;
    }

    public int getTableId() {
        return this.tableId;
    }

    @Override
    public TypeInfo getType() {
        TypeInfo typeInfo = this.type;
        if (typeInfo == null) {
            this.type = typeInfo = new TypeInfo(this.valueType, this.precision, 0, MathUtils.convertLongToInt(this.precision), null);
        }
        return typeInfo;
    }

    @Override
    public int getValueType() {
        return this.valueType;
    }

    @Override
    public String getString() {
        int n = this.precision > Integer.MAX_VALUE || this.precision == 0L ? Integer.MAX_VALUE : (int)this.precision;
        try {
            if (this.small != null) {
                return new String(this.small, StandardCharsets.UTF_8);
            }
            return IOUtils.readStringAndClose(this.getReader(), n);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.toString());
        }
    }

    @Override
    public byte[] getBytes() {
        if (this.small != null) {
            return Utils.cloneByteArray(this.small);
        }
        try {
            return IOUtils.readBytesAndClose(this.getInputStream(), Integer.MAX_VALUE);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.toString());
        }
    }

    @Override
    public byte[] getBytesNoCopy() {
        if (this.small != null) {
            return this.small;
        }
        try {
            return IOUtils.readBytesAndClose(this.getInputStream(), Integer.MAX_VALUE);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.toString());
        }
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            if (this.precision > 4096L) {
                return (int)(this.precision ^ this.precision >>> 32);
            }
            this.hash = Utils.getByteArrayHash(this.getBytesNoCopy());
        }
        return this.hash;
    }

    @Override
    public int compareTypeSafe(Value value, CompareMode compareMode, CastDataProvider castDataProvider) {
        if (value == this) {
            return 0;
        }
        ValueLob valueLob = (ValueLob)value;
        if (this.lobId == valueLob.lobId && this.small == null && valueLob.small == null) {
            return 0;
        }
        return ValueLob.compare(this, valueLob);
    }

    @Override
    public Object getObject() {
        if (this.valueType == 16) {
            return this.getReader();
        }
        return this.getInputStream();
    }

    @Override
    public Reader getReader() {
        return IOUtils.getBufferedReader(this.getInputStream());
    }

    @Override
    public Reader getReader(long l, long l2) {
        return ValueLob.rangeReader(this.getReader(), l, l2, this.valueType == 16 ? this.precision : -1L);
    }

    @Override
    public InputStream getInputStream() {
        if (this.small != null) {
            return new ByteArrayInputStream(this.small);
        }
        if (this.fileName != null) {
            FileStore fileStore = this.handler.openFile(this.fileName, "r", true);
            boolean bl = SysProperties.lobCloseBetweenReads;
            return new BufferedInputStream(new FileStoreInputStream(fileStore, this.handler, false, bl), 4096);
        }
        long l = this.valueType == 15 ? this.precision : -1L;
        try {
            return this.handler.getLobStorage().getInputStream(this, this.hmac, l);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.toString());
        }
    }

    @Override
    public InputStream getInputStream(long l, long l2) {
        InputStream inputStream;
        long l3;
        if (this.small != null) {
            return super.getInputStream(l, l2);
        }
        if (this.fileName != null) {
            FileStore fileStore = this.handler.openFile(this.fileName, "r", true);
            boolean bl = SysProperties.lobCloseBetweenReads;
            l3 = fileStore.length();
            inputStream = new BufferedInputStream(new FileStoreInputStream(fileStore, this.handler, false, bl), 4096);
        } else {
            l3 = this.valueType == 15 ? this.precision : -1L;
            try {
                inputStream = this.handler.getLobStorage().getInputStream(this, this.hmac, l3);
            }
            catch (IOException iOException) {
                throw DbException.convertIOException(iOException, this.toString());
            }
        }
        return ValueLob.rangeInputStream(inputStream, l, l2, l3);
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, int n) {
        if ((n & 2) != 0 && (this.small == null || this.precision > SysProperties.MAX_TRACE_DATA_LENGTH)) {
            if (this.valueType == 16) {
                stringBuilder.append("SPACE(").append(this.precision);
            } else {
                stringBuilder.append("CAST(REPEAT('00', ").append(this.precision).append(") AS BINARY");
            }
            stringBuilder.append(" /* table: ").append(this.tableId).append(" id: ").append(this.lobId).append(" */)");
        }
        if (this.valueType == 16) {
            if ((n & 6) == 0) {
                StringUtils.quoteStringSQL(stringBuilder.append("CAST("), this.getString()).append(" AS CLOB(").append(this.precision).append("))");
            } else {
                StringUtils.quoteStringSQL(stringBuilder, this.getString());
            }
        } else if ((n & 6) == 0) {
            stringBuilder.append("CAST(X'");
            StringUtils.convertBytesToHex(stringBuilder, this.getBytesNoCopy()).append("' AS BLOB(").append(this.precision).append("))");
        } else {
            stringBuilder.append("X'");
            StringUtils.convertBytesToHex(stringBuilder, this.getBytesNoCopy()).append('\'');
        }
        return stringBuilder;
    }

    public long getPrecision() {
        return this.precision;
    }

    public byte[] getSmall() {
        return this.small;
    }

    public DataHandler getDataHandler() {
        return this.handler;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ValueLob)) {
            return false;
        }
        ValueLob valueLob = (ValueLob)object;
        if (this.hashCode() != valueLob.hashCode()) {
            return false;
        }
        return this.compareTypeSafe((Value)object, null, null) == 0;
    }

    @Override
    public int getMemory() {
        if (this.small != null) {
            return this.small.length + 127;
        }
        return 140;
    }

    public ValueLob copyToTemp() {
        return this;
    }

    public ValueLob copyToResult() {
        if (this.handler == null) {
            return this;
        }
        LobStorageInterface lobStorageInterface = this.handler.getLobStorage();
        if (lobStorageInterface.isReadOnly()) {
            return this;
        }
        return lobStorageInterface.copyLob(this, -3, this.precision);
    }

    public long getLobId() {
        return this.lobId;
    }

    @Override
    public String toString() {
        return "lob: " + this.fileName + " table: " + this.tableId + " id: " + this.lobId;
    }

    public static ValueLob createTempClob(Reader reader, long l, DataHandler dataHandler) {
        if (l >= 0L) {
            try {
                reader = new RangeReader(reader, 0L, l);
            }
            catch (IOException iOException) {
                throw DbException.convert(iOException);
            }
        }
        BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, 4096);
        try {
            char[] cArray;
            Object object;
            int n;
            boolean bl = dataHandler.getLobCompressionAlgorithm(16) != null;
            long l2 = Long.MAX_VALUE;
            if (l >= 0L && l < l2) {
                l2 = l;
            }
            if ((n = ValueLob.getBufferSize(dataHandler, bl, l2)) >= Integer.MAX_VALUE) {
                object = IOUtils.readStringAndClose(bufferedReader, -1);
                cArray = ((String)object).toCharArray();
                n = cArray.length;
            } else {
                cArray = new char[n];
                bufferedReader.mark(n);
                n = IOUtils.readFully(bufferedReader, cArray, n);
            }
            if (n <= dataHandler.getMaxLengthInplaceLob()) {
                object = new String(cArray, 0, n).getBytes(StandardCharsets.UTF_8);
                return ValueLob.createSmallLob(16, (byte[])object, n);
            }
            bufferedReader.reset();
            return new ValueLob(dataHandler, bufferedReader, l2);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    public static ValueLob createTempBlob(InputStream inputStream, long l, DataHandler dataHandler) {
        try {
            byte[] byArray;
            int n;
            boolean bl;
            long l2 = Long.MAX_VALUE;
            boolean bl2 = bl = dataHandler.getLobCompressionAlgorithm(15) != null;
            if (l >= 0L && l < l2) {
                l2 = l;
            }
            if ((n = ValueLob.getBufferSize(dataHandler, bl, l2)) >= Integer.MAX_VALUE) {
                byArray = IOUtils.readBytesAndClose(inputStream, -1);
                n = byArray.length;
            } else {
                byArray = Utils.newBytes(n);
                n = IOUtils.readFully(inputStream, byArray, n);
            }
            if (n <= dataHandler.getMaxLengthInplaceLob()) {
                byte[] byArray2 = Utils.copyBytes(byArray, n);
                return ValueLob.createSmallLob(15, byArray2, byArray2.length);
            }
            return new ValueLob(dataHandler, byArray, n, inputStream, l2);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    private static int getBufferSize(DataHandler dataHandler, boolean bl, long l) {
        long l2;
        if (l < 0L || l > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        int n = dataHandler.getMaxLengthInplaceLob();
        long l3 = l2 = bl ? 131072L : 4096L;
        if (l2 < l && l2 <= (long)n) {
            l2 = Math.min(l, (long)n + 1L);
            l2 = MathUtils.roundUpLong(l2, 4096L);
        }
        l2 = Math.min(l, l2);
        if ((l2 = (long)MathUtils.convertLongToInt(l2)) < 0L) {
            l2 = Integer.MAX_VALUE;
        }
        return (int)l2;
    }

    ValueLob convertPrecision(long l) {
        ValueLob valueLob;
        if (this.precision <= l) {
            return this;
        }
        if (this.valueType == 16) {
            if (this.handler == null) {
                try {
                    int n = MathUtils.convertLongToInt(l);
                    String string = IOUtils.readStringAndClose(this.getReader(), n);
                    byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
                    valueLob = ValueLob.createSmallLob(this.valueType, byArray, string.length());
                }
                catch (IOException iOException) {
                    throw DbException.convertIOException(iOException, null);
                }
            } else {
                valueLob = ValueLob.createTempClob(this.getReader(), l, this.handler);
            }
        } else if (this.handler == null) {
            try {
                int n = MathUtils.convertLongToInt(l);
                byte[] byArray = IOUtils.readBytesAndClose(this.getInputStream(), n);
                valueLob = ValueLob.createSmallLob(this.valueType, byArray, byArray.length);
            }
            catch (IOException iOException) {
                throw DbException.convertIOException(iOException, null);
            }
        } else {
            valueLob = ValueLob.createTempBlob(this.getInputStream(), l, this.handler);
        }
        return valueLob;
    }

    public static ValueLob createSmallLob(int n, byte[] byArray) {
        int n2 = n == 16 ? new String(byArray, StandardCharsets.UTF_8).length() : byArray.length;
        return ValueLob.createSmallLob(n, byArray, n2);
    }

    public static ValueLob createSmallLob(int n, byte[] byArray, long l) {
        return new ValueLob(n, byArray, l);
    }

    public void setRecoveryReference(boolean bl) {
        this.isRecoveryReference = bl;
    }

    public boolean isRecoveryReference() {
        return this.isRecoveryReference;
    }
}

