/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.util.Objects;
import org.h2.api.IntervalQualifier;
import org.h2.message.DbException;
import org.h2.util.MathUtils;
import org.h2.value.DataType;
import org.h2.value.ExtTypeInfo;
import org.h2.value.ExtTypeInfoEnum;
import org.h2.value.ExtTypeInfoGeometry;
import org.h2.value.ValueInterval;

public class TypeInfo {
    public static final TypeInfo TYPE_UNKNOWN;
    public static final TypeInfo TYPE_NULL;
    public static final TypeInfo TYPE_BOOLEAN;
    public static final TypeInfo TYPE_TINYINT;
    public static final TypeInfo TYPE_SMALLINT;
    public static final TypeInfo TYPE_INTEGER;
    public static final TypeInfo TYPE_BIGINT;
    public static final TypeInfo TYPE_NUMERIC;
    public static final TypeInfo TYPE_NUMERIC_BIGINT;
    public static final TypeInfo TYPE_NUMERIC_FLOATING_POINT;
    public static final TypeInfo TYPE_DOUBLE;
    public static final TypeInfo TYPE_REAL;
    public static final TypeInfo TYPE_TIME;
    public static final TypeInfo TYPE_DATE;
    public static final TypeInfo TYPE_TIMESTAMP;
    public static final TypeInfo TYPE_VARBINARY;
    public static final TypeInfo TYPE_VARCHAR;
    public static final TypeInfo TYPE_VARCHAR_IGNORECASE;
    public static final TypeInfo TYPE_ARRAY;
    public static final TypeInfo TYPE_RESULT_SET;
    public static final TypeInfo TYPE_JAVA_OBJECT;
    public static final TypeInfo TYPE_UUID;
    public static final TypeInfo TYPE_GEOMETRY;
    public static final TypeInfo TYPE_TIMESTAMP_TZ;
    public static final TypeInfo TYPE_ENUM_UNDEFINED;
    public static final TypeInfo TYPE_INTERVAL_DAY;
    public static final TypeInfo TYPE_INTERVAL_YEAR_TO_MONTH;
    public static final TypeInfo TYPE_INTERVAL_DAY_TO_SECOND;
    public static final TypeInfo TYPE_INTERVAL_HOUR_TO_SECOND;
    public static final TypeInfo TYPE_ROW;
    public static final TypeInfo TYPE_JSON;
    public static final TypeInfo TYPE_TIME_TZ;
    private static final TypeInfo[] TYPE_INFOS_BY_VALUE_TYPE;
    private final int valueType;
    private final long precision;
    private final int scale;
    private final int displaySize;
    private final ExtTypeInfo extTypeInfo;

    public static TypeInfo getTypeInfo(int n) {
        TypeInfo typeInfo;
        if (n == -1) {
            throw DbException.get(50004, "?");
        }
        if (n >= 0 && n < 43 && (typeInfo = TYPE_INFOS_BY_VALUE_TYPE[n]) != null) {
            return typeInfo;
        }
        return TYPE_NULL;
    }

    public static TypeInfo getTypeInfo(int n, long l, int n2, ExtTypeInfo extTypeInfo) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 18: 
            case 20: 
            case 39: 
            case 40: {
                return TYPE_INFOS_BY_VALUE_TYPE[n];
            }
            case -1: {
                return TYPE_UNKNOWN;
            }
            case 6: {
                if (l < 1L) {
                    l = 65535L;
                } else if (l > Integer.MAX_VALUE) {
                    l = Integer.MAX_VALUE;
                }
                return new TypeInfo(6, l, n2, MathUtils.convertLongToInt(l + 2L), null);
            }
            case 9: {
                if (n2 < 0 || n2 >= 9) {
                    return TYPE_TIME;
                }
                int n3 = n2 == 0 ? 8 : 9 + n2;
                return new TypeInfo(9, n3, n2, n3, null);
            }
            case 41: {
                if (n2 < 0 || n2 >= 9) {
                    return TYPE_TIME_TZ;
                }
                int n4 = n2 == 0 ? 14 : 15 + n2;
                return new TypeInfo(41, n4, n2, n4, null);
            }
            case 11: {
                if (n2 < 0 || n2 >= 9) {
                    return TYPE_TIMESTAMP;
                }
                int n5 = n2 == 0 ? 19 : 20 + n2;
                return new TypeInfo(11, n5, n2, n5, null);
            }
            case 24: {
                if (n2 < 0 || n2 >= 9) {
                    return TYPE_TIMESTAMP_TZ;
                }
                int n6 = n2 == 0 ? 25 : 26 + n2;
                return new TypeInfo(24, n6, n2, n6, null);
            }
            case 12: {
                if (l < 1L || l > Integer.MAX_VALUE) {
                    if (l != 0L) {
                        return TYPE_VARBINARY;
                    }
                    l = 1L;
                }
                return new TypeInfo(12, l, 0, MathUtils.convertLongToInt(l * 2L), null);
            }
            case 13: {
                if (l < 1L || l >= Integer.MAX_VALUE) {
                    if (l != 0L) {
                        return TYPE_VARCHAR;
                    }
                    l = 1L;
                }
                return new TypeInfo(13, l, 0, (int)l, null);
            }
            case 14: {
                if (l < 1L || l >= Integer.MAX_VALUE) {
                    if (l != 0L) {
                        return TYPE_VARCHAR_IGNORECASE;
                    }
                    l = 1L;
                }
                return new TypeInfo(14, l, 0, (int)l, null);
            }
            case 15: 
            case 16: {
                if (l < 1L) {
                    l = Long.MAX_VALUE;
                }
                return new TypeInfo(n, l, 0, MathUtils.convertLongToInt(l), null);
            }
            case 17: {
                if (l < 0L || l >= Integer.MAX_VALUE) {
                    if (extTypeInfo == null) {
                        return TYPE_ARRAY;
                    }
                    l = Integer.MAX_VALUE;
                }
                return new TypeInfo(17, l, 0, Integer.MAX_VALUE, extTypeInfo);
            }
            case 19: {
                if (l < 1L || l > Integer.MAX_VALUE) {
                    return TYPE_JAVA_OBJECT;
                }
                return new TypeInfo(19, l, 0, MathUtils.convertLongToInt(l * 2L), null);
            }
            case 21: {
                if (l < 1L) {
                    l = 1L;
                } else if (l > Integer.MAX_VALUE) {
                    l = Integer.MAX_VALUE;
                }
                return new TypeInfo(21, l, 0, (int)l, null);
            }
            case 22: {
                if (extTypeInfo instanceof ExtTypeInfoGeometry) {
                    return new TypeInfo(22, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, extTypeInfo);
                }
                return TYPE_GEOMETRY;
            }
            case 25: {
                if (extTypeInfo instanceof ExtTypeInfoEnum) {
                    return ((ExtTypeInfoEnum)extTypeInfo).getType();
                }
                return TYPE_ENUM_UNDEFINED;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 36: {
                if (l < 1L || l > 18L) {
                    l = 18L;
                }
                return new TypeInfo(n, l, 0, ValueInterval.getDisplaySize(n, (int)l, 0), null);
            }
            case 31: 
            case 35: 
            case 37: 
            case 38: {
                if (l < 1L || l > 18L) {
                    l = 18L;
                }
                if (n2 < 0 || n2 > 9) {
                    n2 = 9;
                }
                return new TypeInfo(n, l, n2, ValueInterval.getDisplaySize(n, (int)l, n2), null);
            }
            case 42: {
                if (l < 1L) {
                    l = 1L;
                } else if (l > Integer.MAX_VALUE) {
                    l = Integer.MAX_VALUE;
                }
                return new TypeInfo(42, l, 0, MathUtils.convertLongToInt(l * 2L), null);
            }
        }
        return TYPE_NULL;
    }

    public TypeInfo(int n, long l, int n2, int n3, ExtTypeInfo extTypeInfo) {
        this.valueType = n;
        this.precision = l;
        this.scale = n2;
        this.displaySize = n3;
        this.extTypeInfo = extTypeInfo;
    }

    public int getValueType() {
        return this.valueType;
    }

    public long getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public int getDisplaySize() {
        return this.displaySize;
    }

    public ExtTypeInfo getExtTypeInfo() {
        return this.extTypeInfo;
    }

    public StringBuilder getSQL(StringBuilder stringBuilder) {
        switch (this.valueType) {
            case 6: {
                stringBuilder.append(DataType.getDataType((int)this.valueType).name);
                stringBuilder.append('(').append(this.precision).append(", ").append(this.scale).append(')');
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 19: {
                stringBuilder.append(DataType.getDataType((int)this.valueType).name);
                if (this.precision >= Integer.MAX_VALUE) break;
                stringBuilder.append('(').append(this.precision).append(')');
                break;
            }
            case 21: 
            case 42: {
                stringBuilder.append(DataType.getDataType((int)this.valueType).name);
                stringBuilder.append('(').append(this.precision).append(')');
                break;
            }
            case 9: 
            case 41: {
                stringBuilder.append("TIME");
                if (this.scale != 0) {
                    stringBuilder.append('(').append(this.scale).append(')');
                }
                if (this.valueType != 41) break;
                stringBuilder.append(" WITH TIME ZONE");
                break;
            }
            case 11: 
            case 24: {
                stringBuilder.append("TIMESTAMP");
                if (this.scale != 6) {
                    stringBuilder.append('(').append(this.scale).append(')');
                }
                if (this.valueType != 24) break;
                stringBuilder.append(" WITH TIME ZONE");
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                IntervalQualifier.valueOf(this.valueType - 26).getTypeName(stringBuilder, this.precision == 2L ? -1 : (int)this.precision, this.scale == 6 ? -1 : this.scale, false);
                break;
            }
            case 17: {
                if (this.extTypeInfo != null) {
                    stringBuilder.append(this.extTypeInfo.getCreateSQL()).append(' ');
                }
                stringBuilder.append("ARRAY");
                if (this.precision >= Integer.MAX_VALUE) break;
                stringBuilder.append('[').append(this.precision).append(']');
                break;
            }
            case 25: {
                stringBuilder.append("ENUM").append(this.extTypeInfo.getCreateSQL());
                break;
            }
            case 22: {
                stringBuilder.append("GEOMETRY");
                if (this.extTypeInfo == null) break;
                stringBuilder.append(this.extTypeInfo.getCreateSQL());
                break;
            }
            default: {
                stringBuilder.append(DataType.getDataType((int)this.valueType).name);
            }
        }
        return stringBuilder;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.valueType;
        n = 31 * n + (int)(this.precision ^ this.precision >>> 32);
        n = 31 * n + this.scale;
        n = 31 * n + this.displaySize;
        n = 31 * n + (this.extTypeInfo == null ? 0 : this.extTypeInfo.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != TypeInfo.class) {
            return false;
        }
        TypeInfo typeInfo = (TypeInfo)object;
        return this.valueType == typeInfo.valueType && this.precision == typeInfo.precision && this.scale == typeInfo.scale && this.displaySize == typeInfo.displaySize && Objects.equals(this.extTypeInfo, typeInfo.extTypeInfo);
    }

    public String toString() {
        return this.getSQL(new StringBuilder()).toString();
    }

    public TypeInfo toNumericType() {
        switch (this.valueType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return TypeInfo.getTypeInfo(6, this.precision, 0, null);
            }
            case 5: {
                return TYPE_NUMERIC_BIGINT;
            }
            case 6: {
                return this;
            }
            case 8: {
                return TypeInfo.getTypeInfo(6, 85L, 46, null);
            }
            case 7: {
                return TypeInfo.getTypeInfo(6, 634L, 325, null);
            }
        }
        return TYPE_NUMERIC_FLOATING_POINT;
    }

    static {
        TypeInfo[] typeInfoArray = new TypeInfo[43];
        TYPE_UNKNOWN = new TypeInfo(-1, -1L, -1, -1, null);
        typeInfoArray[0] = TYPE_NULL = new TypeInfo(0, 1L, 0, 4, null);
        typeInfoArray[1] = TYPE_BOOLEAN = new TypeInfo(1, 1L, 0, 5, null);
        typeInfoArray[2] = TYPE_TINYINT = new TypeInfo(2, 3L, 0, 4, null);
        typeInfoArray[3] = TYPE_SMALLINT = new TypeInfo(3, 5L, 0, 6, null);
        typeInfoArray[4] = TYPE_INTEGER = new TypeInfo(4, 10L, 0, 11, null);
        typeInfoArray[5] = TYPE_BIGINT = new TypeInfo(5, 19L, 0, 20, null);
        typeInfoArray[6] = TYPE_NUMERIC = new TypeInfo(6, Integer.MAX_VALUE, 100000, Integer.MAX_VALUE, null);
        TYPE_NUMERIC_BIGINT = new TypeInfo(6, 19L, 0, 20, null);
        TYPE_NUMERIC_FLOATING_POINT = new TypeInfo(6, 65535L, Short.MAX_VALUE, 65537, null);
        typeInfoArray[7] = TYPE_DOUBLE = new TypeInfo(7, 17L, 0, 24, null);
        typeInfoArray[8] = TYPE_REAL = new TypeInfo(8, 7L, 0, 15, null);
        typeInfoArray[9] = TYPE_TIME = new TypeInfo(9, 18L, 9, 18, null);
        typeInfoArray[10] = TYPE_DATE = new TypeInfo(10, 10L, 0, 10, null);
        typeInfoArray[11] = TYPE_TIMESTAMP = new TypeInfo(11, 29L, 9, 29, null);
        typeInfoArray[12] = TYPE_VARBINARY = new TypeInfo(12, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, null);
        typeInfoArray[13] = TYPE_VARCHAR = new TypeInfo(13, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, null);
        typeInfoArray[14] = TYPE_VARCHAR_IGNORECASE = new TypeInfo(14, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, null);
        typeInfoArray[15] = new TypeInfo(15, Long.MAX_VALUE, 0, Integer.MAX_VALUE, null);
        typeInfoArray[16] = new TypeInfo(16, Long.MAX_VALUE, 0, Integer.MAX_VALUE, null);
        typeInfoArray[17] = TYPE_ARRAY = new TypeInfo(17, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, null);
        typeInfoArray[18] = TYPE_RESULT_SET = new TypeInfo(18, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, null);
        typeInfoArray[19] = TYPE_JAVA_OBJECT = new TypeInfo(19, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, null);
        typeInfoArray[20] = TYPE_UUID = new TypeInfo(20, 16L, 0, 36, null);
        typeInfoArray[21] = new TypeInfo(21, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, null);
        typeInfoArray[22] = TYPE_GEOMETRY = new TypeInfo(22, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, null);
        typeInfoArray[24] = TYPE_TIMESTAMP_TZ = new TypeInfo(24, 35L, 9, 35, null);
        typeInfoArray[25] = TYPE_ENUM_UNDEFINED = new TypeInfo(25, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, null);
        for (int i = 26; i <= 38; ++i) {
            typeInfoArray[i] = new TypeInfo(i, 18L, IntervalQualifier.valueOf(i - 26).hasSeconds() ? 9 : 0, ValueInterval.getDisplaySize(i, 18, 9), null);
        }
        TYPE_INTERVAL_DAY = typeInfoArray[28];
        TYPE_INTERVAL_YEAR_TO_MONTH = typeInfoArray[32];
        TYPE_INTERVAL_DAY_TO_SECOND = typeInfoArray[35];
        TYPE_INTERVAL_HOUR_TO_SECOND = typeInfoArray[37];
        typeInfoArray[39] = TYPE_ROW = new TypeInfo(39, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, null);
        typeInfoArray[40] = TYPE_JSON = new TypeInfo(40, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, null);
        typeInfoArray[41] = TYPE_TIME_TZ = new TypeInfo(41, 24L, 9, 24, null);
        typeInfoArray[42] = new TypeInfo(42, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, null);
        TYPE_INFOS_BY_VALUE_TYPE = typeInfoArray;
    }
}

