/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.h2.command.Prepared;
import org.h2.command.dml.AllColumnsForPlan;
import org.h2.command.dml.DataChangeStatement;
import org.h2.command.dml.Select;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.result.Row;
import org.h2.result.RowList;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.DataChangeDeltaTable;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.HasSQL;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class Update
extends Prepared
implements DataChangeStatement {
    private Expression condition;
    private TableFilter targetTableFilter;
    private TableFilter sourceTableFilter;
    private Expression limitExpr;
    private boolean updateToCurrentValuesReturnsZero;
    private final LinkedHashMap<Column, Expression> setClauseMap = new LinkedHashMap();
    private HashSet<Long> updatedKeysCollector;
    private ResultTarget deltaChangeCollector;
    private DataChangeDeltaTable.ResultOption deltaChangeCollectionMode;

    public Update(Session session) {
        super(session);
    }

    @Override
    public Table getTable() {
        return this.targetTableFilter.getTable();
    }

    public void setTableFilter(TableFilter tableFilter) {
        this.targetTableFilter = tableFilter;
    }

    public void setCondition(Expression expression) {
        this.condition = expression;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public void setAssignment(Column column, Expression expression) {
        if (this.setClauseMap.putIfAbsent(column, expression) != null) {
            throw DbException.get(42121, column.getName());
        }
        if (expression instanceof Parameter) {
            Parameter parameter = (Parameter)expression;
            parameter.setColumn(column);
        }
    }

    public void setUpdatedKeysCollector(HashSet<Long> hashSet) {
        this.updatedKeysCollector = hashSet;
    }

    @Override
    public void setDeltaChangeCollector(ResultTarget resultTarget, DataChangeDeltaTable.ResultOption resultOption) {
        this.deltaChangeCollector = resultTarget;
        this.deltaChangeCollectionMode = resultOption;
    }

    @Override
    public int update() {
        this.targetTableFilter.startQuery(this.session);
        this.targetTableFilter.reset();
        Table table = this.targetTableFilter.getTable();
        try (RowList rowList = new RowList(this.session, table);){
            Row row;
            Value value;
            this.session.getUser().checkRight(table, 8);
            table.fire(this.session, 2, true);
            table.lock(this.session, true, false);
            this.setCurrentRowNumber(0L);
            int n = 0;
            Column[] columnArray = table.getColumns();
            int n2 = columnArray.length;
            int n3 = -1;
            if (this.limitExpr != null && (value = this.limitExpr.getValue(this.session)) != ValueNull.INSTANCE) {
                n3 = value.getInt();
            }
            while (this.targetTableFilter.next()) {
                HasSQL hasSQL;
                this.setCurrentRowNumber(n + 1);
                if (n3 >= 0 && n >= n3) break;
                if (this.condition != null && !this.condition.getBooleanValue(this.session)) continue;
                value = this.targetTableFilter.get();
                if (table.isMVStore()) {
                    row = table.lockRow(this.session, (Row)value);
                    if (row == null) continue;
                    if (!((Row)value).hasSharedData(row)) {
                        value = row;
                        this.targetTableFilter.set((Row)value);
                        if (this.condition != null && !this.condition.getBooleanValue(this.session)) continue;
                    }
                }
                row = table.getTemplateRow();
                boolean bl = false;
                for (int i = 0; i < n2; ++i) {
                    Column column = columnArray[i];
                    Expression expression = this.setClauseMap.get(column);
                    if (expression == null) {
                        if (column.getOnUpdateExpression() != null) {
                            bl = true;
                        }
                        hasSQL = column.getGenerated() ? null : ((SearchRow)value).getValue(i);
                    } else {
                        hasSQL = expression == ValueExpression.DEFAULT ? null : expression.getValue(this.session);
                    }
                    row.setValue(i, (Value)hasSQL);
                }
                long l = ((SearchRow)value).getKey();
                row.setKey(l);
                table.validateConvertUpdateSequence(this.session, row);
                if (bl || this.updateToCurrentValuesReturnsZero) {
                    int n4;
                    bl = false;
                    for (n4 = 0; n4 < n2; ++n4) {
                        if (Objects.equals(((SearchRow)value).getValue(n4), row.getValue(n4))) continue;
                        bl = true;
                        break;
                    }
                    if (bl) {
                        for (n4 = 0; n4 < n2; ++n4) {
                            Expression expression;
                            hasSQL = columnArray[n4];
                            if (this.setClauseMap.get(hasSQL) != null || (expression = ((Column)hasSQL).getOnUpdateExpression()) == null) continue;
                            row.setValue(n4, expression.getValue(this.session));
                        }
                        table.validateConvertUpdateSequence(this.session, row);
                    } else if (this.updateToCurrentValuesReturnsZero) {
                        --n;
                    }
                }
                if (this.deltaChangeCollectionMode == DataChangeDeltaTable.ResultOption.OLD) {
                    this.deltaChangeCollector.addRow(((Row)value).getValueList());
                } else if (this.deltaChangeCollectionMode == DataChangeDeltaTable.ResultOption.NEW) {
                    this.deltaChangeCollector.addRow((Value[])row.getValueList().clone());
                }
                if (!table.fireRow() || !table.fireBeforeRow(this.session, (Row)value, row)) {
                    rowList.add((Row)value);
                    rowList.add(row);
                    if (this.updatedKeysCollector != null) {
                        this.updatedKeysCollector.add(l);
                    }
                }
                if (this.deltaChangeCollectionMode == DataChangeDeltaTable.ResultOption.FINAL) {
                    this.deltaChangeCollector.addRow(row.getValueList());
                }
                ++n;
            }
            table.updateRows(this, this.session, rowList);
            if (table.fireRow()) {
                rowList.reset();
                while (rowList.hasNext()) {
                    value = rowList.next();
                    row = rowList.next();
                    table.fireAfterRow(this.session, (Row)value, row, false);
                }
            }
            table.fire(this.session, 2, false);
            int n5 = n;
            return n5;
        }
    }

    @Override
    public String getPlanSQL(int n) {
        StringBuilder stringBuilder = new StringBuilder("UPDATE ");
        this.targetTableFilter.getPlanSQL(stringBuilder, false, n).append("\nSET\n    ");
        boolean bl = false;
        for (Map.Entry<Column, Expression> entry : this.setClauseMap.entrySet()) {
            if (bl) {
                stringBuilder.append(",\n    ");
            }
            bl = true;
            entry.getKey().getSQL(stringBuilder, n).append(" = ");
            entry.getValue().getSQL(stringBuilder, n);
        }
        if (this.condition != null) {
            stringBuilder.append("\nWHERE ");
            this.condition.getUnenclosedSQL(stringBuilder, n);
        }
        if (this.limitExpr != null) {
            stringBuilder.append("\nLIMIT ");
            this.limitExpr.getUnenclosedSQL(stringBuilder, n);
        }
        return stringBuilder.toString();
    }

    @Override
    public void prepare() {
        if (this.condition != null) {
            this.condition.mapColumns(this.targetTableFilter, 0, 0);
            this.condition = this.condition.optimize(this.session);
            this.condition.createIndexConditions(this.session, this.targetTableFilter);
        }
        for (Map.Entry<Column, Expression> object2 : this.setClauseMap.entrySet()) {
            Expression expression = object2.getValue();
            expression.mapColumns(this.targetTableFilter, 0, 0);
            if (this.sourceTableFilter != null) {
                expression.mapColumns(this.sourceTableFilter, 0, 0);
            }
            object2.setValue(expression.optimize(this.session));
        }
        TableFilter[] tableFilterArray = this.sourceTableFilter == null ? new TableFilter[]{this.targetTableFilter} : new TableFilter[]{this.targetTableFilter, this.sourceTableFilter};
        PlanItem planItem = this.targetTableFilter.getBestPlanItem(this.session, tableFilterArray, 0, new AllColumnsForPlan(tableFilterArray));
        this.targetTableFilter.setPlanItem(planItem);
        this.targetTableFilter.prepare();
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    @Override
    public int getType() {
        return 68;
    }

    @Override
    public String getStatementName() {
        return "UPDATE";
    }

    public void setLimit(Expression expression) {
        this.limitExpr = expression;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    public TableFilter getSourceTableFilter() {
        return this.sourceTableFilter;
    }

    public void setSourceTableFilter(TableFilter tableFilter) {
        this.sourceTableFilter = tableFilter;
    }

    public void setUpdateToCurrentValuesReturnsZero(boolean bl) {
        this.updateToCurrentValuesReturnsZero = bl;
    }

    @Override
    public void collectDependencies(HashSet<DbObject> hashSet) {
        Select select;
        ExpressionVisitor expressionVisitor = ExpressionVisitor.getDependenciesVisitor(hashSet);
        if (this.condition != null) {
            this.condition.isEverything(expressionVisitor);
        }
        if (this.sourceTableFilter != null && (select = this.sourceTableFilter.getSelect()) != null) {
            select.isEverything(expressionVisitor);
        }
    }
}

