/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Objects;
import org.h2.command.Command;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.Engine;
import org.h2.engine.Session;
import org.h2.engine.SysProperties;
import org.h2.expression.Parameter;
import org.h2.expression.ParameterInterface;
import org.h2.expression.ParameterRemote;
import org.h2.jdbc.JdbcException;
import org.h2.message.DbException;
import org.h2.result.ResultColumn;
import org.h2.result.ResultInterface;
import org.h2.result.ResultWithGeneratedKeys;
import org.h2.server.TcpServer;
import org.h2.util.IOUtils;
import org.h2.util.NetUtils;
import org.h2.util.NetworkConnectionInfo;
import org.h2.util.SmallLRUCache;
import org.h2.util.SmallMap;
import org.h2.value.Transfer;
import org.h2.value.Value;
import org.h2.value.ValueLob;

public class TcpServerThread
implements Runnable {
    protected final Transfer transfer;
    private final TcpServer server;
    private Session session;
    private boolean stop;
    private Thread thread;
    private Command commit;
    private final SmallMap cache = new SmallMap(SysProperties.SERVER_CACHED_OBJECTS);
    private final SmallLRUCache<Long, CachedInputStream> lobs = SmallLRUCache.newInstance(Math.max(SysProperties.SERVER_CACHED_OBJECTS, SysProperties.SERVER_RESULT_SET_FETCH_SIZE * 5));
    private final int threadId;
    private int clientVersion;
    private String sessionId;
    private long lastRemoteSettingsId;

    TcpServerThread(Socket socket, TcpServer tcpServer, int n) {
        this.server = tcpServer;
        this.threadId = n;
        this.transfer = new Transfer(null, socket);
    }

    private void trace(String string) {
        this.server.trace(this + " " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Socket socket;
            block28: {
                this.transfer.init();
                this.trace("Connect");
                socket = this.transfer.getSocket();
                if (socket != null) break block28;
                return;
            }
            try {
                int n;
                String string;
                if (!this.server.allow(this.transfer.getSocket())) {
                    throw DbException.get(90117);
                }
                int n2 = this.transfer.readInt();
                if (n2 < 6) {
                    throw DbException.get(90047, Integer.toString(n2), "12");
                }
                int n3 = this.transfer.readInt();
                if (n3 < 12) {
                    throw DbException.get(90047, Integer.toString(n3), "12");
                }
                if (n2 > 19) {
                    throw DbException.get(90047, Integer.toString(n2), "19");
                }
                this.clientVersion = n3 >= 19 ? 19 : n3;
                this.transfer.setVersion(this.clientVersion);
                String string2 = this.transfer.readString();
                String string3 = this.transfer.readString();
                if (string2 == null && string3 == null) {
                    string = this.transfer.readString();
                    int n4 = this.transfer.readInt();
                    this.stop = true;
                    if (n4 == 13) {
                        n = this.transfer.readInt();
                        this.server.cancelStatement(string, n);
                    } else if (n4 == 14) {
                        string2 = this.server.checkKeyAndGetDatabaseName(string);
                        if (!string.equals(string2)) {
                            this.transfer.writeInt(1);
                        } else {
                            this.transfer.writeInt(0);
                        }
                    }
                }
                if ((string = this.server.getBaseDir()) == null) {
                    string = SysProperties.getBaseDir();
                }
                string2 = this.server.checkKeyAndGetDatabaseName(string2);
                ConnectionInfo connectionInfo = new ConnectionInfo(string2);
                connectionInfo.setOriginalURL(string3);
                connectionInfo.setUserName(this.transfer.readString());
                connectionInfo.setUserPasswordHash(this.transfer.readBytes());
                connectionInfo.setFilePasswordHash(this.transfer.readBytes());
                n = this.transfer.readInt();
                for (int i = 0; i < n; ++i) {
                    connectionInfo.setProperty(this.transfer.readString(), this.transfer.readString());
                }
                if (string != null) {
                    connectionInfo.setBaseDir(string);
                }
                if (this.server.getIfExists()) {
                    connectionInfo.setProperty("FORBID_CREATION", "TRUE");
                }
                this.transfer.writeInt(1);
                this.transfer.writeInt(this.clientVersion);
                this.transfer.flush();
                if (this.clientVersion >= 13 && connectionInfo.getFilePasswordHash() != null) {
                    connectionInfo.setFileEncryptionKey(this.transfer.readBytes());
                }
                connectionInfo.setNetworkConnectionInfo(new NetworkConnectionInfo(NetUtils.ipToShortForm(new StringBuilder(this.server.getSSL() ? "ssl://" : "tcp://"), socket.getLocalAddress().getAddress(), true).append(':').append(socket.getLocalPort()).toString(), socket.getInetAddress().getAddress(), socket.getPort(), "" + 'P' + this.clientVersion));
                this.session = Engine.getInstance().createSession(connectionInfo);
                this.transfer.setSession(this.session);
                this.server.addConnection(this.threadId, string3, connectionInfo.getUserName());
                this.trace("Connected");
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.server.traceError(outOfMemoryError);
                this.sendError(outOfMemoryError);
                this.stop = true;
            }
            catch (Throwable throwable) {
                this.sendError(throwable);
                this.stop = true;
            }
            this.lastRemoteSettingsId = this.session.getDatabase().getRemoteSettingsId();
            while (!this.stop) {
                try {
                    this.process();
                }
                catch (Throwable throwable) {
                    this.sendError(throwable);
                }
            }
            this.trace("Disconnect");
        }
        catch (Throwable throwable) {
            this.server.traceError(throwable);
        }
        finally {
            this.close();
        }
    }

    private void closeSession() {
        if (this.session != null) {
            RuntimeException runtimeException = null;
            try {
                this.session.close();
                this.server.removeConnection(this.threadId);
            }
            catch (RuntimeException runtimeException2) {
                runtimeException = runtimeException2;
                this.server.traceError(runtimeException2);
            }
            catch (Exception exception) {
                this.server.traceError(exception);
            }
            finally {
                this.session = null;
            }
            if (runtimeException != null) {
                throw runtimeException;
            }
        }
    }

    void close() {
        try {
            this.stop = true;
            this.closeSession();
        }
        catch (Exception exception) {
            this.server.traceError(exception);
        }
        finally {
            this.transfer.close();
            this.trace("Close");
            this.server.remove(this);
        }
    }

    private void sendError(Throwable throwable) {
        try {
            String string;
            String string2;
            SQLException sQLException = DbException.convert(throwable).getSQLException();
            StringWriter stringWriter = new StringWriter();
            sQLException.printStackTrace(new PrintWriter(stringWriter));
            String string3 = stringWriter.toString();
            if (sQLException instanceof JdbcException) {
                JdbcException jdbcException = (JdbcException)((Object)sQLException);
                string2 = jdbcException.getOriginalMessage();
                string = jdbcException.getSQL();
            } else {
                string2 = sQLException.getMessage();
                string = null;
            }
            this.transfer.writeInt(0).writeString(sQLException.getSQLState()).writeString(string2).writeString(string).writeInt(sQLException.getErrorCode()).writeString(string3).flush();
        }
        catch (Exception exception) {
            if (!this.transfer.isClosed()) {
                this.server.traceError(exception);
            }
            this.stop = true;
        }
    }

    private void setParameters(Command command) throws IOException {
        int n = this.transfer.readInt();
        ArrayList<? extends ParameterInterface> arrayList = command.getParameters();
        for (int i = 0; i < n; ++i) {
            Parameter parameter = (Parameter)arrayList.get(i);
            parameter.setValue(this.transfer.readValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void process() throws IOException {
        int n = this.transfer.readInt();
        switch (n) {
            case 0: 
            case 11: 
            case 18: {
                int n2 = this.transfer.readInt();
                String string = this.transfer.readString();
                int n3 = this.session.getModificationId();
                Command command = this.session.prepareLocal(string);
                boolean bl = command.isReadOnly();
                this.cache.addObject(n2, command);
                boolean bl2 = command.isQuery();
                this.transfer.writeInt(this.getState(n3)).writeBoolean(bl2).writeBoolean(bl);
                if (n == 18) {
                    this.transfer.writeInt(command.getCommandType());
                }
                ArrayList<? extends ParameterInterface> arrayList = command.getParameters();
                this.transfer.writeInt(arrayList.size());
                if (n != 0) {
                    for (ParameterInterface parameterInterface : arrayList) {
                        ParameterRemote.writeMetaData(this.transfer, parameterInterface);
                    }
                }
                this.transfer.flush();
                break;
            }
            case 1: {
                this.stop = true;
                this.closeSession();
                this.transfer.writeInt(1).flush();
                this.close();
                break;
            }
            case 8: {
                if (this.commit == null) {
                    this.commit = this.session.prepareLocal("COMMIT");
                }
                int n4 = this.session.getModificationId();
                this.commit.executeUpdate(null);
                this.transfer.writeInt(this.getState(n4)).flush();
                break;
            }
            case 10: {
                int n5 = this.transfer.readInt();
                int n6 = this.transfer.readInt();
                Command command = (Command)this.cache.getObject(n5, false);
                ResultInterface resultInterface = command.getMetaData();
                this.cache.addObject(n6, resultInterface);
                int n7 = resultInterface.getVisibleColumnCount();
                this.transfer.writeInt(1).writeInt(n7).writeInt(0);
                for (int i = 0; i < n7; ++i) {
                    ResultColumn.writeColumn(this.transfer, resultInterface, i);
                }
                this.transfer.flush();
                break;
            }
            case 2: {
                int n2;
                ResultInterface resultInterface;
                int n9 = this.transfer.readInt();
                int n10 = this.transfer.readInt();
                int n11 = this.transfer.readInt();
                int n12 = this.transfer.readInt();
                Command command = (Command)this.cache.getObject(n9, false);
                this.setParameters(command);
                int n13 = this.session.getModificationId();
                Session session = this.session;
                synchronized (session) {
                    resultInterface = command.executeQuery(n11, false);
                }
                this.cache.addObject(n10, resultInterface);
                int n14 = resultInterface.getVisibleColumnCount();
                int n15 = this.getState(n13);
                this.transfer.writeInt(n15).writeInt(n14);
                int n3 = resultInterface.getRowCount();
                this.transfer.writeInt(n3);
                for (n2 = 0; n2 < n14; ++n2) {
                    ResultColumn.writeColumn(this.transfer, resultInterface, n2);
                }
                n2 = Math.min(n3, n12);
                for (int i = 0; i < n2; ++i) {
                    this.sendRow(resultInterface);
                }
                this.transfer.flush();
                break;
            }
            case 3: {
                int n17;
                ResultWithGeneratedKeys resultWithGeneratedKeys;
                String[] stringArray;
                String[] stringArray2;
                int n18;
                boolean bl;
                int n19 = this.transfer.readInt();
                Command command = (Command)this.cache.getObject(n19, false);
                this.setParameters(command);
                boolean bl3 = bl = this.clientVersion >= 17;
                if (bl) {
                    n18 = this.transfer.readInt();
                    switch (n18) {
                        case 0: {
                            stringArray2 = false;
                            bl3 = false;
                            break;
                        }
                        case 1: {
                            stringArray2 = true;
                            break;
                        }
                        case 2: {
                            void resultInterface;
                            int n21 = this.transfer.readInt();
                            stringArray = (String[])new int[n21];
                            boolean n20 = false;
                            while (resultInterface < n21) {
                                stringArray[resultInterface] = (String)this.transfer.readInt();
                                ++resultInterface;
                            }
                            stringArray2 = stringArray;
                            break;
                        }
                        case 3: {
                            void var10_61;
                            int n21 = this.transfer.readInt();
                            stringArray = new String[n21];
                            boolean valueLob = false;
                            while (var10_61 < n21) {
                                stringArray[var10_61] = this.transfer.readString();
                                ++var10_61;
                            }
                            stringArray2 = stringArray;
                            break;
                        }
                        default: {
                            throw DbException.get(90067, "Unsupported generated keys' mode " + n18);
                        }
                    }
                } else {
                    stringArray2 = Boolean.valueOf(false);
                }
                n18 = this.session.getModificationId();
                stringArray = this.session;
                synchronized (stringArray) {
                    resultWithGeneratedKeys = command.executeUpdate(stringArray2);
                }
                if (this.session.isClosed()) {
                    n17 = 2;
                    this.stop = true;
                } else {
                    n17 = this.getState(n18);
                }
                this.transfer.writeInt(n17).writeInt(resultWithGeneratedKeys.getUpdateCount()).writeBoolean(this.session.getAutoCommit());
                if (bl3) {
                    int n4;
                    ResultInterface resultInterface = resultWithGeneratedKeys.getGeneratedKeys();
                    int n5 = resultInterface.getVisibleColumnCount();
                    this.transfer.writeInt(n5);
                    int n6 = resultInterface.getRowCount();
                    this.transfer.writeInt(n6);
                    for (n4 = 0; n4 < n5; ++n4) {
                        ResultColumn.writeColumn(this.transfer, resultInterface, n4);
                    }
                    for (n4 = 0; n4 < n6; ++n4) {
                        this.sendRow(resultInterface);
                    }
                    resultInterface.close();
                }
                this.transfer.flush();
                break;
            }
            case 4: {
                int n25 = this.transfer.readInt();
                Command command = (Command)this.cache.getObject(n25, true);
                if (command == null) break;
                command.close();
                this.cache.freeObject(n25);
                break;
            }
            case 5: {
                int n26 = this.transfer.readInt();
                int n27 = this.transfer.readInt();
                ResultInterface resultInterface = (ResultInterface)this.cache.getObject(n26, false);
                this.transfer.writeInt(1);
                for (int i = 0; i < n27; ++i) {
                    this.sendRow(resultInterface);
                }
                this.transfer.flush();
                break;
            }
            case 6: {
                int n28 = this.transfer.readInt();
                ResultInterface resultInterface = (ResultInterface)this.cache.getObject(n28, false);
                resultInterface.reset();
                break;
            }
            case 7: {
                int n29 = this.transfer.readInt();
                ResultInterface resultInterface = (ResultInterface)this.cache.getObject(n29, true);
                if (resultInterface == null) break;
                resultInterface.close();
                this.cache.freeObject(n29);
                break;
            }
            case 9: {
                int n30 = this.transfer.readInt();
                int n31 = this.transfer.readInt();
                Object object = this.cache.getObject(n30, false);
                this.cache.freeObject(n30);
                this.cache.addObject(n31, object);
                break;
            }
            case 12: {
                this.sessionId = this.transfer.readString();
                this.transfer.writeInt(1);
                if (this.clientVersion >= 15) {
                    this.transfer.writeBoolean(this.session.getAutoCommit());
                }
                this.transfer.flush();
                break;
            }
            case 15: {
                boolean bl = this.transfer.readBoolean();
                this.session.setAutoCommit(bl);
                this.transfer.writeInt(1).flush();
                break;
            }
            case 16: {
                this.transfer.writeInt(1).writeInt(this.session.hasPendingTransaction() ? 1 : 0).flush();
                break;
            }
            case 17: {
                Object object;
                long l = this.transfer.readLong();
                byte[] byArray = this.transfer.readBytes();
                CachedInputStream cachedInputStream = (CachedInputStream)this.lobs.get(l);
                if (cachedInputStream == null) {
                    cachedInputStream = new CachedInputStream(null);
                    this.lobs.put(l, cachedInputStream);
                }
                long l2 = this.transfer.readLong();
                int n32 = this.transfer.readInt();
                this.transfer.verifyLobMac(byArray, l);
                if (cachedInputStream.getPos() != l2) {
                    object = this.session.getDataHandler().getLobStorage();
                    ValueLob valueLob = ValueLob.create(15, null, -1, l, byArray, -1L);
                    InputStream inputStream = object.getInputStream(valueLob, byArray, -1L);
                    cachedInputStream = new CachedInputStream(inputStream);
                    this.lobs.put(l, cachedInputStream);
                    inputStream.skip(l2);
                }
                n32 = Math.min(65536, n32);
                object = new byte[n32];
                n32 = IOUtils.readFully(cachedInputStream, (byte[])object, n32);
                this.transfer.writeInt(1);
                this.transfer.writeInt(n32);
                this.transfer.writeBytes((byte[])object, 0, n32);
                this.transfer.flush();
                break;
            }
            default: {
                this.trace("Unknown operation: " + n);
                this.close();
            }
        }
    }

    private int getState(int n) {
        if (this.session == null) {
            return 2;
        }
        if (this.session.getModificationId() == n) {
            long l = this.session.getDatabase().getRemoteSettingsId();
            if (this.lastRemoteSettingsId == l) {
                return 1;
            }
            this.lastRemoteSettingsId = l;
        }
        return 3;
    }

    private void sendRow(ResultInterface resultInterface) throws IOException {
        if (resultInterface.next()) {
            this.transfer.writeBoolean(true);
            Value[] valueArray = resultInterface.currentRow();
            for (int i = 0; i < resultInterface.getVisibleColumnCount(); ++i) {
                this.transfer.writeValue(valueArray[i]);
            }
        } else {
            this.transfer.writeBoolean(false);
        }
    }

    void setThread(Thread thread) {
        this.thread = thread;
    }

    Thread getThread() {
        return this.thread;
    }

    void cancelStatement(String string, int n) {
        if (Objects.equals(string, this.sessionId)) {
            Command command = (Command)this.cache.getObject(n, false);
            command.cancel();
        }
    }

    static class CachedInputStream
    extends FilterInputStream {
        private static final ByteArrayInputStream DUMMY = new ByteArrayInputStream(new byte[0]);
        private long pos;

        CachedInputStream(InputStream inputStream) {
            super(inputStream == null ? DUMMY : inputStream);
            if (inputStream == null) {
                this.pos = -1L;
            }
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if ((n2 = super.read(byArray, n, n2)) > 0) {
                this.pos += (long)n2;
            }
            return n2;
        }

        @Override
        public int read() throws IOException {
            int n = this.in.read();
            if (n >= 0) {
                ++this.pos;
            }
            return n;
        }

        @Override
        public long skip(long l) throws IOException {
            if ((l = super.skip(l)) > 0L) {
                this.pos += l;
            }
            return l;
        }

        public long getPos() {
            return this.pos;
        }
    }
}

