/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.type;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.BasicDataType;
import org.h2.mvstore.type.DataType;
import org.h2.mvstore.type.StatefulDataType;

public final class MetaType<D>
extends BasicDataType<DataType<?>> {
    private final D database;
    private final Thread.UncaughtExceptionHandler exceptionHandler;
    private final Map<String, StatefulDataType.Factory<D>> cache = new HashMap<String, StatefulDataType.Factory<D>>();

    public MetaType(D d, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.database = d;
        this.exceptionHandler = uncaughtExceptionHandler;
    }

    @Override
    public int compare(DataType<?> dataType, DataType<?> dataType2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMemory(DataType<?> dataType) {
        return 24;
    }

    @Override
    public void write(WriteBuffer writeBuffer, DataType<?> dataType) {
        Object object;
        Class<?> clazz = dataType.getClass();
        StatefulDataType statefulDataType = null;
        if (dataType instanceof StatefulDataType && (object = (statefulDataType = (StatefulDataType)((Object)dataType)).getFactory()) != null) {
            clazz = object.getClass();
        }
        object = clazz.getName();
        int n = ((String)object).length();
        writeBuffer.putVarInt(n).putStringData((String)object, n);
        if (statefulDataType != null) {
            statefulDataType.save(writeBuffer, this);
        }
    }

    @Override
    public DataType<?> read(ByteBuffer byteBuffer) {
        int n = DataUtils.readVarInt(byteBuffer);
        String string = DataUtils.readString(byteBuffer, n);
        try {
            StatefulDataType.Factory factory = this.cache.get(string);
            if (factory != null) {
                return factory.create(byteBuffer, this, this.database);
            }
            Class<?> clazz = Class.forName(string);
            Object obj = clazz.newInstance();
            if (obj instanceof StatefulDataType.Factory) {
                factory = (StatefulDataType.Factory)obj;
                this.cache.put(string, factory);
                return factory.create(byteBuffer, this, this.database);
            }
            return (DataType)obj;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.uncaughtException(Thread.currentThread(), reflectiveOperationException);
            }
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    public DataType<?>[] createStorage(int n) {
        return new DataType[n];
    }
}

