/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.h2.compress.CompressDeflate;
import org.h2.compress.CompressLZF;
import org.h2.compress.Compressor;
import org.h2.mvstore.Chunk;
import org.h2.mvstore.Cursor;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.FileStore;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStoreTool;
import org.h2.mvstore.Page;
import org.h2.mvstore.RootReference;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.cache.CacheLongKeyLIRS;
import org.h2.mvstore.type.StringDataType;
import org.h2.util.MathUtils;
import org.h2.util.Utils;

public class MVStore
implements AutoCloseable {
    private static final String HDR_H = "H";
    private static final String HDR_BLOCK_SIZE = "blockSize";
    private static final String HDR_FORMAT = "format";
    private static final String HDR_CREATED = "created";
    private static final String HDR_FORMAT_READ = "formatRead";
    private static final String HDR_CHUNK = "chunk";
    private static final String HDR_BLOCK = "block";
    private static final String HDR_VERSION = "version";
    private static final String HDR_CLEAN = "clean";
    private static final String HDR_FLETCHER = "fletcher";
    static final int BLOCK_SIZE = 4096;
    private static final int FORMAT_WRITE = 1;
    private static final int FORMAT_READ = 1;
    private static final int STATE_OPEN = 0;
    private static final int STATE_STOPPING = 1;
    private static final int STATE_CLOSING = 2;
    private static final int STATE_CLOSED = 3;
    private final ReentrantLock storeLock = new ReentrantLock(true);
    private final AtomicReference<BackgroundWriterThread> backgroundWriterThread = new AtomicReference();
    private volatile boolean reuseSpace = true;
    private volatile int state;
    private final FileStore fileStore;
    private final boolean fileStoreIsProvided;
    private final int pageSplitSize;
    private final int keysPerPage;
    private final CacheLongKeyLIRS<Page<?, ?>> cache;
    private final CacheLongKeyLIRS<long[]> chunksToC;
    private Chunk lastChunk;
    private final ConcurrentHashMap<Integer, Chunk> chunks = new ConcurrentHashMap();
    private final Queue<RemovedPageInfo> removedPages = new PriorityBlockingQueue<RemovedPageInfo>();
    private final Deque<Chunk> deadChunks = new ArrayDeque<Chunk>();
    private long updateCounter = 0L;
    private long updateAttemptCounter = 0L;
    private final MVMap<String, String> meta;
    private final ConcurrentHashMap<Integer, MVMap<?, ?>> maps = new ConcurrentHashMap();
    private final HashMap<String, Object> storeHeader = new HashMap();
    private WriteBuffer writeBuffer;
    private final AtomicInteger lastMapId = new AtomicInteger();
    private int versionsToKeep = 5;
    private final int compressionLevel;
    private Compressor compressorFast;
    private Compressor compressorHigh;
    private final boolean recoveryMode;
    public final Thread.UncaughtExceptionHandler backgroundExceptionHandler;
    private volatile long currentVersion;
    private volatile long lastStoredVersion = -1L;
    private final AtomicLong oldestVersionToKeep = new AtomicLong();
    private final Deque<TxCounter> versions = new LinkedList<TxCounter>();
    private volatile TxCounter currentTxCounter = new TxCounter(this.currentVersion);
    private int unsavedMemory;
    private final int autoCommitMemory;
    private volatile boolean saveNeeded;
    private long creationTime;
    private int retentionTime;
    private long lastCommitTime;
    private volatile long currentStoreVersion = -1L;
    private volatile boolean metaChanged;
    private int autoCommitDelay;
    private final int autoCompactFillRate;
    private long autoCompactLastFileOpCount;
    private volatile IllegalStateException panicException;
    private long lastTimeAbsolute;
    private long leafCount;
    private long nonLeafCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MVStore(Map<String, Object> map) {
        Object object;
        int n;
        this.recoveryMode = map.containsKey("recoveryMode");
        this.compressionLevel = DataUtils.getConfigParam(map, "compress", 0);
        String string = (String)map.get("fileName");
        FileStore fileStore = (FileStore)map.get("fileStore");
        boolean bl = this.fileStoreIsProvided = fileStore != null;
        if (fileStore == null && string != null) {
            fileStore = new FileStore();
        }
        this.fileStore = fileStore;
        int n2 = 48;
        CacheLongKeyLIRS.Config config = null;
        CacheLongKeyLIRS.Config config2 = null;
        if (this.fileStore != null) {
            n = DataUtils.getConfigParam(map, "cacheSize", 16);
            if (n > 0) {
                config = new CacheLongKeyLIRS.Config();
                config.maxMemory = (long)n * 1024L * 1024L;
                object = map.get("cacheConcurrency");
                if (object != null) {
                    config.segmentCount = (Integer)object;
                }
            }
            config2 = new CacheLongKeyLIRS.Config();
            config2.maxMemory = 0x100000L;
            n2 = 16384;
        }
        this.cache = config != null ? new CacheLongKeyLIRS(config) : null;
        this.chunksToC = config2 == null ? null : new CacheLongKeyLIRS(config2);
        n2 = DataUtils.getConfigParam(map, "pageSplitSize", n2);
        if (this.cache != null && (long)n2 > this.cache.getMaxItemSize()) {
            n2 = (int)this.cache.getMaxItemSize();
        }
        this.pageSplitSize = n2;
        this.keysPerPage = DataUtils.getConfigParam(map, "keysPerPage", 48);
        this.backgroundExceptionHandler = (Thread.UncaughtExceptionHandler)map.get("backgroundExceptionHandler");
        this.meta = new MVMap<String, String>(this, StringDataType.INSTANCE, StringDataType.INSTANCE);
        if (this.fileStore != null) {
            int n3;
            block18: {
                this.retentionTime = this.fileStore.getDefaultRetentionTime();
                n = Math.max(1, Math.min(19, Utils.scaleForAvailableMemory(64))) * 1024;
                n = DataUtils.getConfigParam(map, "autoCommitBufferSize", n);
                this.autoCommitMemory = n * 1024;
                this.autoCompactFillRate = DataUtils.getConfigParam(map, "autoCompactFillRate", 90);
                object = (char[])map.get("encryptionKey");
                try {
                    if (!this.fileStoreIsProvided) {
                        n3 = map.containsKey("readOnly");
                        this.fileStore.open(string, n3 != 0, (char[])object);
                    }
                    if (this.fileStore.size() == 0L) {
                        this.lastCommitTime = this.creationTime = this.getTimeAbsolute();
                        this.storeHeader.put(HDR_H, 2);
                        this.storeHeader.put(HDR_BLOCK_SIZE, 4096);
                        this.storeHeader.put(HDR_FORMAT, 1);
                        this.storeHeader.put(HDR_CREATED, this.creationTime);
                        this.writeStoreHeader();
                        break block18;
                    }
                    this.storeLock.lock();
                    try {
                        this.readStoreHeader();
                    }
                    finally {
                        this.storeLock.unlock();
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    this.panic(illegalStateException);
                }
                finally {
                    if (object != null) {
                        Arrays.fill((char[])object, '\u0000');
                    }
                }
            }
            this.lastCommitTime = this.getTimeSinceCreation();
            this.scrubMetaMap();
            n3 = DataUtils.getConfigParam(map, "autoCommitDelay", 1000);
            this.setAutoCommitDelay(n3);
        } else {
            this.autoCommitMemory = 0;
            this.autoCompactFillRate = 0;
        }
    }

    private void scrubMetaMap() {
        String string;
        String string22;
        HashSet<String> hashSet = new HashSet<String>();
        Iterator<String> iterator = this.meta.keyIterator("name.");
        while (iterator.hasNext() && (string22 = iterator.next()).startsWith("name.")) {
            int n;
            String string3;
            string = string22.substring("name.".length());
            if (string.equals(string3 = this.getMapName(n = DataUtils.parseHexInt(this.meta.get(string22))))) continue;
            hashSet.add(string22);
        }
        iterator = this.meta.keyIterator("root.");
        while (iterator.hasNext() && (string22 = iterator.next()).startsWith("root.")) {
            string = string22.substring(string22.lastIndexOf(46) + 1);
            if (this.meta.containsKey("map." + string)) continue;
            this.meta.remove(string22);
            this.markMetaChanged();
            hashSet.add(string22);
        }
        for (String string22 : hashSet) {
            this.meta.remove(string22);
            this.markMetaChanged();
        }
        iterator = this.meta.keyIterator("map.");
        while (iterator.hasNext() && (string22 = iterator.next()).startsWith("map.")) {
            string = DataUtils.getMapName(this.meta.get(string22));
            String string4 = string22.substring("map.".length());
            int n = DataUtils.parseHexInt(string4);
            if (n > this.lastMapId.get()) {
                this.lastMapId.set(n);
            }
            if (string4.equals(this.meta.get("name." + string))) continue;
            this.meta.put("name." + string, string4);
            this.markMetaChanged();
        }
    }

    private void panic(IllegalStateException illegalStateException) {
        if (this.isOpen()) {
            this.handleException(illegalStateException);
            this.panicException = illegalStateException;
            this.closeImmediately();
        }
        throw illegalStateException;
    }

    public IllegalStateException getPanicException() {
        return this.panicException;
    }

    public static MVStore open(String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("fileName", string);
        return new MVStore(hashMap);
    }

    public <K, V> MVMap<K, V> openMap(String string) {
        return this.openMap(string, new MVMap.Builder());
    }

    public <M extends MVMap<K, V>, K, V> M openMap(String string, MVMap.MapBuilder<M, K, V> mapBuilder) {
        int n = this.getMapId(string);
        if (n >= 0) {
            MVMap<K, V> mVMap = this.getMap(n);
            if (mVMap == null) {
                mVMap = this.openMap(n, mapBuilder);
            }
            assert (mapBuilder.getKeyType() == null || mVMap.getKeyType().getClass().equals(mapBuilder.getKeyType().getClass()));
            assert (mapBuilder.getValueType() == null || mVMap.getValueType().getClass().equals(mapBuilder.getValueType().getClass()));
            return (M)mVMap;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        n = this.lastMapId.incrementAndGet();
        assert (this.getMap(n) == null);
        hashMap.put("id", n);
        hashMap.put("createVersion", this.currentVersion);
        Object object = mapBuilder.create(this, hashMap);
        String string2 = Integer.toHexString(n);
        this.meta.put(MVMap.getMapKey(n), ((MVMap)object).asString(string));
        this.meta.put("name." + string, string2);
        ((MVMap)object).setRootPos(0L, this.lastStoredVersion);
        this.markMetaChanged();
        MVMap<?, ?> mVMap = this.maps.putIfAbsent(n, (MVMap<?, ?>)object);
        if (mVMap != null) {
            object = mVMap;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <M extends MVMap<K, V>, K, V> M openMap(int n, MVMap.MapBuilder<M, K, V> mapBuilder) {
        this.storeLock.lock();
        try {
            Object object;
            MVMap<K, V> mVMap = this.getMap(n);
            if (mVMap == null) {
                object = this.meta.get(MVMap.getMapKey(n));
                DataUtils.checkArgument(object != null, "Missing map with id {0}", n);
                HashMap<String, Object> hashMap = new HashMap<String, Object>(DataUtils.parseMap((String)object));
                hashMap.put("id", (String)((Object)Integer.valueOf(n)));
                mVMap = mapBuilder.create(this, hashMap);
                long l = MVStore.getRootPos(this.meta, n);
                mVMap.setRootPos(l, this.lastStoredVersion);
                this.maps.put(n, mVMap);
            }
            object = mVMap;
            return (M)object;
        }
        finally {
            this.storeLock.unlock();
        }
    }

    public <K, V> MVMap<K, V> getMap(int n) {
        this.checkOpen();
        MVMap<?, ?> mVMap = this.maps.get(n);
        return mVMap;
    }

    public Set<String> getMapNames() {
        String string;
        HashSet<String> hashSet = new HashSet<String>();
        this.checkOpen();
        Iterator<String> iterator = this.meta.keyIterator("name.");
        while (iterator.hasNext() && (string = iterator.next()).startsWith("name.")) {
            String string2 = string.substring("name.".length());
            hashSet.add(string2);
        }
        return hashSet;
    }

    public MVMap<String, String> getMetaMap() {
        this.checkOpen();
        return this.meta;
    }

    private MVMap<String, String> getMetaMap(long l) {
        Chunk chunk = this.getChunkForVersion(l);
        DataUtils.checkArgument(chunk != null, "Unknown version {0}", l);
        long l2 = chunk.block;
        chunk = this.readChunkHeader(l2);
        MVMap<String, String> mVMap = this.meta.openReadOnly(chunk.metaRootPos, l);
        return mVMap;
    }

    private Chunk getChunkForVersion(long l) {
        Chunk chunk = null;
        for (Chunk chunk2 : this.chunks.values()) {
            if (chunk2.version > l || chunk != null && chunk2.id <= chunk.id) continue;
            chunk = chunk2;
        }
        return chunk;
    }

    public boolean hasMap(String string) {
        return this.meta.containsKey("name." + string);
    }

    public boolean hasData(String string) {
        return this.hasMap(string) && MVStore.getRootPos(this.meta, this.getMapId(string)) != 0L;
    }

    private void markMetaChanged() {
        this.metaChanged = true;
    }

    private void readStoreHeader() {
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n2;
        Object object5 = null;
        boolean bl = true;
        boolean bl2 = false;
        ByteBuffer byteBuffer = this.fileStore.readFully(0L, 8192);
        byte[] byArray = new byte[4096];
        for (n2 = 0; n2 <= 4096; n2 += 4096) {
            byteBuffer.get(byArray);
            try {
                HashMap<String, String> hashMap = DataUtils.parseChecksummedMap(byArray);
                if (hashMap == null) {
                    bl = false;
                    continue;
                }
                long l = DataUtils.readHexLong(hashMap, HDR_VERSION, 0L);
                boolean bl3 = bl = bl && (object5 == null || l == ((Chunk)object5).version);
                if (object5 != null && l <= ((Chunk)object5).version) continue;
                bl2 = true;
                this.storeHeader.putAll(hashMap);
                this.creationTime = DataUtils.readHexLong(hashMap, HDR_CREATED, 0L);
                int n3 = DataUtils.readHexInt(hashMap, HDR_CHUNK, 0);
                long l2 = DataUtils.readHexLong(hashMap, HDR_BLOCK, 0L);
                Chunk chunk3 = this.readChunkHeaderAndFooter(l2, n3);
                if (chunk3 == null) continue;
                object5 = chunk3;
                continue;
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        if (!bl2) {
            throw DataUtils.newIllegalStateException(6, "Store header is corrupt: {0}", this.fileStore);
        }
        n2 = DataUtils.readHexInt(this.storeHeader, HDR_BLOCK_SIZE, 4096);
        if (n2 != 4096) {
            throw DataUtils.newIllegalStateException(5, "Block size {0} is currently not supported", n2);
        }
        long l = DataUtils.readHexLong(this.storeHeader, HDR_FORMAT, 1L);
        if (l > 1L && !this.fileStore.isReadOnly()) {
            throw DataUtils.newIllegalStateException(5, "The write format {0} is larger than the supported format {1}, and the file was not opened in read-only mode", l, 1);
        }
        if ((l = DataUtils.readHexLong(this.storeHeader, HDR_FORMAT_READ, l)) > 1L) {
            throw DataUtils.newIllegalStateException(5, "The read format {0} is larger than the supported format {1}", l, 1);
        }
        bl = bl && object5 != null && DataUtils.readHexInt(this.storeHeader, HDR_CLEAN, 0) != 0 && !this.recoveryMode;
        this.lastStoredVersion = -1L;
        this.chunks.clear();
        long l3 = System.currentTimeMillis();
        int n4 = 1970 + (int)(l3 / 31557600000L);
        if (n4 < 2014) {
            this.creationTime = l3 - (long)this.fileStore.getDefaultRetentionTime();
        } else if (l3 < this.creationTime) {
            this.creationTime = l3;
            this.storeHeader.put(HDR_CREATED, this.creationTime);
        }
        long l4 = this.fileStore.size();
        long l5 = l4 / 4096L;
        Comparator comparator = (chunk, chunk2) -> {
            int n = Long.compare(chunk2.version, chunk.version);
            if (n == 0) {
                n = Long.compare(chunk.block, chunk2.block);
            }
            return n;
        };
        if (!bl && (object4 = this.discoverChunk(l5)) != null) {
            l5 = ((Chunk)object4).block;
            if (object5 == null || ((Chunk)object4).version > ((Chunk)object5).version) {
                object5 = object4;
            }
        }
        object4 = new HashMap();
        if (object5 != null) {
            while (true) {
                object4.put(((Chunk)object5).block, object5);
                if (((Chunk)object5).next == 0L || ((Chunk)object5).next >= l5 || (object3 = this.readChunkHeaderAndFooter(((Chunk)object5).next, ((Chunk)object5).id + 1)) == null || ((Chunk)object3).version <= ((Chunk)object5).version) break;
                bl = false;
                object5 = object3;
            }
        }
        if (bl) {
            object3 = new PriorityQueue(20, Collections.reverseOrder(comparator));
            try {
                this.setLastChunk((Chunk)object5);
                object2 = this.meta.cursor("chunk.");
                while (((Cursor)object2).hasNext() && ((String)((Cursor)object2).next()).startsWith("chunk.")) {
                    object = Chunk.fromString((String)((Cursor)object2).getValue());
                    assert (((Chunk)object).version <= this.currentVersion);
                    this.chunks.putIfAbsent(((Chunk)object).id, (Chunk)object);
                    object3.offer(object);
                    if (object3.size() != 20) continue;
                    object3.poll();
                }
                while (bl && (object = (Chunk)object3.poll()) != null) {
                    bl = this.readChunkHeaderAndFooter(((Chunk)object).block, ((Chunk)object).id) != null;
                }
            }
            catch (IllegalStateException illegalStateException) {
                bl = false;
            }
        }
        if (!bl) {
            Object object6;
            boolean bl4 = false;
            if (!this.recoveryMode) {
                object2 = object4.values().toArray(new Chunk[0]);
                Arrays.sort(object2, comparator);
                object = new HashMap();
                object6 = object2;
                n = ((Object)object6).length;
                for (int i = 0; i < n; ++i) {
                    Object object7 = object6[i];
                    object.put(((Chunk)object7).id, object7);
                }
                bl4 = this.findLastChunkWithCompleteValidChunkSet((Chunk[])object2, (Map<Long, Chunk>)object4, (Map<Integer, Chunk>)object, false);
            }
            if (!bl4) {
                long l6 = l5;
                while ((object6 = this.discoverChunk(l6)) != null) {
                    l6 = ((Chunk)object6).block;
                    object4.put(l6, object6);
                }
                Chunk[] chunkArray = object4.values().toArray(new Chunk[0]);
                Arrays.sort(chunkArray, comparator);
                HashMap<Integer, Chunk> hashMap = new HashMap<Integer, Chunk>();
                for (Chunk chunk3 : chunkArray) {
                    hashMap.put(chunk3.id, chunk3);
                }
                this.findLastChunkWithCompleteValidChunkSet(chunkArray, (Map<Long, Chunk>)object4, hashMap, true);
            }
        }
        this.fileStore.clear();
        for (Chunk chunk5 : this.chunks.values()) {
            if (chunk5.isSaved()) {
                long l7 = chunk5.block * 4096L;
                n = chunk5.len * 4096;
                this.fileStore.markUsed(l7, n);
            }
            if (chunk5.isLive()) continue;
            this.deadChunks.offer(chunk5);
        }
        assert (this.validateFileLength("on open"));
        this.setWriteVersion(this.currentVersion);
        if (this.lastStoredVersion == -1L) {
            this.lastStoredVersion = this.currentVersion - 1L;
        }
    }

    private boolean findLastChunkWithCompleteValidChunkSet(Chunk[] chunkArray, Map<Long, Chunk> map, Map<Integer, Chunk> map2, boolean bl) {
        for (Chunk chunk : chunkArray) {
            boolean bl2 = true;
            try {
                this.setLastChunk(chunk);
                Cursor<String, String> cursor = this.meta.cursor("chunk.");
                while (cursor.hasNext() && cursor.next().startsWith("chunk.")) {
                    Chunk chunk2 = Chunk.fromString(cursor.getValue());
                    assert (chunk2.version <= this.currentVersion);
                    Chunk chunk3 = this.chunks.putIfAbsent(chunk2.id, chunk2);
                    if (chunk3 != null) {
                        chunk2 = chunk3;
                    }
                    assert (this.chunks.get(chunk2.id) == chunk2);
                    chunk3 = map.get(chunk2.block);
                    if (chunk3 == null || chunk3.id != chunk2.id) {
                        chunk3 = map2.get(chunk2.id);
                        if (chunk3 != null) {
                            chunk2.block = chunk3.block;
                        } else if (chunk2.isLive() && (bl || this.readChunkHeaderAndFooter(chunk2.block, chunk2.id) == null)) {
                            bl2 = false;
                            break;
                        }
                    }
                    if (chunk2.isLive()) continue;
                    chunk2.block = Long.MAX_VALUE;
                    chunk2.len = Integer.MAX_VALUE;
                    if (chunk2.unused == 0L) {
                        chunk2.unused = this.creationTime;
                    }
                    if (chunk2.unusedAtVersion != 0L) continue;
                    chunk2.unusedAtVersion = -1L;
                }
            }
            catch (Exception exception) {
                bl2 = false;
            }
            if (!bl2) continue;
            return true;
        }
        return false;
    }

    private void setLastChunk(Chunk chunk) {
        this.chunks.clear();
        this.lastChunk = chunk;
        if (chunk == null) {
            this.lastMapId.set(0);
            this.currentVersion = 0L;
            this.lastStoredVersion = -1L;
            this.meta.setRootPos(0L, -1L);
        } else {
            this.lastMapId.set(chunk.mapId);
            this.currentVersion = chunk.version;
            this.chunks.put(chunk.id, chunk);
            this.lastStoredVersion = this.currentVersion - 1L;
            this.meta.setRootPos(chunk.metaRootPos, this.lastStoredVersion);
        }
    }

    private Chunk discoverChunk(long l) {
        long l2 = Long.MAX_VALUE;
        Chunk chunk = null;
        while (l != l2) {
            if (l == 2L) {
                return null;
            }
            Chunk chunk2 = this.readChunkFooter(l);
            if (chunk2 != null) {
                l2 = Long.MAX_VALUE;
                chunk2 = this.readChunkHeaderOptionally(chunk2.block, chunk2.id);
                if (chunk2 != null) {
                    chunk = chunk2;
                    l2 = chunk2.block;
                }
            }
            if (--l <= l2 || this.readChunkHeaderOptionally(l) == null) continue;
            l2 = Long.MAX_VALUE;
        }
        return chunk;
    }

    private Chunk readChunkHeaderAndFooter(long l, int n) {
        Chunk chunk;
        Chunk chunk2 = this.readChunkHeaderOptionally(l, n);
        if (chunk2 != null && ((chunk = this.readChunkFooter(l + (long)chunk2.len)) == null || chunk.id != n || chunk.block != chunk2.block)) {
            return null;
        }
        return chunk2;
    }

    private Chunk readChunkFooter(long l) {
        try {
            long l2 = l * 4096L - 128L;
            if (l2 < 0L) {
                return null;
            }
            ByteBuffer byteBuffer = this.fileStore.readFully(l2, 128);
            byte[] byArray = new byte[128];
            byteBuffer.get(byArray);
            HashMap<String, String> hashMap = DataUtils.parseChecksummedMap(byArray);
            if (hashMap != null) {
                int n = DataUtils.readHexInt(hashMap, HDR_CHUNK, 0);
                Chunk chunk = new Chunk(n);
                chunk.version = DataUtils.readHexLong(hashMap, HDR_VERSION, 0L);
                chunk.block = DataUtils.readHexLong(hashMap, HDR_BLOCK, 0L);
                return chunk;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void writeStoreHeader() {
        StringBuilder stringBuilder = new StringBuilder(112);
        if (this.lastChunk != null) {
            this.storeHeader.put(HDR_BLOCK, this.lastChunk.block);
            this.storeHeader.put(HDR_CHUNK, this.lastChunk.id);
            this.storeHeader.put(HDR_VERSION, this.lastChunk.version);
        }
        DataUtils.appendMap(stringBuilder, this.storeHeader);
        byte[] byArray = stringBuilder.toString().getBytes(StandardCharsets.ISO_8859_1);
        int n = DataUtils.getFletcher32(byArray, 0, byArray.length);
        DataUtils.appendMap(stringBuilder, HDR_FLETCHER, n);
        stringBuilder.append('\n');
        byArray = stringBuilder.toString().getBytes(StandardCharsets.ISO_8859_1);
        ByteBuffer byteBuffer = ByteBuffer.allocate(8192);
        byteBuffer.put(byArray);
        byteBuffer.position(4096);
        byteBuffer.put(byArray);
        byteBuffer.rewind();
        this.write(0L, byteBuffer);
    }

    private void write(long l, ByteBuffer byteBuffer) {
        try {
            this.fileStore.writeFully(l, byteBuffer);
        }
        catch (IllegalStateException illegalStateException) {
            this.panic(illegalStateException);
        }
    }

    @Override
    public void close() {
        this.closeStore(true, 0L);
    }

    public void close(long l) {
        this.closeStore(true, l);
    }

    public void closeImmediately() {
        try {
            this.closeStore(false, 0L);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStore(boolean bl, long l) {
        while (!this.isClosed()) {
            this.stopBackgroundThread(bl);
            this.storeLock.lock();
            try {
                if (this.state != 0) continue;
                this.state = 1;
                try {
                    try {
                        if (bl && this.fileStore != null && !this.fileStore.isReadOnly()) {
                            for (MVMap<?, ?> mVMap : this.maps.values()) {
                                if (!mVMap.isClosed()) continue;
                                this.deregisterMapRoot(mVMap.getId());
                            }
                            this.setRetentionTime(0);
                            this.commit();
                            if (l > 0L) {
                                this.compactFile(l);
                            } else if (l < 0L) {
                                this.doMaintenance(this.autoCompactFillRate);
                            }
                            this.shrinkFileIfPossible(0);
                            this.storeHeader.put(HDR_CLEAN, 1);
                            this.writeStoreHeader();
                            this.sync();
                            assert (this.validateFileLength("on close"));
                        }
                        this.state = 2;
                        this.clearCaches();
                        for (MVMap<?, ?> mVMap : new ArrayList(this.maps.values())) {
                            mVMap.close();
                        }
                        this.chunks.clear();
                        this.maps.clear();
                    }
                    finally {
                        if (this.fileStore == null || this.fileStoreIsProvided) continue;
                        this.fileStore.close();
                    }
                }
                finally {
                    this.state = 3;
                }
            }
            finally {
                this.storeLock.unlock();
            }
        }
    }

    private Chunk getChunk(long l) {
        int n = DataUtils.getPageChunkId(l);
        Chunk chunk = this.chunks.get(n);
        if (chunk == null) {
            this.checkOpen();
            String string = this.meta.get(Chunk.getMetaKey(n));
            if (string == null) {
                throw DataUtils.newIllegalStateException(9, "Chunk {0} not found", n);
            }
            chunk = Chunk.fromString(string);
            if (!chunk.isSaved()) {
                throw DataUtils.newIllegalStateException(6, "Chunk {0} is invalid", n);
            }
            this.chunks.put(chunk.id, chunk);
        }
        return chunk;
    }

    private void setWriteVersion(long l) {
        Iterator<MVMap<?, ?>> iterator = this.maps.values().iterator();
        while (iterator.hasNext()) {
            MVMap<?, ?> mVMap = iterator.next();
            assert (mVMap != this.meta);
            if (mVMap.setWriteVersion(l) != null) continue;
            iterator.remove();
        }
        this.meta.setWriteVersion(l);
        this.onVersionChange(l);
    }

    public long tryCommit() {
        if ((!this.storeLock.isHeldByCurrentThread() || this.currentStoreVersion < 0L) && this.storeLock.tryLock()) {
            try {
                this.store();
            }
            finally {
                this.storeLock.unlock();
            }
        }
        return this.currentVersion;
    }

    public long commit() {
        if (!this.storeLock.isHeldByCurrentThread() || this.currentStoreVersion < 0L) {
            this.storeLock.lock();
            try {
                this.store();
            }
            finally {
                this.storeLock.unlock();
            }
        }
        return this.currentVersion;
    }

    private void store() {
        this.store(0L, this.reuseSpace ? 0L : this.getAfterLastBlock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(long l, long l2) {
        assert (this.storeLock.isHeldByCurrentThread());
        if (this.isOpenOrStopping() && this.hasUnsavedChanges()) {
            this.dropUnusedChunks();
            try {
                this.currentStoreVersion = this.currentVersion;
                if (this.fileStore == null) {
                    this.lastStoredVersion = this.currentVersion++;
                    this.setWriteVersion(this.currentVersion);
                    this.metaChanged = false;
                } else {
                    if (this.fileStore.isReadOnly()) {
                        throw DataUtils.newIllegalStateException(2, "This store is read-only", new Object[0]);
                    }
                    try {
                        this.storeNow(l, l2);
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.panic(illegalStateException);
                    }
                    catch (Throwable throwable) {
                        this.panic(DataUtils.newIllegalStateException(3, "{0}", throwable.toString(), throwable));
                    }
                }
            }
            finally {
                this.currentStoreVersion = -1L;
            }
        }
    }

    private void storeNow(long l, long l2) {
        boolean bl;
        Object object;
        Page page;
        Object object2;
        MVMap<?, ?> mVMap;
        Serializable serializable;
        Chunk chunk;
        int n;
        long l3 = this.getTimeSinceCreation();
        int n2 = this.unsavedMemory;
        long l4 = this.currentStoreVersion;
        long l5 = ++this.currentVersion;
        this.lastCommitTime = l3;
        if (this.lastChunk == null) {
            n = 0;
        } else {
            n = this.lastChunk.id;
            this.meta.put(Chunk.getMetaKey(n), this.lastChunk.asString());
            this.markMetaChanged();
            l3 = Math.max(this.lastChunk.time, l3);
        }
        int n3 = n;
        while ((chunk = this.chunks.get(n3 = n3 + 1 & 0x3FFFFFF)) != null) {
            if (chunk.isSaved()) continue;
            serializable = DataUtils.newIllegalStateException(3, "Last block {0} not stored, possibly due to out-of-memory", chunk);
            this.panic((IllegalStateException)serializable);
        }
        chunk = new Chunk(n3);
        chunk.pageCount = 0;
        chunk.pageCountLive = 0;
        chunk.maxLen = 0L;
        chunk.maxLenLive = 0L;
        chunk.metaRootPos = Long.MAX_VALUE;
        chunk.block = Long.MAX_VALUE;
        chunk.len = Integer.MAX_VALUE;
        chunk.time = l3;
        chunk.version = l5;
        chunk.next = Long.MAX_VALUE;
        chunk.occupancy = new BitSet();
        this.chunks.put(chunk.id, chunk);
        serializable = new ArrayList();
        Object object3 = this.maps.values().iterator();
        while (object3.hasNext()) {
            mVMap = object3.next();
            RootReference<?, ?> rootReference = mVMap.setWriteVersion(l5);
            if (rootReference == null) {
                object3.remove();
                continue;
            }
            if (mVMap.getCreateVersion() > l4 || mVMap.isVolatile() || !mVMap.hasChangesSince(this.lastStoredVersion)) continue;
            assert (rootReference.version <= l5) : rootReference.version + " > " + l5;
            object2 = rootReference.root;
            if (((Page)object2).isSaved() && !((Page)object2).isLeaf()) continue;
            ((ArrayList)serializable).add(object2);
        }
        object3 = new ArrayList();
        mVMap = this.getWriteBuffer();
        chunk.writeChunkHeader((WriteBuffer)((Object)mVMap), 0);
        int n4 = ((WriteBuffer)((Object)mVMap)).position() + 44;
        ((WriteBuffer)((Object)mVMap)).position(n4);
        object2 = ((ArrayList)serializable).iterator();
        while (object2.hasNext()) {
            page = (Page)object2.next();
            object = MVMap.getMapRootKey(page.getMapId());
            if (page.getTotalCount() == 0L) {
                this.meta.remove(object);
                continue;
            }
            page.writeUnsavedRecursive(chunk, (WriteBuffer)((Object)mVMap), (List<Long>)object3);
            long l6 = page.getPos();
            this.meta.put((String)object, Long.toHexString(l6));
        }
        this.acceptChunkOccupancyChanges(l3, l5);
        object2 = this.meta.setWriteVersion(l5);
        assert (object2 != null);
        assert (((RootReference)object2).version == l5) : ((RootReference)object2).version + " != " + l5;
        this.metaChanged = false;
        this.acceptChunkOccupancyChanges(l3, l5);
        this.onVersionChange(l5);
        page = ((RootReference)object2).root;
        page.writeUnsavedRecursive(chunk, (WriteBuffer)((Object)mVMap), (List<Long>)object3);
        chunk.mapId = this.lastMapId.get();
        chunk.tocPos = ((WriteBuffer)((Object)mVMap)).position();
        object = new long[object3.size()];
        int n5 = 0;
        Iterator iterator = object3.iterator();
        while (iterator.hasNext()) {
            long l7 = (Long)iterator.next();
            object[n5++] = l7;
            ((WriteBuffer)((Object)mVMap)).putLong(l7);
            if (DataUtils.isLeafPosition(l7)) {
                ++this.leafCount;
                continue;
            }
            ++this.nonLeafCount;
        }
        this.chunksToC.put(chunk.id, (long[])object);
        int n6 = ((WriteBuffer)((Object)mVMap)).position();
        int n7 = MathUtils.roundUpInt(n6 + 128, 4096);
        ((WriteBuffer)((Object)mVMap)).limit(n7);
        long l8 = this.fileStore.allocate(n7, l, l2);
        chunk.block = l8 / 4096L;
        chunk.len = n7 / 4096;
        assert (this.validateFileLength(chunk.asString()));
        chunk.metaRootPos = page.getPos();
        chunk.next = l > 0L || l2 == l ? this.fileStore.predictAllocation(chunk.len, 0L, 0L) : 0L;
        assert (chunk.pageCountLive == chunk.pageCount) : chunk;
        assert (chunk.occupancy.cardinality() == 0) : chunk;
        ((WriteBuffer)((Object)mVMap)).position(0);
        chunk.writeChunkHeader((WriteBuffer)((Object)mVMap), n4);
        ((WriteBuffer)((Object)mVMap)).position(((WriteBuffer)((Object)mVMap)).limit() - 128);
        ((WriteBuffer)((Object)mVMap)).put(chunk.getFooterBytes());
        ((WriteBuffer)((Object)mVMap)).position(0);
        this.write(l8, ((WriteBuffer)((Object)mVMap)).getBuffer());
        this.releaseWriteBuffer((WriteBuffer)((Object)mVMap));
        boolean bl2 = false;
        boolean bl3 = bl = l8 + (long)n7 >= this.fileStore.size();
        if (!bl) {
            if (this.lastChunk == null) {
                bl2 = true;
            } else if (this.lastChunk.next != chunk.block) {
                bl2 = true;
            } else {
                long l9 = DataUtils.readHexLong(this.storeHeader, HDR_VERSION, 0L);
                if (this.lastChunk.version - l9 > 20L) {
                    bl2 = true;
                } else {
                    int n8 = DataUtils.readHexInt(this.storeHeader, HDR_CHUNK, 0);
                    while (true) {
                        Chunk chunk2;
                        if ((chunk2 = this.chunks.get(n8)) == null) {
                            bl2 = true;
                            break;
                        }
                        if (n8 == this.lastChunk.id) break;
                        ++n8;
                    }
                }
            }
        }
        if (this.storeHeader.remove(HDR_CLEAN) != null) {
            bl2 = true;
        }
        this.lastChunk = chunk;
        if (bl2) {
            this.writeStoreHeader();
        }
        if (!bl) {
            this.shrinkFileIfPossible(1);
        }
        Iterator iterator2 = ((ArrayList)serializable).iterator();
        while (iterator2.hasNext()) {
            Page page2 = (Page)iterator2.next();
            page2.writeEnd();
        }
        page.writeEnd();
        this.saveNeeded = false;
        this.unsavedMemory = Math.max(0, this.unsavedMemory - n2);
        this.lastStoredVersion = l4;
    }

    private WriteBuffer getWriteBuffer() {
        WriteBuffer writeBuffer;
        if (this.writeBuffer != null) {
            writeBuffer = this.writeBuffer;
            writeBuffer.clear();
        } else {
            writeBuffer = new WriteBuffer();
        }
        return writeBuffer;
    }

    private void releaseWriteBuffer(WriteBuffer writeBuffer) {
        if (writeBuffer.capacity() <= 0x400000) {
            this.writeBuffer = writeBuffer;
        }
    }

    private static boolean canOverwriteChunk(Chunk chunk, long l) {
        return !chunk.isLive() && chunk.unusedAtVersion < l;
    }

    private boolean isSeasonedChunk(Chunk chunk, long l) {
        return this.retentionTime < 0 || chunk.time + (long)this.retentionTime <= l;
    }

    private long getTimeSinceCreation() {
        return Math.max(0L, this.getTimeAbsolute() - this.creationTime);
    }

    private long getTimeAbsolute() {
        long l = System.currentTimeMillis();
        if (this.lastTimeAbsolute != 0L && l < this.lastTimeAbsolute) {
            l = this.lastTimeAbsolute;
        } else {
            this.lastTimeAbsolute = l;
        }
        return l;
    }

    private void acceptChunkOccupancyChanges(long l, long l2) {
        HashSet<Chunk> hashSet = new HashSet<Chunk>();
        while (true) {
            RemovedPageInfo removedPageInfo;
            if ((removedPageInfo = this.removedPages.peek()) != null && removedPageInfo.version < l2) {
                removedPageInfo = this.removedPages.poll();
                assert (removedPageInfo != null);
                assert (removedPageInfo.version < l2) : removedPageInfo + " < " + l2;
                int n = removedPageInfo.getPageChunkId();
                Chunk chunk = this.chunks.get(n);
                assert (chunk != null);
                hashSet.add(chunk);
                if (!chunk.accountForRemovedPage(removedPageInfo.getPageNo(), removedPageInfo.getPageLength(), removedPageInfo.isPinned(), l, removedPageInfo.version)) continue;
                this.deadChunks.offer(chunk);
                continue;
            }
            if (hashSet.isEmpty()) {
                return;
            }
            for (Chunk chunk : hashSet) {
                int n = chunk.id;
                this.meta.put(Chunk.getMetaKey(n), chunk.asString());
            }
            this.markMetaChanged();
            hashSet.clear();
        }
    }

    private void shrinkFileIfPossible(int n) {
        long l;
        if (this.fileStore.isReadOnly()) {
            return;
        }
        long l2 = this.getFileLengthInUse();
        if (l2 >= (l = this.fileStore.size())) {
            return;
        }
        if (n > 0 && l - l2 < 4096L) {
            return;
        }
        int n2 = (int)(100L - l2 * 100L / l);
        if (n2 < n) {
            return;
        }
        if (this.isOpenOrStopping()) {
            this.sync();
        }
        this.fileStore.truncate(l2);
    }

    private long getFileLengthInUse() {
        long l = this.fileStore.getFileLengthInUse();
        assert (l == this.measureFileLengthInUse()) : l + " != " + this.measureFileLengthInUse();
        return l;
    }

    private long getAfterLastBlock() {
        return this.fileStore.getAfterLastBlock();
    }

    private long measureFileLengthInUse() {
        long l = 2L;
        for (Chunk chunk : this.chunks.values()) {
            if (!chunk.isSaved()) continue;
            l = Math.max(l, chunk.block + (long)chunk.len);
        }
        return l * 4096L;
    }

    public boolean hasUnsavedChanges() {
        if (this.metaChanged) {
            return true;
        }
        for (MVMap<?, ?> mVMap : this.maps.values()) {
            if (mVMap.isClosed() || !mVMap.hasChangesSince(this.lastStoredVersion)) continue;
            return true;
        }
        return false;
    }

    private Chunk readChunkHeader(long l) {
        long l2 = l * 4096L;
        ByteBuffer byteBuffer = this.fileStore.readFully(l2, 1024);
        return Chunk.readChunkHeader(byteBuffer, l2);
    }

    private Chunk readChunkHeaderOptionally(long l) {
        try {
            Chunk chunk = this.readChunkHeader(l);
            return chunk.block != l ? null : chunk;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Chunk readChunkHeaderOptionally(long l, int n) {
        Chunk chunk = this.readChunkHeaderOptionally(l);
        return chunk == null || chunk.id != n ? null : chunk;
    }

    public void compactMoveChunks() {
        this.compactMoveChunks(100, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compactMoveChunks(int n, long l) {
        block7: {
            this.storeLock.lock();
            try {
                this.checkOpen();
                if (this.lastChunk == null || !this.reuseSpace) break block7;
                int n2 = this.retentionTime;
                boolean bl = this.reuseSpace;
                try {
                    this.retentionTime = -1;
                    if (this.getFillRate() <= n) {
                        this.compactMoveChunks(l);
                    }
                }
                finally {
                    this.reuseSpace = bl;
                    this.retentionTime = n2;
                }
            }
            finally {
                this.storeLock.unlock();
            }
        }
    }

    private boolean compactMoveChunks(long l) {
        this.dropUnusedChunks();
        long l2 = this.fileStore.getFirstFree() / 4096L;
        Iterable<Chunk> iterable = this.findChunksToMove(l2, l);
        if (iterable == null) {
            return false;
        }
        this.compactMoveChunks(iterable);
        return true;
    }

    private Iterable<Chunk> findChunksToMove(long l, long l2) {
        long l3 = l2 / 4096L;
        ArrayList arrayList = null;
        if (l3 > 0L) {
            PriorityQueue<Chunk> priorityQueue = new PriorityQueue<Chunk>(this.chunks.size() / 2 + 1, (chunk, chunk2) -> {
                int n = Integer.compare(chunk2.collectPriority, chunk.collectPriority);
                if (n != 0) {
                    return n;
                }
                return Long.signum(chunk2.block - chunk.block);
            });
            long l4 = 0L;
            for (Chunk chunk3 : this.chunks.values()) {
                Chunk chunk4;
                if (!chunk3.isSaved() || chunk3.block <= l) continue;
                chunk3.collectPriority = this.getMovePriority(chunk3);
                priorityQueue.offer(chunk3);
                l4 += (long)chunk3.len;
                while (l4 > l3 && (chunk4 = (Chunk)priorityQueue.poll()) != null) {
                    l4 -= (long)chunk4.len;
                }
            }
            if (!priorityQueue.isEmpty()) {
                ArrayList arrayList2 = new ArrayList(priorityQueue);
                arrayList2.sort(Chunk.PositionComparator.INSTANCE);
                arrayList = arrayList2;
            }
        }
        return arrayList;
    }

    private int getMovePriority(Chunk chunk) {
        return this.fileStore.getMovePriority((int)chunk.block);
    }

    private void compactMoveChunks(Iterable<Chunk> iterable) {
        assert (this.storeLock.isHeldByCurrentThread());
        if (iterable != null) {
            assert (this.lastChunk != null);
            this.writeStoreHeader();
            this.sync();
            Iterator<Chunk> iterator = iterable.iterator();
            assert (iterator.hasNext());
            long l = iterator.next().block;
            long l2 = this.getAfterLastBlock();
            for (Chunk chunk : iterable) {
                this.moveChunk(chunk, l, l2);
            }
            this.store(l, l2);
            this.sync();
            Chunk chunk = this.lastChunk;
            long l3 = this.getAfterLastBlock();
            boolean bl = chunk.block < l;
            boolean bl2 = !bl;
            for (Chunk chunk2 : iterable) {
                if (chunk2.block < l2 || !this.moveChunk(chunk2, l2, l3)) continue;
                assert (chunk2.block < l2);
                bl2 = true;
            }
            assert (l3 >= this.getAfterLastBlock());
            if (bl2) {
                boolean bl3 = this.moveChunkInside(chunk, l2);
                this.store(l2, l3);
                this.sync();
                long l4 = bl3 || bl ? l3 : chunk.block;
                boolean bl4 = bl3 = !bl3 && this.moveChunkInside(chunk, l4);
                if (this.moveChunkInside(this.lastChunk, l4) || bl3) {
                    this.store(l4, -1L);
                }
            }
            this.shrinkFileIfPossible(0);
            this.sync();
        }
    }

    private boolean moveChunkInside(Chunk chunk, long l) {
        boolean bl;
        boolean bl2 = bl = chunk.block >= l && this.fileStore.predictAllocation(chunk.len, l, -1L) < l && this.moveChunk(chunk, l, -1L);
        assert (!bl || chunk.block + (long)chunk.len <= l);
        return bl;
    }

    private boolean moveChunk(Chunk chunk, long l, long l2) {
        if (!this.chunks.containsKey(chunk.id)) {
            return false;
        }
        WriteBuffer writeBuffer = this.getWriteBuffer();
        long l3 = chunk.block * 4096L;
        int n = chunk.len * 4096;
        writeBuffer.limit(n);
        ByteBuffer byteBuffer = this.fileStore.readFully(l3, n);
        Chunk chunk2 = Chunk.readChunkHeader(byteBuffer, l3);
        int n2 = byteBuffer.position();
        writeBuffer.position(n2);
        writeBuffer.put(byteBuffer);
        long l4 = this.fileStore.allocate(n, l, l2);
        long l5 = l4 / 4096L;
        assert (l2 > 0L || l5 <= chunk.block) : l5 + " " + chunk;
        writeBuffer.position(0);
        chunk2.block = l5;
        chunk2.next = 0L;
        chunk2.writeChunkHeader(writeBuffer, n2);
        writeBuffer.position(n - 128);
        writeBuffer.put(chunk2.getFooterBytes());
        writeBuffer.position(0);
        this.write(l4, writeBuffer.getBuffer());
        this.releaseWriteBuffer(writeBuffer);
        this.fileStore.free(l3, n);
        chunk.block = l5;
        chunk.next = 0L;
        this.meta.put(Chunk.getMetaKey(chunk.id), chunk.asString());
        this.markMetaChanged();
        return true;
    }

    public void sync() {
        this.checkOpen();
        FileStore fileStore = this.fileStore;
        if (fileStore != null) {
            fileStore.sync();
        }
    }

    public void compactFile(long l) {
        this.setRetentionTime(0);
        long l2 = System.nanoTime();
        while (this.compact(95, 0x1000000)) {
            this.sync();
            this.compactMoveChunks(95, 0x1000000L);
            long l3 = System.nanoTime() - l2;
            if (l3 <= TimeUnit.MILLISECONDS.toNanos(l)) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compact(int n, int n2) {
        block7: {
            if (this.reuseSpace && this.lastChunk != null) {
                this.checkOpen();
                if (n > 0 && this.getChunksFillRate() < n) {
                    if (!this.storeLock.tryLock(10L, TimeUnit.MILLISECONDS)) break block7;
                    try {
                        boolean bl = this.rewriteChunks(n2, 100);
                        this.storeLock.unlock();
                        return bl;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.storeLock.unlock();
                            throw throwable;
                        }
                        catch (InterruptedException interruptedException) {
                            throw new RuntimeException(interruptedException);
                        }
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rewriteChunks(int n, int n2) {
        TxCounter txCounter = this.registerVersionUsage();
        try {
            Iterable<Chunk> iterable = this.findOldChunks(n, n2);
            if (iterable != null) {
                HashSet<Integer> hashSet = MVStore.createIdSet(iterable);
                boolean bl = !hashSet.isEmpty() && this.compactRewrite(hashSet) > 0;
                return bl;
            }
        }
        finally {
            this.deregisterVersionUsage(txCounter);
        }
        return false;
    }

    public int getChunksFillRate() {
        return this.getChunksFillRate(true);
    }

    public int getRewritableChunksFillRate() {
        return this.getChunksFillRate(false);
    }

    private int getChunksFillRate(boolean bl) {
        long l = 1L;
        long l2 = 1L;
        long l3 = this.getTimeSinceCreation();
        for (Chunk chunk : this.chunks.values()) {
            if (!bl && !this.isRewritable(chunk, l3)) continue;
            assert (chunk.maxLen >= 0L);
            l += chunk.maxLen;
            l2 += chunk.maxLenLive;
        }
        int n = (int)(100L * l2 / l);
        return n;
    }

    public int getChunkCount() {
        return this.chunks.size();
    }

    public int getPageCount() {
        int n = 0;
        for (Chunk chunk : this.chunks.values()) {
            n += chunk.pageCount;
        }
        return n;
    }

    public int getLivePageCount() {
        int n = 0;
        for (Chunk chunk : this.chunks.values()) {
            n += chunk.pageCountLive;
        }
        return n;
    }

    private int getProjectedFillRate(int n) {
        int n2 = 0;
        long l = 1L;
        long l2 = 1L;
        long l3 = this.getTimeSinceCreation();
        for (Chunk chunk : this.chunks.values()) {
            assert (chunk.maxLen >= 0L);
            if (!this.isRewritable(chunk, l3) || chunk.getFillRate() > n) continue;
            assert (chunk.maxLen >= chunk.maxLenLive);
            n2 += chunk.len;
            l += chunk.maxLen;
            l2 += chunk.maxLenLive;
        }
        int n3 = (int)((long)n2 * l2 / l);
        int n4 = this.fileStore.getProjectedFillRate(n2 - n3);
        return n4;
    }

    public int getFillRate() {
        return this.fileStore.getFillRate();
    }

    private Iterable<Chunk> findOldChunks(int n, int n2) {
        assert (this.lastChunk != null);
        long l = this.getTimeSinceCreation();
        PriorityQueue<Chunk> priorityQueue = new PriorityQueue<Chunk>(this.chunks.size() / 4 + 1, (chunk, chunk2) -> {
            int n = Integer.compare(chunk2.collectPriority, chunk.collectPriority);
            if (n == 0) {
                n = Long.compare(chunk2.maxLenLive, chunk.maxLenLive);
            }
            return n;
        });
        long l2 = 0L;
        long l3 = this.lastChunk.version + 1L;
        for (Chunk chunk3 : this.chunks.values()) {
            Chunk chunk4;
            int n3 = chunk3.getFillRate();
            if (!this.isRewritable(chunk3, l) || n3 > n2) continue;
            long l4 = l3 - chunk3.version;
            chunk3.collectPriority = (int)((long)(n3 * 1000) / l4);
            l2 += chunk3.maxLenLive;
            priorityQueue.offer(chunk3);
            while (l2 > (long)n && (chunk4 = priorityQueue.poll()) != null) {
                l2 -= chunk4.maxLenLive;
            }
        }
        return priorityQueue.isEmpty() ? null : priorityQueue;
    }

    private boolean isRewritable(Chunk chunk, long l) {
        return chunk.isRewritable() && this.isSeasonedChunk(chunk, l);
    }

    private int compactRewrite(Set<Integer> set) {
        assert (this.storeLock.isHeldByCurrentThread());
        assert (this.currentStoreVersion < 0L);
        this.acceptChunkOccupancyChanges(this.getTimeSinceCreation(), this.currentVersion + 1L);
        int n = this.rewriteChunks(set, false);
        this.acceptChunkOccupancyChanges(this.getTimeSinceCreation(), this.currentVersion + 1L);
        return n += this.rewriteChunks(set, true);
    }

    private int rewriteChunks(Set<Integer> set, boolean bl) {
        int n = 0;
        for (int n2 : set) {
            Chunk chunk = this.chunks.get(n2);
            long[] lArray = this.getToC(chunk);
            if (lArray == null) continue;
            int n3 = 0;
            while ((n3 = chunk.occupancy.nextClearBit(n3)) < chunk.pageCount) {
                MVMap<String, String> mVMap;
                long l = lArray[n3];
                int n4 = DataUtils.getPageMapId(l);
                MVMap<String, String> mVMap2 = mVMap = n4 == 0 ? this.meta : this.getMap(n4);
                if (mVMap != null && !mVMap.isClosed()) {
                    long l2;
                    assert (!mVMap.isSingleWriter());
                    if ((bl || DataUtils.isLeafPosition(l)) && mVMap.rewritePage(l2 = DataUtils.getPagePos(n2, l))) {
                        ++n;
                        if (mVMap == this.meta) {
                            this.markMetaChanged();
                        }
                    }
                }
                ++n3;
            }
        }
        return n;
    }

    private static HashSet<Integer> createIdSet(Iterable<Chunk> iterable) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (Chunk chunk : iterable) {
            hashSet.add(chunk.id);
        }
        return hashSet;
    }

    <K, V> Page<K, V> readPage(MVMap<K, V> mVMap, long l) {
        try {
            if (!DataUtils.isPageSaved(l)) {
                throw DataUtils.newIllegalStateException(6, "Position 0", new Object[0]);
            }
            Page<K, V> page = this.readPageFromCache(l);
            if (page == null) {
                try {
                    Chunk chunk = this.getChunk(l);
                    int n = DataUtils.getPageOffset(l);
                    ByteBuffer byteBuffer = chunk.readBufferForPage(this.fileStore, n, l);
                    page = Page.read(byteBuffer, l, mVMap);
                    if (page.pageNo < 0) {
                        page.pageNo = this.calculatePageNo(l);
                    }
                }
                catch (Exception exception) {
                    throw DataUtils.newIllegalStateException(6, "Unable to read the page at position {0}", l, exception);
                }
                this.cachePage(page);
            }
            return page;
        }
        catch (IllegalStateException illegalStateException) {
            if (this.recoveryMode) {
                return mVMap.createEmptyLeaf();
            }
            throw illegalStateException;
        }
    }

    private long[] getToC(Chunk chunk) {
        if (chunk.tocPos == 0) {
            return null;
        }
        long[] lArray = this.chunksToC.get(chunk.id);
        if (lArray == null) {
            lArray = chunk.readToC(this.fileStore);
            assert (lArray != null);
            this.chunksToC.put(chunk.id, lArray, lArray.length * 8);
        }
        return lArray;
    }

    private <K, V> Page<K, V> readPageFromCache(long l) {
        return this.cache == null ? null : this.cache.get(l);
    }

    void accountForRemovedPage(long l, long l2, boolean bl, int n) {
        assert (DataUtils.isPageSaved(l));
        if (n < 0) {
            n = this.calculatePageNo(l);
        }
        RemovedPageInfo removedPageInfo = new RemovedPageInfo(l, bl, l2, n);
        this.removedPages.add(removedPageInfo);
    }

    private int calculatePageNo(long l) {
        int n = -1;
        Chunk chunk = this.getChunk(l);
        long[] lArray = this.getToC(chunk);
        if (lArray != null) {
            int n2 = DataUtils.getPageOffset(l);
            int n3 = 0;
            int n4 = lArray.length - 1;
            while (n3 <= n4) {
                int n5 = n3 + n4 >>> 1;
                long l2 = DataUtils.getPageOffset(lArray[n5]);
                if (l2 < (long)n2) {
                    n3 = n5 + 1;
                    continue;
                }
                if (l2 > (long)n2) {
                    n4 = n5 - 1;
                    continue;
                }
                n = n5;
                break;
            }
        }
        return n;
    }

    Compressor getCompressorFast() {
        if (this.compressorFast == null) {
            this.compressorFast = new CompressLZF();
        }
        return this.compressorFast;
    }

    Compressor getCompressorHigh() {
        if (this.compressorHigh == null) {
            this.compressorHigh = new CompressDeflate();
        }
        return this.compressorHigh;
    }

    int getCompressionLevel() {
        return this.compressionLevel;
    }

    public int getPageSplitSize() {
        return this.pageSplitSize;
    }

    public int getKeysPerPage() {
        return this.keysPerPage;
    }

    public long getMaxPageSize() {
        return this.cache == null ? Long.MAX_VALUE : this.cache.getMaxItemSize() >> 4;
    }

    public boolean getReuseSpace() {
        return this.reuseSpace;
    }

    public void setReuseSpace(boolean bl) {
        this.reuseSpace = bl;
    }

    public int getRetentionTime() {
        return this.retentionTime;
    }

    public void setRetentionTime(int n) {
        this.retentionTime = n;
    }

    public void setVersionsToKeep(int n) {
        this.versionsToKeep = n;
    }

    public long getVersionsToKeep() {
        return this.versionsToKeep;
    }

    long getOldestVersionToKeep() {
        long l;
        long l2 = this.oldestVersionToKeep.get();
        l2 = Math.max(l2 - (long)this.versionsToKeep, -1L);
        if (this.fileStore != null && (l = this.lastStoredVersion) != -1L && l < l2) {
            l2 = l;
        }
        return l2;
    }

    private void setOldestVersionToKeep(long l) {
        long l2;
        boolean bl;
        while (!(bl = l <= (l2 = this.oldestVersionToKeep.get()) || this.oldestVersionToKeep.compareAndSet(l2, l))) {
        }
    }

    private boolean isKnownVersion(long l) {
        if (l > this.currentVersion || l < 0L) {
            return false;
        }
        if (l == this.currentVersion || this.chunks.isEmpty()) {
            return true;
        }
        Chunk chunk = this.getChunkForVersion(l);
        if (chunk == null) {
            return false;
        }
        MVMap<String, String> mVMap = this.getMetaMap(l);
        try {
            String string;
            Iterator<String> iterator = mVMap.keyIterator("chunk.");
            while (iterator.hasNext() && (string = iterator.next()).startsWith("chunk.")) {
                if (this.meta.containsKey(string)) continue;
                String string2 = mVMap.get(string);
                Chunk chunk2 = Chunk.fromString(string2);
                Chunk chunk3 = this.readChunkHeaderAndFooter(chunk2.block, chunk2.id);
                if (chunk3 != null) continue;
                return false;
            }
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
        return true;
    }

    public void registerUnsavedMemory(int n) {
        this.unsavedMemory += n;
        int n2 = this.unsavedMemory;
        if (n2 > this.autoCommitMemory && this.autoCommitMemory > 0) {
            this.saveNeeded = true;
        }
    }

    boolean isSaveNeeded() {
        return this.saveNeeded;
    }

    void beforeWrite(MVMap<?, ?> mVMap) {
        if (this.saveNeeded && this.fileStore != null && this.isOpenOrStopping() && (this.storeLock.isHeldByCurrentThread() || !mVMap.getRoot().isLockedByCurrentThread()) && mVMap != this.meta) {
            this.saveNeeded = false;
            if (this.unsavedMemory > this.autoCommitMemory && this.autoCommitMemory > 0) {
                if (3 * this.unsavedMemory > 4 * this.autoCommitMemory && !mVMap.isSingleWriter()) {
                    this.commit();
                } else {
                    this.tryCommit();
                }
            }
        }
    }

    public int getStoreVersion() {
        this.checkOpen();
        String string = this.meta.get("setting.storeVersion");
        return string == null ? 0 : DataUtils.parseHexInt(string);
    }

    public void setStoreVersion(int n) {
        this.storeLock.lock();
        try {
            this.checkOpen();
            this.markMetaChanged();
            this.meta.put("setting.storeVersion", Integer.toHexString(n));
        }
        finally {
            this.storeLock.unlock();
        }
    }

    public void rollback() {
        this.rollbackTo(this.currentVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackTo(long l) {
        this.storeLock.lock();
        try {
            TxCounter txCounter;
            this.checkOpen();
            if (l == 0L) {
                this.meta.setInitialRoot(this.meta.createEmptyLeaf(), -1L);
                this.deadChunks.clear();
                this.removedPages.clear();
                this.chunks.clear();
                this.clearCaches();
                if (this.fileStore != null) {
                    this.fileStore.clear();
                }
                this.lastChunk = null;
                this.versions.clear();
                this.currentVersion = l;
                this.setWriteVersion(l);
                this.metaChanged = false;
                this.lastStoredVersion = -1L;
                for (MVMap<?, ?> mVMap : this.maps.values()) {
                    mVMap.close();
                }
                return;
            }
            DataUtils.checkArgument(this.isKnownVersion(l), "Unknown version {0}", l);
            while ((txCounter = this.versions.peekLast()) != null && txCounter.version >= l) {
                this.versions.removeLast();
            }
            this.currentTxCounter = new TxCounter(l);
            this.meta.rollbackTo(l);
            this.metaChanged = false;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            Chunk chunk = null;
            for (Chunk object : this.chunks.values()) {
                if (object.version > l) {
                    arrayList.add(object.id);
                    continue;
                }
                if (chunk != null && chunk.version >= object.version) continue;
                chunk = object;
            }
            if (!arrayList.isEmpty()) {
                arrayList.sort(Collections.reverseOrder());
                Iterator<Object> iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    int n = (Integer)((Object)iterator.next());
                    Chunk chunk2 = this.chunks.remove(n);
                    if (chunk2 == null) continue;
                    long l2 = chunk2.block * 4096L;
                    int n2 = chunk2.len * 4096;
                    this.freeFileSpace(l2, n2);
                    WriteBuffer writeBuffer = this.getWriteBuffer();
                    writeBuffer.limit(n2);
                    Arrays.fill(writeBuffer.getBuffer().array(), (byte)0);
                    this.write(l2, writeBuffer.getBuffer());
                    this.releaseWriteBuffer(writeBuffer);
                    this.sync();
                }
                this.lastChunk = chunk;
                this.writeStoreHeader();
                this.readStoreHeader();
            }
            this.deadChunks.clear();
            this.removedPages.clear();
            this.clearCaches();
            this.currentVersion = l;
            if (this.lastStoredVersion == -1L) {
                this.lastStoredVersion = this.currentVersion - 1L;
            }
            for (MVMap mVMap : new ArrayList(this.maps.values())) {
                int n = mVMap.getId();
                if (mVMap.getCreateVersion() >= l) {
                    mVMap.close();
                    this.maps.remove(n);
                    continue;
                }
                if (mVMap.rollbackRoot(l)) continue;
                mVMap.setRootPos(MVStore.getRootPos(this.meta, n), l);
            }
        }
        finally {
            this.storeLock.unlock();
        }
    }

    private void clearCaches() {
        if (this.cache != null) {
            this.cache.clear();
        }
        if (this.chunksToC != null) {
            this.chunksToC.clear();
        }
    }

    private static long getRootPos(MVMap<String, String> mVMap, int n) {
        String string = mVMap.get(MVMap.getMapRootKey(n));
        return string == null ? 0L : DataUtils.parseHexLong(string);
    }

    public long getCurrentVersion() {
        return this.currentVersion;
    }

    public FileStore getFileStore() {
        return this.fileStore;
    }

    public Map<String, Object> getStoreHeader() {
        return this.storeHeader;
    }

    private void checkOpen() {
        if (!this.isOpenOrStopping()) {
            throw DataUtils.newIllegalStateException(4, "This store is closed", this.panicException);
        }
    }

    public void renameMap(MVMap<?, ?> mVMap, String string) {
        this.checkOpen();
        DataUtils.checkArgument(mVMap != this.meta, "Renaming the meta map is not allowed", new Object[0]);
        int n = mVMap.getId();
        String string2 = this.getMapName(n);
        if (string2 != null && !string2.equals(string)) {
            String string3 = Integer.toHexString(n);
            String string4 = this.meta.putIfAbsent("name." + string, string3);
            DataUtils.checkArgument(string4 == null || string4.equals(string3), "A map named {0} already exists", string);
            this.meta.put(MVMap.getMapKey(n), mVMap.asString(string));
            this.meta.remove("name." + string2);
            this.markMetaChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMap(MVMap<?, ?> mVMap) {
        this.storeLock.lock();
        try {
            this.checkOpen();
            DataUtils.checkArgument(mVMap != this.meta, "Removing the meta map is not allowed", new Object[0]);
            RootReference<?, ?> rootReference = mVMap.clearIt();
            mVMap.close();
            this.updateCounter += rootReference.updateCounter;
            this.updateAttemptCounter += rootReference.updateAttemptCounter;
            int n = mVMap.getId();
            String string = this.getMapName(n);
            if (this.meta.remove(MVMap.getMapKey(n)) != null) {
                this.markMetaChanged();
            }
            if (this.meta.remove("name." + string) != null) {
                this.markMetaChanged();
            }
        }
        finally {
            this.storeLock.unlock();
        }
    }

    void deregisterMapRoot(int n) {
        if (this.meta.remove(MVMap.getMapRootKey(n)) != null) {
            this.markMetaChanged();
        }
    }

    public void removeMap(String string) {
        int n = this.getMapId(string);
        if (n > 0) {
            MVMap mVMap = this.getMap(n);
            if (mVMap == null) {
                mVMap = this.openMap(string, MVStoreTool.getGenericMapBuilder());
            }
            this.removeMap(mVMap);
        }
    }

    public String getMapName(int n) {
        this.checkOpen();
        String string = this.meta.get(MVMap.getMapKey(n));
        return string == null ? null : DataUtils.getMapName(string);
    }

    private int getMapId(String string) {
        String string2 = this.meta.get("name." + string);
        return string2 == null ? -1 : DataUtils.parseHexInt(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeInBackground() {
        block21: {
            try {
                if (!this.isOpenOrStopping() || this.isReadOnly()) {
                    return;
                }
                long l = this.getTimeSinceCreation();
                if (l > this.lastCommitTime + (long)this.autoCommitDelay) {
                    this.tryCommit();
                    if (this.autoCompactFillRate < 0) {
                        this.compact(-this.getTargetFillRate(), this.autoCommitMemory);
                    }
                }
                int n = this.getFillRate();
                if (this.fileStore.isFragmented() && n < this.autoCompactFillRate) {
                    if (this.storeLock.tryLock(10L, TimeUnit.MILLISECONDS)) {
                        try {
                            int n2 = this.autoCommitMemory;
                            if (this.isIdle()) {
                                n2 *= 4;
                            }
                            this.compactMoveChunks(n2);
                        }
                        finally {
                            this.storeLock.unlock();
                        }
                    }
                } else if (n >= this.autoCompactFillRate && this.lastChunk != null) {
                    int n3 = this.getRewritableChunksFillRate();
                    int n4 = n3 = this.isIdle() ? 100 - (100 - n3) / 2 : n3;
                    if (n3 < this.getTargetFillRate() && this.storeLock.tryLock(10L, TimeUnit.MILLISECONDS)) {
                        try {
                            int n5 = this.autoCommitMemory * n / Math.max(n3, 1);
                            if (!this.isIdle()) {
                                n5 /= 4;
                            }
                            if (this.rewriteChunks(n5, n3)) {
                                this.dropUnusedChunks();
                            }
                        }
                        finally {
                            this.storeLock.unlock();
                        }
                    }
                }
                this.autoCompactLastFileOpCount = this.fileStore.getWriteCount() + this.fileStore.getReadCount();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
                if (this.backgroundExceptionHandler != null) break block21;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMaintenance(int n) {
        if (this.autoCompactFillRate > 0 && this.lastChunk != null && this.reuseSpace) {
            try {
                int n2 = -1;
                for (int i = 0; i < 5; ++i) {
                    int n3;
                    int n4 = n3 = this.getFillRate();
                    if (n3 > n && ((n4 = this.getProjectedFillRate(100)) > n || n4 <= n2)) break;
                    n2 = n4;
                    if (!this.storeLock.tryLock(10L, TimeUnit.MILLISECONDS)) break;
                    try {
                        int n5 = this.autoCommitMemory * n / Math.max(n4, 1);
                        if ((n4 >= n3 || this.rewriteChunks(n5, n) && this.dropUnusedChunks() != 0 || i <= 0) && this.compactMoveChunks(n5)) continue;
                        break;
                    }
                    finally {
                        this.storeLock.unlock();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
    }

    private int getTargetFillRate() {
        int n = this.autoCompactFillRate;
        if (!this.isIdle()) {
            n /= 2;
        }
        return n;
    }

    private boolean isIdle() {
        return this.autoCompactLastFileOpCount == this.fileStore.getWriteCount() + this.fileStore.getReadCount();
    }

    private void handleException(Throwable throwable) {
        block3: {
            if (this.backgroundExceptionHandler != null) {
                try {
                    this.backgroundExceptionHandler.uncaughtException(Thread.currentThread(), throwable);
                }
                catch (Throwable throwable2) {
                    if (throwable == throwable2) break block3;
                    throwable.addSuppressed(throwable2);
                }
            }
        }
    }

    public void setCacheSize(int n) {
        long l = (long)n * 1024L * 1024L;
        if (this.cache != null) {
            this.cache.setMaxMemory(l);
            this.cache.clear();
        }
    }

    private boolean isOpen() {
        return this.state == 0;
    }

    public boolean isClosed() {
        if (this.isOpen()) {
            return false;
        }
        this.storeLock.lock();
        try {
            assert (this.state == 3);
            boolean bl = true;
            return bl;
        }
        finally {
            this.storeLock.unlock();
        }
    }

    private boolean isOpenOrStopping() {
        return this.state <= 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopBackgroundThread(boolean bl) {
        BackgroundWriterThread backgroundWriterThread;
        while ((backgroundWriterThread = this.backgroundWriterThread.get()) != null) {
            if (!this.backgroundWriterThread.compareAndSet(backgroundWriterThread, null)) continue;
            if (backgroundWriterThread == Thread.currentThread()) break;
            Object object = backgroundWriterThread.sync;
            synchronized (object) {
                backgroundWriterThread.sync.notifyAll();
            }
            if (!bl) break;
            try {
                backgroundWriterThread.join();
            }
            catch (Exception exception) {}
            break;
        }
    }

    public void setAutoCommitDelay(int n) {
        int n2;
        BackgroundWriterThread backgroundWriterThread;
        if (this.autoCommitDelay == n) {
            return;
        }
        this.autoCommitDelay = n;
        if (this.fileStore == null || this.fileStore.isReadOnly()) {
            return;
        }
        this.stopBackgroundThread(true);
        if (n > 0 && this.isOpen() && this.backgroundWriterThread.compareAndSet(null, backgroundWriterThread = new BackgroundWriterThread(this, n2 = Math.max(1, n / 10), this.fileStore.toString()))) {
            backgroundWriterThread.start();
        }
    }

    public boolean isBackgroundThread() {
        return Thread.currentThread() == this.backgroundWriterThread.get();
    }

    public int getAutoCommitDelay() {
        return this.autoCommitDelay;
    }

    public int getAutoCommitMemory() {
        return this.autoCommitMemory;
    }

    public int getUnsavedMemory() {
        return this.unsavedMemory;
    }

    void cachePage(Page<?, ?> page) {
        if (this.cache != null) {
            this.cache.put(page.getPos(), page, page.getMemory());
        }
    }

    public int getCacheSizeUsed() {
        if (this.cache == null) {
            return 0;
        }
        return (int)(this.cache.getUsedMemory() >> 20);
    }

    public int getCacheSize() {
        if (this.cache == null) {
            return 0;
        }
        return (int)(this.cache.getMaxMemory() >> 20);
    }

    public CacheLongKeyLIRS<Page<?, ?>> getCache() {
        return this.cache;
    }

    public boolean isReadOnly() {
        return this.fileStore != null && this.fileStore.isReadOnly();
    }

    public int getCacheHitRatio() {
        return MVStore.getCacheHitRatio(this.cache);
    }

    public int getTocCacheHitRatio() {
        return MVStore.getCacheHitRatio(this.chunksToC);
    }

    private static int getCacheHitRatio(CacheLongKeyLIRS<?> cacheLongKeyLIRS) {
        if (cacheLongKeyLIRS == null) {
            return 0;
        }
        long l = cacheLongKeyLIRS.getHits();
        return (int)(100L * l / (l + cacheLongKeyLIRS.getMisses() + 1L));
    }

    public int getLeafRatio() {
        return (int)(this.leafCount * 100L / Math.max(1L, this.leafCount + this.nonLeafCount));
    }

    public double getUpdateFailureRatio() {
        long l = this.updateCounter;
        long l2 = this.updateAttemptCounter;
        RootReference<String, String> rootReference = this.meta.getRoot();
        l += rootReference.updateCounter;
        l2 += rootReference.updateAttemptCounter;
        for (MVMap<?, ?> mVMap : this.maps.values()) {
            RootReference<?, ?> rootReference2 = mVMap.getRoot();
            l += rootReference2.updateCounter;
            l2 += rootReference2.updateAttemptCounter;
        }
        return l2 == 0L ? 0.0 : 1.0 - (double)l / (double)l2;
    }

    public TxCounter registerVersionUsage() {
        TxCounter txCounter;
        while ((txCounter = this.currentTxCounter).incrementAndGet() <= 0) {
            assert (txCounter != this.currentTxCounter) : txCounter;
            txCounter.decrementAndGet();
        }
        return txCounter;
    }

    public void deregisterVersionUsage(TxCounter txCounter) {
        if (txCounter != null && txCounter.decrementAndGet() <= 0) {
            if (this.storeLock.isHeldByCurrentThread()) {
                this.dropUnusedVersions();
            } else if (this.storeLock.tryLock()) {
                try {
                    this.dropUnusedVersions();
                }
                finally {
                    this.storeLock.unlock();
                }
            }
        }
    }

    private void onVersionChange(long l) {
        TxCounter txCounter = this.currentTxCounter;
        assert (txCounter.get() >= 0);
        this.versions.add(txCounter);
        this.currentTxCounter = new TxCounter(l);
        txCounter.decrementAndGet();
        this.dropUnusedVersions();
    }

    private void dropUnusedVersions() {
        TxCounter txCounter;
        assert (this.storeLock.isHeldByCurrentThread());
        while ((txCounter = this.versions.peek()) != null && txCounter.get() < 0) {
            this.versions.poll();
        }
        this.setOldestVersionToKeep((txCounter != null ? txCounter : this.currentTxCounter).version);
    }

    private int dropUnusedChunks() {
        assert (this.storeLock.isHeldByCurrentThread());
        int n = 0;
        if (!this.deadChunks.isEmpty()) {
            Chunk chunk;
            long l = this.getOldestVersionToKeep();
            long l2 = this.getTimeSinceCreation();
            while ((chunk = this.deadChunks.poll()) != null && (this.isSeasonedChunk(chunk, l2) && MVStore.canOverwriteChunk(chunk, l) || !this.deadChunks.offerFirst(chunk))) {
                if (this.chunks.remove(chunk.id) == null) continue;
                long[] lArray = this.chunksToC.remove(chunk.id);
                if (lArray != null && this.cache != null) {
                    for (long l3 : lArray) {
                        long l4 = DataUtils.getPagePos(chunk.id, l3);
                        this.cache.remove(l4);
                    }
                }
                if (this.meta.remove(Chunk.getMetaKey(chunk.id)) != null) {
                    this.markMetaChanged();
                }
                if (chunk.isSaved()) {
                    this.freeChunkSpace(chunk);
                }
                ++n;
            }
        }
        return n;
    }

    private void freeChunkSpace(Chunk chunk) {
        long l = chunk.block * 4096L;
        int n = chunk.len * 4096;
        this.freeFileSpace(l, n);
    }

    private void freeFileSpace(long l, int n) {
        this.fileStore.free(l, n);
        assert (this.validateFileLength(l + ":" + n));
    }

    private boolean validateFileLength(String string) {
        assert (this.fileStore.getFileLengthInUse() == this.measureFileLengthInUse()) : this.fileStore.getFileLengthInUse() + " != " + this.measureFileLengthInUse() + " " + string;
        return true;
    }

    public static final class Builder {
        private final HashMap<String, Object> config;

        private Builder(HashMap<String, Object> hashMap) {
            this.config = hashMap;
        }

        public Builder() {
            this.config = new HashMap();
        }

        private Builder set(String string, Object object) {
            this.config.put(string, object);
            return this;
        }

        public Builder autoCommitDisabled() {
            return this.set("autoCommitDelay", 0);
        }

        public Builder autoCommitBufferSize(int n) {
            return this.set("autoCommitBufferSize", n);
        }

        public Builder autoCompactFillRate(int n) {
            return this.set("autoCompactFillRate", n);
        }

        public Builder fileName(String string) {
            return this.set("fileName", string);
        }

        public Builder encryptionKey(char[] cArray) {
            return this.set("encryptionKey", cArray);
        }

        public Builder readOnly() {
            return this.set("readOnly", 1);
        }

        public Builder recoveryMode() {
            return this.set("recoveryMode", 1);
        }

        public Builder cacheSize(int n) {
            return this.set("cacheSize", n);
        }

        public Builder cacheConcurrency(int n) {
            return this.set("cacheConcurrency", n);
        }

        public Builder compress() {
            return this.set("compress", 1);
        }

        public Builder compressHigh() {
            return this.set("compress", 2);
        }

        public Builder pageSplitSize(int n) {
            return this.set("pageSplitSize", n);
        }

        public Builder backgroundExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            return this.set("backgroundExceptionHandler", uncaughtExceptionHandler);
        }

        public Builder fileStore(FileStore fileStore) {
            return this.set("fileStore", fileStore);
        }

        public MVStore open() {
            return new MVStore(this.config);
        }

        public String toString() {
            return DataUtils.appendMap(new StringBuilder(), this.config).toString();
        }

        public static Builder fromString(String string) {
            return new Builder(DataUtils.parseMap(string));
        }
    }

    private static class RemovedPageInfo
    implements Comparable<RemovedPageInfo> {
        final long version;
        final long removedPageInfo;

        RemovedPageInfo(long l, boolean bl, long l2, int n) {
            this.removedPageInfo = RemovedPageInfo.createRemovedPageInfo(l, bl, n);
            this.version = l2;
        }

        @Override
        public int compareTo(RemovedPageInfo removedPageInfo) {
            return Long.compare(this.version, removedPageInfo.version);
        }

        int getPageChunkId() {
            return DataUtils.getPageChunkId(this.removedPageInfo);
        }

        int getPageNo() {
            return DataUtils.getPageOffset(this.removedPageInfo);
        }

        int getPageLength() {
            return DataUtils.getPageMaxLength(this.removedPageInfo);
        }

        boolean isPinned() {
            return (this.removedPageInfo & 1L) == 1L;
        }

        private static long createRemovedPageInfo(long l, boolean bl, int n) {
            long l2 = l & 0xFFFFFFC00000003EL | (long)(n << 6) & 0xFFFFFFFFL;
            if (bl) {
                l2 |= 1L;
            }
            return l2;
        }

        public String toString() {
            return "RemovedPageInfo{version=" + this.version + ", chunk=" + this.getPageChunkId() + ", pageNo=" + this.getPageNo() + ", len=" + this.getPageLength() + (this.isPinned() ? ", pinned" : "") + '}';
        }
    }

    private static class BackgroundWriterThread
    extends Thread {
        public final Object sync = new Object();
        private final MVStore store;
        private final int sleep;

        BackgroundWriterThread(MVStore mVStore, int n, String string) {
            super("MVStore background writer " + string);
            this.store = mVStore;
            this.sleep = n;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.store.isBackgroundThread()) {
                Object object = this.sync;
                synchronized (object) {
                    try {
                        this.sync.wait(this.sleep);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!this.store.isBackgroundThread()) break;
                this.store.writeInBackground();
            }
        }
    }

    public static final class TxCounter {
        public final long version;
        private volatile int counter;
        private static final AtomicIntegerFieldUpdater<TxCounter> counterUpdater = AtomicIntegerFieldUpdater.newUpdater(TxCounter.class, "counter");

        TxCounter(long l) {
            this.version = l;
        }

        int get() {
            return this.counter;
        }

        int incrementAndGet() {
            return counterUpdater.incrementAndGet(this);
        }

        int decrementAndGet() {
            return counterUpdater.decrementAndGet(this);
        }

        public String toString() {
            return "v=" + this.version + " / cnt=" + this.counter;
        }
    }
}

