/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.engine.CastDataProvider;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class UnaryOperation
extends Expression {
    private Expression arg;
    private TypeInfo type;

    public UnaryOperation(Expression expression) {
        this.arg = expression;
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, int n) {
        stringBuilder.append("(- ");
        return this.arg.getSQL(stringBuilder, n).append(')');
    }

    @Override
    public Value getValue(Session session) {
        Value value = this.arg.getValue(session).convertTo(this.type, (CastDataProvider)session);
        return value == ValueNull.INSTANCE ? value : value.negate();
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
        this.arg.mapColumns(columnResolver, n, n2);
    }

    @Override
    public Expression optimize(Session session) {
        this.arg = this.arg.optimize(session);
        this.type = this.arg.getType();
        if (this.type.getValueType() == -1) {
            this.type = TypeInfo.TYPE_NUMERIC_FLOATING_POINT;
        } else if (this.type.getValueType() == 25) {
            this.type = TypeInfo.TYPE_INTEGER;
        }
        if (this.arg.isConstant()) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.arg.setEvaluatable(tableFilter, bl);
    }

    @Override
    public TypeInfo getType() {
        return this.type;
    }

    @Override
    public void updateAggregate(Session session, int n) {
        this.arg.updateAggregate(session, n);
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.arg.isEverything(expressionVisitor);
    }

    @Override
    public int getCost() {
        return this.arg.getCost() + 1;
    }

    @Override
    public int getSubexpressionCount() {
        return 1;
    }

    @Override
    public Expression getSubexpression(int n) {
        if (n == 0) {
            return this.arg;
        }
        throw new IndexOutOfBoundsException();
    }
}

