/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.system;

import org.h2gis.api.DeterministicScalarFunction;

public class DoubleRange
extends DeterministicScalarFunction {
    public DoubleRange() {
        this.addProperty("remarks", "Return an array of doubles within the range [start-end). \nThe default step increment is 1 but the user can set another one.");
    }

    public String getJavaStaticMethod() {
        return "createArray";
    }

    public static Double[] createArray(double begin, double end) {
        return DoubleRange.createArray(begin, end, 1.0);
    }

    public static Double[] createArray(double begin, double end, double step) {
        if (end < begin) {
            throw new IllegalArgumentException("End must be greater or equal to begin");
        }
        int nbClasses = (int)((end - begin) / step);
        Double[] getArray = new Double[nbClasses];
        for (int i = 0; i < nbClasses; ++i) {
            getArray[i] = (double)i * step + begin;
        }
        return getArray;
    }
}

