/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.properties;

import java.sql.Connection;
import java.sql.SQLException;
import org.h2gis.api.AbstractFunction;
import org.h2gis.api.ScalarFunction;
import org.h2gis.utilities.GeometryTableUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.dbtypes.DBTypes;
import org.locationtech.jts.geom.Geometry;

public class ST_EstimatedExtent
extends AbstractFunction
implements ScalarFunction {
    public ST_EstimatedExtent() {
        this.addProperty("remarks", "Return the 'estimated' extent of the given spatial table.\nOnly 2D coordinate plane is supported\nThe Extent is first calculated from the spatial index of the table.\nif the pointed geometry column doesn't have a spatial index then\nthe extent is based on all geometries.\nThis function is fast, but estimation may include uncommitted data \n(including data from other transactions),\nmay return approximate bounds, or be different with actual value due to other reasons.");
    }

    public String getJavaStaticMethod() {
        return "computeEstimatedExtent";
    }

    public static Geometry computeEstimatedExtent(Connection connection, String tableName) throws SQLException {
        return GeometryTableUtilities.getEstimatedExtent((Connection)connection, (TableLocation)TableLocation.parse((String)tableName, (DBTypes)DBTypes.H2GIS));
    }

    public static Geometry computeEstimatedExtent(Connection connection, String tableName, String geometryColumn) throws SQLException {
        return GeometryTableUtilities.getEstimatedExtent((Connection)connection, (TableLocation)TableLocation.parse((String)tableName, (DBTypes)DBTypes.H2GIS), (String)geometryColumn);
    }
}

