/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.geojson;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.h2gis.api.DriverFunction;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.functions.io.DriverManager;
import org.h2gis.functions.io.geojson.GeoJsonReaderDriver;
import org.h2gis.functions.io.geojson.GeoJsonWriteDriver;

public class GeoJsonDriverFunction
implements DriverFunction {
    public DriverFunction.IMPORT_DRIVER_TYPE getImportDriverType() {
        return DriverFunction.IMPORT_DRIVER_TYPE.COPY;
    }

    public String[] getImportFormats() {
        return new String[]{"geojson", "geojson.gz"};
    }

    public String[] getExportFormats() {
        return new String[]{"geojson", "geojson.gz"};
    }

    public String getFormatDescription(String format) {
        if (format.equalsIgnoreCase("geojson")) {
            return "GeoJSON 1.0";
        }
        return "";
    }

    public boolean isSpatialFormat(String extension) {
        return extension.equals("geojson");
    }

    public String[] exportTable(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        return this.exportTable(connection, tableReference, fileName, null, false, progress);
    }

    public String[] exportTable(Connection connection, String tableReference, File fileName, boolean deleteFiles, ProgressVisitor progress) throws SQLException, IOException {
        return this.exportTable(connection, tableReference, fileName, null, deleteFiles, progress);
    }

    public String[] exportTable(Connection connection, String tableReference, File fileName, String encoding, boolean deleteFiles, ProgressVisitor progress) throws SQLException {
        progress = DriverManager.check(connection, tableReference, fileName, progress);
        GeoJsonWriteDriver geoJsonDriver = new GeoJsonWriteDriver(connection);
        try {
            geoJsonDriver.write(progress, tableReference, fileName, encoding, deleteFiles);
            return new String[]{fileName.getAbsolutePath()};
        }
        catch (IOException | SQLException ex) {
            throw new SQLException(ex);
        }
    }

    public String[] exportTable(Connection connection, String tableReference, File fileName, String encoding, ProgressVisitor progress) throws SQLException, IOException {
        return this.exportTable(connection, tableReference, fileName, encoding, false, progress);
    }

    public String[] importFile(Connection connection, String tableReference, File fileName, String options, boolean deleteTables, ProgressVisitor progress) throws SQLException, IOException {
        DriverManager.check(connection, tableReference, fileName, progress);
        GeoJsonReaderDriver geoJsonReaderDriver = new GeoJsonReaderDriver(connection, fileName, options, deleteTables);
        String outputTable = geoJsonReaderDriver.read(progress, tableReference);
        if (outputTable == null) {
            return null;
        }
        return new String[]{outputTable};
    }

    public String[] importFile(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        return this.importFile(connection, tableReference, fileName, null, false, progress);
    }

    public String[] importFile(Connection connection, String tableReference, File fileName, String options, ProgressVisitor progress) throws SQLException, IOException {
        return this.importFile(connection, tableReference, fileName, options, false, progress);
    }

    public String[] importFile(Connection connection, String tableReference, File fileName, boolean deleteTables, ProgressVisitor progress) throws SQLException, IOException {
        return this.importFile(connection, tableReference, fileName, null, deleteTables, progress);
    }
}

