/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.commons.printer;

import org.orbisgis.commons.annotations.NotNull;
import org.orbisgis.commons.printer.CustomPrinter;
import org.orbisgis.commons.printer.ICustomPrinter;
import org.orbisgis.commons.utilities.CheckUtils;

public class Ascii
extends CustomPrinter {
    public Ascii(@NotNull StringBuilder builder) {
        super(builder);
        if (this.builder.length() != 0) {
            builder.append("\n");
        }
    }

    public Ascii() {
        super(new StringBuilder());
    }

    @Override
    public void appendTableLineSeparator() {
        if (this.isDrawingTable) {
            this.builder.append("+");
            for (int i = 0; i < this.columnCount; ++i) {
                for (int j = 0; j < this.columnWidth; ++j) {
                    this.builder.append("-");
                }
                this.builder.append("+");
            }
            this.builder.append("\n");
        }
    }

    @Override
    public void appendTableValue(@NotNull Object value, @NotNull ICustomPrinter.CellPosition position) {
        CheckUtils.checkNotNull(value, "The value to append should not be null.");
        CheckUtils.checkNotNull((Object)position, "The position of the value should not be null.");
        if (this.isDrawingTable) {
            this.builder.append("|");
            String cut = value.toString();
            if (cut.length() > this.columnWidth) {
                cut = cut.substring(0, this.columnWidth - 3) + "...";
            }
            switch (position) {
                case LEFT: {
                    this.builder.append(cut);
                    for (int i = 0; i < this.columnWidth - cut.length(); ++i) {
                        this.builder.append(" ");
                    }
                    break;
                }
                case RIGHT: {
                    for (int i = 0; i < this.columnWidth - cut.length(); ++i) {
                        this.builder.append(" ");
                    }
                    this.builder.append(cut);
                    break;
                }
                default: {
                    int i;
                    for (i = 0; i < (this.columnWidth - cut.length()) / 2; ++i) {
                        this.builder.append(" ");
                    }
                    this.builder.append(cut);
                    for (i = 0; i < this.columnWidth - cut.length() - (this.columnWidth - cut.length()) / 2; ++i) {
                        this.builder.append(" ");
                    }
                }
            }
            ++this.columnIndex;
            if (this.columnIndex == this.columnCount) {
                this.columnIndex = 0;
                this.builder.append("|");
                this.builder.append("\n");
            }
        }
    }

    @Override
    public void appendTableHeaderValue(@NotNull Object value, @NotNull ICustomPrinter.CellPosition position) {
        CheckUtils.checkNotNull(value, "The value to append should not be null.");
        CheckUtils.checkNotNull((Object)position, "The position of the value should not be null.");
        this.appendTableValue(value, position);
    }

    @Override
    public void appendTableTitle(@NotNull Object title) {
        CheckUtils.checkNotNull(title, "The title to append should not be null.");
        if (this.isDrawingTable) {
            int i;
            this.builder.append("+");
            for (int j = 0; j < this.columnWidth; ++j) {
                this.builder.append("-");
            }
            this.builder.append("+");
            this.builder.append("\n");
            this.builder.append("|");
            String cut = title.toString();
            if (cut.length() > this.columnWidth) {
                cut = cut.substring(0, this.columnWidth - 3) + "...";
            }
            for (i = 0; i < (this.columnWidth - cut.length()) / 2; ++i) {
                this.builder.append(" ");
            }
            this.builder.append(cut);
            for (i = 0; i < this.columnWidth - cut.length() - (this.columnWidth - cut.length()) / 2; ++i) {
                this.builder.append(" ");
            }
            this.builder.append("|");
            this.builder.append("\n");
        }
    }

    @Override
    public void appendValue(Object value) {
        CheckUtils.checkNotNull(value, "The value to append should not be null.");
        if (this.isDrawingTable) {
            this.appendTableValue(value);
        } else {
            this.builder.append(value).append("\n");
        }
    }
}

