/*
 * Decompiled with CFR 0.152.
 */
package org.h2.schema;

import java.math.BigDecimal;
import org.h2.command.ddl.SequenceOptions;
import org.h2.engine.CastDataProvider;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObjectBase;
import org.h2.table.Table;
import org.h2.util.HasSQL;
import org.h2.value.Value;
import org.h2.value.ValueBigint;
import org.h2.value.ValueNumeric;

public class Sequence
extends SchemaObjectBase {
    public static final int DEFAULT_CACHE_SIZE = 32;
    private long value;
    private long valueWithMargin;
    private long increment;
    private long cacheSize;
    private long startValue;
    private long minValue;
    private long maxValue;
    private boolean cycle;
    private boolean belongsToTable;
    private boolean writeWithMargin;

    public Sequence(Session session, Schema schema, int n, String string, SequenceOptions sequenceOptions, boolean bl) {
        super(schema, n, string, 9);
        long l;
        long l2;
        Long l3 = sequenceOptions.getIncrement(session);
        long l4 = l3 != null ? l3 : 1L;
        Long l5 = sequenceOptions.getStartValue(session);
        Long l6 = sequenceOptions.getMinValue(null, session);
        Long l7 = sequenceOptions.getMaxValue(null, session);
        long l8 = l6 != null ? l6 : Sequence.getDefaultMinValue(l5, l4);
        long l9 = l2 = l7 != null ? l7 : Sequence.getDefaultMaxValue(l5, l4);
        long l10 = l5 != null ? l5 : (l4 >= 0L ? l8 : l2);
        Long l11 = sequenceOptions.getRestartValue(session, l10);
        long l12 = l = l11 != null ? l11 : l10;
        if (!Sequence.isValid(l, l10, l8, l2, l4)) {
            throw DbException.get(90009, string, Long.toString(l), Long.toString(l10), Long.toString(l8), Long.toString(l2), Long.toString(l4));
        }
        this.valueWithMargin = this.value = l;
        this.increment = l4;
        l3 = sequenceOptions.getCacheSize(session);
        this.cacheSize = l3 != null ? Math.max(1L, l3) : 32L;
        this.startValue = l10;
        this.minValue = l8;
        this.maxValue = l2;
        this.cycle = Boolean.TRUE.equals(sequenceOptions.getCycle());
        this.belongsToTable = bl;
    }

    public synchronized void modify(Long l, Long l2, Long l3, Long l4, Long l5) {
        long l6;
        if (l == null) {
            l = this.startValue;
        }
        if (l3 == null) {
            l3 = this.minValue;
        }
        if (l4 == null) {
            l4 = this.maxValue;
        }
        if (l5 == null) {
            l5 = this.increment;
        }
        long l7 = l6 = l2 != null ? l2 : this.value;
        if (!Sequence.isValid(l6, l, l3, l4, l5)) {
            throw DbException.get(90009, this.getName(), String.valueOf(l6), String.valueOf(l), String.valueOf(l3), String.valueOf(l4), String.valueOf(l5));
        }
        this.valueWithMargin = this.value = l6;
        this.startValue = l;
        this.minValue = l3;
        this.maxValue = l4;
        this.increment = l5;
    }

    private static boolean isValid(long l, long l2, long l3, long l4, long l5) {
        return l3 <= l && l4 >= l && l3 <= l2 && l4 >= l2 && l4 > l3 && l5 != 0L && Long.compareUnsigned(Math.abs(l5), l4 - l3) <= 0;
    }

    public static long getDefaultMinValue(Long l, long l2) {
        long l3;
        long l4 = l3 = l2 >= 0L ? 1L : Long.MIN_VALUE;
        if (l != null && l2 >= 0L && l < l3) {
            l3 = l;
        }
        return l3;
    }

    public static long getDefaultMaxValue(Long l, long l2) {
        long l3;
        long l4 = l3 = l2 >= 0L ? Long.MAX_VALUE : -1L;
        if (l != null && l2 < 0L && l > l3) {
            l3 = l;
        }
        return l3;
    }

    public boolean getBelongsToTable() {
        return this.belongsToTable;
    }

    public long getIncrement() {
        return this.increment;
    }

    public long getStartValue() {
        return this.startValue;
    }

    public long getMinValue() {
        return this.minValue;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public boolean getCycle() {
        return this.cycle;
    }

    public void setCycle(boolean bl) {
        this.cycle = bl;
    }

    @Override
    public String getDropSQL() {
        if (this.getBelongsToTable()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder("DROP SEQUENCE IF EXISTS ");
        return this.getSQL(stringBuilder, 0).toString();
    }

    @Override
    public String getCreateSQLForCopy(Table table, String string) {
        throw DbException.throwInternalError(this.toString());
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQL(false, false);
    }

    public synchronized String getCreateSQL(boolean bl, boolean bl2) {
        long l = !bl && this.writeWithMargin ? this.valueWithMargin : this.value;
        long l2 = this.startValue;
        if (bl && bl2) {
            if (l == l2) {
                return null;
            }
            return this.getSQL(new StringBuilder("ALTER SEQUENCE "), 0).append(" RESTART WITH ").append(l).toString();
        }
        StringBuilder stringBuilder = new StringBuilder("CREATE SEQUENCE ");
        this.getSQL(stringBuilder, 0).append(" START WITH ").append(l2);
        if (!bl && l != l2) {
            stringBuilder.append(" RESTART WITH ").append(l);
        }
        if (this.increment != 1L) {
            stringBuilder.append(" INCREMENT BY ").append(this.increment);
        }
        if (this.minValue != Sequence.getDefaultMinValue(l, this.increment)) {
            stringBuilder.append(" MINVALUE ").append(this.minValue);
        }
        if (this.maxValue != Sequence.getDefaultMaxValue(l, this.increment)) {
            stringBuilder.append(" MAXVALUE ").append(this.maxValue);
        }
        if (this.cycle) {
            stringBuilder.append(" CYCLE");
        }
        if (this.cacheSize != 32L) {
            if (this.cacheSize == 1L) {
                stringBuilder.append(" NO CACHE");
            } else {
                stringBuilder.append(" CACHE ").append(this.cacheSize);
            }
        }
        if (this.belongsToTable) {
            stringBuilder.append(" BELONGS_TO_TABLE");
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value getNext(Session session) {
        long l;
        boolean bl = false;
        HasSQL hasSQL = this;
        synchronized (hasSQL) {
            if (this.increment > 0L && this.value >= this.valueWithMargin || this.increment < 0L && this.value <= this.valueWithMargin) {
                this.valueWithMargin += this.increment * this.cacheSize;
                bl = true;
            }
            if (this.increment > 0L && this.value > this.maxValue || this.increment < 0L && this.value < this.minValue) {
                if (this.cycle) {
                    this.value = this.increment > 0L ? this.minValue : this.maxValue;
                    this.valueWithMargin = this.value + this.increment * this.cacheSize;
                    bl = true;
                } else {
                    throw DbException.get(90006, this.getName());
                }
            }
            l = this.value;
            this.value += this.increment;
        }
        if (bl) {
            this.flush(session);
        }
        hasSQL = this.database.getMode().decimalSequences ? ValueNumeric.get(BigDecimal.valueOf(l)) : ValueBigint.get(l);
        if (session != null) {
            session.setCurrentValueFor(this, (Value)hasSQL);
        }
        return hasSQL;
    }

    public void flushWithoutMargin() {
        if (this.valueWithMargin != this.value) {
            this.valueWithMargin = this.value;
            this.flush(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(Session session) {
        if (this.isTemporary()) {
            return;
        }
        if (session == null || !this.database.isSysTableLockedBy(session)) {
            Session session2 = this.database.getSystemSession();
            CastDataProvider castDataProvider = this.database.isMVStore() ? session2 : this.database;
            synchronized (castDataProvider) {
                this.flushInternal(session2);
                session2.commit(false);
            }
        }
        CastDataProvider castDataProvider = this.database.isMVStore() ? session : this.database;
        synchronized (castDataProvider) {
            this.flushInternal(session);
        }
    }

    private void flushInternal(Session session) {
        boolean bl = this.database.lockMeta(session);
        try {
            this.writeWithMargin = true;
            this.database.updateMeta(session, this);
        }
        finally {
            this.writeWithMargin = false;
            if (!bl) {
                this.database.unlockMeta(session);
            }
        }
    }

    public void close() {
        this.flushWithoutMargin();
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.database.removeMeta(session, this.getId());
        this.invalidate();
    }

    public synchronized long getCurrentValue() {
        return this.value - this.increment;
    }

    public void setBelongsToTable(boolean bl) {
        this.belongsToTable = bl;
    }

    public void setCacheSize(long l) {
        this.cacheSize = Math.max(1L, l);
    }

    public long getCacheSize() {
        return this.cacheSize;
    }
}

