/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.condition.Comparison;
import org.h2.index.IndexCondition;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueCollectionBase;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;

public class ValueExpression
extends Expression {
    public static final ValueExpression NULL = new ValueExpression(ValueNull.INSTANCE);
    public static final ValueExpression DEFAULT = new ValueExpression(ValueNull.INSTANCE);
    public static final ValueExpression TRUE = new ValueExpression(ValueBoolean.TRUE);
    public static final ValueExpression FALSE = new ValueExpression(ValueBoolean.FALSE);
    final Value value;

    ValueExpression(Value value) {
        this.value = value;
    }

    public static ValueExpression get(Value value) {
        if (value == ValueNull.INSTANCE) {
            return NULL;
        }
        if (value.getValueType() == 1) {
            return ValueExpression.getBoolean(value.getBoolean());
        }
        return new ValueExpression(value);
    }

    public static ValueExpression getBoolean(Value value) {
        if (value == ValueNull.INSTANCE) {
            return TypedValueExpression.UNKNOWN;
        }
        return ValueExpression.getBoolean(value.getBoolean());
    }

    public static ValueExpression getBoolean(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    @Override
    public Value getValue(Session session) {
        return this.value;
    }

    @Override
    public TypeInfo getType() {
        return this.value.getType();
    }

    @Override
    public void createIndexConditions(Session session, TableFilter tableFilter) {
        if (this.value.getValueType() == 1 && !this.value.getBoolean()) {
            tableFilter.addIndexCondition(IndexCondition.get(6, null, this));
        }
    }

    @Override
    public Expression getNotIfPossible(Session session) {
        return new Comparison(0, this, FALSE);
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
    }

    @Override
    public Expression optimize(Session session) {
        return this;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public boolean isNullConstant() {
        return this == NULL;
    }

    @Override
    public boolean isValueSet() {
        return true;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, int n) {
        if (this == DEFAULT) {
            stringBuilder.append("DEFAULT");
        } else {
            this.value.getSQL(stringBuilder, n);
        }
        return stringBuilder;
    }

    @Override
    public void updateAggregate(Session session, int n) {
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        switch (expressionVisitor.getType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        throw DbException.throwInternalError("type=" + expressionVisitor.getType());
    }

    @Override
    public int getCost() {
        return 0;
    }

    @Override
    public Expression[] getExpressionColumns(Session session) {
        int n = this.getType().getValueType();
        switch (n) {
            case 17: 
            case 39: {
                return ValueExpression.getExpressionColumns(session, (ValueCollectionBase)this.getValue(session));
            }
            case 18: {
                return ValueExpression.getExpressionColumns(session, ((ValueResultSet)this.getValue(session)).getResult());
            }
        }
        return super.getExpressionColumns(session);
    }
}

