/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.ArrayList;
import java.util.HashSet;
import org.h2.command.Command;
import org.h2.command.dml.CommandWithValues;
import org.h2.command.dml.DataChangeStatement;
import org.h2.command.dml.Query;
import org.h2.command.dml.Update;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.Parameter;
import org.h2.expression.ValueExpression;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.mvstore.db.MVPrimaryIndex;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.result.Row;
import org.h2.table.Column;
import org.h2.table.DataChangeDeltaTable;
import org.h2.table.Table;
import org.h2.util.HasSQL;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class Merge
extends CommandWithValues
implements DataChangeStatement {
    private boolean isReplace;
    private Table table;
    private Column[] columns;
    private Column[] keys;
    private Query query;
    private Update update;
    private ResultTarget deltaChangeCollector;
    private DataChangeDeltaTable.ResultOption deltaChangeCollectionMode;

    public Merge(Session session, boolean bl) {
        super(session);
        this.isReplace = bl;
    }

    @Override
    public void setCommand(Command command) {
        super.setCommand(command);
        if (this.query != null) {
            this.query.setCommand(command);
        }
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setColumns(Column[] columnArray) {
        this.columns = columnArray;
    }

    public void setKeys(Column[] columnArray) {
        this.keys = columnArray;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    @Override
    public void setDeltaChangeCollector(ResultTarget resultTarget, DataChangeDeltaTable.ResultOption resultOption) {
        this.deltaChangeCollector = resultTarget;
        this.deltaChangeCollectionMode = resultOption;
        this.update.setDeltaChangeCollector(resultTarget, resultOption);
    }

    @Override
    public int update() {
        int n = 0;
        this.session.getUser().checkRight(this.table, 4);
        this.session.getUser().checkRight(this.table, 8);
        this.setCurrentRowNumber(0L);
        if (!this.valuesExpressionList.isEmpty()) {
            int n2 = this.valuesExpressionList.size();
            for (int i = 0; i < n2; ++i) {
                this.setCurrentRowNumber(i + 1);
                Expression[] expressionArray = (Expression[])this.valuesExpressionList.get(i);
                Row row = this.table.getTemplateRow();
                int n3 = this.columns.length;
                for (int j = 0; j < n3; ++j) {
                    Column column = this.columns[j];
                    int n4 = column.getColumnId();
                    Expression expression = expressionArray[j];
                    if (expression == ValueExpression.DEFAULT) continue;
                    try {
                        row.setValue(n4, expression.getValue(this.session));
                        continue;
                    }
                    catch (DbException dbException) {
                        throw this.setRow(dbException, n, Merge.getSimpleSQL(expressionArray));
                    }
                }
                n += this.merge(row, expressionArray);
            }
        } else {
            this.query.setNeverLazy(true);
            ResultInterface resultInterface = this.query.query(0);
            this.table.fire(this.session, 3, true);
            this.table.lock(this.session, true, false);
            while (resultInterface.next()) {
                Value[] valueArray = resultInterface.currentRow();
                Row row = this.table.getTemplateRow();
                this.setCurrentRowNumber(n);
                for (int i = 0; i < this.columns.length; ++i) {
                    row.setValue(this.columns[i].getColumnId(), valueArray[i]);
                }
                n += this.merge(row, null);
            }
            resultInterface.close();
            this.table.fire(this.session, 3, false);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private int merge(Row row, Expression[] expressionArray) {
        int n;
        if (this.update == null) {
            n = 0;
        } else {
            HasSQL hasSQL;
            ArrayList<Parameter> arrayList = this.update.getParameters();
            int n2 = 0;
            int n3 = this.columns.length;
            for (int i = 0; i < n3; ++i) {
                void hasSQL2;
                Column column = this.columns[i];
                if (column.getGenerated()) {
                    if (expressionArray != null && expressionArray[i] == ValueExpression.DEFAULT) continue;
                    throw DbException.get(90154, column.getSQLWithTable(new StringBuilder(), 3).toString());
                }
                Value value = row.getValue(column.getColumnId());
                if (value == null) {
                    hasSQL = column.getDefaultExpression();
                    ValueNull valueNull = hasSQL != null ? ((Expression)hasSQL).getValue(this.session) : ValueNull.INSTANCE;
                }
                arrayList.get(n2++).setValue((Value)hasSQL2);
            }
            for (Column column : this.keys) {
                hasSQL = row.getValue(column.getColumnId());
                if (hasSQL == null) {
                    throw DbException.get(90081, column.getTraceSQL());
                }
                arrayList.get(n2++).setValue((Value)hasSQL);
            }
            n = this.update.update();
        }
        if (n == 0) {
            try {
                this.table.validateConvertUpdateSequence(this.session, row);
                if (this.deltaChangeCollectionMode == DataChangeDeltaTable.ResultOption.NEW) {
                    this.deltaChangeCollector.addRow((Value[])row.getValueList().clone());
                }
                if (!this.table.fireBeforeRow(this.session, null, row)) {
                    this.table.lock(this.session, true, false);
                    this.table.addRow(this.session, row);
                    if (this.deltaChangeCollectionMode == DataChangeDeltaTable.ResultOption.FINAL) {
                        this.deltaChangeCollector.addRow(row.getValueList());
                    }
                    this.session.log(this.table, (short)0, row);
                    this.table.fireAfterRow(this.session, null, row, false);
                } else if (this.deltaChangeCollectionMode == DataChangeDeltaTable.ResultOption.FINAL) {
                    this.deltaChangeCollector.addRow(row.getValueList());
                }
                return 1;
            }
            catch (DbException dbException) {
                Index index;
                if (dbException.getErrorCode() == 23505 && (index = (Index)dbException.getSource()) != null) {
                    boolean bl;
                    Column[] columnArray;
                    if (index instanceof MVPrimaryIndex) {
                        MVPrimaryIndex mVPrimaryIndex = (MVPrimaryIndex)index;
                        columnArray = new Column[]{mVPrimaryIndex.getIndexColumns()[mVPrimaryIndex.getMainIndexColumn()].column};
                    } else {
                        columnArray = index.getColumns();
                    }
                    if (columnArray.length <= this.keys.length) {
                        bl = true;
                        for (int i = 0; i < columnArray.length; ++i) {
                            if (columnArray[i] == this.keys[i]) continue;
                            bl = false;
                            break;
                        }
                    } else {
                        bl = false;
                    }
                    if (bl) {
                        throw DbException.get(90131, this.table.getName());
                    }
                }
                throw dbException;
            }
        }
        if (n == 1) {
            return this.isReplace ? 2 : 1;
        }
        throw DbException.get(23505, this.table.getTraceSQL());
    }

    @Override
    public String getPlanSQL(int n) {
        StringBuilder stringBuilder = new StringBuilder(this.isReplace ? "REPLACE INTO " : "MERGE INTO ");
        this.table.getSQL(stringBuilder, n).append('(');
        Column.writeColumns(stringBuilder, this.columns, n);
        stringBuilder.append(')');
        if (!this.isReplace && this.keys != null) {
            stringBuilder.append(" KEY(");
            Column.writeColumns(stringBuilder, this.keys, n);
            stringBuilder.append(')');
        }
        stringBuilder.append('\n');
        if (!this.valuesExpressionList.isEmpty()) {
            stringBuilder.append("VALUES ");
            int n2 = 0;
            for (Expression[] expressionArray : this.valuesExpressionList) {
                if (n2++ > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append('(');
                Expression.writeExpressions(stringBuilder, expressionArray, n);
                stringBuilder.append(')');
            }
        } else {
            stringBuilder.append(this.query.getPlanSQL(n));
        }
        return stringBuilder.toString();
    }

    @Override
    public void prepare() {
        Object object;
        if (this.columns == null) {
            this.columns = !this.valuesExpressionList.isEmpty() && ((Expression[])this.valuesExpressionList.get(0)).length == 0 ? new Column[0] : this.table.getColumns();
        }
        if (!this.valuesExpressionList.isEmpty()) {
            for (Expression[] expressionArray : this.valuesExpressionList) {
                if (expressionArray.length != this.columns.length) {
                    throw DbException.get(21002);
                }
                for (int i = 0; i < expressionArray.length; ++i) {
                    Expression hasSQL = expressionArray[i];
                    if (hasSQL == null) continue;
                    expressionArray[i] = hasSQL.optimize(this.session);
                }
            }
        } else {
            this.query.prepare();
            if (this.query.getColumnCount() != this.columns.length) {
                throw DbException.get(21002);
            }
        }
        if (this.keys == null) {
            object = this.table.getPrimaryKey();
            if (object == null) {
                throw DbException.get(90057, "PRIMARY KEY");
            }
            this.keys = object.getColumns();
        }
        if (this.isReplace) {
            for (Column column : this.keys) {
                boolean column2 = false;
                for (Column column3 : this.columns) {
                    if (column3.getColumnId() != column.getColumnId()) continue;
                    column2 = true;
                    break;
                }
                if (column2) continue;
                return;
            }
        }
        object = this.table.getSQL(new StringBuilder("UPDATE "), 0).append(" SET ");
        boolean bl = false;
        for (Column column : this.columns) {
            if (column.getGenerated()) continue;
            if (bl) {
                ((StringBuilder)object).append(", ");
            }
            bl = true;
            column.getSQL((StringBuilder)object, 0).append("=?");
        }
        Column.writeColumns(((StringBuilder)object).append(" WHERE "), this.keys, " AND ", "=?", 0);
        this.update = (Update)this.session.prepare(((StringBuilder)object).toString());
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    @Override
    public int getType() {
        return this.isReplace ? 63 : 62;
    }

    @Override
    public String getStatementName() {
        return this.isReplace ? "REPLACE" : "MERGE";
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    @Override
    public void collectDependencies(HashSet<DbObject> hashSet) {
        if (this.query != null) {
            this.query.collectDependencies(hashSet);
        }
    }
}

