/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import org.h2.command.ddl.SchemaCommand;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintActionType;
import org.h2.constraint.ConstraintCheck;
import org.h2.constraint.ConstraintReferential;
import org.h2.constraint.ConstraintUnique;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.value.DataType;

public class AlterTableAddConstraint
extends SchemaCommand {
    private final int type;
    private String constraintName;
    private String tableName;
    private IndexColumn[] indexColumns;
    private ConstraintActionType deleteAction = ConstraintActionType.RESTRICT;
    private ConstraintActionType updateAction = ConstraintActionType.RESTRICT;
    private Schema refSchema;
    private String refTableName;
    private IndexColumn[] refIndexColumns;
    private Expression checkExpression;
    private Index index;
    private Index refIndex;
    private String comment;
    private boolean checkExisting;
    private boolean primaryKeyHash;
    private boolean ifTableExists;
    private final boolean ifNotExists;
    private final ArrayList<Index> createdIndexes = new ArrayList();
    private ConstraintUnique createdUniqueConstraint;

    public AlterTableAddConstraint(Session session, Schema schema, int n, boolean bl) {
        super(session, schema);
        this.ifNotExists = bl;
        this.type = n;
    }

    public void setIfTableExists(boolean bl) {
        this.ifTableExists = bl;
    }

    private String generateConstraintName(Table table) {
        if (this.constraintName == null) {
            this.constraintName = this.getSchema().getUniqueConstraintName(this.session, table);
        }
        return this.constraintName;
    }

    @Override
    public int update() {
        try {
            int n = this.tryUpdate();
            return n;
        }
        catch (DbException dbException) {
            try {
                if (this.createdUniqueConstraint != null) {
                    Index index = this.createdUniqueConstraint.getIndex();
                    this.session.getDatabase().removeSchemaObject(this.session, this.createdUniqueConstraint);
                    this.createdIndexes.remove(index);
                }
                for (Index index : this.createdIndexes) {
                    this.session.getDatabase().removeSchemaObject(this.session, index);
                }
            }
            catch (Throwable throwable) {
                dbException.addSuppressed(throwable);
            }
            throw dbException;
        }
        finally {
            this.getSchema().freeUniqueName(this.constraintName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private int tryUpdate() {
        Constraint constraint;
        if (!this.transactional) {
            this.session.commit(true);
        }
        Database database = this.session.getDatabase();
        Table table = this.getSchema().findTableOrView(this.session, this.tableName);
        if (table == null) {
            if (this.ifTableExists) {
                return 0;
            }
            throw DbException.get(42102, this.tableName);
        }
        if (this.constraintName != null && this.getSchema().findConstraint(this.session, this.constraintName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw DbException.get(90045, this.constraintName);
        }
        this.session.getUser().checkRight(table, 15);
        database.lockMeta(this.session);
        table.lock(this.session, true, true);
        switch (this.type) {
            case 6: {
                Object object;
                Object object2;
                IndexColumn.mapColumns(this.indexColumns, table);
                this.index = table.findPrimaryKey();
                ArrayList<Constraint> arrayList = table.getConstraints();
                for (int i = 0; arrayList != null && i < arrayList.size(); ++i) {
                    object2 = arrayList.get(i);
                    if (Constraint.Type.PRIMARY_KEY != ((Constraint)object2).getConstraintType()) continue;
                    throw DbException.get(90017);
                }
                if (this.index != null) {
                    object = this.index.getIndexColumns();
                    if (((IndexColumn[])object).length != this.indexColumns.length) {
                        throw DbException.get(90017);
                    }
                    for (int i = 0; i < ((IndexColumn[])object).length; ++i) {
                        if (object[i].column == this.indexColumns[i].column) continue;
                        throw DbException.get(90017);
                    }
                } else {
                    object = IndexType.createPrimaryKey(table.isPersistIndexes(), this.primaryKeyHash);
                    object2 = table.getSchema().getUniqueIndexName(this.session, table, "PRIMARY_KEY_");
                    int n = this.session.getDatabase().allocateObjectId();
                    try {
                        this.index = table.addIndex(this.session, (String)object2, n, this.indexColumns, (IndexType)object, true, null);
                    }
                    finally {
                        this.getSchema().freeUniqueName((String)object2);
                    }
                }
                this.index.getIndexType().setBelongsToConstraint(true);
                int n = this.getObjectId();
                String string = this.generateConstraintName(table);
                ConstraintUnique constraintUnique = new ConstraintUnique(this.getSchema(), n, string, table, true);
                constraintUnique.setColumns(this.indexColumns);
                constraintUnique.setIndex(this.index, true);
                constraint = constraintUnique;
                break;
            }
            case 4: {
                IndexColumn.mapColumns(this.indexColumns, table);
                constraint = this.createUniqueConstraint(table, this.index, this.indexColumns, false);
                break;
            }
            case 3: {
                int n = this.getObjectId();
                String string = this.generateConstraintName(table);
                ConstraintCheck constraintCheck = new ConstraintCheck(this.getSchema(), n, string, table);
                TableFilter tableFilter = new TableFilter(this.session, table, null, false, null, 0, null);
                this.checkExpression.mapColumns(tableFilter, 0, 0);
                this.checkExpression = this.checkExpression.optimize(this.session);
                constraintCheck.setExpression(this.checkExpression);
                constraintCheck.setTableFilter(tableFilter);
                constraint = constraintCheck;
                if (!this.checkExisting) break;
                constraintCheck.checkExistingData(this.session);
                break;
            }
            case 5: {
                void var10_33;
                int n;
                Table table2 = this.refSchema.resolveTableOrView(this.session, this.refTableName);
                if (table2 == null) {
                    throw DbException.get(42102, this.refTableName);
                }
                this.session.getUser().checkRight(table2, 15);
                if (!table2.canReference()) {
                    StringBuilder stringBuilder = new StringBuilder("Reference ");
                    table2.getSQL(stringBuilder, 3);
                    throw DbException.getUnsupportedException(stringBuilder.toString());
                }
                boolean bl = false;
                IndexColumn.mapColumns(this.indexColumns, table);
                if (this.refIndexColumns == null) {
                    this.refIndexColumns = table2.getPrimaryKey().getIndexColumns();
                } else {
                    IndexColumn.mapColumns(this.refIndexColumns, table2);
                }
                int n2 = this.indexColumns.length;
                if (this.refIndexColumns.length != n2) {
                    throw DbException.get(21002);
                }
                for (IndexColumn object3 : this.refIndexColumns) {
                    Column column = object3.column;
                    if (!column.getGenerated()) continue;
                    switch (this.deleteAction) {
                        case SET_DEFAULT: 
                        case SET_NULL: {
                            throw DbException.get(90155, column.getSQLWithTable(new StringBuilder(), 3).toString(), "ON DELETE " + this.deleteAction.getSqlName());
                        }
                    }
                    switch (this.updateAction) {
                        case SET_DEFAULT: 
                        case SET_NULL: 
                        case CASCADE: {
                            throw DbException.get(90155, column.getSQLWithTable(new StringBuilder(), 3).toString(), "ON UPDATE " + this.updateAction.getSqlName());
                        }
                    }
                }
                for (n = 0; n < n2; ++n) {
                    Column column = this.indexColumns[n].column;
                    Column column2 = this.refIndexColumns[n].column;
                    if (DataType.areStableComparable(column.getType(), column2.getType())) continue;
                    throw DbException.get(90153, column.getCreateSQL(), column2.getCreateSQL());
                }
                if (this.index != null && AlterTableAddConstraint.canUseIndex(this.index, table, this.indexColumns, false)) {
                    bl = true;
                    this.index.getIndexType().setBelongsToConstraint(true);
                } else {
                    this.index = AlterTableAddConstraint.getIndex(table, this.indexColumns, false);
                    if (this.index == null) {
                        this.index = this.createIndex(table, this.indexColumns, false);
                        bl = true;
                    }
                }
                n = this.getObjectId();
                String string = this.generateConstraintName(table);
                ConstraintReferential constraintReferential = new ConstraintReferential(this.getSchema(), n, string, table);
                constraintReferential.setColumns(this.indexColumns);
                constraintReferential.setIndex(this.index, bl);
                constraintReferential.setRefTable(table2);
                constraintReferential.setRefColumns(this.refIndexColumns);
                ConstraintUnique constraintUnique = AlterTableAddConstraint.getUniqueConstraint(table2, this.refIndexColumns);
                if (constraintUnique == null) {
                    ConstraintUnique constraintUnique2 = this.createUniqueConstraint(table2, this.refIndex, this.refIndexColumns, true);
                    this.addConstraintToTable(database, table2, constraintUnique2);
                    this.createdUniqueConstraint = constraintUnique2;
                }
                constraintReferential.setRefConstraint((ConstraintUnique)var10_33);
                if (this.checkExisting) {
                    constraintReferential.checkExistingData(this.session);
                }
                table2.addConstraint(constraintReferential);
                constraintReferential.setDeleteAction(this.deleteAction);
                constraintReferential.setUpdateAction(this.updateAction);
                constraint = constraintReferential;
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + this.type);
            }
        }
        constraint.setComment(this.comment);
        this.addConstraintToTable(database, table, constraint);
        return 0;
    }

    private ConstraintUnique createUniqueConstraint(Table table, Index index, IndexColumn[] indexColumnArray, boolean bl) {
        String string;
        int n;
        boolean bl2 = false;
        if (index != null && AlterTableAddConstraint.canUseIndex(index, table, indexColumnArray, true)) {
            bl2 = true;
            index.getIndexType().setBelongsToConstraint(true);
        } else {
            index = AlterTableAddConstraint.getIndex(table, indexColumnArray, true);
            if (index == null) {
                index = this.createIndex(table, indexColumnArray, true);
                bl2 = true;
            }
        }
        if (bl) {
            n = this.session.getDatabase().allocateObjectId();
            string = this.getSchema().getUniqueConstraintName(this.session, table);
        } else {
            n = this.getObjectId();
            string = this.generateConstraintName(table);
        }
        ConstraintUnique constraintUnique = new ConstraintUnique(this.getSchema(), n, string, table, false);
        constraintUnique.setColumns(indexColumnArray);
        constraintUnique.setIndex(index, bl2);
        return constraintUnique;
    }

    private void addConstraintToTable(Database database, Table table, Constraint constraint) {
        if (table.isTemporary() && !table.isGlobalTemporary()) {
            this.session.addLocalTempTableConstraint(constraint);
        } else {
            database.addSchemaObject(this.session, constraint);
        }
        table.addConstraint(constraint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Index createIndex(Table table, IndexColumn[] indexColumnArray, boolean bl) {
        int n = this.session.getDatabase().allocateObjectId();
        IndexType indexType = bl ? IndexType.createUnique(table.isPersistIndexes(), false) : IndexType.createNonUnique(table.isPersistIndexes());
        indexType.setBelongsToConstraint(true);
        String string = this.constraintName == null ? "CONSTRAINT" : this.constraintName;
        String string2 = table.getSchema().getUniqueIndexName(this.session, table, string + "_INDEX_");
        try {
            Index index = table.addIndex(this.session, string2, n, indexColumnArray, indexType, true, null);
            this.createdIndexes.add(index);
            Index index2 = index;
            return index2;
        }
        finally {
            this.getSchema().freeUniqueName(string2);
        }
    }

    public void setDeleteAction(ConstraintActionType constraintActionType) {
        this.deleteAction = constraintActionType;
    }

    public void setUpdateAction(ConstraintActionType constraintActionType) {
        this.updateAction = constraintActionType;
    }

    private static ConstraintUnique getUniqueConstraint(Table table, IndexColumn[] indexColumnArray) {
        ArrayList<Constraint> arrayList = table.getConstraints();
        if (arrayList != null) {
            for (Constraint constraint : arrayList) {
                Constraint.Type type;
                if (constraint.getTable() != table || (type = constraint.getConstraintType()) != Constraint.Type.PRIMARY_KEY && type != Constraint.Type.UNIQUE || !AlterTableAddConstraint.canUseIndex(constraint.getIndex(), table, indexColumnArray, true)) continue;
                return (ConstraintUnique)constraint;
            }
        }
        return null;
    }

    private static Index getIndex(Table table, IndexColumn[] indexColumnArray, boolean bl) {
        ArrayList<Index> arrayList = table.getIndexes();
        if (arrayList != null) {
            for (Index index : arrayList) {
                if (!AlterTableAddConstraint.canUseIndex(index, table, indexColumnArray, bl)) continue;
                return index;
            }
        }
        return null;
    }

    private static boolean canUseIndex(Index index, Table table, IndexColumn[] indexColumnArray, boolean bl) {
        if (index.getTable() != table || (!bl ? index.getCreateSQL() == null : !index.getIndexType().isUnique()) || index.getColumns().length != indexColumnArray.length) {
            return false;
        }
        for (IndexColumn indexColumn : indexColumnArray) {
            if (index.getColumnIndex(indexColumn.column) >= 0) continue;
            return false;
        }
        return true;
    }

    public void setConstraintName(String string) {
        this.constraintName = string;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public void setCheckExpression(Expression expression) {
        this.checkExpression = expression;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public void setIndexColumns(IndexColumn[] indexColumnArray) {
        this.indexColumns = indexColumnArray;
    }

    public IndexColumn[] getIndexColumns() {
        return this.indexColumns;
    }

    public void setRefTableName(Schema schema, String string) {
        this.refSchema = schema;
        this.refTableName = string;
    }

    public void setRefIndexColumns(IndexColumn[] indexColumnArray) {
        this.refIndexColumns = indexColumnArray;
    }

    public void setIndex(Index index) {
        this.index = index;
    }

    public void setRefIndex(Index index) {
        this.refIndex = index;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setCheckExisting(boolean bl) {
        this.checkExisting = bl;
    }

    public void setPrimaryKeyHash(boolean bl) {
        this.primaryKeyHash = bl;
    }
}

