/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.SchemaCommand;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintDomain;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Domain;
import org.h2.schema.Schema;

public class AlterDomainDropConstraint
extends SchemaCommand {
    private String constraintName;
    private String domainName;
    private boolean ifDomainExists;
    private final boolean ifConstraintExists;

    public AlterDomainDropConstraint(Session session, Schema schema, boolean bl) {
        super(session, schema);
        this.ifConstraintExists = bl;
    }

    public void setDomainName(String string) {
        this.domainName = string;
    }

    public void setIfDomainExists(boolean bl) {
        this.ifDomainExists = bl;
    }

    public void setConstraintName(String string) {
        this.constraintName = string;
    }

    @Override
    public int update() {
        this.session.commit(true);
        Domain domain = this.getSchema().findDomain(this.domainName);
        if (domain == null) {
            if (this.ifDomainExists) {
                return 0;
            }
            throw DbException.get(90120, this.domainName);
        }
        Constraint constraint = this.getSchema().findConstraint(this.session, this.constraintName);
        if (constraint == null || constraint.getConstraintType() != Constraint.Type.DOMAIN || ((ConstraintDomain)constraint).getDomain() != domain) {
            if (!this.ifConstraintExists) {
                throw DbException.get(90057, this.constraintName);
            }
        } else {
            this.session.getUser().checkAdmin();
            this.session.getDatabase().removeSchemaObject(this.session, constraint);
        }
        return 0;
    }

    @Override
    public int getType() {
        return 93;
    }
}

