# -*- coding: utf-8 -*-

"""
/***************************************************************************
 ConversorNomesComuns
                                 A QGIS plugin
 This plugin converts common names of tree species to their respective scientific names.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-05-08
        copyright            : (C) 2021 by Antonio Sobral Almeida
        email                : 66124.almeida@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Antonio Sobral Almeida'
__date__ = '2021-05-08'
__copyright__ = '(C) 2021 by Antonio Sobral Almeida'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import (QgsProcessing,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterVectorLayer,
                       QgsProcessingParameterString,
                       QgsProcessingOutputVectorLayer,
                       QgsProcessingParameterEnum)
from qgis import processing
from PyQt5.QtCore import QVariant
from qgis.core import QgsField, QgsFields
from qgis.core import QgsExpression
from qgis.core import QgsVectorLayer, QgsVectorDataProvider
from qgis.PyQt.QtCore import QVariant
from qgis.core import QgsProject, QgsWkbTypes

class ConversorNomesComunsAlgorithm(QgsProcessingAlgorithm): 

    INPUT = 'INPUT'
    OUTPUT = 'OUTPUT'
    CHAVE = 'CHAVE'

    def tr(self, string):
        """
        Returns areas, perimeters and lengths of polygon and line vector layers.
        """
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return ConversorNomesComunsAlgorithm()

    def name(self):
        return 'conversor_nomes_comuns'

    def displayName(self):
        return self.tr('Conversor de nomes comuns')

    def group(self):
        None

    def groupId(self):
        None

    def shortHelpString(self):
        return self.tr("This plugin converts common names of tree species to their respective scientific names. The user chooses a common name from a drop-down list, and the plugin creates two new fields (if they do not already exist), one for the common names and the other for the respective scientific names, and fills in these fields for all features, or only for the selected features. Common and scientific names were taken from listings published by the Portuguese Institute for the Conservation of Nature and Forests. O utilizador escolhe o nome comum numa lista drop-down, e o plugin cria dois novos campos (caso ainda não existam), um para os nomes comuns e o outro para os respectivos nomes científicos, e preenche estes campos para todos os elementos, ou só para os elementos seleccionados. Dados publicados pelo ICNF. Para correr o plugin: Processing -> Toolbox -> Conversores -> Conversor de Nomes Comuns. Consulte o Manual em: https://github.com/Almeida100/Conversor-Nomes-Comuns")

    def initAlgorithm(self, config=None):
        """
        Input layer: any vector layer; Type: Point, Polygon or Line.
        """
        self.addParameter(
            QgsProcessingParameterVectorLayer(
                self.INPUT,
                self.tr('Input layer'),
                [QgsProcessing.TypeVectorPoint,QgsProcessing.TypeVectorLine,QgsProcessing.TypeVectorPolygon]
            )
        )
        self.addOutput(
            QgsProcessingOutputVectorLayer(
                self.OUTPUT,
                self.tr('Output layer')
            )
        )
        # Lists of common (nomes_cm) and sci (nomes_ct) names
        self.nomes_cm = ["Abeto-Branco",  "Abeto-Do-Cáucaso",  "Abeto-Espanhol",  "Abrunheiro",  "Acácia  Cyclops",  "Acácia  Decurrens",  "Acácia  Karroo",  "Acácia  Longifolia",  "Acácia  Mearnsii",  "Acácia  Pycnantha",  "Acácia  Rhetinodes",  "Acácia-De-Dioscorides",  "Aderno-Bastardo",  "Aderno-De-Folhas-Largas",  "Ailanto",  "Albizia",  "Albizia-De-Constantinopla",  "Alfarrobeira",  "Alfenheiro",  "Alfenheiro-Do-Japão",  "Alfenheiro-Oval",  "Amieiro",  "Amieiro-Napolitano",  "Amoreira-Branca",  "Amoreira-Preta",  "Araucária-De-Norfolk",  "Aroeira",  "Árvore-Do-Incenso",  "Austrália",  "Aveleira",  "Azereiro",  "Azereiro-Dos-Danados",  "Azevinho",  "Azinheira",  "Azinheira-Macha",  "Bordo-Comum",  "Bordo-Da-Noruega",  "Borrazeira-Branca",  "Borrazeira-Preta",  "Botoeiro",  "Buxo",  "Cagoiceiro",  "Calocedro",  "Cameciparis-De-Lawson",  "Cameciparis-Hinoqui",  "Caneleiro",  "Canforeira",  "Carrasco",  "Carrasco-Arbóreo",  "Carvalho-Alvarinho",  "Carvalho-De-Monchique",  "Carvalho-Negral",  "Carvalho-Português",  "Carvalho-Turco",  "Carvalho-Vermelho-América rubra",  "Carvalho-Vermelho-América coccinea",  "Carvalho-Vermelho-América palustris",  "Castanheiro",  "Castanheiro-Da-India",  "Castanheiro-Da-India-De-Flores-Rosa",  "Castanheiro-Do-Japão",  "Casuarina-Cavalinha",  "Casuarina-Ténue",  "Catalpa",  "Catapereiro",  "Cedro-Do-Atlas",  "Cedro-Do-Himalaia",  "Cerejeira-Brava",  "Cerejeira-De-Santa-Luzia",  "Cevadilha",  "Choupo-Americano",  "Choupo-Branco",  "Choupo-Híbrido",  "Choupo-Negro",  "Choupo-Tremedor",  "Cipreste-Comum",  "Cipreste-Da-Califórnia",  "Cipreste-Do-Arizona",  "Cipreste-Do-Buçaco",  "Corniso",  "Criptoméria-Do-Japão",  "Escalheiro",  "Espinheiro-Cerval",  "Espinheiro-Da-Virgínia",  "Espruce",  "Espruce-De-Sitka",  "Eucalipto  Botryoides",  "Eucalipto  Camaldulensis",  "Eucalipto  Cladocalyx",  "Eucalipto  Cornuta",  "Eucalipto  Dalrympleana",  "Eucalipto  Diversicolor",  "Eucalipto  Globulus",  "Eucalipto  Grandis",  "Eucalipto  Gunnii",  "Eucalipto  Maidenii",  "Eucalipto  Nitens",  "Eucalipto  Polyanthemos",  "Eucalipto  Resinifera",  "Eucalipto  Robusta",  "Eucalipto  Rudis",  "Eucalipto  Sideroxylon",  "Eucalipto  Smithii",  "Eucalipto x Kirtoniana",  "Eucalipto  Tereticornis",  "Eucalipto x Algeriensis",  "Eucalipto x Trabuti",  "Eucalipto Gomphocephala",  "Eucalipto Obliqua",  "Evonimo",  "Faia",  "Folhado",  "Freixo",  "Freixo-Americano",  "Freixo-Americano",  "Freixo-Europeu",  "Grevilia",  "Guilhomo",  "Haquea-De-Folhas-De-Salgueiro",  "Haquea-Picante",  "Karo",  "Larício-Europeu",  "Larício-Híbrido-De-Dunkeld",  "Lentisco",  "Liquidambar",  "Lódão-Bastardo",  "Loureiro",  "Macieira-Brava",  "Marmeleiro",  "Medronheiro",  "Melaleuca",  "Metrosidero",  "Metrosidero-Robusto",  "Mimosa",  "Mióporo",  "Mostajeiro latifolia",  "Mostajeiro torminalis",  "Mulatas",  "Murta",  "Nogueira",  "Nogueira-Preta",  "Olaia",  "Oxicedro",  "Pacana",  "Padreiro",  "Palmeira-Das-Vassouras",  "Pau-Ferro",  "Paulónia",  "Pereira-Brava",  "Pilriteiro",  "Pimenteira-Bastarda",  "Pimenteira-Do-Brasil",  "Pinheiro-Bravo",  "Pinheiro-Da-Calábria",  "Pinheiro-Das-Canárias",  "Pinheiro-Da-Transcaucásia",  "Pinheiro-De-Alepo",  "Pinheiro-Do-Bispo",  "Pinheiro-Do-Himalaia",  "Pinheiro-Insigne",  "Pinheiro-Larício",  "Pinheiro-Manso",  "Pinheiro-Montanhês",  "Pinheiro-Silvestre",  "Piorno-Branco",  "Piorro",  "Pitósporo-Da-China",  "Plátano",  "Pseudotsuga",  "Robínia",  "Roble",  "Rododendro",  "Sabina-Da-Praia",  "Sabina-Da-Virgínia",  "Sabugueiro",  "Salgueiro-De-Folhas-De-Amendoeira",  "Salgueiro",  "Salgueiro x Erytoclados",  "Salgueiro x Multidentata",  "Salgueiro x Pseudosalviifolia",  "Salgueiro x Rubens",  "Salgueiro (x Secalliana)",  "Salgueiro-Americano",  "Salgueiro-Chorão",  "Salgueiro-Das-Dunas",  "Salgueiro-De-Casca-Roxa",  "Samouco",  "Samouco-Do-Brabante",  "Sanguinho",  "Sequóia",  "Sobreiro",  "Sófora-Do-Japão",  "Sorveira",  "Tamargueira",  "Tamargueira-Rosada",  "Taxódio",  "Teixo",  "Terebinto",  "Tília-De-Folhas-Grandes",  "Tília-De-Folhas-Pequenas",  "Tília-Prateada",  "Totara",  "Tramazeira",  "Tuia-Gigante",  "Tulipeiro-Da-Virgínia",  "Ulmeiro-Das-Montanhas",  "Ulmeiro-De-Folhas-Lisas",  "Urze-Branca",  "Urze-Das-Vassouras",  "Viburno",  "Vidoeiro  Pendula",  "Vidoeiro  Pubescens",  "Vimeiro  Viminalis",  "Vimeiro-Branco",  "Vimeiro-Francês",  "Vimeiro-Vermelho",  "Zambujeiro",  "Zelha",  "Zimbro-Comum" ]   
        self.nomes_ct = ["Abies alba L.", "Abies nordmanniana (Steven) Spach", "Abies pinsapo Boissier", "Prunus spinosa L.", "Acacia cyclops G. Don fil.", "Acacia decurrens (J. C. Wendl.) Willd.", "Acacia karroo Hayne", "Acacia longifolia (Andrews) Willdenow", "Acacia mearnsii De Wild", "Acacia pycnantha Bentham", "Acacia rhetinodes Schlechtendal", "Acacia farnesiana (L.) Willd.", "Rhamnus alaternus L.", "Phillyrea latifolia L.", "Ailanthus altissima (Miller) Swingle", "Albizzia lophanta (Will.) Benth.", "Albizzia julibrissin Durazz.", "Ceratonia siliqua L.", "Ligustrum vulgare L.", "Ligustrum lucidum Aiton f.", "Ligustrum ovalifolium Hasskarl", "Alnus glutinosa (L.) Gaertner", "Alnus cordata Desfontaines", "Morus alba L.", "Morus nigra L.", "Araucaria heterophylla (Salis.) Franco", "Pistacia lentiscus L", "Pittosporum undulatum Ventanat", "Acacia melanoxylon R. Brown", "Corylus avellana L.", "Prunus lusitanica L.", "Prunus padus L.", "Ilex aquifolium L.", "Quercus rotundifolia Lambert", "Quercus x mixta Colm.5", "Acer campestre L.", "Acer platanoides L.", "Salix salviifolia Brotero", "Salix atrocinerea Brotero", "Sorbus aria(L.) Crantz", "Buxus sempervirens L.", "Prunus insititia L.", "Calocedrus decurrens(Torrey) Florin", "Chamaecyparis lawsoniana (Murray) Parl.", "Chamaecyparis obtusa (Sieb. & Zucc.) Endl.", "Viburnum opulus L.", "Cinnamomum camphora (L.) Siebold", "Quercus coccifera L.", "Quercus rivasmartinezii (Capelo & J. C. Costa) Capelo & J. C. Costa", "Quercus robur L.", "Quercus canariensis Willdenow", "Quercus pyrenaica Willdenow", "Quercus faginea Lambert", "Quercus cerris L.", "Quercus rubra L.", "Quercus coccinea Muenchhausen", "Quercus palustris Muenchhausen", "Castanea sativa L.", "Aesculus hippocastanum L.", "Aesculus x carnea Hayne", "Castanea crenataSiebold & Zuccarini", "Casuarina equisetifolia L.", "Casuarina cunninghamiana Miquel", "Catalpa bignonioides Walter", "Pyrus bourgaena Decaisne", "Cedrus atlantica (Endl.) Man. ex Carr.", "Cedrus deodara (Hooker f.) Henry", "Prunus avium L.", "Prunus mahaleb L.", "Nerium oleander L.", "Populus deltoides Marshall", "Populus alba L.", "Populus x canadensis Moenchen", "Populus nigra L.", "Populus tremula L.", "Cupressus sempervirens L.", "Cupressus macrocarpa Hartweg ex Gordon", "Cupressus arizonica Greene", "Cupressus lusitanica Miller", "Cornus sanguinea L.", "Cryptomeria japonica (L. f.) D. Don", "Pyrus cordata Desvaux", "Rhamnus cathartica L.", "Gleditsia triacanthos L.", "Picea abies(L.) Link", "Picea sitchensis (Bongard) Carriere", "Eucalyptus botryoides Smith", "Eucalyptus camaldulensis Dehnhardt", "Eucalyptus cladocalyx Muller", "Eucalyptus cornuta Labillardiere", "Eucalyptus dalrympleana Maiden", "Eucalyptus diversicolor Muller", "Eucalyptus globulus Labillardiere", "Eucalyptus grandis (Hill.) Maiden", "Eucalyptus gunnii Hooker f.", "Eucalyptus maidenii Muller", "Eucalyptus nitens Maiden", "Eucalyptus polyanthemos Schauer", "Eucalyptus resinifera Smith", "Eucalyptus robusta Smith", "Eucalyptus rudis Endl.", "Eucalyptus sideroxylon(A. Cunn.) Benth.", "Eucalyptus smithii R. T. Baker", "Eucalyptu x kirtoniana Muller", "Eucalyptus tereticornis Smith", "Eucalyptus x algeriensis Trabut.", "Eucalyptus x trabuti Vilmorin ex Trabut", "Eucalyptus gomphocephala De Candolle", "Eucalyptus obliqua L’Herit.", "Euonymus europaeus L.", "Fagus sylvatica L.", "Viburnum tinus L.", "Fraxinus angustifolia Vahl", "Fraxinus americana L.", "Fraxinus pennsylvanica Marsh", "Fraxinus excelsior L.", "Grevillea robusta L.", "Amelanchier ovalis Medic.", "Hakea salicifolia (Vent) B.L. Burtt", "Hakea sericea Schrader", "Pittosporum crassifolium A. Cunningham", "Larix decidua Miller", "Larix x eurolepis A. Henry", "Phillyrea angustifolia L.", "Liquidambar styraciflua L.", "Celtis australis L.", "Laurus nobilis L.", "Malus sylvestris(L.) Miller", "Cydonia oblonga Miller", "Arbutus unedo L.", "Melaleuca armilaris Smith", "Metrosiderus excelsus Soland ex Gaertn.", "Metrosiderus robustus A. Cunn.", "Acacia dealbata Link", "Myoporum tetrandrum (Labill.) Domin", "Sorbus latifolia (Lambert) Persoon", "Sorbus torminalis (L.) Crantz", "Myoporum acuminatum R. Br.", "Myrtus communis L.", "Juglans regia L.", "Juglans nigra L.", "Cercis siliquastrum L.", "Juniperus oxycedrus L.", "Carya illinoinensis (Wangenheim) K. Koch", "Acer pseudoplatanus L.", "Chamaerops humilis L.", "Acer negundo L.", "Paulownia tomentosa (Thunberg) Steudel", "Pyrus pyraster Burgsd.", "Crataegus monogyna Jacques", "Schinus molle L.", "Schinus terebenthifolius Raddi", "Pinus pinaster Aiton", "Pinus brutia Tenot", "Pinus canariensis Chr. Sm. ex Buch", "Pinus eldarica Medwedew", "Pinus halepensis Miller", "Pinus muricata D. Don", "Pinus wallichiana Jackson", "Pinus radiata D. Don", "Pinus nigra Arnold", "Pinus pinea L.", "Pinus uncinata Miller ex Mirbel", "Pinus sylvestris L.", "Retama monosperma (L.) Boiss.", "Juniperus navicularis Gand.", "Pittosporum tobira (Thunberg) Aiton", "Platanus x hispanica Muenchenhausen", "Pseudotsuga menziesii (Mirbel) Franco", "Robinia pseudoacacia L.", "Nothofagus obliqua (Mirbel) Blume", "Rhododendron ponticum L. ssp. baeticum(Boiss. & Reuter) Hend.-Mazz.", "Juniperus turbinata Guss.", "Juniperus virginiana L.", "Sambucus nigra L.", "Salix triandra L.", "Salix xerytoclados Simonkai7", "Salix xmultidentata T. E. Diaz & E. Puente8", "Salix x pseudosalviifolia T.E. Diaz & Puente", "Salix x rubens Schrank9", "Salix x secalliana Pau & C. Vicioso11", "Salix caprea L.", "Salix canescens(Aitur) Marshall", "Salix babylonica L.", "Salix arenaria L.", "Salix purpurea L.", "Myrica faya Aiton", "Myrica gale L.", "Frangula alnus Miller", "Sequoia sempervirens (D. Don) Endl.", "Quercus suber L.", "Sophora japonica L.", "Sorbus domestica L.", "Tamarix africana Poiret", "Tamarix canariensis Willdenow", "Taxodium distichum (L.) Richards", "Taxus baccata L.", "Pistacia terebinthus L.", "Tilia platyphyllos Scopoli", "Tilia cordata Miller", "Tilia tomentosa Moenchen", "Podocarpus totara D. Don ex Lambert", "Sorbus aucuparia L.", "Thuja plicata D. Don", "Liriodendron tulipifera L.", "Ulmus glabra Hudson", "Ulmus minor Miller", "Erica arborea L.", "Erica scoparia L.", "Viburnum lantana L.", "Betula pendula Rothwell", "Betula pubescens Ehrhart", "Salix viminalis L.", "Salix alba L.", "Salix fragilis L.", "Salix x rubens Schrank", "Olea europaea L.", "Acer monspessulanum L.", "Juniperus communis L. ssp. nanaSyme" ] 
        # Input enumeration of common names
        self.addParameter(
            QgsProcessingParameterEnum(
                self.CHAVE,
                self.tr('Escolha o nome comum'),
                options= self.nomes_cm  , 
                allowMultiple=False, defaultValue=[]))
    
    def processAlgorithm(self, parameters, context, feedback):
        source = self.parameterAsVectorLayer(
            parameters,
            self.INPUT,
            context
        )
        # Key of chosen common name
        Valores = self.parameterAsEnums(parameters, self.CHAVE, context)
        Val = Valores[0]
        # Check if there is a selection; if yes, apply script only to selected features
        if len (source.selectedFeatures())>0:
            selection = source.selectedFeatures()
        else:
            selection = source.getFeatures()
        # Check if fields for common and sci names already exist on table; if no, create them
        field_name1 = "Nome_comum"
        field_name2 = "Nome_ctfc"
        pr = source.dataProvider()
        if (source.fields().indexFromName(field_name1)<0) :
            attr1 = pr.addAttributes([QgsField('Nome_comum', QVariant.String)])
            source.updateFields()            
        if (source.fields().indexFromName(field_name2)<0) :
            attr2 = pr.addAttributes([QgsField('Nome_ctfc', QVariant.String)]) 
            source.updateFields()   
        # Add chosen common (and corresponding sci) names to attribute table
        caps = pr.capabilities()
        field_index1 = source.fields().indexFromName('Nome_comum')
        field_index2 = source.fields().indexFromName('Nome_ctfc')
        if caps & QgsVectorDataProvider.ChangeAttributeValues:
            attr1 = {field_index1 : (self.nomes_cm [Val])}
            attr2 = {field_index2 : (self.nomes_ct [Val])}
            for feature in selection:
                pr.changeAttributeValues({feature.id() : attr1})
                pr.changeAttributeValues({feature.id() : attr2})      
        source.updateFields()
        source.dataProvider().reloadData()  # Mandatory to let user see the results on open attribute table!
        return {self.OUTPUT: source} 