# -*- coding: utf-8 -*-

"""
/***************************************************************************
 ContourGenerator
                                 A QGIS plugin
 Generates contours from point layer
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2018-04-24
        copyright            : (C) 2018 by Chris Crook
        email                : ccrook@linz.govt.nz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = "Chris Crook"
__date__ = "2018-04-24"
__copyright__ = "(C) 2018 by Chris Crook"

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = "$Format:%H$"

import os
import sys
import inspect

from qgis.core import QgsProcessingAlgorithm, QgsApplication
from .ContourGeneratorProvider import ContourGeneratorProvider
from .ContourDialog import ContourDialogPlugin

cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)


class ContourPlugin(object):

    def __init__(self, iface):
        self.provider = ContourGeneratorProvider()
        self.dialog = ContourDialogPlugin(iface)

    def initGui(self):
        QgsApplication.processingRegistry().addProvider(self.provider)
        self.dialog.initGui()

    def initProcessing(self):
        QgsApplication.processingRegistry().addProvider(self.provider)

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)
        self.dialog.unload()
