# -*- coding: utf-8 -*-

"""
/***************************************************************************
 ContinuousNetworkAnalysis
                                 A QGIS plugin
 Vector network analysis procedures
Network connectivity
Locate sources (geometry independent)
Attribute discontinuity in a network (Attribute must be continuous)
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-07-30
        copyright            : (C) 2024 by Matheus Oliveira de Freitas
        email                : matheus18.1@yahoo.com.br
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Matheus Oliveira de Freitas'
__date__ = '2024-07-30'
__copyright__ = '(C) 2024 by Matheus Oliveira de Freitas'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.core import QgsProcessingProvider
from .Continuous_network_analysis_algorithm import ContinuousNetworkAnalysisAlgorithm
from .NascentesAlgorithm import NascentesAlgorithm
from .ConectividadeAlgorithm import ConectividadeAlgorithm
from .DANGOS_NAO_DANGOS import DANGOS_NAO_DANGOS
from .Dangles import Dangles
from .Ponto_duplo import Pseudo_node_Analysis
from .Cont_numero_vert import Cont_numero_vert
from .Pseudo_node import Pseudo_node


class ContinuousNetworkAnalysisProvider(QgsProcessingProvider):

    def __init__(self):
        """
        Default constructor.
        """
        QgsProcessingProvider.__init__(self)

    def unload(self):
        """
        Unloads the provider. Any tear-down steps required by the provider
        should be implemented here.
        """
        pass

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        """
        self.addAlgorithm(ContinuousNetworkAnalysisAlgorithm())
        self.addAlgorithm(NascentesAlgorithm())
        self.addAlgorithm(ConectividadeAlgorithm())
        self.addAlgorithm(DANGOS_NAO_DANGOS())
        self.addAlgorithm(Dangles())
        self.addAlgorithm(Pseudo_node_Analysis())
        self.addAlgorithm(Cont_numero_vert())
        self.addAlgorithm(Pseudo_node())
        # add additional algorithms here
        # self.addAlgorithm(MyOtherAlgorithm())

    def id(self):
        """
        Returns the unique provider id, used for identifying the provider. This
        string should be a unique, short, character only string, eg "qgis" or
        "gdal". This string should not be localised.
        """
        return 'Continuous_Network_Analysis'

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.

        This string should be short (e.g. "Lastools") and localised.
        """
        return self.tr('Vector Network Analysis')

    def icon(self):
        """
        Should return a QIcon which is used for your provider inside
        the Processing toolbox.
        """
        return QgsProcessingProvider.icon(self)

    def longName(self):
        """
        Returns the a longer version of the provider name, which can include
        extra details such as version numbers. E.g. "Lastools LIDAR tools
        (version 2.2.1)". This string should be localised. The default
        implementation returns the same string as name().
        """
        return self.name()
