# -*- coding: utf-8 -*-

"""
/***************************************************************************
 ContinuousNetworkAnalysis
                                 A QGIS plugin
 Vector network analysis procedures
Network connectivity
Locate sources (geometry independent)
Attribute discontinuity in a network (Attribute must be continuous)
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-07-30
        copyright            : (C) 2024 by Matheus Oliveira de Freitas
        email                : matheus18.1@yahoo.com.br
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Matheus Oliveira de Freitas'
__date__ = '2024-07-30'
__copyright__ = '(C) 2024 by Matheus Oliveira de Freitas'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import (QgsProcessing,
                       QgsFeatureSink,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterFeatureSink,
                       QgsProcessingParameterVectorDestination,
                       QgsProcessingParameterField)
from qgis import processing
from qgis.core import QgsProject
from qgis.core import QgsCoordinateReferenceSystem, QgsProject, QgsWkbTypes,QgsFeature,QgsVectorLayer,QgsProcessingUtils

class ContinuousNetworkAnalysisAlgorithm(QgsProcessingAlgorithm):
    """
    This is an example algorithm that takes a vector layer and
    creates a new identical one.

    It is meant to be used as an example of how to create your own
    algorithms and explain methods and variables used to do it. An
    algorithm like this will be available in all elements, and there
    is not need for additional work.

    All Processing algorithms should extend the QgsProcessingAlgorithm
    class.
    """

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.

    OUTPUT = 'OUTPUT'
    INPUT = 'INPUT'
    FIELD='FIELD'
    def initAlgorithm(self, config):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """

        # We add the input vector features source. It can have any kind of
        # geometry.
        self.addParameter(
            QgsProcessingParameterFeatureSource(
                self.INPUT,
                self.tr('Input layer'),
                [QgsProcessing.TypeVectorLine]
            )
        )
        #Campo
        self.addParameter(
            QgsProcessingParameterField(
                self.FIELD,
                self.tr('Select the attribute column that cannot be stopped'),
                '',
                self.INPUT
            )
        )
        # We add a feature sink in which to store our processed features (this
        # usually takes the form of a newly created vector layer when the
        # algorithm is run in QGIS).
        self.addParameter(
            QgsProcessingParameterFeatureSink(
                self.OUTPUT,
                self.tr('Discontinuity')
            )
        )
    def shortHelpString(self):
        #DEscrever oque ele faz nada muito grande so falar que ele detecta uma descontinuidade de um atribuo 
        return self.tr("English:\n It performs a series of processes to identify discontinuities of a selected attribute within a line-type vector network and generates a file that points out the attribute discontinuities along the network.\nThe accuracy of the final result depends directly on the quality of the network flow — the better the flow, the greater the accuracy.\nPortuguês:\n Realiza uma série de processos para identificar descontinuidades de atributo selecionado dentro de uma rede vetorial do tipo linha e gera um arquivo que aponta as descontinuidades do atributo ao longo da rede.\nA precisão do resultado final depende diretamente da qualidade do fluxo da rede — quanto melhor o fluxo, maior será a precisão.")
        
        
    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        """

        # Retrieve the feature source and sink. The 'dest_id' variable is used
        # to uniquely identify the feature sink, and must be included in the
        # dictionary returned by the processAlgorithm function.
        source = self.parameterAsSource(parameters, self.INPUT, context)
        field_name = self.parameterAsString(parameters, self.FIELD, context)



        a=parameters['FIELD']       
        
        quebra=processing.run("native:splitwithlines", {'INPUT':parameters['INPUT'],
        'LINES':parameters['INPUT'],
        'OUTPUT':'memory:'},context=context, feedback=feedback, is_child_algorithm=True) 
        quebra_ofic=QgsProcessingUtils.mapLayerFromString(quebra['OUTPUT'], context)
        if feedback.isCanceled():
            return {} 
        
        nome=processing.run("native:extractbyexpression",
        {'INPUT': quebra_ofic,
        'EXPRESSION':f'{a} is not null',
        'OUTPUT':'memory:'},context=context, feedback=feedback, is_child_algorithm=True) 
        nome_ofic=QgsProcessingUtils.mapLayerFromString(nome['OUTPUT'], context)
        if feedback.isCanceled():
            return {}
        
        verti_0=processing.run("native:extractspecificvertices",{
        'INPUT':nome_ofic,
        'VERTICES':0,
        'OUTPUT':'memory:'},context=context, feedback=feedback, is_child_algorithm=True) 
        verti_0_ofic=QgsProcessingUtils.mapLayerFromString(verti_0['OUTPUT'], context)
        if feedback.isCanceled():
            return {}

        #Extrair o vertice -1 da camada quebrada a parti dos dissolvidos
        verti_1=processing.run("native:extractspecificvertices",{
        'INPUT':nome_ofic,
        'VERTICES':-1,
        'OUTPUT':'memory:'},context=context, feedback=feedback, is_child_algorithm=True) 
        verti_1_ofic=QgsProcessingUtils.mapLayerFromString(verti_1['OUTPUT'], context)
        if feedback.isCanceled():
            return {}

        #Mesclar (unir) os output dos vertices 0 e -1 
        mescla=processing.run("native:mergevectorlayers",{
        'LAYERS':[verti_0_ofic,verti_1_ofic],
        'OUTPUT':'memory:'},context=context, feedback=feedback, is_child_algorithm=True) 
        mescla_ofic=QgsProcessingUtils.mapLayerFromString(mescla['OUTPUT'], context)
        if feedback.isCanceled():
            return {}
     

        X_Y=processing.run("native:fieldcalculator", 
        {'INPUT':mescla_ofic,
        'FIELD_NAME':'cont',
        'FIELD_LENGTH':0,
        'FIELD_PRECISION':0,
        'FORMULA':'$X + $Y\r\n\r\n',
        'OUTPUT':'memory:'},context=context, feedback=feedback, is_child_algorithm=True) 
        X_Y_ofic=QgsProcessingUtils.mapLayerFromString(X_Y['OUTPUT'], context)
        if feedback.isCanceled():
            return {}
        
        #ver quantas vezes se repete a soma se reperti mais que duas quer dizer que é intercessao
        rep=processing.run("native:fieldcalculator", {'INPUT':X_Y_ofic,
        'FIELD_NAME':'repe',
        'FIELD_TYPE':0,
        'FIELD_LENGTH':0,
        'FIELD_PRECISION':0,
        'FORMULA':'count( "cont","cont" )',
        'OUTPUT':'memory:'},context=context, feedback=feedback, is_child_algorithm=True) 
        rep_ofic=QgsProcessingUtils.mapLayerFromString(rep['OUTPUT'], context)
        if feedback.isCanceled():
            return {}
        
        #Retira os simples
        remov=processing.run("native:extractbyattribute",
        {'INPUT':rep_ofic,
        'FIELD':'repe',
        'OPERATOR':0,
        'VALUE':'1',
        'OUTPUT':'memory:'},context=context, feedback=feedback, is_child_algorithm=True) 
        remov_ofic=QgsProcessingUtils.mapLayerFromString(remov['OUTPUT'], context)
        if feedback.isCanceled():
            return {}
              
        #QgsProject.instance().addMapLayer(remov['OUTPUT'])
        
        #PARTE 2 DO PROGRAMA'
        
        sem_nome=processing.run("native:extractbyexpression",
        {'INPUT': quebra_ofic,
        'EXPRESSION':f'"{a}" is NULL or "{a}"  =\' \'',
        'OUTPUT':'memory:'},context=context, feedback=feedback, is_child_algorithm=True) 
        sem_nome_ofic=QgsProcessingUtils.mapLayerFromString(sem_nome['OUTPUT'], context)
        if feedback.isCanceled():
            return {}

        verti_0_sem=processing.run("native:extractspecificvertices",{
        'INPUT':sem_nome_ofic,
        'VERTICES':0,
        'OUTPUT':'memory:'},context=context, feedback=feedback, is_child_algorithm=True) 
        verti_0_sem_ofic=QgsProcessingUtils.mapLayerFromString(verti_0_sem['OUTPUT'], context)
        if feedback.isCanceled():
            return {}
        
        #Extrair o vertice -1 da camada quebrada a parti dos dissolvidos
        verti_1_sem=processing.run("native:extractspecificvertices",{
        'INPUT':sem_nome_ofic,
        'VERTICES':-1,
        'OUTPUT':'memory:'},context=context, feedback=feedback, is_child_algorithm=True) 
        verti_1_sem_ofic=QgsProcessingUtils.mapLayerFromString(verti_1_sem['OUTPUT'], context)
        if feedback.isCanceled():
            return {}
        
        mescla_sem=processing.run("native:mergevectorlayers",{
        'LAYERS':[verti_0_sem_ofic,verti_1_sem_ofic],
        'OUTPUT':'memory:'},context=context, feedback=feedback, is_child_algorithm=True) 
        mescla_sem_ofic=QgsProcessingUtils.mapLayerFromString(mescla_sem['OUTPUT'], context)
        if feedback.isCanceled():
            return {}
            
        
        #Achar os vertices que sao nascentes, extrair por localizaca (desunidos),  pela os mescla depois e se tem sobreposicao quer dizer que nao é nascente
        nasc_sem1=processing.run("native:extractbylocation",
        {'INPUT':mescla_sem_ofic,
        'INTERSECT':remov_ofic,
        'PREDICATE':[0],
        'OUTPUT':'memory:'},context=context, feedback=feedback, is_child_algorithm=True) 
        nasc_sem1_ofic=QgsProcessingUtils.mapLayerFromString(nasc_sem1['OUTPUT'], context)
        if feedback.isCanceled():
            return {}
        #QgsProject.instance().addMapLayer(nasc_sem1['OUTPUT'])
        
                       
        
        #output = self.parameterAsOutputLayer(parameters, self.OUTPUT, context)
        
        local=processing.run("native:extractbyexpression",
        {'INPUT': nasc_sem1_ofic,
        'EXPRESSION':f'"{a}" is null',
        'OUTPUT':'memory:'},context=context, feedback=feedback, is_child_algorithm=True) 
        local_ofic=QgsProcessingUtils.mapLayerFromString(local['OUTPUT'], context)
        if feedback.isCanceled():
            return {}
        
        nasc_sem_Final=processing.run("native:deleteduplicategeometries", {'INPUT':local_ofic,
        'OUTPUT':'memory:'},context=context, feedback=feedback, is_child_algorithm=True) 
        nasc_sem_Final_ofic=QgsProcessingUtils.mapLayerFromString(nasc_sem_Final['OUTPUT'], context)
        if feedback.isCanceled():
            return {}
            
        ExtrairPorExpresso1=processing.run('native:extractbyexpression',{
            'EXPRESSION': '"nome" is not null',
            'INPUT': parameters['INPUT'],
            'FAIL_OUTPUT': 'memory:',
            'OUTPUT': 'memory:'})
        
        #outputs['ExtrairPorExpresso1'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)    
        
        ExtrairVrticesEspecficos1SemNome=processing.run('native:extractspecificvertices',{
            'INPUT': ExtrairPorExpresso1['FAIL_OUTPUT'],
            'VERTICES': '-1',
            'OUTPUT': 'memory:'},context=context, feedback=feedback, is_child_algorithm=True) 
        ExtrairVrticesEspecficos1SemNome_ofic=QgsProcessingUtils.mapLayerFromString(ExtrairVrticesEspecficos1SemNome['OUTPUT'], context)
        if feedback.isCanceled():
            return {}
        
        #outputs['ExtrairVrticesEspecficos1SemNome'] = processing.run('native:extractspecificvertices', alg_params, context=context, feedback=feedback, is_child_algorithm=True)


        # Extrair vértices específicos_sem_nome_0
        ExtrairVrticesEspecficos_sem_nome_0=processing.run('native:extractspecificvertices',{
            'INPUT': ExtrairPorExpresso1['FAIL_OUTPUT'],
            'VERTICES': '0',
            'OUTPUT':'memory:'},context=context, feedback=feedback, is_child_algorithm=True) 
        ExtrairVrticesEspecficos_sem_nome_0_ofic=QgsProcessingUtils.mapLayerFromString(ExtrairVrticesEspecficos_sem_nome_0['OUTPUT'], context)
        if feedback.isCanceled():
            return {}
        
        
        #outputs['ExtrairVrticesEspecficos_sem_nome_0'] = processing.run('native:extractspecificvertices', alg_params, context=context, feedback=feedback, is_child_algorithm=True)



        # Extrair vértices específicos_com_nome_-1
        ExtrairVrticesEspecficos_com_nome_1 =processing.run('native:extractspecificvertices',{
            'INPUT': ExtrairPorExpresso1['OUTPUT'],
            'VERTICES': '-1',
            'OUTPUT': 'memory:'},context=context, feedback=feedback, is_child_algorithm=True) 
        ExtrairVrticesEspecficos_com_nome_1_ofic=QgsProcessingUtils.mapLayerFromString(ExtrairVrticesEspecficos_com_nome_1['OUTPUT'], context)
        if feedback.isCanceled():
            return {}
        
        #outputs['ExtrairVrticesEspecficos_com_nome_1'] = processing.run('native:extractspecificvertices', alg_params, context=context, feedback=feedback, is_child_algorithm=True)


        # Extrair vértices específicos_com_nome_0
        ExtrairVrticesEspecficos_com_nome_0 =processing.run('native:extractspecificvertices', {
            'INPUT': ExtrairPorExpresso1['OUTPUT'],
            'VERTICES': '0',
            'OUTPUT': 'memory:'},context=context, feedback=feedback, is_child_algorithm=True) 
        ExtrairVrticesEspecficos_com_nome_0_ofic=QgsProcessingUtils.mapLayerFromString(ExtrairVrticesEspecficos_com_nome_0['OUTPUT'], context)
        if feedback.isCanceled():
            return {}
        
        #outputs['ExtrairVrticesEspecficos_com_nome_0'] = processing.run('native:extractspecificvertices', alg_params, context=context, feedback=feedback, is_child_algorithm=True)



        # Extrair por localização_Nascente
        ExtrairPorLocalizao_nascente=processing.run('native:extractbylocation', {
            'INPUT':ExtrairVrticesEspecficos_com_nome_0_ofic,
            'INTERSECT': ExtrairVrticesEspecficos_com_nome_1_ofic,
            'PREDICATE': [2],  
            'OUTPUT':'memory:'},context=context, feedback=feedback, is_child_algorithm=True) 
        ExtrairPorLocalizao_nascente_ofic=QgsProcessingUtils.mapLayerFromString(ExtrairPorLocalizao_nascente['OUTPUT'], context)
        if feedback.isCanceled():
            return {}
        
        #outputs['ExtrairPorLocalizao_nascente'] = processing.run('native:extractbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)



        # Interseção vert_-1_sem_nome_-1_com_nome
        InterseoVert_1_sem_nome_1_com_nome =processing.run('native:intersection', {
            'INPUT': ExtrairVrticesEspecficos1SemNome_ofic,
            'INPUT_FIELDS': [''],
            'OVERLAY': ExtrairVrticesEspecficos_com_nome_1_ofic,
            'OVERLAY_FIELDS': [''],
            'OVERLAY_FIELDS_PREFIX': '',
            'OUTPUT': 'memory:'},context=context, feedback=feedback, is_child_algorithm=True) 
        InterseoVert_1_sem_nome_1_com_nome_ofic=QgsProcessingUtils.mapLayerFromString(InterseoVert_1_sem_nome_1_com_nome['OUTPUT'], context)
        if feedback.isCanceled():
            return {}
        
        #outputs['InterseoVert_1_sem_nome_1_com_nome'] = processing.run('native:intersection', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        # Extrair por localização_1
        ExtrairPorLocalizao_1 =processing.run('native:extractbylocation', {
            'INPUT': ExtrairVrticesEspecficos_com_nome_1_ofic,
            'INTERSECT': ExtrairVrticesEspecficos_com_nome_0_ofic,
            'PREDICATE': [2],  
            'OUTPUT': 'memory:'},context=context, feedback=feedback, is_child_algorithm=True) 
        ExtrairPorLocalizao_1_ofic=QgsProcessingUtils.mapLayerFromString(ExtrairPorLocalizao_1['OUTPUT'], context)
        if feedback.isCanceled():
            return {}
        
        #outputs['ExtrairPorLocalizao_1'] = processing.run('native:extractbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)


        # Extrair por localização oi
        ExtrairPorLocalizaoOi =processing.run('native:extractbylocation', {
            'INPUT': ExtrairPorLocalizao_1_ofic,
            'INTERSECT':ExtrairPorLocalizao_nascente_ofic,
            'PREDICATE': [2],  # desunidos
            'OUTPUT': 'memory:'},context=context, feedback=feedback, is_child_algorithm=True) 
        ExtrairPorLocalizaoOi_ofic=QgsProcessingUtils.mapLayerFromString(ExtrairPorLocalizaoOi['OUTPUT'], context)
        if feedback.isCanceled():
            return {}
        
        #outputs['ExtrairPorLocalizaoOi'] = processing.run('native:extractbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)


        # Extrair por localizaçãover_-1_sem_nome_-1_com_nome_vs_0_com_nome
        ExtrairPorLocalizaover_1_sem_nome_1_com_nome_vs_0_com_nome =processing.run('native:extractbylocation', {
            'INPUT': InterseoVert_1_sem_nome_1_com_nome_ofic,
            'INTERSECT': ExtrairVrticesEspecficos_com_nome_0_ofic,
            'PREDICATE': [2],  # desunidos
            'OUTPUT': 'memory:'},context=context, feedback=feedback, is_child_algorithm=True) 
        ExtrairPorLocalizaover_1_sem_nome_1_com_nome_vs_0_com_nome_ofic=QgsProcessingUtils.mapLayerFromString(ExtrairPorLocalizaover_1_sem_nome_1_com_nome_vs_0_com_nome['OUTPUT'], context)
        if feedback.isCanceled():
            return {}
        

        # Extrair por localização06
        ExtrairPorLocalizao06 =processing.run('native:extractbylocation', {
            'INPUT':ExtrairPorLocalizaoOi_ofic,
            'INTERSECT': ExtrairVrticesEspecficos_com_nome_0_ofic,
            'PREDICATE': [2],  
            'OUTPUT': 'memory:'},context=context, feedback=feedback, is_child_algorithm=True) 
        ExtrairPorLocalizao06_ofic=QgsProcessingUtils.mapLayerFromString(ExtrairPorLocalizao06['OUTPUT'], context)
        if feedback.isCanceled():
            return {}
        
        #outputs['ExtrairPorLocalizao06'] = processing.run('native:extractbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        #Nao
        # Remover duplicatas pelo atributo-1-1+0
        RemoverDuplicatasPeloAtributo110=processing.run('native:removeduplicatesbyattribute', {
            'FIELDS': ['id'],
            'INPUT': ExtrairPorLocalizaover_1_sem_nome_1_com_nome_vs_0_com_nome_ofic,
            'DUPLICATES': 'memory:',
            'OUTPUT': 'memory:'})
        
        #outputs['RemoverDuplicatasPeloAtributo110'] = processing.run('native:removeduplicatesbyattribute', alg_params, context=context, feedback=feedback, is_child_algorithm=True)






        # Extrair por localização final
        ExtrairPorLocalizaoFinal =processing.run('native:extractbylocation', {
            'INPUT': ExtrairPorLocalizao06_ofic,
            'INTERSECT': ExtrairVrticesEspecficos_sem_nome_0_ofic,
            'PREDICATE': [0], 
            'OUTPUT': 'memory:'},context=context, feedback=feedback, is_child_algorithm=True) 
        ExtrairPorLocalizaoFinal_ofic=QgsProcessingUtils.mapLayerFromString(ExtrairPorLocalizaoFinal['OUTPUT'], context)
        if feedback.isCanceled():
            return {}
        #outputs['ExtrairPorLocalizaoFinal'] = processing.run('native:extractbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)


        #NAO
        # Remover duplicatas pelo atributo final2
        RemoverDuplicatasPeloAtributoFinal2=processing.run('native:removeduplicatesbyattribute', {
            'FIELDS': 'nome; vertex_pos',
            'INPUT': ExtrairPorLocalizaoFinal_ofic,
            'DUPLICATES':'memory:',
            'OUTPUT': 'memory:'
        })
        #outputs['RemoverDuplicatasPeloAtributoFinal2'] = processing.run('native:removeduplicatesbyattribute', alg_params, context=context, feedback=feedback, is_child_algorithm=True)




        # Amortecedor
        Amortecedor=processing.run('native:buffer', {
            'DISSOLVE': False,
            'DISTANCE': 1e-05,
            'END_CAP_STYLE': 0,  # Arredondado
            'INPUT': ExtrairPorLocalizaoFinal_ofic,
            'JOIN_STYLE': 0,  # Arredondado
            'MITER_LIMIT': 2,
            'SEGMENTS': 5,
            'OUTPUT': 'memory:'},context=context, feedback=feedback, is_child_algorithm=True) 
        Amortecedor_ofic=QgsProcessingUtils.mapLayerFromString(Amortecedor['OUTPUT'], context)
        if feedback.isCanceled():
            return {}
        #outputs['Amortecedor'] = processing.run('native:buffer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        # Interseção 
        Interseo=processing.run('native:intersection', {
            'INPUT': ExtrairPorLocalizaoFinal_ofic,
            'INPUT_FIELDS': [''],
            'OVERLAY': Amortecedor_ofic,
            'OVERLAY_FIELDS': [''],
            'OVERLAY_FIELDS_PREFIX': '',
            'OUTPUT': 'memory:'},context=context, feedback=feedback, is_child_algorithm=True) 
        Interseo_ofic=QgsProcessingUtils.mapLayerFromString(Interseo['OUTPUT'], context)
        if feedback.isCanceled():
            return {}
        #outputs['Interseo'] = processing.run('native:intersection', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        # Contagem de pontos em polígono
        ContagemDePontosEmPolgono =processing.run('native:countpointsinpolygon', {
            'CLASSFIELD': '',
            'FIELD': 'NUMPOINTS',
            'POINTS': ExtrairPorLocalizaoFinal_ofic,
            'POLYGONS':Amortecedor_ofic,
            'WEIGHT': '',
            'OUTPUT': 'memory:'},context=context, feedback=feedback, is_child_algorithm=True) 
        ContagemDePontosEmPolgono_ofic=QgsProcessingUtils.mapLayerFromString(ContagemDePontosEmPolgono['OUTPUT'], context)
        if feedback.isCanceled():
            return {}
        #outputs['ContagemDePontosEmPolgono'] = processing.run('native:countpointsinpolygon', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        # 0Extrair por expressão 000000000000000000000000000000000000000000000000
        ExtrairPorExpresso0000000 = processing.run('native:extractbyexpression',{
            'EXPRESSION': '"nome" !="nome_2"',
            'INPUT': Interseo_ofic,
            'OUTPUT': 'memory:'},context=context, feedback=feedback, is_child_algorithm=True) 
        ExtrairPorExpresso0000000_ofic=QgsProcessingUtils.mapLayerFromString(ExtrairPorExpresso0000000['OUTPUT'], context)
        if feedback.isCanceled():
            return {}
        #outputs['ExtrairPorExpresso000000000000000000000000000000000000000000000000'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        # Extrair por atributo_agora
        ExtrairPorAtributo_agora =processing.run('native:extractbyattribute', {
            'FIELD': 'NUMPOINTS',
            'INPUT': ContagemDePontosEmPolgono_ofic,
            'OPERATOR': 0,  # =
            'VALUE': '1',
            'OUTPUT': 'memory:'},context=context, feedback=feedback, is_child_algorithm=True) 
        ExtrairPorAtributo_agora_ofic=QgsProcessingUtils.mapLayerFromString(ExtrairPorAtributo_agora['OUTPUT'], context)
        if feedback.isCanceled():
            return {}
        #outputs['ExtrairPorAtributo_agora'] = processing.run('native:extractbyattribute', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        # Extrair por localização_contagem
        ExtrairPorLocalizao_contagem = processing.run('native:extractbylocation',{
            'INPUT': ExtrairPorLocalizaoFinal_ofic,
            'INTERSECT': ExtrairPorAtributo_agora_ofic,
            'PREDICATE': [0], 
            'OUTPUT': 'memory:'},context=context, feedback=feedback, is_child_algorithm=True) 
        ExtrairPorLocalizao_contagem_ofic=QgsProcessingUtils.mapLayerFromString(ExtrairPorLocalizao_contagem['OUTPUT'], context)
        if feedback.isCanceled():
            return {}
        #outputs['ExtrairPorLocalizao_contagem'] = processing.run('native:extractbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)


        # Excluir geometrias duplicadas009
        ExcluirGeometriasDuplicadas009 =processing.run('native:deleteduplicategeometries', {
            'INPUT': ExtrairPorExpresso0000000_ofic,
            'OUTPUT': 'memory:'},context=context, feedback=feedback, is_child_algorithm=True) 
        ExcluirGeometriasDuplicadas009_ofic=QgsProcessingUtils.mapLayerFromString(ExcluirGeometriasDuplicadas009['OUTPUT'], context)
        if feedback.isCanceled():
            return {}
        #outputs['ExcluirGeometriasDuplicadas009'] = processing.run('native:deleteduplicategeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)


        #MEsclar
        a01=processing.run("native:mergevectorlayers",{
        'LAYERS':[ExtrairPorLocalizao_contagem_ofic,ExcluirGeometriasDuplicadas009['OUTPUT']],
        'OUTPUT':'memory:'},context=context, feedback=feedback, is_child_algorithm=True) 
        a01_ofic=QgsProcessingUtils.mapLayerFromString(a01['OUTPUT'], context)
        if feedback.isCanceled():
            return {}
            
        #output = self.parameterAsOutputLayer(parameters, self.OUTPUT, context)
        fil_1=processing.run("native:mergevectorlayers",{
        'LAYERS':[a01_ofic,nasc_sem_Final_ofic],
        'OUTPUT':'memory:'},context=context, feedback=feedback, is_child_algorithm=True) 
        fil_1_ofic=QgsProcessingUtils.mapLayerFromString(fil_1['OUTPUT'], context)
        if feedback.isCanceled():
            return {}
        
        fil_2=processing.run('native:deleteduplicategeometries', {
            'INPUT': fil_1_ofic,
            'OUTPUT':'memory:'},context=context, feedback=feedback, is_child_algorithm=True) 
        fil_2_ofic=QgsProcessingUtils.mapLayerFromString(fil_2['OUTPUT'], context)
        if feedback.isCanceled():
            return {}
            
        (sink, dest_id) = self.parameterAsSink(parameters, self.OUTPUT, context, fil_2_ofic.fields(), fil_2_ofic.wkbType(), fil_2_ofic.sourceCrs())

            
        for feature in fil_2_ofic.getFeatures():
            geom = feature.geometry()
            new_feature = QgsFeature()
            new_feature.setGeometry(geom)
            new_feature.setAttributes(feature.attributes())
            sink.addFeature(new_feature)            

        
        
        return {'OUTPUT':dest_id}    





    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'Attribute Discontinuity Detector'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr(self.name())

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr(self.groupId())

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return ''

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return ContinuousNetworkAnalysisAlgorithm()
