# -*- coding: utf-8 -*-

"""
/***************************************************************************
 ContinuousNetworkAnalysis
                                 A QGIS plugin
 Vector network analysis procedures
Network connectivity
Locate sources (geometry independent)
Attribute discontinuity in a network (Attribute must be continuous)
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-07-30
        copyright            : (C) 2024 by Matheus Oliveira de Freitas
        email                : matheus18.1@yahoo.com.br
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Matheus Oliveira de Freitas'
__date__ = '2024-07-30'
__copyright__ = '(C) 2024 by Matheus Oliveira de Freitas'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
import sys
import inspect

from qgis.core import QgsProcessingAlgorithm, QgsApplication
from .Continuous_network_analysis_provider import ContinuousNetworkAnalysisProvider

cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)


class ContinuousNetworkAnalysisPlugin(object):

    def __init__(self):
        self.provider = None

    def initProcessing(self):
        """Init Processing provider for QGIS >= 3.8."""
        self.provider = ContinuousNetworkAnalysisProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def initGui(self):
        self.initProcessing()

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)
