# -*- coding: utf-8 -*-
"""
consolidatenetworks
/***************************************************************************
ConsolidateNetworks
A QGIS plugin
Consolidate Networks
Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-02-25
        git sha              : $Format:%H$
        copyright            : (C) 2022 by Simon Ducournau
        email                : imagodata+consolidate_networks@skiff.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
from qgis.core import QgsApplication
from qgis.utils import iface
# Initialize Qt resources from file resources.py
from .resources import *
from functools import partial
# Import the code for the DockWidget
import processing
from .processing.library.consolidate_networks.consolidate_networks_provider import ConsolidateNetworksProvider
import os.path




class ConsolidateNetworksManager:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface

        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)

        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'ConsolidateNetworks_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        #self.menu = self.tr(u'&Consolidate Networks')
        # TODO: We are going to let the user set this up in a future iteration


        self.first_start = None

        self.provider = None
        self.initProcessing()

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Consolidate Networks', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """


        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(partial(callback, status_tip))
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            if hasattr(self.iface,  "addPluginToVectorMenu"):
                self.iface.addPluginToVectorMenu(self.menuLabel, action)
            else:
                self.iface.addPluginToMenu(self.menuLabel, action)

        self.actions.append(action)

        return action

    def initProcessing(self):
        """Init Processing provider for QGIS >= 3.8."""

        self.provider_cn = ConsolidateNetworksProvider()
        QgsApplication.processingRegistry().addProvider(self.provider_cn)



    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""
        
    
        # Add toolbar button and menu item
        self.menuLabel = QtWidgets.QApplication.translate("CNLabel", "&Consolidate Networks")

        icon_path = ':/plugins/consolidate_networks/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Consolidate Networks'),
            callback=self.run_algs,
            add_to_menu=False,
            add_to_toolbar=True,
            status_tip='model:cn.sefl-repair',
            whats_this='model:cn.sefl-repair',
            parent=self.iface.mainWindow())
        
        self.add_action(
            icon_path,
            text=self.tr(u'Auto-repair pipeline'),
            callback=self.run_algs,
            add_to_menu=True,
            add_to_toolbar=False,
            status_tip='model:cn.sefl-repair',
            whats_this='model:cn.sefl-repair',
            parent=self.iface.mainWindow())
        

        self.add_action(
            icon_path,
            text=self.tr(u'Cut and extend end lines from a layer source within a buffer'),
            callback=self.run_algs,
            add_to_menu=True,
            add_to_toolbar=False,
            status_tip='cn:endpointstrimmingextending',
            whats_this='cn:endpointstrimmingextending',
            parent=self.iface.mainWindow())
        
        self.add_action(
            icon_path,
            text=self.tr(u'Snap lines endpoints'' to each other''s from a layer source within a buffer'),
            callback=self.run_algs,
            add_to_menu=True,
            add_to_toolbar=False,
            status_tip='cn:endpointssnapping',
            whats_this='cn:endpointssnapping',
            parent=self.iface.mainWindow())
        
        self.add_action(
            icon_path,
            text=self.tr(u'Snap lines endpoints'' to each other''s from an other layer source within a buffer'),
            callback=self.run_algs,
            add_to_menu=True,
            add_to_toolbar=False,
            status_tip='cn:snapendpointstoLayer',
            whats_this='cn:snapendpointstoLayer',
            parent=self.iface.mainWindow())
        
        self.add_action(
            icon_path,
            text=self.tr(u'Align lines vertices'' hubs on top of each other within a buffer'),
            callback=self.run_algs,
            add_to_menu=True,
            add_to_toolbar=False,
            status_tip='cn:hubsnapping',
            whats_this='cn:hubsnapping',
            parent=self.iface.mainWindow())
        
        self.add_action(
            icon_path,
            text=self.tr(u'Align lines vertices'' hubs on top of an other layer source within a buffer'),
            callback=self.run_algs,
            add_to_menu=True,
            add_to_toolbar=False,
            status_tip='cn:snaphubspointstolayer',
            whats_this='cn:snaphubspointstolayer',
            parent=self.iface.mainWindow())
        
        
        self.add_action(
            icon_path,
            text=self.tr(u'Calculate dbscan clusters of lines from a layer source'),
            callback=self.run_algs,
            add_to_menu=True,
            add_to_toolbar=False,
            status_tip='cn:calculatedbscan',
            whats_this='cn:calculatedbscan',
            parent=self.iface.mainWindow())
        
        self.add_action(
            icon_path,
            text=self.tr(u'Snap lines to each other splitting by their clusters from a layer source resulted from cn.calculatedbscan'),
            callback=self.run_algs,
            add_to_menu=True,
            add_to_toolbar=False,
            status_tip='cn:consolidatewithdbscan',
            whats_this='cn:consolidatewithdbscan',
            parent=self.iface.mainWindow())
        
        self.add_action(
            icon_path,
            text=self.tr(u'Insert missing vertices from a source layer'),
            callback=self.run_algs,
            add_to_menu=True,
            add_to_toolbar=False,
            status_tip='cn:makeintersectionsvertexes',
            whats_this='cn:makeintersectionsvertexes',
            parent=self.iface.mainWindow())
        

        

        
        self.first_start = True


    #--------------------------------------------------------------------------





    def run_algs(self, name):
        """Run the different algorithms from cn provider"""
        
        processing.execAlgorithmDialog(name)

    def open_file(self, path):

        os.startfile(path)



    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            if hasattr(self.iface, "removePluginVectorMenu"):
                self.iface.removePluginVectorMenu(self.menuLabel,action)
            else:
                self.iface.removePluginMenu(self.menuLabel, action)
            self.iface.removeToolBarIcon(action)
        try:
            """Unload the differents processing providers"""
            QgsApplication.processingRegistry().removeProvider(self.provider_cn)
       
        except:
            pass
    #--------------------------------------------------------------------------

    def run(self):
        """Run method that loads and starts the plugin"""

        if self.first_start == True:
            
            modup = self.plugin_dir + os.sep + 'operating_mode' + os.sep + 'Operating mode CN.docx'
            self.run_algs('model:cn.sefl-repair')
            

        
