# -*- coding: utf-8 -*-

"""
/***************************************************************************

                                 Consolidate Networks QGIS plugin

 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-11-15
        copyright            : (C) 2021 by a
        email                : a
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Simon Ducournau'
__date__ = '2021-11-15'
__copyright__ = '(C) 2021 by Simon Ducournau'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import *
import math
from qgis import processing
from qgis.processing import alg
from datetime import datetime

class CalculateDbscan(QgsProcessingAlgorithm):
    """
    Calculate dbscan clusters of lines from a layer source.
    """

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.
    OUTPUT = 'OUTPUT'
    INPUT = 'INPUT'


    def initAlgorithm(self, config):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """

        # We add the input vector features source. It can have any kind of
        # geometry.
        self.addParameter(
            QgsProcessingParameterFeatureSource(
                self.INPUT,
                self.tr('INPUT'),
                [QgsProcessing.TypeVectorLine, QgsProcessing.TypeVectorPolygon]
            )
        )

        self.addParameter(
            QgsProcessingParameterBoolean(
                self.tr('FIX_GEOMETRIES_BEFORE_PROCESSING'),
                self.tr('FIX GEOMETRIES BEFORE PROCESSING'),
                True,
                True
            )
        )

        self.addParameter(
            QgsProcessingParameterDistance(
                self.tr('POINTS_DBSCAN_THRESHOLD_DISTANCE'),
                self.tr('POINTS DBCAN THRESHOLD DISTANCE'),
                0.1,
                self.INPUT,
                False,
                0.0
            )
        )

        self.addParameter(
            QgsProcessingParameterBoolean(
                self.tr('DBSCAN*'),
                self.tr('DBSCAN*'),
                False,
                True
            )
        )

        self.addParameter(
            QgsProcessingParameterBoolean(
                self.tr('PRINT_DEBUG'),
                self.tr('PRINT DEBUG'),
                False,
                True
            )
        )


        # We add a feature sink in which to store our processed features (this
        # usually takes the form of a newly created vector layer when the
        # algorithm is run in QGIS).



        self.addParameter(
            QgsProcessingParameterFeatureSink(
                self.OUTPUT,
                self.tr('OUTPUT')
            )
        )

    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        """
        source = self.parameterAsSource(parameters, self.INPUT, context)

        numfeatures = source.featureCount()

        fix_geoms_flag = self.parameterAsBool(parameters, 'FIX_GEOMETRIES_BEFORE_PROCESSING',
                                                context)

        points_dbscan = self.parameterAsDouble(parameters, 'POINTS_DBSCAN_THRESHOLD_DISTANCE',
                                                context)
        
        dbscan_ = self.parameterAsBool(parameters, 'DBSCAN*',
                                                context)

        print_debug_flag = self.parameterAsBool(parameters, 'PRINT_DEBUG',
                                        context)

        start_timer = datetime.now()

        outputs = {}

        if fix_geoms_flag is True:

            alg_params_fixgeometries = {
                "INPUT": source.materialize(QgsFeatureRequest()),
                "METHOD": 1,
                "OUTPUT": QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_fixgeometries'] = processing.run("qgis:fixgeometries", alg_params_fixgeometries, context=context,  feedback=feedback)


            alg_params_unipart = {
            'INPUT': outputs['alg_params_fixgeometries']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_unipart'] = processing.run("qgis:multiparttosingleparts", alg_params_unipart, context=context,  feedback=feedback)
        
        else:

            alg_params_unipart = {
            'INPUT': source.materialize(QgsFeatureRequest()),
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_unipart'] = processing.run("qgis:multiparttosingleparts", alg_params_unipart, context=context,  feedback=feedback)


        #create points from polylines intersections
        alg_params_pointsalonglines = {

        'DISTANCE': points_dbscan,
        'END_OFFSET': 0,
        'INPUT': outputs['alg_params_unipart']['OUTPUT'],
        'START_OFFSET': 0,
        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT


        }
        outputs['alg_params_pointsalonglines'] = processing.run('qgis:pointsalonglines', alg_params_pointsalonglines,context=context, feedback=feedback)


        if feedback.isCanceled():
            return {}

        alg_params_dbscanclustering = {

        'DBSCAN*': dbscan_,
        'EPS': 1,
        'FIELD_NAME': 'CLUSTER_ID',
        'INPUT': outputs['alg_params_pointsalonglines']['OUTPUT'],
        'MIN_SIZE': 5,
        'SIZE_FIELD_NAME': 'CLUSTER_SIZE',
        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT



        }
        outputs['alg_params_dbscanclustering'] = processing.run('qgis:dbscanclustering', alg_params_dbscanclustering,context=context, feedback=feedback)

        if feedback.isCanceled():
            return {}


        outputs['alg_params_unipart']['OUTPUT'].dataProvider().createSpatialIndex()
        outputs['alg_params_dbscanclustering']['OUTPUT'].dataProvider().createSpatialIndex()

        alg_params_joinattributesbylocation = {
        'DISCARD_NONMATCHING': False,
        'JOIN_FIELDS': ['CLUSTER_ID','CLUSTER_SIZE'],
        'INPUT': outputs['alg_params_unipart']['OUTPUT'],
        'JOIN': outputs['alg_params_dbscanclustering']['OUTPUT'],
        'PREDICATE': 0,
        'METHOD':2,
        'PREFIX': '',
        'OUTPUT' : QgsProcessing.TEMPORARY_OUTPUT
        }

        outputs['alg_params_joinattributesbylocation'] = processing.run('qgis:joinattributesbylocation', alg_params_joinattributesbylocation,context=context, feedback=feedback)

        layer = outputs['alg_params_joinattributesbylocation']['OUTPUT']

            
        (sink_output, dest_output) = self.parameterAsSink(parameters, self.OUTPUT,
                context, layer.fields(), layer.wkbType(), layer.sourceCrs())
        
        numfeatures = layer.featureCount()

        for y, feature in enumerate(layer.getFeatures()):
            output_feature = QgsFeature(feature)
            sink_output.addFeature(output_feature, QgsFeatureSink.FastInsert)
            
        end_timer = datetime.now() - start_timer

        #feedback.pushInfo('cn.' + self.name() + ' : ' + self.displayName() + " took {} seconds to calculate.".format(end_timer.strftime("%H:%M:%S")))


        return {'OUTPUT': self.OUTPUT,
                'NUMBEROFFEATURES': numfeatures}

    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'calculatedbscan'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return 'Calculate dbscan clusters of lines from a layer source'

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr(self.groupId())

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'DBscan and consolidate'

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return CalculateDbscan()


class ConsolidateWithDbscan(QgsProcessingAlgorithm):
    """
    Snap lines to each other splitting by their clusters from a layer source resulted from CalculateDbscan().
    """

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.
    OUTPUT = 'OUTPUT'
    INPUT = 'INPUT'


    def initAlgorithm(self, config):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """

        # We add the input vector features source. It can have any kind of
        # geometry.
        self.addParameter(
            QgsProcessingParameterFeatureSource(
                self.INPUT,
                self.tr('INPUT'),
                [QgsProcessing.TypeVectorAnyGeometry]
            )
        )

        self.addParameter(
            QgsProcessingParameterBoolean(
                self.tr('FIX_GEOMETRIES_BEFORE_PROCESSING'),
                self.tr('FIX GEOMETRIES BEFORE PROCESSING'),
                True,
                True
            )
        )

        self.addParameter(
            QgsProcessingParameterDistance(
                self.tr('BUFFER_DBSCAN'),
                self.tr('BUFFER DBSCAN'),
                10.0,
                self.INPUT,
                False,
                0.0
            )
        )

        self.addParameter(
            QgsProcessingParameterBoolean(
                self.tr('PRINT_DEBUG'),
                self.tr('PRINT DEBUG'),
                False,
                True
            )
        )
        # We add a feature sink in which to store our processed features (this
        # usually takes the form of a newly created vector layer when the
        # algorithm is run in QGIS).



        self.addParameter(
            QgsProcessingParameterFeatureSink(
                self.OUTPUT,
                self.tr('OUTPUT')
            )
        )

    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        """
        source = self.parameterAsSource(parameters, self.INPUT, context)

        (sink_output, dest_output) = self.parameterAsSink(
        parameters, self.OUTPUT, context,
        source.fields(), source.wkbType(), source.sourceCrs())


        numfeatures = source.featureCount()

        fix_geoms_flag = self.parameterAsBool(parameters, 'FIX_GEOMETRIES_BEFORE_PROCESSING',
                                        context)

        buffer_snap_dbscan   = self.parameterAsDouble(parameters, 'BUFFER_DBSCAN',
                                                context)

        print_debug_flag = self.parameterAsBool(parameters, 'PRINT_DEBUG',
                                        context)
        
        start_timer = datetime.now()

        outputs = {}
        
        if fix_geoms_flag is True:

            alg_params_fixgeometries = {
                "INPUT": source.materialize(QgsFeatureRequest()),
                "METHOD": 1,
                "OUTPUT": QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_fixgeometries'] = processing.run("qgis:fixgeometries", alg_params_fixgeometries, context=context,  feedback=feedback)


            alg_params_unipart = {
            'INPUT': outputs['alg_params_fixgeometries']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_unipart'] = processing.run("qgis:multiparttosingleparts", alg_params_unipart, context=context,  feedback=feedback)
        
        else:

            alg_params_unipart = {
            'INPUT': source.materialize(QgsFeatureRequest()),
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_unipart'] = processing.run("qgis:multiparttosingleparts", alg_params_unipart, context=context,  feedback=feedback)


        layer = outputs['alg_params_unipart']['OUTPUT']


        request = QgsFeatureRequest()
        clause = QgsFeatureRequest().OrderByClause('"CLUSTER_SIZE"', ascending=True)
        orderby = QgsFeatureRequest().OrderBy([clause])
        request.setOrderBy(orderby)


        for y, feature in enumerate(layer.getFeatures(request)):
            
            if feedback.isCanceled():
                return {}
            
            if not feature.geometry().isEmpty():
                with edit(layer):


                    geometry = feature.geometry()
                    spatial_index = QgsSpatialIndex(layer.getFeatures())
                    polyline = geometry.asPolyline()
                    seg_start = polyline[0]
                    seg_end = polyline[-1]
                    geometry_start = QgsGeometry.fromPointXY(QgsPointXY(seg_start.x(),seg_start.y()))
                    geometry_end = QgsGeometry.fromPointXY(QgsPointXY(seg_end.x(),seg_end.y()))
                    lastvert = len(polyline)-1




                    nnfeatures_closest_vertex = []
                    nearestids = spatial_index.nearestNeighbor(geometry_start.asPoint(),3,buffer_snap_dbscan)

                    if feature.id() in nearestids:
                        nearestids.remove(feature.id())


                    if len(nearestids) > 0:
                        for nearestid in nearestids:
                            nnfeature = next(layer.getFeatures(QgsFeatureRequest(nearestid)))

                            if geometry_start.distance(nnfeature.geometry()) <= buffer_snap_dbscan and feature["CLUSTER_ID"] != nnfeature["CLUSTER_ID"]:
                                nnfeatures_closest_vertex.append((geometry_start.distance(nnfeature.geometry()),nnfeature.geometry().closestVertex(geometry_start.asPoint())))

                        if len(nnfeatures_closest_vertex)  > 0:
                            nnfeatures_closest_vertex.sort(key=lambda k:k[0])
                            nnfeature_closest =  nnfeatures_closest_vertex[0][1]


                            QgsVectorLayerEditUtils(layer).moveVertex(nnfeature_closest[0].x(),nnfeature_closest[0].y(),feature.id(),0)



                    nnfeatures_closest_vertex = []
                    nearestids = spatial_index.nearestNeighbor(geometry_end.asPoint(),3,buffer_snap_dbscan)

                    if feature.id() in nearestids:
                        nearestids.remove(feature.id())


                    if len(nearestids) > 0:
                        for nearestid in nearestids:
                            nnfeature = next(layer.getFeatures(QgsFeatureRequest(nearestid)))

                            if geometry_end.distance(nnfeature.geometry()) <= buffer_snap_dbscan and feature["CLUSTER_ID"] != nnfeature["CLUSTER_ID"]:
                                nnfeatures_closest_vertex.append((geometry_end.distance(nnfeature.geometry()),nnfeature.geometry().closestVertex(geometry_end.asPoint())))

                        if len(nnfeatures_closest_vertex)  > 0:
                            nnfeatures_closest_vertex.sort(key=lambda k:k[0])
                            nnfeature_closest =  nnfeatures_closest_vertex[0][1]

                            QgsVectorLayerEditUtils(layer).moveVertex(nnfeature_closest[0].x(),nnfeature_closest[0].y(),feature.id(),lastvert)






            feedback.setProgress(int((y /numfeatures) * 100))

        numfeatures = layer.featureCount()


        for y, feature in enumerate(layer.getFeatures()):
            output_feature = QgsFeature(feature)
            sink_output.addFeature(output_feature, QgsFeatureSink.FastInsert)

        end_timer = datetime.now() - start_timer

        #feedback.pushInfo('cn.' + self.name() + ' : ' + self.displayName() + " took {} seconds to calculate.".format(end_timer.strftime("%H:%M:%S")))


        return {'OUTPUT': self.OUTPUT,
                'NUMBEROFFEATURES': numfeatures}

    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'consolidatewithdbscan'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return 'Snap lines to each other splitting by their clusters from a layer source resulted from cn.calculatedbscan'

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr(self.groupId())

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'DBscan and consolidate'

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return ConsolidateWithDbscan()

class MakeIntersectionsVertexes(QgsProcessingAlgorithm):
    """
    Insert missing vertices from a source layer.
    """

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.
    OUTPUT = 'OUTPUT'
    INPUT = 'INPUT'


    def initAlgorithm(self, config):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """

        # We add the input vector features source. It can have any kind of
        # geometry.
        self.addParameter(
            QgsProcessingParameterFeatureSource(
                self.INPUT,
                self.tr('INPUT'),
                [QgsProcessing.TypeVectorLine, QgsProcessing.TypeVectorPolygon]
            )
        )
        
        self.addParameter(
            QgsProcessingParameterBoolean(
                self.tr('FIX_GEOMETRIES_BEFORE_PROCESSING'),
                self.tr('FIX GEOMETRIES BEFORE PROCESSING'),
                True,
                True
            )
        )

        self.addParameter(
            QgsProcessingParameterField(
                self.tr('ENTITY_IDENTIFICATION_FIELDS'),
                self.tr('ENTITY IDENTIFICATION FIELDS'),
                None,
                self.INPUT,
                QgsProcessingParameterField.Any,
                True,
                True,
                True
            )
        )

        self.addParameter(
            QgsProcessingParameterBoolean(
                self.tr('PRINT_DEBUG'),
                self.tr('PRINT DEBUG'),
                False,
                True
            )
        )

        # We add a feature sink in which to store our processed features (this
        # usually takes the form of a newly created vector layer when the
        # algorithm is run in QGIS).



        self.addParameter(
            QgsProcessingParameterFeatureSink(
                self.OUTPUT,
                self.tr('OUTPUT')
            )
        )

    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        """
        source = self.parameterAsSource(parameters, self.INPUT, context)
        if source is None:
            raise QgsProcessingException(self.invalidSourceError(parameters, self.INPUT))

        (sink_output, dest_output) = self.parameterAsSink(parameters, self.OUTPUT,
                context, source.fields(), source.wkbType(), source.sourceCrs())

        numfeatures = source.featureCount()

        fix_geoms_flag = self.parameterAsBool(parameters, 'FIX_GEOMETRIES_BEFORE_PROCESSING',
                                        context)
        
        entity_identification_fields = self.parameterAsFields(parameters, 'ENTITY_IDENTIFICATION_FIELDS',
                                                context)

        print_debug_flag = self.parameterAsBool(parameters, 'PRINT_DEBUG',
                                        context)
        
        start_timer = datetime.now()



        outputs = {}

        if fix_geoms_flag is True:

            alg_params_fixgeometries = {
                "INPUT": source.materialize(QgsFeatureRequest()),
                "METHOD": 1,
                "OUTPUT": QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_fixgeometries'] = processing.run("qgis:fixgeometries", alg_params_fixgeometries, context=context,  feedback=feedback)


            alg_params_unipart = {
            'INPUT': outputs['alg_params_fixgeometries']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_unipart'] = processing.run("qgis:multiparttosingleparts", alg_params_unipart, context=context,  feedback=feedback)
        
        else:

            alg_params_unipart = {
            'INPUT': source.materialize(QgsFeatureRequest()),
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_unipart'] = processing.run("qgis:multiparttosingleparts", alg_params_unipart, context=context,  feedback=feedback)


        if feedback.isCanceled():
            return {}

        layer = outputs['alg_params_unipart']['OUTPUT']

        alg_params_split_lines = {
            'INPUT': layer,
            'LINES': layer,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['alg_params_split_lines'] = processing.run('qgis:splitwithlines', alg_params_split_lines, context=context, feedback=feedback)


        if feedback.isCanceled():
            return {}
        
        alg_params_dissolve = {
            'FIELD': entity_identification_fields,
            'INPUT': outputs['alg_params_split_lines']['OUTPUT'],
            'SEPARATE_DISJOINT': False,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['alg_params_dissolve'] = processing.run('qgis:dissolve', alg_params_dissolve, context=context, feedback=feedback)

        layer = outputs['alg_params_dissolve']['OUTPUT']

        numfeatures = layer.featureCount()

        for y, feature in enumerate(layer.getFeatures()):
            output_feature = QgsFeature(feature)
            sink_output.addFeature(output_feature, QgsFeatureSink.FastInsert)
            feedback.setProgress(int((y /numfeatures) * 100))

        end_timer = datetime.now() - start_timer

        #feedback.pushInfo('cn.' + self.name() + ' : ' + self.displayName() + " took {} seconds to calculate.".format(end_timer.strftime("%H:%M:%S")))


        return {'OUTPUT': self.OUTPUT,
                'NUMBEROFFEATURES': numfeatures}

    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'makeintersectionsvertexes'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return 'Insert missing vertices from a source layer'

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr(self.groupId())

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'DBscan and consolidate'

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return MakeIntersectionsVertexes()

class EndpointsStrimmingExtending(QgsProcessingAlgorithm):
    """
    Cut and extend end lines from a layer source within a buffer.
    """

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.
    OUTPUT = 'OUTPUT'
    INPUT = 'INPUT'
    BEHAVIORS = ['Trim','Extend','None']

    def initAlgorithm(self, config):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """

        # We add the input vector features source. It can have any kind of
        # geometry.
        self.addParameter(
            QgsProcessingParameterFeatureSource(
                self.INPUT,
                self.tr('INPUT'),
                [QgsProcessing.TypeVectorLine]
            )
        )

        self.addParameter(
            QgsProcessingParameterBoolean(
                self.tr('FIX_GEOMETRIES_BEFORE_PROCESSING'),
                self.tr('FIX GEOMETRIES BEFORE PROCESSING'),
                True,
                True
            )
        )

        self.addParameter(
            QgsProcessingParameterDistance(
                self.tr('BUFFER_TRIM'),
                self.tr('BUFFER_TRIM'),
                3.0,
                self.INPUT,
                False,
                0.0
            )
        )

        self.addParameter(
            QgsProcessingParameterDistance(
                self.tr('BUFFER_EXTEND'),
                self.tr('BUFFER_EXTEND'),
                5.0,
                self.INPUT,
                False,
                0.0
            )
        )

        self.addParameter(
            QgsProcessingParameterEnum(
                self.tr('PREFERRED_BEHAVIOR_FOR_STARTING_EXTREMITIES'),
                self.tr('PREFERRED BEHAVIOR FOR STARTING EXTREMITIES'),
                self.BEHAVIORS,
                False,
                1,
                False
            )
        )  

        self.addParameter(
            QgsProcessingParameterEnum(
                self.tr('PREFERRED_BEHAVIOR_FOR_ENDING_EXTREMITIES'),
                self.tr('PREFERRED BEHAVIOR FOR ENDING EXTREMITIES'),
                self.BEHAVIORS,
                False,
                0,
                False
            )
        ) 

        self.addParameter(
            QgsProcessingParameterNumber(
                name=self.tr('HAUSDORFF DISTANCE LIMIT'),
                description=self.tr('HAUSDORFF DISTANCE LIMIT'),
                type=QgsProcessingParameterNumber.Double,
                defaultValue=40,
                optional=False,
                minValue=0,
                maxValue=100
                    )
        )


        self.addParameter(
            QgsProcessingParameterNumber(
                                    name=self.tr('ANGULAR LIMIT OF PARALLEL GEOMETRIES'),
                                    description=self.tr('ANGULAR LIMIT OF PARALLEL GEOMETRIES'),
                                    type=QgsProcessingParameterNumber.Double,
                                    defaultValue=40,
                                    optional=False,
                                    minValue=0,
                                    maxValue=100
                                        )
        )

        self.addParameter(
            QgsProcessingParameterBoolean(
                self.tr('EXPLODE_AND_GATHER'),
                self.tr('EXPLODE AND GATHER'),
                False,
                True
            )
        )

        self.addParameter(
            QgsProcessingParameterField(
                self.tr('ENTITY_IDENTIFICATION_FIELDS'),
                self.tr('ENTITY IDENTIFICATION FIELDS'),
                None,
                self.INPUT,
                QgsProcessingParameterField.Any,
                True,
                True,
                True
            )
        )

        self.addParameter(
            QgsProcessingParameterBoolean(
                self.tr('PRINT_DEBUG'),
                self.tr('PRINT DEBUG'),
                False,
                True
            )
        )

        # We add a feature sink in which to store our processed features (this
        # usually takes the form of a newly created vector layer when the
        # algorithm is run in QGIS).



        self.addParameter(
            QgsProcessingParameterFeatureSink(
                self.OUTPUT,
                self.tr('OUTPUT')
            )
        )

    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        """
        source = self.parameterAsSource(parameters, self.INPUT, context)
        if source is None:
            raise QgsProcessingException(self.invalidSourceError(parameters, self.INPUT))
        

        (sink_output, dest_output) = self.parameterAsSink(parameters, self.OUTPUT,
                context, source.fields(), source.wkbType(), source.sourceCrs())

        numfeatures = source.featureCount()

        fix_geoms_flag = self.parameterAsBool(parameters, 'FIX_GEOMETRIES_BEFORE_PROCESSING',
                                        context)

        buffer_trim = self.parameterAsDouble(parameters, 'BUFFER_TRIM',
                                                context)
        
        buffer_extend = self.parameterAsDouble(parameters, 'BUFFER_EXTEND',
                                        context)
        
        prefered_behaviour_start = self.BEHAVIORS[self.parameterAsEnum(parameters, 'PREFERRED_BEHAVIOR_FOR_STARTING_EXTREMITIES',
                                               context)]
        
        prefered_behaviour_end = self.BEHAVIORS[self.parameterAsEnum(parameters, 'PREFERRED_BEHAVIOR_FOR_ENDING_EXTREMITIES',
                                               context)]
        
        hausdorff_distance_limit = self.parameterAsDouble(parameters, 'HAUSDORFF_DISTANCE_LIMIT',
                                               context)
        
        angular_limit = self.parameterAsDouble(parameters, 'ANGULAR_LIMIT_OF_PARALLEL_GEOMETRIES',
                                               context)

        explode_and_gather_flag = self.parameterAsBool(parameters, 'EXPLODE_AND_GATHER',
                                context)

        entity_identification_fields = self.parameterAsFields(parameters, 'ENTITY_IDENTIFICATION_FIELDS',
                                                context)

        print_debug_flag = self.parameterAsBool(parameters, 'PRINT_DEBUG',
                                context)


        start_timer = datetime.now()



        outputs = {}

        if fix_geoms_flag is True:

            alg_params_fixgeometries = {
                "INPUT": source.materialize(QgsFeatureRequest()),
                "METHOD": 1,
                "OUTPUT": QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_fixgeometries'] = processing.run("qgis:fixgeometries", alg_params_fixgeometries, context=context,  feedback=feedback)


            alg_params_unipart = {
            'INPUT': outputs['alg_params_fixgeometries']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_unipart'] = processing.run("qgis:multiparttosingleparts", alg_params_unipart, context=context,  feedback=feedback)
        
        else:

            alg_params_unipart = {
            'INPUT': source.materialize(QgsFeatureRequest()),
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_unipart'] = processing.run("qgis:multiparttosingleparts", alg_params_unipart, context=context,  feedback=feedback)


        if explode_and_gather_flag is True:

            alg_params_explodelines = {
            'INPUT': outputs['alg_params_unipart']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_explodelines'] = processing.run("qgis:explodelines", alg_params_explodelines, context=context,  feedback=feedback)
            layer = outputs['alg_params_explodelines']['OUTPUT']

        else:
            layer = outputs['alg_params_unipart']['OUTPUT']


        request = QgsFeatureRequest()
        clause = QgsFeatureRequest().OrderByClause('$length', ascending=True)
        orderby = QgsFeatureRequest().OrderBy([clause])
        request.setOrderBy(orderby)


        for y, feature in enumerate(layer.getFeatures(request)):
            
            if feedback.isCanceled():
                return {}
            
            if not feature.geometry().isEmpty():
                try:    
                    with edit(layer):
                        
                        geometry = feature.geometry()


                        spatial_index = QgsSpatialIndex(layer.getFeatures())
            
                        polyline = geometry.asPolyline()

                        polyline_start = polyline[0]
                        polyline_start_near_vertex = polyline[1]

                        polyline_end = polyline[-1]
                        polyline_end_near_vertex = polyline[-2]


                        geometry_start = QgsGeometry.fromPointXY(polyline_start)
                        geometry_end = QgsGeometry.fromPointXY(polyline_end)

            
                        
                        
                        
                        start_out_segment =  [polyline_start_near_vertex, polyline_start]
                        start_out_segment_geom = QgsGeometry.fromPolylineXY(start_out_segment).extendLine(0, buffer_extend/2)
                        start_out_segment_geom.insertVertex(QgsPoint(polyline_start), 1)
                        start_out_segment_geom.deleteVertex(0)

                        if print_debug_flag is True:
                            print('STEP : ' + 'INIT', 'local_feature : ' + str(feature['fid']), 'start_out_segment_geom : ', start_out_segment_geom)          



                        end_out_segment =  [polyline_end_near_vertex, polyline_end]
                        end_out_segment_geom = QgsGeometry.fromPolylineXY(end_out_segment).extendLine(0, buffer_extend/2)
                        end_out_segment_geom.insertVertex(QgsPoint(polyline_end), 1)
                        end_out_segment_geom.deleteVertex(0)

                        if print_debug_flag is True:
                            print('STEP : ' + 'INIT', 'local_feature : ' + str(feature['fid']), 'end_out_segment_geom : ', end_out_segment_geom) 



                        if QgsGeometry.fromPolylineXY([polyline_start, polyline_start_near_vertex]).length() >= buffer_trim/2:
                            start_in_segment =  [polyline_start, QgsGeometry.fromPolylineXY([polyline_start, polyline_start_near_vertex]).interpolate(buffer_trim/2).asPoint()]
                        else:
                            start_in_segment =  [polyline_start, polyline_start_near_vertex]

                        start_in_segment_geom = QgsGeometry.fromPolylineXY(start_in_segment)

                        if print_debug_flag is True:
                            print('STEP : ' + 'INIT', 'local_feature : ' + str(feature['fid']), 'start_in_segment_geom : ', start_in_segment_geom) 



                        if QgsGeometry.fromPolylineXY([polyline_end, polyline_end_near_vertex]).length() >= buffer_trim/2:
                            end_in_segment =  [polyline_end, QgsGeometry.fromPolylineXY([polyline_end, polyline_end_near_vertex]).interpolate(buffer_trim/2).asPoint()]
                        else:
                            end_in_segment =  [polyline_end, polyline_end_near_vertex]

                        end_in_segment_geom = QgsGeometry.fromPolylineXY(end_in_segment)

                        if print_debug_flag is True:
                            print('STEP : ' + 'INIT', 'local_feature : ' + str(feature['fid']), 'end_in_segment_geom : ', end_in_segment_geom) 



                        distance = [polyline_start.x() - polyline_start_near_vertex.x(), polyline_start.y() - polyline_start_near_vertex.y()]
                        norm = math.sqrt(distance[0] ** 2 + distance[1] ** 2)
                        direction = [distance[0] / norm, distance[1] / norm]
                        start_vector = QgsVector(direction[0] * math.sqrt(2), direction[1] * math.sqrt(2))


                        distance = [polyline_end_near_vertex.x() - polyline_end.x(), polyline_end_near_vertex.y() - polyline_end.y()]
                        norm = math.sqrt(distance[0] ** 2 + distance[1] ** 2)
                        direction = [distance[0] / norm, distance[1] / norm]
                        end_vector = QgsVector(direction[0] * math.sqrt(2), direction[1] * math.sqrt(2))



                        break_update_step = False
                        closest_intersections = []


                        nearestids = spatial_index.nearestNeighbor(start_in_segment_geom.asPolyline()[-1],5,buffer_trim/2)
                        if feature.id() in nearestids:
                            nearestids.remove(feature.id())

                        if len(nearestids) > 0:
                            for nearestid in nearestids:

                                try:
                                    nnfeature = next(layer.getFeatures(QgsFeatureRequest(nearestid)))
                        
                                    nnfeature_closest_vertex = nnfeature.geometry().closestSegmentWithContext(start_in_segment_geom.asPolyline()[-1],buffer_trim/2)
                                    
                                    segment = []
                                    segment.append(QgsPointXY(nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]-1).x(),  nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]-1).y()))
                                    segment.append(QgsPointXY(nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]).x(),  nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]).y()))
                                    segment_geom = QgsGeometry.fromPolylineXY(segment)

                                    hausdorff_distance = start_in_segment_geom.hausdorffDistance(segment_geom)

                                    feature_segment_angle = math.degrees(start_in_segment_geom.interpolateAngle(start_in_segment_geom.length())) % 180
                                    nnfeature_segment_angle = math.degrees(segment_geom.interpolateAngle(segment_geom.length())) % 180

                                    if abs(feature_segment_angle - nnfeature_segment_angle) > angular_limit and hausdorff_distance > hausdorff_distance_limit:
                                        if nnfeature_closest_vertex[0] <=  (buffer_trim/2)**2:


                                            distance = [nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]).x() - nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]-1).x(), nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]).y() - nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]-1).y() ]
                                                                                
                                            norm = math.sqrt(distance[0] ** 2 + distance[1] ** 2)
                                            direction = [distance[0] / norm, distance[1] / norm]
                                            nnfeature_vector = QgsVector(direction[0] * math.sqrt(2), direction[1] * math.sqrt(2))

                                            extended_polyline = start_in_segment_geom.asPolyline()

                                            inter = QgsGeometryUtils.lineIntersection(QgsPoint(extended_polyline[0]),start_vector,nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]-1),nnfeature_vector)
                                            distance_inter = QgsGeometry.fromPointXY(extended_polyline[0]).distance(QgsGeometry.fromPointXY(QgsPointXY(inter[1])))

                                            intersects_segment = start_in_segment_geom.intersects(segment_geom)

                                            if print_debug_flag is True:
                                                print('STEP : ' + 'START_POINT BUFFER_TRIM', 'local_feature : ' + str(feature['fid']), 'distant_feature : ' + str(nnfeature['fid']), 'distance : ' + str(distance_inter))          


                                            if inter[0] and distance_inter <= buffer_trim/2:
                                                closest_intersections.append((inter[1], segment_geom, nnfeature_closest_vertex, distance_inter, -1, intersects_segment))
                                except:
                                    if print_debug_flag is True:
                                        print('EXCEPTION : '  + 'START_POINT BUFFER_EXTEND LOOP', 'local_feature : ' + str(feature['fid']))
                                


                        geometry_start_buffer = geometry_start.buffer(0.001,1)
                        list_intersects_boundingBox = spatial_index.intersects(geometry_start_buffer.boundingBox())
                        if feature.id() in list_intersects_boundingBox:
                            list_intersects_boundingBox.remove(feature.id())
                        if len(list_intersects_boundingBox) >= 2:
                            for id in list_intersects_boundingBox:
                                feat = next(layer.getFeatures(QgsFeatureRequest(id)))
                                feat_polyline = feat.geometry().asPolyline()

                                if geometry_start_buffer.intersects(QgsGeometry.fromPointXY(feat_polyline[0])) or geometry_start_buffer.intersects(QgsGeometry.fromPointXY(feat_polyline[-1])):
                                    break_update_step = True

                                    if print_debug_flag is True:
                                        print('STEP : ' + 'START_POINT BREAK_UPDATE_STEP', 'local_feature : ' + str(feature['fid']), 'break_update_step : ' + str(break_update_step))
                                    break

                        if break_update_step is False:             
                            nearestids = spatial_index.nearestNeighbor(start_out_segment_geom.asPolyline()[-1],5,buffer_extend/2)
                            if feature.id() in nearestids:
                                nearestids.remove(feature.id())

                            if len(nearestids) > 0:
                                for nearestid in nearestids:

                                    try:
                                        nnfeature = next(layer.getFeatures(QgsFeatureRequest(nearestid)))
                            
                                        nnfeature_closest_vertex = nnfeature.geometry().closestSegmentWithContext(start_out_segment_geom.asPolyline()[-1],buffer_extend/2)
                                        
                                        segment = []
                                        segment.append(QgsPointXY(nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]-1).x(),  nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]-1).y()))
                                        segment.append(QgsPointXY(nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]).x(),  nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]).y()))
                                        segment_geom = QgsGeometry.fromPolylineXY(segment)

                                        hausdorff_distance = start_out_segment_geom.hausdorffDistance(segment_geom)

                                        feature_segment_angle = math.degrees(start_out_segment_geom.interpolateAngle(start_out_segment_geom.length())) % 180
                                        nnfeature_segment_angle = math.degrees(segment_geom.interpolateAngle(segment_geom.length())) % 180

                                        if abs(feature_segment_angle - nnfeature_segment_angle) > angular_limit and hausdorff_distance > hausdorff_distance_limit: 
                                            if nnfeature_closest_vertex[0] <=  (buffer_extend/2)**2:


                                                distance = [nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]).x() - nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]-1).x(), nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]).y() - nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]-1).y() ]
                                                                                    
                                                norm = math.sqrt(distance[0] ** 2 + distance[1] ** 2)
                                                direction = [distance[0] / norm, distance[1] / norm]
                                                nnfeature_vector = QgsVector(direction[0] * math.sqrt(2), direction[1] * math.sqrt(2))

                                                extended_polyline = start_out_segment_geom.asPolyline()

                                                inter = QgsGeometryUtils.lineIntersection(QgsPoint(extended_polyline[0]),start_vector.rotateBy(math.pi),nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]-1),nnfeature_vector)
                                                distance_inter = QgsGeometry.fromPointXY(extended_polyline[0]).distance(QgsGeometry.fromPointXY(QgsPointXY(inter[1])))

                                                intersects_segment = start_out_segment_geom.intersects(segment_geom)

                                                if print_debug_flag is True:
                                                    print('STEP : ' + 'START_POINT BUFFER_EXTEND', 'local_feature : ' + str(feature['fid']), 'distant_feature : ' + str(nnfeature['fid']), 'distance : ' + str(distance_inter))          

                                                if inter[0] and distance_inter <= buffer_extend/2:
                                                    closest_intersections.append((inter[1], segment_geom, nnfeature_closest_vertex, distance_inter, 1, intersects_segment))
                                    except:
                                        if print_debug_flag is True:
                                            print('EXCEPTION : '  + 'START_POINT BUFFER_EXTEND LOOP', 'local_feature : ' + str(feature['fid']))
                                    
                        if len(closest_intersections) > 0:
                            if break_update_step is False:
                                if prefered_behaviour_start == 'Extend':
                                    closest_intersections = sorted(closest_intersections, key=lambda k: (k[4]*-1,not k[5], k[3]))
                                elif prefered_behaviour_start == 'Trim':
                                    closest_intersections = sorted(closest_intersections, key=lambda k: (k[4],not k[5], k[3]))
                                elif prefered_behaviour_start == 'None':
                                    closest_intersections = sorted(closest_intersections, key=lambda k: (not k[5], k[3]))

                                if print_debug_flag is True:
                                    print('STEP : ' +  'START_POINT UPDATE GEOMETRY', 'local_feature : ' + str(feature['fid']), 'closest_intersections : ', closest_intersections)

                                for closest_intersection in closest_intersections:
                                    new_polyline = polyline
                                    new_polyline[0] = QgsPointXY(closest_intersection[0])
                                    new_geom = QgsGeometry.fromPolylineXY(new_polyline)
                                    if not new_geom.isEmpty():
                                        if (closest_intersection[4] == 1 and new_geom.length() >= geometry.length()) or (closest_intersection[4] == -1 and geometry.length() >= new_geom.length()):
                                            feature.setGeometry(new_geom)
                                            layer.updateFeature(feature)
                                            break



                        break_update_step = False                
                        closest_intersections = []

                        
                        nearestids = spatial_index.nearestNeighbor(end_in_segment_geom.asPolyline()[-1],5,buffer_trim/2)
                        if feature.id() in nearestids:
                            nearestids.remove(feature.id())

                        if len(nearestids) > 0:
                            for nearestid in nearestids:
                                                                    
                                try:
                                    nnfeature = next(layer.getFeatures(QgsFeatureRequest(nearestid)))
                                    
                                    nnfeature_closest_vertex = nnfeature.geometry().closestSegmentWithContext(end_in_segment_geom.asPolyline()[-1],buffer_trim/2)
                                    
                                    segment = []
                                    segment.append(QgsPointXY(nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]-1).x(),  nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]-1).y()))
                                    segment.append(QgsPointXY(nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]).x(),  nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]).y()))
                                    segment_geom = QgsGeometry.fromPolylineXY(segment)

                                    hausdorff_distance = end_in_segment_geom.hausdorffDistance(segment_geom)

                                    feature_segment_angle = math.degrees(end_in_segment_geom.interpolateAngle(end_in_segment_geom.length())) % 180
                                    nnfeature_segment_angle = math.degrees(segment_geom.interpolateAngle(segment_geom.length())) % 180

                                    if abs(feature_segment_angle - nnfeature_segment_angle) > angular_limit and hausdorff_distance > hausdorff_distance_limit:   
                                        if nnfeature_closest_vertex[0] <=  (buffer_trim/2)**2:


                                            distance = [nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]).x() - nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]-1).x(), nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]).y() - nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]-1).y() ]
                                                                                
                                            norm = math.sqrt(distance[0] ** 2 + distance[1] ** 2)
                                            direction = [distance[0] / norm, distance[1] / norm]
                                            nnfeature_vector = QgsVector(direction[0] * math.sqrt(2), direction[1] * math.sqrt(2))

                                            extended_polyline = end_in_segment_geom.asPolyline()

                                            inter = QgsGeometryUtils.lineIntersection(QgsPoint(extended_polyline[0]),end_vector.rotateBy(math.pi),nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]-1),nnfeature_vector)
                                            distance_inter = QgsGeometry.fromPointXY(extended_polyline[0]).distance(QgsGeometry.fromPointXY(QgsPointXY(inter[1])))

                                            intersects_segment = end_in_segment_geom.intersects(segment_geom)

                                            if print_debug_flag is True:
                                                print('STEP : ' + 'END_POINT BUFFER_TRIM', 'local_feature : ' + str(feature['fid']), 'distant_feature : ' + str(nnfeature['fid']), 'distance : ' + str(distance_inter))          

                                            if inter[0] and distance_inter <= buffer_trim/2:
                                                closest_intersections.append((inter[1], segment_geom, nnfeature_closest_vertex, distance_inter, -1, intersects_segment))
                                except:
                                    if print_debug_flag is True:
                                        print('EXCEPTION : '  + 'END_POINT BUFFER_TRIM LOOP', 'local_feature : ' + str(feature['fid']))



                        geometry_end_buffer = geometry_end.buffer(0.001,1)
                        list_intersects_boundingBox = spatial_index.intersects(geometry_end_buffer.boundingBox())
                        if feature.id() in list_intersects_boundingBox:
                            list_intersects_boundingBox.remove(feature.id())
                        if len(list_intersects_boundingBox) >= 2:
                            for id in list_intersects_boundingBox:
                                feat = next(layer.getFeatures(QgsFeatureRequest(id)))
                                feat_polyline = feat.geometry().asPolyline()

                                if geometry_end_buffer.intersects(QgsGeometry.fromPointXY(feat_polyline[0])) or geometry_end_buffer.intersects(QgsGeometry.fromPointXY(feat_polyline[-1])):
                                    break_update_step = True

                                    if print_debug_flag is True:
                                        print('STEP : ' + 'END_POINT BREAK_UPDATE_STEP', 'local_feature : ' + str(feature['fid']), 'break_update_step : ' + str(break_update_step))
                                    break

                        if break_update_step is False: 
                            nearestids = spatial_index.nearestNeighbor(end_out_segment_geom.asPolyline()[-1],5,buffer_extend/2)
                            if feature.id() in nearestids:
                                nearestids.remove(feature.id())

                            if len(nearestids) > 0:
                                for nearestid in nearestids:

                                    try:
                                        nnfeature = next(layer.getFeatures(QgsFeatureRequest(nearestid)))
                                        
                                        nnfeature_closest_vertex = nnfeature.geometry().closestSegmentWithContext(end_out_segment_geom.asPolyline()[-1],buffer_extend/2)
                                        
                                        segment = []
                                        segment.append(QgsPointXY(nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]-1).x(),  nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]-1).y()))
                                        segment.append(QgsPointXY(nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]).x(),  nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]).y()))
                                        segment_geom = QgsGeometry.fromPolylineXY(segment)

                                        hausdorff_distance = end_out_segment_geom.hausdorffDistance(segment_geom)

                                        feature_segment_angle = math.degrees(end_out_segment_geom.interpolateAngle(end_out_segment_geom.length())) % 180
                                        nnfeature_segment_angle = math.degrees(segment_geom.interpolateAngle(segment_geom.length())) % 180

                                        if abs(feature_segment_angle - nnfeature_segment_angle) > angular_limit and hausdorff_distance > hausdorff_distance_limit:   
                                            if nnfeature_closest_vertex[0] <=  (buffer_extend/2)**2:

                                        

                                                distance = [nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]).x() - nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]-1).x(), nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]).y() - nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]-1).y() ]
                                                                                    
                                                norm = math.sqrt(distance[0] ** 2 + distance[1] ** 2)
                                                direction = [distance[0] / norm, distance[1] / norm]
                                                nnfeature_vector = QgsVector(direction[0] * math.sqrt(2), direction[1] * math.sqrt(2))

                                                extended_polyline = end_out_segment_geom.asPolyline()

                                                inter = QgsGeometryUtils.lineIntersection(QgsPoint(extended_polyline[0]),end_vector,nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]-1),nnfeature_vector)
                                                distance_inter = QgsGeometry.fromPointXY(extended_polyline[0]).distance(QgsGeometry.fromPointXY(QgsPointXY(inter[1])))

                                                intersects_segment = end_out_segment_geom.intersects(segment_geom)

                                                if print_debug_flag is True:
                                                    print('STEP : ' + 'END_POINT BUFFER_EXTEND', 'local_feature : ' + str(feature['fid']), 'distant_feature : ' + str(nnfeature['fid']), 'distance : ' + str(distance_inter))          

                                                if inter[0] and distance_inter <= buffer_extend/2:
                                                    closest_intersections.append((inter[1], segment_geom, nnfeature_closest_vertex, distance_inter, 1, intersects_segment))
                                    except:
                                        if print_debug_flag is True:
                                            print('EXCEPTION : '  + 'END_POINT BUFFER_EXTEND LOOP', 'local_feature : ' + str(feature['fid']))
                                

                    

                        if len(closest_intersections) > 0:
                            if break_update_step is False:
                                if prefered_behaviour_end == 'Extend':
                                    closest_intersections = sorted(closest_intersections, key=lambda k: (k[4]*-1, not k[5], k[3]))
                                elif prefered_behaviour_end == 'Trim':
                                    closest_intersections = sorted(closest_intersections, key=lambda k: (k[4], not k[5], k[3]))
                                elif prefered_behaviour_end == 'None':
                                    closest_intersections = sorted(closest_intersections, key=lambda k: (not k[5], k[3]))

                                if print_debug_flag is True:
                                    print('STEP : ' +  'END_POINT UPDATE GEOMETRY', 'local_feature : ' + str(feature['fid']), 'closest_intersections : ', closest_intersections)

                                for closest_intersection in closest_intersections:
                                    new_polyline = polyline
                                    new_polyline[-1] = QgsPointXY(closest_intersection[0])
                                    new_geom = QgsGeometry.fromPolylineXY(new_polyline)
                                    if not new_geom.isEmpty():
                                        if (closest_intersection[4] == 1 and new_geom.length() >= geometry.length()) or (closest_intersection[4] == -1 and geometry.length() >= new_geom.length()):
                                            feature.setGeometry(new_geom)
                                            layer.updateFeature(feature)
                                            break

                except:
                    if print_debug_flag is True:
                        print('EXCEPTION : '  + 'FEATURE_LOOP', 'local_feature : ' + str(feature['fid']))


            feedback.setProgress(int((y /numfeatures) * 100))


        if explode_and_gather_flag is True:
            alg_params_dissolve = {
                'FIELD': entity_identification_fields,
                'INPUT': layer,
                'SEPARATE_DISJOINT': False,
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_dissolve'] = processing.run('qgis:dissolve', alg_params_dissolve, context=context, feedback=feedback)
            layer = outputs['alg_params_dissolve']['OUTPUT']  

        numfeatures = layer.featureCount()

        for y, feature in enumerate(layer.getFeatures()):
            output_feature = QgsFeature(feature)
            sink_output.addFeature(output_feature, QgsFeatureSink.FastInsert)

        end_timer = datetime.now() - start_timer

        #feedback.pushInfo('cn.' + self.name() + ' : ' + self.displayName() + " took {} seconds to calculate.".format(end_timer.strftime("%H:%M:%S")))


        return {'OUTPUT': self.OUTPUT,
                'NUMBEROFFEATURES': numfeatures}

    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'endpointstrimmingextending'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return 'Cut and extend end lines from a layer source within a buffer'

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr(self.groupId())

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'Snapping layer (from himself)'

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return EndpointsStrimmingExtending()

class EndpointsSnapping(QgsProcessingAlgorithm):
    """
    Snap lines endpoints' to each other's from a layer source within a buffer.
    """

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.
    OUTPUT = 'OUTPUT'
    INPUT = 'INPUT'
    BEHAVIORS = ['Nearest, Minimum angular variation','Farest, Minimum angular variation','Nearest, Maximum angular variation','Farest, Maximum angular variation']


    def initAlgorithm(self, config):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """

        # We add the input vector features source. It can have any kind of
        # geometry.
        self.addParameter(
            QgsProcessingParameterFeatureSource(
                self.INPUT,
                self.tr('INPUT'),
                [QgsProcessing.TypeVectorLine]
            )
        )

        self.addParameter(
            QgsProcessingParameterBoolean(
                self.tr('FIX_GEOMETRIES_BEFORE_PROCESSING'),
                self.tr('FIX GEOMETRIES BEFORE PROCESSING'),
                True,
                True
            )
        )

        self.addParameter(
            QgsProcessingParameterDistance(
                self.tr('BUFFER_ENDPOINTS_SNAPPING'),
                self.tr('BUFFER ENDPOINTS SNAPPING'),
                5.0,
                self.INPUT,
                False,
                0.0
            )
        )

        self.addParameter(
            QgsProcessingParameterEnum(
                self.tr('PREFERRED_BEHAVIOR_FOR_STARTING_EXTREMITIES'),
                self.tr('PREFERRED BEHAVIOR FOR STARTING EXTREMITIES'),
                self.BEHAVIORS,
                False,
                0,
                False
            )
        )  

        self.addParameter(
            QgsProcessingParameterEnum(
                self.tr('PREFERRED_BEHAVIOR_FOR_ENDING_EXTREMITIES'),
                self.tr('PREFERRED BEHAVIOR FOR ENDING EXTREMITIES'),
                self.BEHAVIORS,
                False,
                0,
                False
            )
        ) 

        self.addParameter(
            QgsProcessingParameterNumber(
                name=self.tr('HAUSDORFF DISTANCE LIMIT'),
                description=self.tr('HAUSDORFF DISTANCE LIMIT'),
                type=QgsProcessingParameterNumber.Double,
                defaultValue=40,
                optional=False,
                minValue=0,
                maxValue=100
                    )
        )

        self.addParameter(
            QgsProcessingParameterNumber(
                name=self.tr('MIN ANGULAR LIMIT OF PARALLEL GEOMETRIES'),
                description=self.tr('MIN ANGULAR LIMIT OF PARALLEL GEOMETRIES'),
                type=QgsProcessingParameterNumber.Double,
                defaultValue=40,
                optional=False,
                minValue=0,
                maxValue=100
                    )
        )


        self.addParameter(
            QgsProcessingParameterNumber(
                name=self.tr('MAX_ANGULAR_LIMIT_OF_PARALLEL_GEOMETRIES'),
                description=self.tr('MAX_ANGULAR_LIMIT_OF_PARALLEL_GEOMETRIES'),
                type=QgsProcessingParameterNumber.Double,
                defaultValue=40,
                optional=False,
                minValue=0,
                maxValue=100
                    )
        )

        self.addParameter(
            QgsProcessingParameterBoolean(
                self.tr('PREFERS_SAME_GEOMETRY_DIRECTION'),
                self.tr('PREFERS SAME GEOMETRY DIRECTION'),
                True,
                True
            )
        )

        self.addParameter(
            QgsProcessingParameterBoolean(
                self.tr('EXPLODE_AND_GATHER'),
                self.tr('EXPLODE AND GATHER'),
                False,
                True
            )
        )

        self.addParameter(
            QgsProcessingParameterField(
                self.tr('ENTITY_IDENTIFICATION_FIELDS'),
                self.tr('ENTITY IDENTIFICATION FIELDS'),
                None,
                self.INPUT,
                QgsProcessingParameterField.Any,
                True,
                True,
                True
            )
        )


        self.addParameter(
            QgsProcessingParameterBoolean(
                self.tr('PRINT_DEBUG'),
                self.tr('PRINT DEBUG'),
                False,
                True
            )
        )


        # We add a feature sink in which to store our processed features (this
        # usually takes the form of a newly created vector layer when the
        # algorithm is run in QGIS).



        self.addParameter(
            QgsProcessingParameterFeatureSink(
                self.OUTPUT,
                self.tr('OUTPUT')
            )
        )

    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        """
        source = self.parameterAsSource(parameters, self.INPUT, context)
        if source is None:
            raise QgsProcessingException(self.invalidSourceError(parameters, self.INPUT))


        (sink_output, dest_output) = self.parameterAsSink(parameters, self.OUTPUT,
                context, source.fields(), source.wkbType(), source.sourceCrs())

        numfeatures = source.featureCount()

        fix_geoms_flag = self.parameterAsBool(parameters, 'FIX_GEOMETRIES_BEFORE_PROCESSING',
                                        context)
        
        buffer_snap = self.parameterAsDouble(parameters, 'BUFFER_ENDPOINTS_SNAPPING',
                                                context)

        hausdorff_distance_limit = self.parameterAsDouble(parameters, 'HAUSDORFF_DISTANCE_LIMIT',
                                               context)
        
        min_angular_limit = self.parameterAsDouble(parameters, 'MIN_ANGULAR_LIMIT_OF_PARALLEL_GEOMETRIES',
                                               context)
        
        max_angular_limit = self.parameterAsDouble(parameters, 'MAX_ANGULAR_LIMIT_OF_PARALLEL_GEOMETRIES',
                                               context)
        
        prefered_behaviour_start = self.BEHAVIORS[self.parameterAsEnum(parameters, 'PREFERRED_BEHAVIOR_FOR_STARTING_EXTREMITIES',
                                               context)]
        
        prefered_behaviour_end = self.BEHAVIORS[self.parameterAsEnum(parameters, 'PREFERRED_BEHAVIOR_FOR_ENDING_EXTREMITIES',
                                               context)]

        same_direction_geoms_flag = self.parameterAsBool(parameters, 'PREFERS_SAME_GEOMETRY_DIRECTION',
                                context)
        
        explode_and_gather_flag = self.parameterAsBool(parameters, 'EXPLODE_AND_GATHER',
                                context)

        entity_identification_fields = self.parameterAsFields(parameters, 'ENTITY_IDENTIFICATION_FIELDS',
                                                context)

        print_debug_flag = self.parameterAsBool(parameters, 'PRINT_DEBUG',
                                context)



        start_timer = datetime.now()

        outputs = {}


        if fix_geoms_flag is True:

            alg_params_fixgeometries = {
                "INPUT": source.materialize(QgsFeatureRequest()),
                "METHOD": 1,
                "OUTPUT": QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_fixgeometries'] = processing.run("qgis:fixgeometries", alg_params_fixgeometries, context=context,  feedback=feedback)


            alg_params_unipart = {
            'INPUT': outputs['alg_params_fixgeometries']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_unipart'] = processing.run("qgis:multiparttosingleparts", alg_params_unipart, context=context,  feedback=feedback)
        
        else:

            alg_params_unipart = {
            'INPUT': source.materialize(QgsFeatureRequest()),
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_unipart'] = processing.run("qgis:multiparttosingleparts", alg_params_unipart, context=context,  feedback=feedback)


        if explode_and_gather_flag is True:

            alg_params_explodelines = {
            'INPUT': outputs['alg_params_unipart']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_explodelines'] = processing.run("qgis:explodelines", alg_params_explodelines, context=context,  feedback=feedback)
            layer = outputs['alg_params_explodelines']['OUTPUT']

        else:
            layer = outputs['alg_params_unipart']['OUTPUT']


        request = QgsFeatureRequest()
        clause = QgsFeatureRequest().OrderByClause('$length', ascending=True)
        orderby = QgsFeatureRequest().OrderBy([clause])
        request.setOrderBy(orderby)


        for y, feature in enumerate(layer.getFeatures(request)):
            
            if feedback.isCanceled():
                return {}
            
            if not feature.geometry().isEmpty():
                try:
                    with edit(layer):


                        geometry = feature.geometry()

                        spatial_index = QgsSpatialIndex(layer.getFeatures())


                        polyline = geometry.asPolyline()

                        polyline_start = polyline[0]
                        polyline_start_near_vertex = polyline[1]

                        polyline_end = polyline[-1]
                        polyline_end_near_vertex = polyline[-2]

                        geometry_start = QgsGeometry.fromPointXY(polyline_start)
                        geometry_end = QgsGeometry.fromPointXY(polyline_end)

                        start_segment_geometry = QgsGeometry.fromPolylineXY([polyline_start, polyline_start_near_vertex])

                        end_segment_geometry = QgsGeometry.fromPolylineXY([polyline_end_near_vertex, polyline_end])
                                                                            
                        break_update_step = False
                        closest_vertices = []

                        geometry_start_buffer = geometry_start.buffer(0.001,1)
                        list_intersects_boundingBox = spatial_index.intersects(geometry_start_buffer.boundingBox())
                        if feature.id() in list_intersects_boundingBox:
                            list_intersects_boundingBox.remove(feature.id())
                        if len(list_intersects_boundingBox) >= 1:
                            for id in list_intersects_boundingBox:
                                feat = next(layer.getFeatures(QgsFeatureRequest(id)))
                                feat_polyline = feat.geometry().asPolyline()

                                if geometry_start_buffer.intersects(QgsGeometry.fromPointXY(feat_polyline[0])) or geometry_start_buffer.intersects(QgsGeometry.fromPointXY(feat_polyline[-1])):
                                    break_update_step = True

                                    if print_debug_flag is True:
                                        print('STEP : ' + 'START_POINT BREAK_UPDATE_STEP', 'local_feature : ' + str(feature['fid']), 'break_update_step : ' + str(break_update_step))
                                    break


                        if break_update_step is False:                
                            nearestids = spatial_index.nearestNeighbor(geometry_start.asPoint(),5,buffer_snap)
                            if feature.id() in nearestids:
                                nearestids.remove(feature.id())

                            if len(nearestids) > 0:
                                for nearestid in nearestids:
                                    try:
                                        nnfeature = next(layer.getFeatures(QgsFeatureRequest(nearestid)))
                                        nnfeature_closest_vertex = nnfeature.geometry().closestVertex(geometry_start.asPoint())

                                        if nnfeature_closest_vertex[2] == -1 or nnfeature_closest_vertex[3] == -1:

                                            if nnfeature_closest_vertex[-1] <= buffer_snap**2:
                                                
                                                nnfeature_closest_PointXY = QgsPointXY(nnfeature.geometry().vertexAt(nnfeature_closest_vertex[1]).x(),  nnfeature.geometry().vertexAt(nnfeature_closest_vertex[1]).y())
                                                nnfeature_closest_PointXY_geom = QgsGeometry.fromPointXY(nnfeature_closest_PointXY)

                                                distance_point_from_geom = geometry_start.distance(nnfeature_closest_PointXY_geom)

                                                if print_debug_flag is True:
                                                    print('STEP : ' + 'START_POINT DISTANCE TO POINT', 'local_feature : ' + str(feature['fid']), 'distant_feature : ' + str(nnfeature['fid']), 'distance : ' + str(distance_point_from_geom))
                                            
                                                if distance_point_from_geom <= buffer_snap and geometry.length() > distance_point_from_geom:

                                                    endpoint_type = 1 if nnfeature_closest_vertex[3] == -1 else -1

                                                    distant_segment = [nnfeature_closest_PointXY]

                                                    if endpoint_type == 1:
                                                        distant_segment.append(QgsPointXY(nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]).x(),  nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]).y()))
                                                    elif endpoint_type == -1:
                                                        distant_segment.append(QgsPointXY(nnfeature.geometry().vertexAt(nnfeature_closest_vertex[3]).x(),  nnfeature.geometry().vertexAt(nnfeature_closest_vertex[3]).y()))

                                                    distant_segment_geom = QgsGeometry.fromPolylineXY(distant_segment)

                                                    start_segment_angle = math.degrees(start_segment_geometry.interpolateAngle(start_segment_geometry.length())) % 180
                                                    distant_segment_angle = math.degrees(distant_segment_geom.interpolateAngle(distant_segment_geom.length())) % 180
                                          
                                                    angular_variation = abs(start_segment_angle - distant_segment_angle)

                                                    hausdorff_distance = start_segment_geometry.hausdorffDistance(distant_segment_geom)

                                                    if print_debug_flag is True:
                                                        print('STEP : ' + 'START_POINT ANGULAR_VARIATION & HAUSDORFF_DISTANCE', 'local_feature : ' + str(feature['fid']), 'distant_feature : ' + str(nnfeature['fid']), 'hausdorff_distance : ' + str(hausdorff_distance), 'angular_variation : ' + str(angular_variation), 'nnfeature_closest_vertex : ', nnfeature_closest_vertex)

                                                    if (angular_variation >= min_angular_limit and angular_variation <= max_angular_limit) and hausdorff_distance > hausdorff_distance_limit:
                                                        closest_vertices.append((nnfeature_closest_PointXY, distance_point_from_geom, angular_variation, endpoint_type))
                                    except:
                                        if print_debug_flag is True:
                                            print('EXCEPTION : '  + 'START_POINT LOOP', 'local_feature : ' + str(feature['fid']))


                        if len(closest_vertices) > 0:
                            if break_update_step is False:
                                if prefered_behaviour_start == 'Nearest, Minimum angular variation':
                                    if same_direction_geoms_flag is True:
                                        closest_vertices = sorted(closest_vertices, key=lambda k: (k[3]*-1, k[1], k[2]))
                                    else:
                                        closest_vertices = sorted(closest_vertices, key=lambda k: (k[1], k[2]))

                                elif prefered_behaviour_start == 'Farest, Minimum angular variation':
                                    if same_direction_geoms_flag is True:
                                        closest_vertices = sorted(closest_vertices, key=lambda k: (k[3]*-1, k[1]*-1, k[2]))
                                    else:
                                        closest_vertices = sorted(closest_vertices, key=lambda k: (k[1]*-1, k[2]))

                                elif prefered_behaviour_start == 'Nearest, Maximum angular variation':
                                    if same_direction_geoms_flag is True:
                                        closest_vertices = sorted(closest_vertices, key=lambda k: (k[3]*-1, k[1], k[2]*-1))
                                    else:
                                        closest_vertices = sorted(closest_vertices, key=lambda k: (k[1], k[2]*-1))

                                elif prefered_behaviour_start == 'Farest, Maximum angular variation':
                                    if same_direction_geoms_flag is True:
                                        closest_vertices = sorted(closest_vertices, key=lambda k: (k[3]*-1, k[1]*-1, k[2]*-1))
                                    else:
                                        closest_vertices = sorted(closest_vertices, key=lambda k: (k[1]*-1, k[2]*-1))

                                if print_debug_flag is True:
                                    print('STEP : ' +  'START_POINT UPDATE GEOMETRY', 'local_feature : ' + str(feature['fid']), 'closest_vertices : ', closest_vertices)

                                for closest_vertex in closest_vertices:
                                    new_polyline = polyline
                                    new_polyline[0] = closest_vertex[0]
                                    new_geom = QgsGeometry.fromPolylineXY(new_polyline)
                                    if not new_geom.isEmpty() and new_geom.length() >= closest_vertex[1]:
                                        feature.setGeometry(new_geom)
                                        layer.updateFeature(feature)
                                        break                            





                        break_update_step = False
                        closest_vertices = []

                        geometry_end_buffer = geometry_end.buffer(0.001,1)
                        list_intersects_boundingBox = spatial_index.intersects(geometry_end_buffer.boundingBox())
                        if feature.id() in list_intersects_boundingBox:
                            list_intersects_boundingBox.remove(feature.id())
                        if len(list_intersects_boundingBox) >= 1:
                            for id in list_intersects_boundingBox:
                                feat = next(layer.getFeatures(QgsFeatureRequest(id)))
                                feat_polyline = feat.geometry().asPolyline()

                                if geometry_end_buffer.intersects(QgsGeometry.fromPointXY(feat_polyline[0])) or geometry_end_buffer.intersects(QgsGeometry.fromPointXY(feat_polyline[-1])):
                                    break_update_step = True

                                    if print_debug_flag is True:
                                        print('STEP : ' + 'END_POINT BREAK_UPDATE_STEP', 'local_feature : ' + str(feature['fid']), 'break_update_step : ' + str(break_update_step))
                                    break

                        if break_update_step is False:            
                            nearestids = spatial_index.nearestNeighbor(geometry_end.asPoint(),5,buffer_snap)
                            if feature.id() in nearestids:
                                nearestids.remove(feature.id())

                            if len(nearestids) > 0:
                                for nearestid in nearestids:
                                    try:    
                                        nnfeature = next(layer.getFeatures(QgsFeatureRequest(nearestid)))
                                        nnfeature_closest_vertex = nnfeature.geometry().closestVertex(geometry_end.asPoint())

                                        if nnfeature_closest_vertex[2] == -1 or nnfeature_closest_vertex[3] == -1:

                                            if nnfeature_closest_vertex[-1] <= buffer_snap**2:
                                                
                                                nnfeature_closest_PointXY = QgsPointXY(nnfeature.geometry().vertexAt(nnfeature_closest_vertex[1]).x(),  nnfeature.geometry().vertexAt(nnfeature_closest_vertex[1]).y())
                                                nnfeature_closest_PointXY_geom = QgsGeometry.fromPointXY(nnfeature_closest_PointXY)

                                                distance_point_from_geom = geometry_end.distance(nnfeature_closest_PointXY_geom)

                                                if print_debug_flag is True:
                                                    print('STEP : ' + 'END_POINT DISTANCE TO POINT', 'local_feature : ' + str(feature['fid']), 'distant_feature : ' + str(nnfeature['fid']), 'distance : ' + str(distance_point_from_geom))          
                                            
                                                if distance_point_from_geom <= buffer_snap and geometry.length() > distance_point_from_geom:

                                                    endpoint_type = 1 if nnfeature_closest_vertex[3] == -1 else -1

                                                    distant_segment = [nnfeature_closest_PointXY]

                                                    if endpoint_type == 1:
                                                        distant_segment.append(QgsPointXY(nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]).x(),  nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]).y()))
                                                    elif endpoint_type == -1:
                                                        distant_segment.append(QgsPointXY(nnfeature.geometry().vertexAt(nnfeature_closest_vertex[3]).x(),  nnfeature.geometry().vertexAt(nnfeature_closest_vertex[3]).y()))

                                                    distant_segment_geom = QgsGeometry.fromPolylineXY(distant_segment)

                                                    end_segment_angle = math.degrees(end_segment_geometry.interpolateAngle(end_segment_geometry.length())) % 180
                                                    distant_segment_angle = math.degrees(distant_segment_geom.interpolateAngle(distant_segment_geom.length())) % 180
                                          
                                                    angular_variation = abs(end_segment_angle - distant_segment_angle)

                                                    hausdorff_distance = end_segment_geometry.hausdorffDistance(distant_segment_geom)

                                                    if print_debug_flag is True:
                                                        print('STEP : ' + 'END_POINT ANGULAR_VARIATION & HAUSDORFF_DISTANCE', 'local_feature : ' + str(feature['fid']), 'distant_feature : ' + str(nnfeature['fid']), 'hausdorff_distance : ' + str(hausdorff_distance), 'angular_variation : ' + str(angular_variation), 'nnfeature_closest_vertex : ', nnfeature_closest_vertex)

                                                    if (angular_variation >= min_angular_limit and angular_variation <= max_angular_limit) and hausdorff_distance > hausdorff_distance_limit:
                                                        closest_vertices.append((nnfeature_closest_PointXY, distance_point_from_geom, angular_variation, endpoint_type))
                                    except:
                                        if print_debug_flag is True:
                                            print('EXCEPTION : '  + 'END_POINT LOOP', 'local_feature : ' + str(feature['fid']))
                                

                        if len(closest_vertices) > 0:
                            if break_update_step is False:
                                if prefered_behaviour_end == 'Nearest, Minimum angular variation':
                                    if same_direction_geoms_flag is True:
                                        closest_vertices = sorted(closest_vertices, key=lambda k: (k[3]*-1, k[1], k[2]))
                                    else:
                                        closest_vertices = sorted(closest_vertices, key=lambda k: (k[1], k[2]))

                                elif prefered_behaviour_end == 'Farest, Minimum angular variation':
                                    if same_direction_geoms_flag is True:
                                        closest_vertices = sorted(closest_vertices, key=lambda k: (k[3]*-1, k[1]*-1, k[2]))
                                    else:
                                        closest_vertices = sorted(closest_vertices, key=lambda k: (k[1]*-1, k[2]))

                                elif prefered_behaviour_end == 'Nearest, Maximum angular variation':
                                    if same_direction_geoms_flag is True:
                                        closest_vertices = sorted(closest_vertices, key=lambda k: (k[3]*-1, k[1], k[2]*-1))
                                    else:
                                        closest_vertices = sorted(closest_vertices, key=lambda k: (k[1], k[2]*-1))

                                elif prefered_behaviour_end == 'Farest, Maximum angular variation':
                                    if same_direction_geoms_flag is True:
                                        closest_vertices = sorted(closest_vertices, key=lambda k: (k[3]*-1, k[1]*-1, k[2]*-1))
                                    else:
                                        closest_vertices = sorted(closest_vertices, key=lambda k: (k[1]*-1, k[2]*-1))

                                if print_debug_flag is True:
                                    print('STEP : ' +  'END_POINT UPDATE GEOMETRY', 'local_feature : ' + str(feature['fid']), 'closest_vertices : ', closest_vertices)


                    
                                for closest_vertex in closest_vertices:
                                    new_polyline = polyline
                                    new_polyline[-1] = closest_vertex[0]
                                    new_geom = QgsGeometry.fromPolylineXY(new_polyline)
                                    if not new_geom.isEmpty() and new_geom.length() >= closest_vertex[1]:
                                        feature.setGeometry(new_geom)
                                        layer.updateFeature(feature)
                                        break
                except:
                    if print_debug_flag is True:
                        print('EXCEPTION : '  + 'FEATURE_LOOP', 'local_feature : ' + str(feature['fid']))                          


            feedback.setProgress(int((y /numfeatures) * 100))

        
        if explode_and_gather_flag is True:
            alg_params_dissolve = {
                'FIELD': entity_identification_fields,
                'INPUT': layer,
                'SEPARATE_DISJOINT': False,
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_dissolve'] = processing.run('qgis:dissolve', alg_params_dissolve, context=context, feedback=feedback)
            layer = outputs['alg_params_dissolve']['OUTPUT']    

        numfeatures = layer.featureCount()

        for y, feature in enumerate(layer.getFeatures()):
            output_feature = QgsFeature(feature)
            sink_output.addFeature(output_feature, QgsFeatureSink.FastInsert)

        end_timer = datetime.now() - start_timer

        #feedback.pushInfo('cn.' + self.name() + ' : ' + self.displayName() + " took {} seconds to calculate.".format(end_timer.strftime("%H:%M:%S")))


        return {'OUTPUT': self.OUTPUT,
                'NUMBEROFFEATURES': numfeatures}

    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'endpointssnapping'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return 'Snap lines endpoints'' to each other''s from a layer source within a buffer'

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr(self.groupId())

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'Snapping layer (from himself)'

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return EndpointsSnapping()

class HubSnapping(QgsProcessingAlgorithm):
    """
    Align lines vertices' hubs on top of each other within a buffer.
    """

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.
    OUTPUT = 'OUTPUT'
    INPUT = 'INPUT'


    def initAlgorithm(self, config):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """

        # We add the input vector features source. It can have any kind of
        # geometry.
        self.addParameter(
            QgsProcessingParameterFeatureSource(
                self.INPUT,
                self.tr('INPUT'),
                [QgsProcessing.TypeVectorLine]
            )
        )

        self.addParameter(
            QgsProcessingParameterBoolean(
                self.tr('FIX_GEOMETRIES_BEFORE_PROCESSING'),
                self.tr('FIX GEOMETRIES BEFORE PROCESSING'),
                True,
                True
            )
        )

        self.addParameter(
            QgsProcessingParameterDistance(
                self.tr('BUFFER_HUB_SNAPPING'),
                self.tr('BUFFER HUB SNAPPING'),
                1.5,
                self.INPUT,
                False,
                0.0
            )
        )

        self.addParameter(
            QgsProcessingParameterBoolean(
                self.tr('MAXIMIZE_ENDPOINTS'),
                self.tr('MAXIMIZE ENDPOINTS'),
                True,
                True
            )
        )

        self.addParameter(
                QgsProcessingParameterNumber(
                name=self.tr('ENDPOINTS THRESHOLD'),
                description=self.tr('ENDPOINTS THRESHOLD'),
                type=QgsProcessingParameterNumber.Integer,
                defaultValue=2,
                optional=False,
                minValue=0,
                maxValue=100
                    )
        )

        self.addParameter(
            QgsProcessingParameterBoolean(
                self.tr('HUBPOINT_MUST_BE_AN_EXISTING_VERTEX'),
                self.tr('HUBPOINT MUST BE AN EXISTING VERTEX'),
                True,
                True
            )
        )

        self.addParameter(
            QgsProcessingParameterBoolean(
                self.tr('EXPLODE_AND_GATHER'),
                self.tr('EXPLODE AND GATHER'),
                False,
                True
            )
        )

        self.addParameter(
            QgsProcessingParameterField(
                self.tr('ENTITY_IDENTIFICATION_FIELDS'),
                self.tr('ENTITY IDENTIFICATION FIELDS'),
                None,
                self.INPUT,
                QgsProcessingParameterField.Any,
                True,
                True,
                True
            )
        )

        self.addParameter(
            QgsProcessingParameterBoolean(
                self.tr('PRINT_DEBUG'),
                self.tr('PRINT DEBUG'),
                False,
                True
            )
        )
        # We add a feature sink in which to store our processed features (this
        # usually takes the form of a newly created vector layer when the
        # algorithm is run in QGIS).



        self.addParameter(
            QgsProcessingParameterFeatureSink(
                self.OUTPUT,
                self.tr('OUTPUT')
            )
        )

    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        """
        source = self.parameterAsSource(parameters, self.INPUT, context)
        if source is None:
            raise QgsProcessingException(self.invalidSourceError(parameters, self.INPUT))
        (sink_output, dest_output) = self.parameterAsSink(parameters, self.OUTPUT,
                context, source.fields(), source.wkbType(), source.sourceCrs())

        numfeatures = source.featureCount()

        fix_geoms_flag = self.parameterAsBool(parameters, 'FIX_GEOMETRIES_BEFORE_PROCESSING',
                                        context)
        
        buffer_hub_snap = self.parameterAsDouble(parameters, 'BUFFER_HUB_SNAPPING',
                                                context)
        
        maximize_endpoints_flag = self.parameterAsBool(parameters, 'MAXIMIZE_ENDPOINTS',
                                        context)
        
        endpoints_threshold = self.parameterAsInt(parameters, 'ENDPOINTS_THRESHOLD',
                                        context)
        
        hubpoint_is_existing_vertex_flag = self.parameterAsBool(parameters, 'HUBPOINT_MUST_BE_AN_EXISTING_VERTEX',
                                        context)
        
        explode_and_gather_flag = self.parameterAsBool(parameters, 'EXPLODE_AND_GATHER',
                                context)

        entity_identification_fields = self.parameterAsFields(parameters, 'ENTITY_IDENTIFICATION_FIELDS',
                                                context)

        print_debug_flag = self.parameterAsBool(parameters, 'PRINT_DEBUG',
                                        context)
        
        start_timer = datetime.now()


        outputs = {}


        if fix_geoms_flag is True:

            alg_params_fixgeometries = {
                "INPUT": source.materialize(QgsFeatureRequest()),
                "METHOD": 1,
                "OUTPUT": QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_fixgeometries'] = processing.run("qgis:fixgeometries", alg_params_fixgeometries, context=context,  feedback=feedback)


            alg_params_unipart = {
            'INPUT': outputs['alg_params_fixgeometries']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_unipart'] = processing.run("qgis:multiparttosingleparts", alg_params_unipart, context=context,  feedback=feedback)
        
        else:

            alg_params_unipart = {
            'INPUT': source.materialize(QgsFeatureRequest()),
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_unipart'] = processing.run("qgis:multiparttosingleparts", alg_params_unipart, context=context,  feedback=feedback)
        

        if explode_and_gather_flag is True:

            alg_params_explodelines = {
            'INPUT': outputs['alg_params_unipart']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_explodelines'] = processing.run("qgis:explodelines", alg_params_explodelines, context=context,  feedback=feedback)
            layer = outputs['alg_params_explodelines']['OUTPUT']

        else:
            layer = outputs['alg_params_unipart']['OUTPUT']


        request = QgsFeatureRequest()
        clause = QgsFeatureRequest().OrderByClause('$length', ascending=True)
        orderby = QgsFeatureRequest().OrderBy([clause])
        request.setOrderBy(orderby)

        for y, feature in enumerate(layer.getFeatures(request)):
            
            if feedback.isCanceled():
                return {}
            
            if not feature.geometry().isEmpty():
                try:
                    with edit(layer):


                        geometry = feature.geometry()

                        spatial_index = QgsSpatialIndex(layer.getFeatures())


                        polyline = geometry.asPolyline()

                        polyline_start = polyline[0]
                        polyline_end = polyline[-1]

                        geometry_start = QgsGeometry.fromPointXY(polyline_start)
                        geometry_end = QgsGeometry.fromPointXY(polyline_end)


                        try: 
                            nearest_nnfeatures_points = []
                
                            for nnfeature in layer.getFeatures(QgsFeatureRequest().setFilterRect(geometry_start.buffer(buffer_hub_snap,5).boundingBox())):
                                nnfeature_closest_vertex = nnfeature.geometry().closestVertex(geometry_start.asPoint())

                                if nnfeature_closest_vertex[-1] <= buffer_hub_snap**2:
                                    nnfeature_closest_PointXY = QgsPointXY(nnfeature.geometry().vertexAt(nnfeature_closest_vertex[1]).x(),  nnfeature.geometry().vertexAt(nnfeature_closest_vertex[1]).y())
                                    nnfeature_nearest_vertex_geom = QgsGeometry.fromPointXY(nnfeature_closest_PointXY)
                                    distance_from_nnfeature_nearest_vertex = geometry_start.distance(nnfeature_nearest_vertex_geom)
                                    
                                    if distance_from_nnfeature_nearest_vertex <= buffer_hub_snap:
                                        if nnfeature_closest_vertex[2] == -1 or nnfeature_closest_vertex[3] == -1:
                                            nearest_nnfeatures_points.append((nnfeature_closest_vertex, nnfeature_nearest_vertex_geom, distance_from_nnfeature_nearest_vertex, nnfeature, True))
                                        else:
                                            nearest_nnfeatures_points.append((nnfeature_closest_vertex, nnfeature_nearest_vertex_geom, distance_from_nnfeature_nearest_vertex, nnfeature, False))

                            nearest_nnfeatures_points.sort(key=lambda x:x[2]) 

                            if maximize_endpoints_flag is True and len([nnfeature for nnfeature in nearest_nnfeatures_points if nnfeature[4] == True]) + 1 < endpoints_threshold and len(nearest_nnfeatures_points) < 3:
                                raise Exception("Not enough points")
                            elif maximize_endpoints_flag is False and len(nearest_nnfeatures_points) < 3:
                                raise Exception("Not enough points")

                            polygon = QgsGeometry.fromPolygonXY([[ nnfeature[1].asPoint() for nnfeature in nearest_nnfeatures_points ]])

                            if not polygon.isEmpty():

                                nearest_nnfeatures_points = [nnfeature + (nnfeature[1].distance(polygon.centroid()),) for nnfeature in nearest_nnfeatures_points]
                                nearest_nnfeatures_points = sorted(nearest_nnfeatures_points, key=lambda k: k[-1])

                                if hubpoint_is_existing_vertex_flag is True:
                                    
                                    for nnfeature in nearest_nnfeatures_points:
                                        QgsVectorLayerEditUtils(layer).moveVertex(nearest_nnfeatures_points[0][1].asPoint().x(),nearest_nnfeatures_points[0][1].asPoint().y(),nnfeature[3].id(),nnfeature[0][1])

                                else:
                                    for nnfeature in nearest_nnfeatures_points:
                                        QgsVectorLayerEditUtils(layer).moveVertex(polygon.centroid().asPoint().x(),polygon.centroid().asPoint().y(),nnfeature[3].id(),nnfeature[0][1])

                        except:
                            if print_debug_flag is True:
                                print('EXCEPTION : '  + 'START_POINT LOOP', 'local_feature : ' + str(feature['fid']))


                        try:            
                            nearest_nnfeatures_points = []
                
                            for nnfeature in layer.getFeatures(QgsFeatureRequest().setFilterRect(geometry_end.buffer(buffer_hub_snap,5).boundingBox())):
                                nnfeature_closest_vertex = nnfeature.geometry().closestVertex(geometry_end.asPoint())

                                if nnfeature_closest_vertex[-1] <= buffer_hub_snap**2:
                                    nnfeature_closest_PointXY = QgsPointXY(nnfeature.geometry().vertexAt(nnfeature_closest_vertex[1]).x(),  nnfeature.geometry().vertexAt(nnfeature_closest_vertex[1]).y())
                                    nnfeature_nearest_vertex_geom = QgsGeometry.fromPointXY(nnfeature_closest_PointXY)
                                    distance_from_nnfeature_nearest_vertex = geometry_end.distance(nnfeature_nearest_vertex_geom)
                                    
                                    if distance_from_nnfeature_nearest_vertex <= buffer_hub_snap:
                                        if nnfeature_closest_vertex[2] == -1 or nnfeature_closest_vertex[3] == -1:
                                            nearest_nnfeatures_points.append((nnfeature_closest_vertex, nnfeature_nearest_vertex_geom, distance_from_nnfeature_nearest_vertex, nnfeature, True))
                                        else:
                                            nearest_nnfeatures_points.append((nnfeature_closest_vertex, nnfeature_nearest_vertex_geom, distance_from_nnfeature_nearest_vertex, nnfeature, False))

                            nearest_nnfeatures_points.sort(key=lambda x:x[2])

                            if maximize_endpoints_flag is True and len([nnfeature for nnfeature in nearest_nnfeatures_points if nnfeature[4] == True]) + 1 < endpoints_threshold and len(nearest_nnfeatures_points) < 3:
                                raise Exception("Not enough points")
                            elif maximize_endpoints_flag is False and len(nearest_nnfeatures_points) < 3:
                                raise Exception("Not enough points")

                            polygon = QgsGeometry.fromPolygonXY([[ nnfeature[1].asPoint() for nnfeature in nearest_nnfeatures_points ]])

                            if not polygon.isEmpty():
                                
                                nearest_nnfeatures_points = [nnfeature + (nnfeature[1].distance(polygon.centroid()),) for nnfeature in nearest_nnfeatures_points]
                                nearest_nnfeatures_points = sorted(nearest_nnfeatures_points, key=lambda k: k[-1])

                                if hubpoint_is_existing_vertex_flag is True:
                                    
                                    for nnfeature in nearest_nnfeatures_points:
                                        QgsVectorLayerEditUtils(layer).moveVertex(nearest_nnfeatures_points[0][1].asPoint().x(),nearest_nnfeatures_points[0][1].asPoint().y(),nnfeature[3].id(),nnfeature[0][1])

                                else:
                                    for nnfeature in nearest_nnfeatures_points:
                                        QgsVectorLayerEditUtils(layer).moveVertex(polygon.centroid().asPoint().x(),polygon.centroid().asPoint().y(),nnfeature[3].id(),nnfeature[0][1])

                        except:
                            if print_debug_flag is True:
                                print('EXCEPTION : '  + 'END_POINT LOOP', 'local_feature : ' + str(feature['fid']))
                except:
                    if print_debug_flag is True:
                        print('EXCEPTION : '  + 'FEATURE_LOOP', 'local_feature : ' + str(feature['fid']))                         


            feedback.setProgress(int((y /numfeatures) * 100))

        if explode_and_gather_flag is True:
            alg_params_dissolve = {
                'FIELD': entity_identification_fields,
                'INPUT': layer,
                'SEPARATE_DISJOINT': False,
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_dissolve'] = processing.run('qgis:dissolve', alg_params_dissolve, context=context, feedback=feedback)
            layer = outputs['alg_params_dissolve']['OUTPUT']  

        
        numfeatures = layer.featureCount()

        for y, feature in enumerate(layer.getFeatures()):
            output_feature = QgsFeature(feature)
            sink_output.addFeature(output_feature, QgsFeatureSink.FastInsert)

        end_timer = datetime.now() - start_timer

        #feedback.pushInfo('cn.' + self.name() + ' : ' + self.displayName() + " took {} seconds to calculate.".format(end_timer.strftime("%H:%M:%S")))



        return {'OUTPUT': self.OUTPUT,
                'NUMBEROFFEATURES': numfeatures}

    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'hubsnapping'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return 'Align lines vertices'' hubs on top of each other within a buffer'

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr(self.groupId())

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'Snapping layer (from himself)'

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return HubSnapping()


class SnapHubsPointsToLayer(QgsProcessingAlgorithm):
    """
    Align lines vertices' hubs on top of an other layer source within a buffer.
    """

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.
    OUTPUT = 'OUTPUT'
    INPUT = 'INPUT'
    REF_INPUT = 'REF_INPUT'

    def initAlgorithm(self, config):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """

        # We add the input vector features source. It can have any kind of
        # geometry.
        self.addParameter(
            QgsProcessingParameterFeatureSource(
                self.INPUT,
                self.tr('INPUT'),
                [QgsProcessing.TypeVectorLine]
            )
        )
        self.addParameter(
            QgsProcessingParameterFeatureSource(
                self.REF_INPUT,
                self.tr('REF_INPUT'),
                [QgsProcessing.TypeVectorLine, QgsProcessing.TypeVectorPoint]
            )
        )

        self.addParameter(
            QgsProcessingParameterBoolean(
                self.tr('FIX_GEOMETRIES_BEFORE_PROCESSING'),
                self.tr('FIX GEOMETRIES BEFORE PROCESSING'),
                True,
                True
            )
        )
        
        self.addParameter(
            QgsProcessingParameterDistance(
                self.tr('BUFFER_HUB_SNAPPING'),
                self.tr('BUFFER HUB SNAPPING'),
                1.3,
                self.INPUT,
                False,
                0.0
            )
        )

        self.addParameter(
            QgsProcessingParameterBoolean(
                self.tr('MAXIMIZE_ENDPOINTS'),
                self.tr('MAXIMIZE ENDPOINTS'),
                True,
                False
            )
        )
        self.addParameter(
            QgsProcessingParameterNumber(
                name=self.tr('ENDPOINTS THRESHOLD'),
                description=self.tr('ENDPOINTS THRESHOLD'),
                type=QgsProcessingParameterNumber.Integer,
                defaultValue=2,
                optional=False,
                minValue=0,
                maxValue=100
                    )
        )

        self.addParameter(
            QgsProcessingParameterBoolean(
                self.tr('HUBPOINT_MUST_BE_AN_EXISTING_VERTEX'),
                self.tr('HUBPOINT MUST BE AN EXISTING VERTEX'),
                True,
                True
            )
        )

        self.addParameter(
            QgsProcessingParameterBoolean(
                self.tr('EXPLODE_AND_GATHER'),
                self.tr('EXPLODE AND GATHER'),
                False,
                True
            )
        )

        self.addParameter(
            QgsProcessingParameterField(
                self.tr('ENTITY_IDENTIFICATION_FIELDS'),
                self.tr('ENTITY IDENTIFICATION FIELDS'),
                None,
                self.INPUT,
                QgsProcessingParameterField.Any,
                True,
                True,
                True
            )
        )

        self.addParameter(
            QgsProcessingParameterBoolean(
                self.tr('PRINT_DEBUG'),
                self.tr('PRINT DEBUG'),
                False,
                True
            )
        )
        # We add a feature sink in which to store our processed features (this
        # usually takes the form of a newly created vector layer when the
        # algorithm is run in QGIS).



        self.addParameter(
            QgsProcessingParameterFeatureSink(
                self.OUTPUT,
                self.tr('OUTPUT')
            )
        )

    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        """
        source = self.parameterAsSource(parameters, self.INPUT, context)

        if source is None:
            raise QgsProcessingException(self.invalidSourceError(parameters, self.INPUT))
        
        source_ref_layer = self.parameterAsSource(parameters, self.REF_INPUT, context)

        if source_ref_layer is None:
            raise QgsProcessingException(self.invalidSourceError(parameters, self.REF_INPUT))
        
        (sink_output, dest_output) = self.parameterAsSink(parameters, self.OUTPUT,
                context, source.fields(), source.wkbType(), source.sourceCrs())

        numfeatures = source.featureCount()

        fix_geoms_flag = self.parameterAsBool(parameters, 'FIX_GEOMETRIES_BEFORE_PROCESSING',
                                        context)
        
        buffer_hub_snap = self.parameterAsDouble(parameters, 'BUFFER_HUB_SNAPPING',
                                                context)
        
        maximize_endpoints_flag = self.parameterAsBool(parameters, 'MAXIMIZE_ENDPOINTS',
                                        context)
        
        endpoints_threshold = self.parameterAsInt(parameters, 'ENDPOINTS_THRESHOLD',
                                        context)
        
        hubpoint_is_existing_vertex_flag = self.parameterAsBool(parameters, 'HUBPOINT_MUST_BE_AN_EXISTING_VERTEX',
                                        context)
        
        explode_and_gather_flag = self.parameterAsBool(parameters, 'EXPLODE_AND_GATHER',
                                context)

        entity_identification_fields = self.parameterAsFields(parameters, 'ENTITY_IDENTIFICATION_FIELDS',
                                                context)

        print_debug_flag = self.parameterAsBool(parameters, 'PRINT_DEBUG',
                                context)
        
        start_timer = datetime.now()
        
        def takeLast(elem):
            return elem[-1]



        outputs = {}

        if fix_geoms_flag is True:

            alg_params_fixgeometries = {
                "INPUT": source.materialize(QgsFeatureRequest()),
                "METHOD": 1,
                "OUTPUT": QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_fixgeometries'] = processing.run("qgis:fixgeometries", alg_params_fixgeometries, context=context,  feedback=feedback)

            alg_params_fixgeometries_ref_layer = {
                "INPUT": source_ref_layer.materialize(QgsFeatureRequest()),
                "METHOD": 1,
                "OUTPUT": QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_fixgeometries_ref_layer'] = processing.run("qgis:fixgeometries", alg_params_fixgeometries_ref_layer, context=context,  feedback=feedback)

            alg_params_unipart = {
            'INPUT': outputs['alg_params_fixgeometries']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_unipart'] = processing.run("qgis:multiparttosingleparts", alg_params_unipart, context=context,  feedback=feedback)


            alg_params_unipart_ref_layer = {
            'INPUT': outputs['alg_params_fixgeometries_ref_layer']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_unipart_ref_layer'] = processing.run("qgis:multiparttosingleparts",alg_params_unipart_ref_layer,context=context,  feedback=feedback)

        else:

            alg_params_unipart = {
            'INPUT': source.materialize(QgsFeatureRequest()),
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_unipart'] = processing.run("qgis:multiparttosingleparts", alg_params_unipart, context=context,  feedback=feedback)

            alg_params_unipart_ref_layer = {
            'INPUT': source_ref_layer.materialize(QgsFeatureRequest()),
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_unipart_ref_layer'] = processing.run("qgis:multiparttosingleparts",alg_params_unipart_ref_layer,context=context,  feedback=feedback)

        if explode_and_gather_flag is True:

            alg_params_explodelines = {
            'INPUT': outputs['alg_params_unipart']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_explodelines'] = processing.run("qgis:explodelines", alg_params_explodelines, context=context,  feedback=feedback)
            layer = outputs['alg_params_explodelines']['OUTPUT']

        else:
            layer = outputs['alg_params_unipart']['OUTPUT']


        ref_layer = outputs['alg_params_unipart_ref_layer']['OUTPUT']

        request = QgsFeatureRequest()
        clause = QgsFeatureRequest().OrderByClause('$length', ascending=True)
        orderby = QgsFeatureRequest().OrderBy([clause])
        request.setOrderBy(orderby)


        for y, feature in enumerate(layer.getFeatures(request)):
            
            if feedback.isCanceled():
                return {}
            
            if not feature.geometry().isEmpty():
                try:
                    with edit(layer):


                        geometry = feature.geometry()

                        spatial_index = QgsSpatialIndex(layer.getFeatures())


                        polyline = geometry.asPolyline()

                        polyline_start = polyline[0]
                        polyline_end = polyline[-1]

                        geometry_start = QgsGeometry.fromPointXY(polyline_start)
                        geometry_end = QgsGeometry.fromPointXY(polyline_end)


                        try:
                            nearest_nnfeatures_points = []
                
                            for nnfeature in ref_layer.getFeatures(QgsFeatureRequest().setFilterRect(geometry_start.buffer(buffer_hub_snap,5).boundingBox())):
                                nnfeature_closest_vertex = nnfeature.geometry().closestVertex(geometry_start.asPoint())

                                if nnfeature_closest_vertex[-1] <= buffer_hub_snap**2:
                                    nnfeature_closest_PointXY = QgsPointXY(nnfeature.geometry().vertexAt(nnfeature_closest_vertex[1]).x(),  nnfeature.geometry().vertexAt(nnfeature_closest_vertex[1]).y())
                                    nnfeature_nearest_vertex_geom = QgsGeometry.fromPointXY(nnfeature_closest_PointXY)
                                    distance_from_nnfeature_nearest_vertex = geometry_start.distance(nnfeature_nearest_vertex_geom)
                                    
                                    if distance_from_nnfeature_nearest_vertex <= buffer_hub_snap:
                                        if nnfeature_closest_vertex[2] == -1 or nnfeature_closest_vertex[3] == -1:
                                            nearest_nnfeatures_points.append((nnfeature_closest_vertex, nnfeature_nearest_vertex_geom, distance_from_nnfeature_nearest_vertex, nnfeature, True))
                                        else:
                                            nearest_nnfeatures_points.append((nnfeature_closest_vertex, nnfeature_nearest_vertex_geom, distance_from_nnfeature_nearest_vertex, nnfeature, False))

                            nearest_nnfeatures_points.sort(key=lambda x:x[2]) 

                            if maximize_endpoints_flag is True and len([nnfeature for nnfeature in nearest_nnfeatures_points if nnfeature[4] == True]) + 1 < endpoints_threshold and len(nearest_nnfeatures_points) < 3:
                                raise Exception("Not enough points")
                            elif maximize_endpoints_flag is False and len(nearest_nnfeatures_points) < 3:
                                raise Exception("Not enough points")
                            
                            polygon = QgsGeometry.fromPolygonXY([[ nnfeature[1].asPoint() for nnfeature in nearest_nnfeatures_points ]])

                            if not polygon.isEmpty():

                                nearest_nnfeatures_points = [nnfeature + (nnfeature[1].distance(polygon.centroid()),) for nnfeature in nearest_nnfeatures_points]
                                nearest_nnfeatures_points = sorted(nearest_nnfeatures_points, key=lambda k: k[-1])

                                if hubpoint_is_existing_vertex_flag is True:
                                    
                                    for nnfeature in nearest_nnfeatures_points:
                                        QgsVectorLayerEditUtils(layer).moveVertex(nearest_nnfeatures_points[0][1].asPoint().x(),nearest_nnfeatures_points[0][1].asPoint().y(),nnfeature[3].id(),nnfeature[0][1])

                                else:
                                    for nnfeature in nearest_nnfeatures_points:
                                        QgsVectorLayerEditUtils(layer).moveVertex(polygon.centroid().asPoint().x(),polygon.centroid().asPoint().y(),nnfeature[3].id(),nnfeature[0][1])

                        except:
                            if print_debug_flag is True:
                                print('EXCEPTION : '  + 'START_POINT LOOP', 'local_feature : ' + str(feature['fid']))




                        try:                
                            nearest_nnfeatures_points = []
                
                            for nnfeature in ref_layer.getFeatures(QgsFeatureRequest().setFilterRect(geometry_end.buffer(buffer_hub_snap,5).boundingBox())):
                                nnfeature_closest_vertex = nnfeature.geometry().closestVertex(geometry_end.asPoint())

                                if nnfeature_closest_vertex[-1] <= buffer_hub_snap**2:
                                    nnfeature_closest_PointXY = QgsPointXY(nnfeature.geometry().vertexAt(nnfeature_closest_vertex[1]).x(),  nnfeature.geometry().vertexAt(nnfeature_closest_vertex[1]).y())
                                    nnfeature_nearest_vertex_geom = QgsGeometry.fromPointXY(nnfeature_closest_PointXY)
                                    distance_from_nnfeature_nearest_vertex = geometry_end.distance(nnfeature_nearest_vertex_geom)
                                    
                                    if distance_from_nnfeature_nearest_vertex <= buffer_hub_snap:
                                        if nnfeature_closest_vertex[2] == -1 or nnfeature_closest_vertex[3] == -1:
                                            nearest_nnfeatures_points.append((nnfeature_closest_vertex, nnfeature_nearest_vertex_geom, distance_from_nnfeature_nearest_vertex, nnfeature, True))
                                        else:
                                            nearest_nnfeatures_points.append((nnfeature_closest_vertex, nnfeature_nearest_vertex_geom, distance_from_nnfeature_nearest_vertex, nnfeature, False))

                            nearest_nnfeatures_points.sort(key=lambda x:x[2]) 

                            if maximize_endpoints_flag is True and len([nnfeature for nnfeature in nearest_nnfeatures_points if nnfeature[4] == True]) + 1 < endpoints_threshold and len(nearest_nnfeatures_points) < 3:
                                raise Exception("Not enough points")
                            elif maximize_endpoints_flag is False and len(nearest_nnfeatures_points) < 3:
                                raise Exception("Not enough points")

                            polygon = QgsGeometry.fromPolygonXY([[ nnfeature[1].asPoint() for nnfeature in nearest_nnfeatures_points ]])

                            if not polygon.isEmpty():

                                nearest_nnfeatures_points = [nnfeature + (nnfeature[1].distance(polygon.centroid()),) for nnfeature in nearest_nnfeatures_points]
                                nearest_nnfeatures_points = sorted(nearest_nnfeatures_points, key=lambda k: k[-1])

                                if hubpoint_is_existing_vertex_flag is True:
                                    
                                    for nnfeature in nearest_nnfeatures_points:
                                        QgsVectorLayerEditUtils(layer).moveVertex(nearest_nnfeatures_points[0][1].asPoint().x(),nearest_nnfeatures_points[0][1].asPoint().y(),nnfeature[3].id(),nnfeature[0][1])

                                else:
                                    for nnfeature in nearest_nnfeatures_points:
                                        QgsVectorLayerEditUtils(layer).moveVertex(polygon.centroid().asPoint().x(),polygon.centroid().asPoint().y(),nnfeature[3].id(),nnfeature[0][1])

                        except:
                            if print_debug_flag is True:
                                print('EXCEPTION : '  + 'END_POINT LOOP', 'local_feature : ' + str(feature['fid']))
                except:
                    if print_debug_flag is True:
                        print('EXCEPTION : '  + 'FEATURE_LOOP', 'local_feature : ' + str(feature['fid']))                         


            feedback.setProgress(int((y /numfeatures) * 100))

        if explode_and_gather_flag is True:
            alg_params_dissolve = {
                'FIELD': entity_identification_fields,
                'INPUT': layer,
                'SEPARATE_DISJOINT': False,
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_dissolve'] = processing.run('qgis:dissolve', alg_params_dissolve, context=context, feedback=feedback)
            layer = outputs['alg_params_dissolve']['OUTPUT']

        numfeatures = layer.featureCount()

        for y, feature in enumerate(layer.getFeatures()):
            output_feature = QgsFeature(feature)
            sink_output.addFeature(output_feature, QgsFeatureSink.FastInsert)

        end_timer = datetime.now() - start_timer

        #feedback.pushInfo('cn.' + self.name() + ' : ' + self.displayName() + " took {} seconds to calculate.".format(end_timer.strftime("%H:%M:%S")))



        return {'OUTPUT': self.OUTPUT,
                'NUMBEROFFEATURES': numfeatures}

    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'snaphubspointstolayer'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return 'Align lines vertices'' hubs on top of an other layer source within a buffer'

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr(self.groupId())

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'Snapping layer (from another layer)'

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return SnapHubsPointsToLayer()

class SnapEndpointsToLayer(QgsProcessingAlgorithm):
    """
    Snap lines endpoints' to each other's from an other layer source within a buffer.
    """

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.
    OUTPUT = 'OUTPUT'
    INPUT = 'INPUT'
    REF_INPUT = 'REF_INPUT'
    BEHAVIORS = ['Nearest, Minimum angular variation','Farest, Minimum angular variation','Nearest, Maximum angular variation','Farest, Maximum angular variation']

    def initAlgorithm(self, config):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """

        # We add the input vector features source. It can have any kind of
        # geometry.
        self.addParameter(
            QgsProcessingParameterFeatureSource(
                self.INPUT,
                self.tr('INPUT'),
                [QgsProcessing.TypeVectorLine]
            )
        )
        self.addParameter(
            QgsProcessingParameterFeatureSource(
                self.REF_INPUT,
                self.tr('REF_INPUT'),
                [QgsProcessing.TypeVectorLine, QgsProcessing.TypeVectorPoint]
            )
        )

        self.addParameter(
            QgsProcessingParameterBoolean(
                self.tr('FIX_GEOMETRIES_BEFORE_PROCESSING'),
                self.tr('FIX GEOMETRIES BEFORE PROCESSING'),
                True,
                True
            )
        )

        self.addParameter(
            QgsProcessingParameterEnum(
                self.tr('PREFERRED_BEHAVIOR_FOR_STARTING_EXTREMITIES'),
                self.tr('PREFERRED BEHAVIOR FOR STARTING EXTREMITIES'),
                self.BEHAVIORS,
                False,
                0,
                False
            )
        )  

        self.addParameter(
            QgsProcessingParameterEnum(
                self.tr('PREFERRED_BEHAVIOR_FOR_ENDING_EXTREMITIES'),
                self.tr('PREFERRED BEHAVIOR FOR ENDING EXTREMITIES'),
                self.BEHAVIORS,
                False,
                0,
                False
            )
        ) 
        self.addParameter(
            QgsProcessingParameterNumber(
                name=self.tr('HAUSDORFF DISTANCE LIMIT'),
                description=self.tr('HAUSDORFF DISTANCE LIMIT'),
                type=QgsProcessingParameterNumber.Integer,
                defaultValue=1,
                optional=False,
                minValue=0,
                maxValue=100
                    )
        )

        self.addParameter(
            QgsProcessingParameterNumber(
 
                name=self.tr("MIN ANGULAR LIMIT OF PARALLEL GEOMETRIES'S"),
                description=self.tr("MIN ANGULAR LIMIT OF PARALLEL GEOMETRIES'S"),
                type=QgsProcessingParameterNumber.Integer,
                defaultValue=1,
                optional=False,
                minValue=0,
                maxValue=100
                    )
        )

        self.addParameter(
            QgsProcessingParameterBoolean(
                self.tr('PREFERS_SAME_GEOMETRY_DIRECTION'),
                self.tr('PREFERS SAME GEOMETRY DIRECTION'),
                True,
                True
            )
        )

        self.addParameter(
            QgsProcessingParameterBoolean(
                self.tr('EXPLODE_AND_GATHER'),
                self.tr('EXPLODE AND GATHER'),
                False,
                True
            )
        )

        self.addParameter(
            QgsProcessingParameterField(
                self.tr('ENTITY_IDENTIFICATION_FIELDS'),
                self.tr('ENTITY IDENTIFICATION FIELDS'),
                None,
                self.INPUT,
                QgsProcessingParameterField.Any,
                True,
                True,
                True
            )
        )


        self.addParameter(
            QgsProcessingParameterBoolean(
                self.tr('PRINT_DEBUG'),
                self.tr('PRINT DEBUG'),
                False,
                True
            )
        )
        # We add a feature sink in which to store our processed features (this
        # usually takes the form of a newly created vector layer when the
        # algorithm is run in QGIS).



        self.addParameter(
            QgsProcessingParameterFeatureSink(
                self.OUTPUT,
                self.tr('OUTPUT')
            )
        )

    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        """
        source = self.parameterAsSource(parameters, self.INPUT, context)
        if source is None:
            raise QgsProcessingException(self.invalidSourceError(parameters, self.INPUT))
        source_ref_layer = self.parameterAsSource(parameters, self.REF_INPUT, context)


        (sink_output, dest_output) = self.parameterAsSink(parameters, self.OUTPUT,
                context, source.fields(), source.wkbType(), source.sourceCrs())

        numfeatures = source.featureCount()

        fix_geoms_flag = self.parameterAsBool(parameters, 'FIX_GEOMETRIES_BEFORE_PROCESSING',
                                        context)
        
        buffer_snap = self.parameterAsDouble(parameters, 'BUFFER_ENDPOINTS_SNAPPING',
                                                context)

        hausdorff_distance_limit = self.parameterAsDouble(parameters, 'HAUSDORFF_DISTANCE_LIMIT',
                                               context)
        
        min_angular_limit = self.parameterAsDouble(parameters, 'MIN_ANGULAR_LIMIT_OF_PARALLEL_GEOMETRIES',
                                               context)
        
        max_angular_limit = self.parameterAsDouble(parameters, 'MAX_ANGULAR_LIMIT_OF_PARALLEL_GEOMETRIES',
                                               context)
        
        prefered_behaviour_start = self.BEHAVIORS[self.parameterAsEnum(parameters, 'PREFERRED_BEHAVIOR_FOR_STARTING_EXTREMITIES',
                                               context)]
        
        prefered_behaviour_end = self.BEHAVIORS[self.parameterAsEnum(parameters, 'PREFERRED_BEHAVIOR_FOR_ENDING_EXTREMITIES',
                                               context)]

        same_direction_geoms_flag = self.parameterAsBool(parameters, 'PREFERS_SAME_GEOMETRY_DIRECTION',
                                context)
        
        explode_and_gather_flag = self.parameterAsBool(parameters, 'EXPLODE_AND_GATHER',
                                context)

        entity_identification_fields = self.parameterAsFields(parameters, 'ENTITY_IDENTIFICATION_FIELDS',
                                                context)

        print_debug_flag = self.parameterAsBool(parameters, 'PRINT_DEBUG',
                                context)
        
        start_timer = datetime.now()


        outputs = {}

        if fix_geoms_flag is True:

            alg_params_fixgeometries = {
                "INPUT": source.materialize(QgsFeatureRequest()),
                "METHOD": 1,
                "OUTPUT": QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_fixgeometries'] = processing.run("qgis:fixgeometries", alg_params_fixgeometries, context=context,  feedback=feedback)

            alg_params_fixgeometries_ref_layer = {
                "INPUT": source_ref_layer.materialize(QgsFeatureRequest()),
                "METHOD": 1,
                "OUTPUT": QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_fixgeometries_ref_layer'] = processing.run("qgis:fixgeometries", alg_params_fixgeometries_ref_layer, context=context,  feedback=feedback)

            alg_params_unipart = {
            'INPUT': outputs['alg_params_fixgeometries']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_unipart'] = processing.run("qgis:multiparttosingleparts", alg_params_unipart, context=context,  feedback=feedback)


            alg_params_unipart_ref_layer = {
            'INPUT': outputs['alg_params_fixgeometries_ref_layer']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_unipart_ref_layer'] = processing.run("qgis:multiparttosingleparts",alg_params_unipart_ref_layer,context=context,  feedback=feedback)

        else:

            alg_params_unipart = {
            'INPUT': source.materialize(QgsFeatureRequest()),
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_unipart'] = processing.run("qgis:multiparttosingleparts", alg_params_unipart, context=context,  feedback=feedback)

            alg_params_unipart_ref_layer = {
            'INPUT': source_ref_layer.materialize(QgsFeatureRequest()),
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_unipart_ref_layer'] = processing.run("qgis:multiparttosingleparts",alg_params_unipart_ref_layer,context=context,  feedback=feedback)

        if explode_and_gather_flag is True:

            alg_params_explodelines = {
            'INPUT': outputs['alg_params_unipart']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_explodelines'] = processing.run("qgis:explodelines", alg_params_explodelines, context=context,  feedback=feedback)
            layer = outputs['alg_params_explodelines']['OUTPUT']

        else:
            layer = outputs['alg_params_unipart']['OUTPUT']


        ref_layer = outputs['alg_params_unipart_ref_layer']['OUTPUT']   

        request = QgsFeatureRequest()
        clause = QgsFeatureRequest().OrderByClause('$length', ascending=True)
        orderby = QgsFeatureRequest().OrderBy([clause])
        request.setOrderBy(orderby)


        for y, feature in enumerate(layer.getFeatures(request)):
            
            if feedback.isCanceled():
                return {}
            
            if not feature.geometry().isEmpty():
                try:
                    with edit(layer):


                        geometry = feature.geometry()

                        spatial_index = QgsSpatialIndex(ref_layer.getFeatures())


                        polyline = geometry.asPolyline()

                        polyline_start = polyline[0]
                        polyline_start_near_vertex = polyline[1]

                        polyline_end = polyline[-1]
                        polyline_end_near_vertex = polyline[-2]

                        geometry_start = QgsGeometry.fromPointXY(polyline_start)
                        geometry_end = QgsGeometry.fromPointXY(polyline_end)

                        start_segment_geometry = QgsGeometry.fromPolylineXY([polyline_start, polyline_start_near_vertex])

                        end_segment_geometry = QgsGeometry.fromPolylineXY([polyline_end_near_vertex, polyline_end])
                                                                            
                        break_update_step = False
                        closest_vertices = []

                        geometry_start_buffer = geometry_start.buffer(0.001,1)
                        list_intersects_boundingBox = spatial_index.intersects(geometry_start_buffer.boundingBox())
                        if len(list_intersects_boundingBox) >= 1:
                            for id in list_intersects_boundingBox:
                                feat = next(ref_layer.getFeatures(QgsFeatureRequest(id)))
                                feat_polyline = feat.geometry().asPolyline()

                                if geometry_start_buffer.intersects(QgsGeometry.fromPointXY(feat_polyline[0])) or geometry_start_buffer.intersects(QgsGeometry.fromPointXY(feat_polyline[-1])):
                                    break_update_step = True

                                    if print_debug_flag is True:
                                        print('STEP : ' + 'START_POINT BREAK_UPDATE_STEP', 'local_feature : ' + str(feature['fid']), 'break_update_step : ' + str(break_update_step))
                                    break


                        if break_update_step is False:                
                            nearestids = spatial_index.nearestNeighbor(geometry_start.asPoint(),5,buffer_snap)
                            
                            if len(nearestids) > 0:
                                for nearestid in nearestids:
                                    try:
                                        nnfeature = next(ref_layer.getFeatures(QgsFeatureRequest(nearestid)))
                                        nnfeature_closest_vertex = nnfeature.geometry().closestVertex(geometry_start.asPoint())

                                        if nnfeature_closest_vertex[2] == -1 or nnfeature_closest_vertex[3] == -1:

                                            if nnfeature_closest_vertex[-1] <= buffer_snap**2:
                                                
                                                nnfeature_closest_PointXY = QgsPointXY(nnfeature.geometry().vertexAt(nnfeature_closest_vertex[1]).x(),  nnfeature.geometry().vertexAt(nnfeature_closest_vertex[1]).y())
                                                nnfeature_closest_PointXY_geom = QgsGeometry.fromPointXY(nnfeature_closest_PointXY)

                                                distance_point_from_geom = geometry_start.distance(nnfeature_closest_PointXY_geom)

                                                if print_debug_flag is True:
                                                    print('STEP : ' + 'START_POINT DISTANCE TO POINT', 'local_feature : ' + str(feature['fid']), 'distant_feature : ' + str(nnfeature['fid']), 'distance : ' + str(distance_point_from_geom))
                                            
                                                if distance_point_from_geom <= buffer_snap and geometry.length() > distance_point_from_geom:

                                                    endpoint_type = 1 if nnfeature_closest_vertex[3] == -1 else -1

                                                    distant_segment = [nnfeature_closest_PointXY]

                                                    if endpoint_type == 1:
                                                        distant_segment.append(QgsPointXY(nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]).x(),  nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]).y()))
                                                    elif endpoint_type == -1:
                                                        distant_segment.append(QgsPointXY(nnfeature.geometry().vertexAt(nnfeature_closest_vertex[3]).x(),  nnfeature.geometry().vertexAt(nnfeature_closest_vertex[3]).y()))

                                                    distant_segment_geom = QgsGeometry.fromPolylineXY(distant_segment)

                                                    start_segment_angle = math.degrees(start_segment_geometry.interpolateAngle(start_segment_geometry.length())) % 180
                                                    distant_segment_angle = math.degrees(distant_segment_geom.interpolateAngle(distant_segment_geom.length())) % 180
                                          
                                                    angular_variation = abs(start_segment_angle - distant_segment_angle)

                                                    hausdorff_distance = start_segment_geometry.hausdorffDistance(distant_segment_geom)

                                                    if print_debug_flag is True:
                                                        print('STEP : ' + 'START_POINT ANGULAR_VARIATION & HAUSDORFF_DISTANCE', 'local_feature : ' + str(feature['fid']), 'distant_feature : ' + str(nnfeature['fid']), 'hausdorff_distance : ' + str(hausdorff_distance), 'angular_variation : ' + str(angular_variation), 'nnfeature_closest_vertex : ', nnfeature_closest_vertex)

                                                    if (angular_variation >= min_angular_limit and angular_variation <= max_angular_limit) and hausdorff_distance > hausdorff_distance_limit:
                                                        closest_vertices.append((nnfeature_closest_PointXY, distance_point_from_geom, angular_variation, endpoint_type))
                                    except:
                                        if print_debug_flag is True:
                                            print('EXCEPTION : '  + 'START_POINT LOOP', 'local_feature : ' + str(feature['fid']))

                        if len(closest_vertices) > 0:
                            if break_update_step is False:
                                if prefered_behaviour_start == 'Nearest, Minimum angular variation':
                                    if same_direction_geoms_flag is True:
                                        closest_vertices = sorted(closest_vertices, key=lambda k: (k[3]*-1, k[1], k[2]))
                                    else:
                                        closest_vertices = sorted(closest_vertices, key=lambda k: (k[1], k[2]))

                                elif prefered_behaviour_start == 'Farest, Minimum angular variation':
                                    if same_direction_geoms_flag is True:
                                        closest_vertices = sorted(closest_vertices, key=lambda k: (k[3]*-1, k[1]*-1, k[2]))
                                    else:
                                        closest_vertices = sorted(closest_vertices, key=lambda k: (k[1]*-1, k[2]))

                                elif prefered_behaviour_start == 'Nearest, Maximum angular variation':
                                    if same_direction_geoms_flag is True:
                                        closest_vertices = sorted(closest_vertices, key=lambda k: (k[3]*-1, k[1], k[2]*-1))
                                    else:
                                        closest_vertices = sorted(closest_vertices, key=lambda k: (k[1], k[2]*-1))

                                elif prefered_behaviour_start == 'Farest, Maximum angular variation':
                                    if same_direction_geoms_flag is True:
                                        closest_vertices = sorted(closest_vertices, key=lambda k: (k[3]*-1, k[1]*-1, k[2]*-1))
                                    else:
                                        closest_vertices = sorted(closest_vertices, key=lambda k: (k[1]*-1, k[2]*-1))

                                if print_debug_flag is True:
                                    print('STEP : ' +  'START_POINT UPDATE GEOMETRY', 'local_feature : ' + str(feature['fid']), 'closest_vertices : ', closest_vertices)

                                for closest_vertex in closest_vertices:
                                    new_polyline = polyline
                                    new_polyline[0] = closest_vertex[0]
                                    new_geom = QgsGeometry.fromPolylineXY(new_polyline)
                                    if not new_geom.isEmpty() and new_geom.length() >= closest_vertex[1]:
                                        feature.setGeometry(new_geom)
                                        layer.updateFeature(feature)
                                        break                            





                        break_update_step = False
                        closest_vertices = []

                        geometry_end_buffer = geometry_end.buffer(0.001,1)
                        list_intersects_boundingBox = spatial_index.intersects(geometry_end_buffer.boundingBox())
                        if len(list_intersects_boundingBox) >= 1:
                            for id in list_intersects_boundingBox:
                                feat = next(ref_layer.getFeatures(QgsFeatureRequest(id)))
                                feat_polyline = feat.geometry().asPolyline()

                                if geometry_end_buffer.intersects(QgsGeometry.fromPointXY(feat_polyline[0])) or geometry_end_buffer.intersects(QgsGeometry.fromPointXY(feat_polyline[-1])):
                                    break_update_step = True
                                    
                                    if print_debug_flag is True:
                                        print('STEP : ' + 'END_POINT BREAK_UPDATE_STEP', 'local_feature : ' + str(feature['fid']), 'break_update_step : ' + str(break_update_step))
                                    break

                        if break_update_step is False:            
                            nearestids = spatial_index.nearestNeighbor(geometry_end.asPoint(),5,buffer_snap)

                            if len(nearestids) > 0:
                                for nearestid in nearestids:
                                    try:    
                                        nnfeature = next(ref_layer.getFeatures(QgsFeatureRequest(nearestid)))
                                        nnfeature_closest_vertex = nnfeature.geometry().closestVertex(geometry_end.asPoint())

                                        if nnfeature_closest_vertex[2] == -1 or nnfeature_closest_vertex[3] == -1:

                                            if nnfeature_closest_vertex[-1] <= buffer_snap**2:
                                                
                                                nnfeature_closest_PointXY = QgsPointXY(nnfeature.geometry().vertexAt(nnfeature_closest_vertex[1]).x(),  nnfeature.geometry().vertexAt(nnfeature_closest_vertex[1]).y())
                                                nnfeature_closest_PointXY_geom = QgsGeometry.fromPointXY(nnfeature_closest_PointXY)

                                                distance_point_from_geom = geometry_end.distance(nnfeature_closest_PointXY_geom)

                                                if print_debug_flag is True:
                                                    print('STEP : ' + 'END_POINT DISTANCE TO POINT', 'local_feature : ' + str(feature['fid']), 'distant_feature : ' + str(nnfeature['fid']), 'distance : ' + str(distance_point_from_geom))          
                                            
                                                if distance_point_from_geom <= buffer_snap and geometry.length() > distance_point_from_geom:

                                                    endpoint_type = 1 if nnfeature_closest_vertex[3] == -1 else -1

                                                    distant_segment = [nnfeature_closest_PointXY]

                                                    if endpoint_type == 1:
                                                        distant_segment.append(QgsPointXY(nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]).x(),  nnfeature.geometry().vertexAt(nnfeature_closest_vertex[2]).y()))
                                                    elif endpoint_type == -1:
                                                        distant_segment.append(QgsPointXY(nnfeature.geometry().vertexAt(nnfeature_closest_vertex[3]).x(),  nnfeature.geometry().vertexAt(nnfeature_closest_vertex[3]).y()))

                                                    distant_segment_geom = QgsGeometry.fromPolylineXY(distant_segment)

                                                    end_segment_angle = math.degrees(end_segment_geometry.interpolateAngle(end_segment_geometry.length())) % 180
                                                    distant_segment_angle = math.degrees(distant_segment_geom.interpolateAngle(distant_segment_geom.length())) % 180
                                          
                                                    angular_variation = abs(end_segment_angle - distant_segment_angle)

                                                    hausdorff_distance = end_segment_geometry.hausdorffDistance(distant_segment_geom)

                                                    if print_debug_flag is True:
                                                        print('STEP : ' + 'END_POINT ANGULAR_VARIATION & HAUSDORFF_DISTANCE', 'local_feature : ' + str(feature['fid']), 'distant_feature : ' + str(nnfeature['fid']), 'hausdorff_distance : ' + str(hausdorff_distance), 'angular_variation : ' + str(angular_variation), 'nnfeature_closest_vertex : ', nnfeature_closest_vertex)

                                                    if (angular_variation >= min_angular_limit and angular_variation <= max_angular_limit) and hausdorff_distance > hausdorff_distance_limit:
                                                        closest_vertices.append((nnfeature_closest_PointXY, distance_point_from_geom, angular_variation, endpoint_type))
                                    except:
                                        if print_debug_flag is True:
                                            print('EXCEPTION : '  + 'END_POINT LOOP', 'local_feature : ' + str(feature['fid']))
                                

                        if len(closest_vertices) > 0:
                            if break_update_step is False:
                                if prefered_behaviour_end == 'Nearest, Minimum angular variation':
                                    if same_direction_geoms_flag is True:
                                        closest_vertices = sorted(closest_vertices, key=lambda k: (k[3]*-1, k[1], k[2]))
                                    else:
                                        closest_vertices = sorted(closest_vertices, key=lambda k: (k[1], k[2]))

                                elif prefered_behaviour_end == 'Farest, Minimum angular variation':
                                    if same_direction_geoms_flag is True:
                                        closest_vertices = sorted(closest_vertices, key=lambda k: (k[3]*-1, k[1]*-1, k[2]))
                                    else:
                                        closest_vertices = sorted(closest_vertices, key=lambda k: (k[1]*-1, k[2]))

                                elif prefered_behaviour_end == 'Nearest, Maximum angular variation':
                                    if same_direction_geoms_flag is True:
                                        closest_vertices = sorted(closest_vertices, key=lambda k: (k[3]*-1, k[1], k[2]*-1))
                                    else:
                                        closest_vertices = sorted(closest_vertices, key=lambda k: (k[1], k[2]*-1))

                                elif prefered_behaviour_end == 'Farest, Maximum angular variation':
                                    if same_direction_geoms_flag is True:
                                        closest_vertices = sorted(closest_vertices, key=lambda k: (k[3]*-1, k[1]*-1, k[2]*-1))
                                    else:
                                        closest_vertices = sorted(closest_vertices, key=lambda k: (k[1]*-1, k[2]*-1))

                                if print_debug_flag is True:
                                    print('STEP : ' +  'END_POINT UPDATE GEOMETRY', 'local_feature : ' + str(feature['fid']), 'closest_vertices : ', closest_vertices)


                    
                                for closest_vertex in closest_vertices:
                                    new_polyline = polyline
                                    new_polyline[-1] = closest_vertex[0]
                                    new_geom = QgsGeometry.fromPolylineXY(new_polyline)
                                    if not new_geom.isEmpty() and new_geom.length() >= closest_vertex[1]:
                                        feature.setGeometry(new_geom)
                                        layer.updateFeature(feature)
                                        break

                except:
                    if print_debug_flag is True:
                        print('EXCEPTION : '  + 'FEATURE_LOOP', 'local_feature : ' + str(feature['fid']))                         


            feedback.setProgress(int((y /numfeatures) * 100))
        
        if explode_and_gather_flag is True:
            alg_params_dissolve = {
                'FIELD': entity_identification_fields,
                'INPUT': layer,
                'SEPARATE_DISJOINT': False,
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            outputs['alg_params_dissolve'] = processing.run('qgis:dissolve', alg_params_dissolve, context=context, feedback=feedback)
            layer = outputs['alg_params_dissolve']['OUTPUT']
        
        numfeatures = layer.featureCount()

        for y, feature in enumerate(layer.getFeatures()):
            output_feature = QgsFeature(feature)
            sink_output.addFeature(output_feature, QgsFeatureSink.FastInsert)

        end_timer = datetime.now() - start_timer

        #feedback.pushInfo('cn.' + self.name() + ' : ' + self.displayName() + " took {} seconds to calculate.".format(end_timer.strftime("%H:%M:%S")))



        return {'OUTPUT': self.OUTPUT,
                'NUMBEROFFEATURES': numfeatures}

    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'snapendpointstoLayer'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return 'Snap lines endpoints'' to each other''s from an other layer source within a buffer'

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr(self.groupId())

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'Snapping layer (from another layer)'

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return SnapEndpointsToLayer()
