# -*- coding: utf-8 -*-
"""
/***************************************************************************
 ConfigurableSearchDialog
                                 A QGIS plugin
 Attribute search based on config file
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2020-02-01
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Zoltan Siki
        email                : siki1958@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os
from qgis.core import QgsProject, QgsMapLayer, Qgis, QgsVectorLayer
from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtCore import QThread
from .searchWorker import Worker

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'configurable_search_dialog_base.ui'))


class ConfigurableSearchDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, plugin, parent=None):
        """Constructor."""
        super(ConfigurableSearchDialog, self).__init__(parent)
        self.setupUi(self)
        self.plugin = plugin
        self.iface = plugin.iface
        self.tr = plugin.tr
        self.canvas = plugin.iface.mapCanvas()
        self.doneButton.clicked.connect(self.closeDialog)
        self.stopButton.clicked.connect(self.killWorker)
        self.searchButton.clicked.connect(self.runSearch)
        self.clearButton.clicked.connect(self.clearResults)
        self.confButton.clicked.connect(self.loadConf)
        self.maxResults = 1500
        self.resultsTable.setColumnCount(4)
        self.resultsTable.setSortingEnabled(False)
        self.resultsTable.setHorizontalHeaderLabels(self.plugin.headers)
        self.resultsTable.setSelectionBehavior(QtWidgets.QAbstractItemView.SelectRows)
        self.comparisonComboBox.addItems(self.plugin.compTypes)
        self.comparisonComboBox.setCurrentIndex(2)  # starts with ...
        self.searchTypeComboBox.addItems(plugin.searchTypes.keys())
        self.resultsTable.itemSelectionChanged.connect(self.select_feature)

    def closeDialog(self):
        '''Close the dialog box when the Close button is pushed'''
        self.hide()

    def select_feature(self):
        '''A feature has been selected from the list so we need to select
        and zoom to it'''
        if self.noSelection:
            # We do not want this event while data is being changed
            return
        # Deselect all selections
        layers = QgsProject.instance().mapLayers().values()
        for layer in layers:
            if layer.type() == QgsMapLayer.VectorLayer:
                layer.removeSelection()
        # Find the layer that was selected and select the feature in the layer
        selectedRow = self.resultsTable.currentRow()
        selectedLayer = self.results[selectedRow][0]
        selectedFeature = self.results[selectedRow][1]
        if QgsProject.instance().layerTreeRoot().findLayer(selectedLayer.id()).isVisible():
            selectedLayer.select(selectedFeature.id())
            # Zoom to the selected feature
            self.canvas.zoomToSelected(selectedLayer)
        else:
            # zoom to feature bounding box
            f = selectedLayer.getFeature(selectedFeature.id())
            bbox = f.geometry().boundingBox()
            self.canvas.zoomToFeatureExtent(bbox)

    def runSearch(self):
        '''Called when the user pushes the Search button'''
        searchT = str(self.searchTypeComboBox.currentText()) # text to search
        searchP = self.plugin.searchTypes[searchT][0]        # paths to search
        selectedField = self.plugin.searchTypes[searchT][1]  # field to search
        searchL = self.plugin.searchTypes[searchT][2]        # layer names to search
        infield = selectedField != "*"
        comparisonMode = self.comparisonComboBox.currentIndex()
        self.noSelection = True
        try:
            sstr = self.findStringEdit.text().strip()
        except:
            self.showErrorMessage(self.plugin.tr(u'Invalid Search String'))
            return

        if sstr == '':
            self.showErrorMessage(self.plugin.tr(u'Search string is empty'))
            return
        # the vector layers that are to be searched
        self.vlayers = []
        if self.invisibleBox.isChecked():
            # find invisible layers too
            for k, lay in QgsProject.instance().mapLayers().items():
                if isinstance(lay, QgsVectorLayer):
                    lp = lay.dataProvider().dataSourceUri().split('|')[0]
                    if lp in searchP or lay.name() in searchL:
                        self.vlayers.append(lay)
        else:
            # find visible layer by path or name
            for lay in self.iface.mapCanvas().layers():
                if isinstance(lay, QgsVectorLayer):
                    lp = lay.dataProvider().dataSourceUri().split('|')[0]
                    if lp in searchP or lay.name() in searchL:
                        self.vlayers.append(lay)
        # layers found?
        if len(self.vlayers) == 0:
            self.showErrorMessage(self.plugin.tr(u'There are no open/visible vector layers to search through'))
            self.showErrorMessage(self.plugin.tr(u'Add one of the following layer to your project: ') + str(searchP))
            return
        # vlayers contains the layers that we will search in
        self.searchButton.setEnabled(False)
        self.stopButton.setEnabled(True)
        self.doneButton.setEnabled(False)
        self.clearButton.setEnabled(False)
        self.clearResults()
        self.resultsLabel.setText('')

        # Because this could take a lot of time, set up a separate thread
        # for a worker function to do the searching.
        thread = QThread()
        worker = Worker(self.vlayers, infield, sstr, comparisonMode, selectedField, self.maxResults)
        worker.moveToThread(thread)
        thread.started.connect(worker.run)
        worker.finished.connect(self.workerFinished)
        worker.foundmatch.connect(self.addFoundItem)
        worker.error.connect(self.workerError)
        self.thread = thread
        self.worker = worker
        self.noSelection = False
        thread.start()

    def workerFinished(self, status):
        '''Clean up the worker and thread'''
        self.worker.deleteLater()
        self.thread.quit()
        self.thread.wait()
        self.thread.deleteLater()
        self.worker = None
        self.resultsLabel.setText('Results: '+str(self.found))

        self.vlayers = []
        self.searchButton.setEnabled(True)
        self.clearButton.setEnabled(True)
        self.stopButton.setEnabled(False)
        self.doneButton.setEnabled(True)

    def workerError(self, exception_string):
        '''An error occurred so display it.'''
        self.showErrorMessage(exception_string)
        #print(exception_string)

    def killWorker(self):
        '''This is initiated when the user presses the Stop button
        and will stop the search process'''
        try:
            if self.worker is not None:
                self.worker.kill()
        except:
            pass

    def clearResults(self):
        '''Clear all the search results.'''
        self.noSelection = True
        self.found = 0
        self.results = []
        self.resultsTable.setRowCount(0)
        self.noSelection = False

    def addFoundItem(self, layer, feature, attrname, value):
        '''We found an item so add it to the found list.'''
        self.resultsTable.insertRow(self.found)
        self.results.append([layer, feature])
        self.resultsTable.setItem(self.found, 0, QtWidgets.QTableWidgetItem(value))
        self.resultsTable.setItem(self.found, 1, QtWidgets.QTableWidgetItem(layer.name()))
        self.resultsTable.setItem(self.found, 2, QtWidgets.QTableWidgetItem(attrname))
        self.resultsTable.setItem(self.found, 3, QtWidgets.QTableWidgetItem(str(feature.id())))
        self.found += 1

    def showErrorMessage(self, message):
        '''Display an error message.'''
        self.iface.messageBar().pushMessage("", message, level=Qgis.Warning, duration=5)

    def loadConf(self):
        qfd = QtWidgets.QFileDialog()
        filt = self.plugin.tr("Config files(*.cfg)")
        title = self.plugin.tr("Select config file to load")
        f, _ = QtWidgets.QFileDialog.getOpenFileName(qfd, title, ".", filt)
        self.plugin.newConfig(f)
