# -*- coding: utf-8 -*-
"""
/***************************************************************************
 ConfigurableSearch
                                 A QGIS plugin
 Attribute search based on config file
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-02-01
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Zoltan Siki
        email                : siki1958@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os.path
import configparser
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QMessageBox
from qgis.core import Qgis

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .configurable_search_dialog import ConfigurableSearchDialog

DEFAULT_CONFIG = "L:/xxii/search.cfg"

class ConfigurableSearch:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        try:
            locale = QSettings().value('locale/userLocale')[0:2]
        except Exception:
            locale = "hu"
        locale_path = os.path.join(self.plugin_dir, 'i18n',
            '{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Configurable search')
        # table headers
        self.headers = [self.tr(u'Value'), self.tr(u'Layer'),
            self.tr(u'Field'), self.tr(u'Feature Id')]
        # comparision types
        self.compTypes = [self.tr(u'='), self.tr(u'contains'),
            self.tr(u'begins with')]
        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None
        # load search configuration
        if os.path.exists(DEFAULT_CONFIG):
            self.searchTypes = self.config(DEFAULT_CONFIG)
        else:
            self.searchTypes = self.config(os.path.join(self.plugin_dir, "default.cfg"))

    def config(self, path):
        """ load and parse config file """
        parser = configparser.ConfigParser()
        if not os.path.exists(path):
            QMessageBox.warning(None, self.tr("Missing file"),
                self.tr("Config file not found: {}").format(path))
            return {}
        try:
            parser.read(path)
        except Exception:
            self.iface.messageBar().pushMessage("",
                self.tr("Config file is not valid: {}").format(path),
                level=Qgis.Critical, duration=4)
            return {}
        sConf = {}
        base_dir = ""
        for section in parser.sections():
            if section == "include":
                return self.config(parser[section]['path'])
            if section == "base":
                base_dir = parser[section].get('dir', self.plugin_dir).replace('\\', '/')
                if len(base_dir) > 0 and not base_dir.endswith('/'):
                    base_dir += '/'        # add trailing /
            elif section.startswith("search_group"):
                lp = []
                if 'path' in parser[section]:
                    # join is wrong on windows \\ is inserted while a the provider returns path with /
                    lp = [base_dir + p.strip().replace('\\', '/')
                            for p in parser[section]['path'].split(',')]
                ln = []
                if 'layer' in parser[section]:
                    ln = parser[section]['layer'].split(',')
                sConf[parser[section]['name']] = [
                    lp, parser[section]['field'], ln]
        if len(sConf) < 1:
            QMessageBox.warning(None, self.tr("Empty config"),
                self.tr("Empty config file: {}").format(path))
            return {}
        return sConf

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('ConfigurableSearch', message)


    def add_action(self, icon_path, text, callback, enabled_flag=True,
        add_to_menu=True, add_to_toolbar=True, status_tip=None,
        whats_this=None, parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(self.menu, action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/configurable_search/icon.png'
        self.add_action(icon_path, text=self.tr(u'Search'), callback=self.run,
            parent=self.iface.mainWindow())
        # will be set False in run()
        self.first_start = True

    def newConfig(self, f):
        """ load new search config """
        if len(f):
           self.searchTypes = self.config(f)
           self.dlg.searchTypeComboBox.clear()
           self.dlg.searchTypeComboBox.addItems(self.searchTypes.keys())

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(self.tr(u'&Configurable search'),
                action)
            self.iface.removeToolBarIcon(action)

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = ConfigurableSearchDialog(self)

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        self.dlg.exec_()
