# -*- coding: utf-8 -*-
"""
/***************************************************************************
 ConcaveHullDialog
                                 A QGIS plugin
 Computes a concave hull containing a set of features
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2018-12-27
        git sha              : $Format:%H$
        copyright            : (C) 2018 by Detlev Neumann, Geospatial Services
        email                : dneumann@geospatial-services.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from PyQt5 import uic
from PyQt5 import QtWidgets, QtCore, QtGui
from PyQt5.QtWidgets import QFileDialog, QDialogButtonBox, QMessageBox

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'concave_hull_dialog_base.ui'))


class ConcaveHullDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor"""
        super(ConcaveHullDialog, self).__init__(parent)
        # Set up the user interface from Designer
        self.setupUi(self)

        self._table_model = TableModel(self, [])
        self.ls_layers.setModel(self._table_model)
        self._selection_model = self.ls_layers.selectionModel()
        self._selection_model.selectionChanged.connect(self.ls_layers_selection_changed)
        self._table_model.layoutChanged.connect(self.ls_layers_changed)
        self._combo_delegate = MyComboDelegate(self)
        self.ls_layers.setItemDelegateForColumn(1, self._combo_delegate)

        for row in range(0, self._table_model.rowCount()):
            self.ls_layers.openPersistentEditor(self._table_model.index(row, 1))

        self.ls_layers.setSelectionMode(QtWidgets.QAbstractItemView.ExtendedSelection)
        self.ls_layers.setSelectionBehavior(QtWidgets.QAbstractItemView.SelectRows)

        # initial visibility of field selection combo boxes
        self.ls_layers.setColumnHidden(1, not self.cb_group_by_attribute.isChecked())

        # set column width
        self.ls_layers.horizontalHeader().setStretchLastSection(False)
        self.ls_layers.horizontalHeader().setSectionResizeMode(QtWidgets.QHeaderView.Stretch)

        # set row height
        self.ls_layers.resizeRowsToContents()

        self.buttonBox.button(QDialogButtonBox.Apply).setEnabled(False)

        # connect events to handlers to ensure proper behaviour
        self.bt_file_browser.clicked.connect(self.file_browser)
        self.rb_shapefile.toggled.connect(self.rb_shapefile_toggled)
        self.rb_existing_layer.toggled.connect(self.rb_existing_layer_toggled)
        self.rb_new_memory_layer.toggled.connect(self.rb_new_memory_layer_toggled)
        self.ed_memory_layer.textChanged.connect(self.rb_new_memory_layer_toggled)
        self.ed_output_layer.textChanged.connect(self.rb_shapefile_toggled)
        self.cb_group_by_attribute.toggled.connect(self.cb_group_by_attribute_toggled)
        self.cb_output_clusters_only.toggled.connect(self.cb_output_clusters_only_toggled)
        self._combo_delegate.commitData.connect(self.ls_layers_selection_changed)

    # if order or existence map layer is changed, then the table and combo boxes shall be updated
    @QtCore.pyqtSlot()
    def ls_layers_changed(self):
        for row in range(0, self._table_model.rowCount()):
            self.ls_layers.closePersistentEditor(self._table_model.index(row, 1))  # clears combo boxes
            self.ls_layers.openPersistentEditor(self._table_model.index(row, 1))  # refills combo boxes

        self.ls_layers.setColumnHidden(1, not self.cb_group_by_attribute.isChecked())

    # enable Ok button only if at least one input layer is selected,
    # and in case of grouping each selected layer has an assigned group by attribute
    @QtCore.pyqtSlot()
    def ls_layers_selection_changed(self, old=QtCore.QItemSelection(), new=QtCore.QItemSelection()):
        if self.ls_layers.selectionModel().selectedRows():
            enabled = True
            if self.cb_group_by_attribute.isChecked():

                # for all selected layers check if an attribute is specified
                rows = self.ls_layers.selectionModel().selectedRows()
                for row in rows:
                    # index of selected attribute is requested as UserRole, an index of 0 is invalid (dummy entry)
                    enabled = enabled and self._table_model.data(row, QtCore.Qt.UserRole) > 0

            self.buttonBox.button(QDialogButtonBox.Ok).setEnabled(enabled)
            self.buttonBox.button(QDialogButtonBox.Apply).setEnabled(enabled and not self.cb_output_clusters_only.isChecked())
        else:
            self.buttonBox.button(QDialogButtonBox.Ok).setEnabled(False)
            self.buttonBox.button(QDialogButtonBox.Apply).setEnabled(False)

    # if output to shapefile is selected, then a valid filename shall be specified
    @QtCore.pyqtSlot()
    def rb_shapefile_toggled(self):
        if self.rb_shapefile.isChecked():
            if self.ed_output_layer.text() and self.ls_layers.selectionModel().selectedRows():
                self.buttonBox.button(QDialogButtonBox.Ok).setEnabled(True)
                self.buttonBox.button(QDialogButtonBox.Apply).setEnabled(True and not self.cb_output_clusters_only.isChecked())
            else:
                self.buttonBox.button(QDialogButtonBox.Ok).setEnabled(False)
                self.buttonBox.button(QDialogButtonBox.Apply).setEnabled(False)

    # if output to existing layer is selected, then a valid polygon layer shall be specified
    @QtCore.pyqtSlot()
    def rb_existing_layer_toggled(self):
        if self.rb_existing_layer.isChecked():
            if self.cb_output.currentIndex() > -1 and self.ls_layers.selectionModel().selectedRows():
                self.buttonBox.button(QDialogButtonBox.Ok).setEnabled(True)
                self.buttonBox.button(QDialogButtonBox.Apply).setEnabled(True and not self.cb_output_clusters_only.isChecked())
            else:
                self.buttonBox.button(QDialogButtonBox.Ok).setEnabled(False)
                self.buttonBox.button(QDialogButtonBox.Apply).setEnabled(False)

    # if output to new memory layer is selected, then a valid layer name shall be specified
    @QtCore.pyqtSlot()
    def rb_new_memory_layer_toggled(self):
        if self.rb_new_memory_layer.isChecked():
            if self.ed_memory_layer.text() and self.ls_layers.selectionModel().selectedRows():
                self.buttonBox.button(QDialogButtonBox.Ok).setEnabled(True)
                self.buttonBox.button(QDialogButtonBox.Apply).setEnabled(True and not self.cb_output_clusters_only.isChecked())
            else:
                self.buttonBox.button(QDialogButtonBox.Ok).setEnabled(False)
                self.buttonBox.button(QDialogButtonBox.Apply).setEnabled(False)

    # if group by attribute is selected, then a second column with combo boxes with field names shall be displayed
    @QtCore.pyqtSlot()
    def cb_group_by_attribute_toggled(self):
        self.ls_layers.setColumnHidden(1, not self.cb_group_by_attribute.isChecked())
        self.ls_layers_selection_changed()  # update ok button state
        self.ls_layers.model().layoutChanged.emit()

    # if output clustered points only is checked, then disable Apply button. This is kind of debug function and
    # not intended for interactive, incremental processes
    @QtCore.pyqtSlot()
    def cb_output_clusters_only_toggled(self):
        self.buttonBox.button(QDialogButtonBox.Apply).setDisabled(self.cb_output_clusters_only.isChecked() or not self.buttonBox.button(QDialogButtonBox.Ok).isEnabled())

    @QtCore.pyqtSlot()
    def file_browser(self):
        filename = QFileDialog.getSaveFileName(self, 'Open file', '', 'Shapefile (*.shp);;All files (*)')
        filename = os.path.splitext(str(filename[0]))[0]+'.shp'
        layer_name = os.path.splitext(os.path.basename(str(filename)))[0]
        if layer_name == '.shp':
            return
        self.ed_output_layer.setText(filename)

        
class TableModel(QtCore.QAbstractTableModel):
    """
    Table model to manage list of map layers and their fields
    """
    def __init__(self, parent=None, table_data=None):
        super(TableModel, self).__init__(parent)
        self._table_data = []
        self._selected_indices = []
        self.setTableData(table_data)

    def getTableData(self):
        return self._table_data

    def setTableData(self, table_data=None):
        self._table_data = table_data if table_data else ['', [], 0]
        self._selected_indices = [0 for _ in range(0, len(self._table_data))]
        self.layoutChanged.emit()
        
    def rowCount(self, parent=QtCore.QModelIndex()):
        return len(self._table_data)

    def columnCount(self, parent=QtCore.QModelIndex()):
        if len(self._table_data) > 0:
            return len(self._table_data[0])
        return 2
        
    def data(self, index, role=QtCore.Qt.DisplayRole):
        if not index.isValid(): 
            return None

        # selected combo box entries are saved to UserRole
        if role == QtCore.Qt.UserRole:
            return self._selected_indices[index.row()]

        if not role == QtCore.Qt.DisplayRole:
            return None

        # column 0: layer name, column 1: list of fields of layer
        if index.column() == 0:
            return str(self._table_data[index.row()][index.column()])
        elif index.column() == 1:
            return self._table_data[index.row()][index.column()]
        else:
            return ''

    def setData(self, index, value, role=QtCore.Qt.DisplayRole):
        self._selected_indices[index.row()] = value

    def flags(self, index):
        if index.column() == 1:
            return QtCore.Qt.ItemIsEditable | QtCore.Qt.ItemIsEnabled
        else:
            return QtCore.Qt.ItemIsEnabled | QtCore.Qt.ItemIsSelectable

    def clear(self):
        pass

            
class MyComboDelegate(QtWidgets.QItemDelegate):
    """
    This delegate places a fully functioning QComboBox in every
    cell of the column to which it is applied
    """

    def __init__(self, parent):
        super(MyComboDelegate, self).__init__(parent)

    def createEditor(self, parent, option, index):
        combo = QtWidgets.QComboBox(parent)
        combo.addItems(index.model().data(index))
        combo.currentIndexChanged.connect(self.currentIndexChanged)
        return combo

    def setEditorData(self, editor, index):
        editor.blockSignals(True)
        editor.setCurrentIndex(0)  # always select the first dummy entry
        editor.blockSignals(False)

    def setModelData(self, editor, model, index):
        # index of selected list entry goes to models UserRole
        model.setData(index, editor.currentIndex(), QtCore.Qt.UserRole)

    @QtCore.pyqtSlot()
    def currentIndexChanged(self):
        self.commitData.emit(self.sender())
